/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FormatPostingsDocsConsumer;
import org.apache.lucene.index.FormatPostingsDocsWriter;
import org.apache.lucene.index.FormatPostingsFieldsWriter;
import org.apache.lucene.index.FormatPostingsTermsConsumer;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.TermInfosWriter;

final class FormatPostingsTermsWriter
extends FormatPostingsTermsConsumer
implements Closeable {
    final FormatPostingsFieldsWriter parent;
    final FormatPostingsDocsWriter docsWriter;
    final TermInfosWriter termsOut;
    FieldInfo fieldInfo;
    char[] currentTerm;
    int currentTermStart;
    long freqStart;
    long proxStart;

    FormatPostingsTermsWriter(SegmentWriteState segmentWriteState, FormatPostingsFieldsWriter formatPostingsFieldsWriter) throws IOException {
        this.parent = formatPostingsFieldsWriter;
        this.termsOut = formatPostingsFieldsWriter.termsOut;
        this.docsWriter = new FormatPostingsDocsWriter(segmentWriteState, this);
    }

    void setField(FieldInfo fieldInfo) {
        this.fieldInfo = fieldInfo;
        this.docsWriter.setField(fieldInfo);
    }

    @Override
    FormatPostingsDocsConsumer addTerm(char[] cArray, int n) {
        this.currentTerm = cArray;
        this.currentTermStart = n;
        this.freqStart = this.docsWriter.out.getFilePointer();
        if (this.docsWriter.posWriter.out != null) {
            this.proxStart = this.docsWriter.posWriter.out.getFilePointer();
        }
        this.parent.skipListWriter.resetSkip();
        return this.docsWriter;
    }

    @Override
    void finish() {
    }

    @Override
    public void close() throws IOException {
        this.docsWriter.close();
    }
}

