/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.DefaultSkipListWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FormatPostingsFieldsConsumer;
import org.apache.lucene.index.FormatPostingsTermsConsumer;
import org.apache.lucene.index.FormatPostingsTermsWriter;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.TermInfosWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.IOUtils;

final class FormatPostingsFieldsWriter
extends FormatPostingsFieldsConsumer {
    final Directory dir;
    final String segment;
    TermInfosWriter termsOut;
    final FieldInfos fieldInfos;
    FormatPostingsTermsWriter termsWriter;
    final DefaultSkipListWriter skipListWriter;
    final int totalNumDocs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FormatPostingsFieldsWriter(SegmentWriteState segmentWriteState, FieldInfos fieldInfos) throws IOException {
        this.dir = segmentWriteState.directory;
        this.segment = segmentWriteState.segmentName;
        this.totalNumDocs = segmentWriteState.numDocs;
        this.fieldInfos = fieldInfos;
        boolean bl = false;
        try {
            this.termsOut = new TermInfosWriter(this.dir, this.segment, fieldInfos, segmentWriteState.termIndexInterval);
            this.skipListWriter = new DefaultSkipListWriter(this.termsOut.skipInterval, this.termsOut.maxSkipLevels, this.totalNumDocs, null, null);
            this.termsWriter = new FormatPostingsTermsWriter(segmentWriteState, this);
            return;
        }
        catch (Throwable throwable) {
            if (bl) throw throwable;
            IOUtils.closeWhileHandlingException(this.termsOut, this.termsWriter);
            throw throwable;
        }
    }

    @Override
    FormatPostingsTermsConsumer addField(FieldInfo fieldInfo) {
        this.termsWriter.setField(fieldInfo);
        return this.termsWriter;
    }

    @Override
    void finish() throws IOException {
        IOUtils.close(this.termsOut, this.termsWriter);
    }
}

