/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.DocFieldConsumerPerField;
import org.apache.lucene.index.DocInverterPerThread;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.InvertedDocConsumerPerField;
import org.apache.lucene.index.InvertedDocEndConsumerPerField;

final class DocInverterPerField
extends DocFieldConsumerPerField {
    private final DocInverterPerThread perThread;
    private final FieldInfo fieldInfo;
    final InvertedDocConsumerPerField consumer;
    final InvertedDocEndConsumerPerField endConsumer;
    final DocumentsWriter.DocState docState;
    final FieldInvertState fieldState;

    public DocInverterPerField(DocInverterPerThread docInverterPerThread, FieldInfo fieldInfo) {
        this.perThread = docInverterPerThread;
        this.fieldInfo = fieldInfo;
        this.docState = docInverterPerThread.docState;
        this.fieldState = docInverterPerThread.fieldState;
        this.consumer = docInverterPerThread.consumer.addField(this, fieldInfo);
        this.endConsumer = docInverterPerThread.endConsumer.addField(this, fieldInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void abort() {
        try {
            this.consumer.abort();
        }
        finally {
            this.endConsumer.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processFields(Fieldable[] fieldableArray, int n) throws IOException {
        this.fieldState.reset(this.docState.doc.getBoost());
        int n2 = this.docState.maxFieldLength;
        boolean bl = this.consumer.start(fieldableArray, n);
        for (int i = 0; i < n; ++i) {
            Fieldable fieldable = fieldableArray[i];
            if (fieldable.isIndexed() && bl) {
                int n3;
                Object object;
                if (i > 0) {
                    this.fieldState.position = this.fieldState.position + (this.docState.analyzer == null ? 0 : this.docState.analyzer.getPositionIncrementGap(this.fieldInfo.name));
                }
                if (!fieldable.isTokenized()) {
                    object = fieldable.stringValue();
                    int n4 = ((String)object).length();
                    this.perThread.singleToken.reinit((String)object, 0, n4);
                    this.fieldState.attributeSource = this.perThread.singleToken;
                    this.consumer.start(fieldable);
                    n3 = 0;
                    try {
                        this.consumer.add();
                        n3 = 1;
                    }
                    finally {
                        if (n3 == 0) {
                            this.docState.docWriter.setAborting();
                        }
                    }
                    this.fieldState.offset += n4;
                    ++this.fieldState.length;
                    ++this.fieldState.position;
                } else {
                    Object object2;
                    TokenStream tokenStream = fieldable.tokenStreamValue();
                    if (tokenStream != null) {
                        object = tokenStream;
                    } else {
                        Reader reader;
                        Reader reader2 = fieldable.readerValue();
                        if (reader2 != null) {
                            reader = reader2;
                        } else {
                            object2 = fieldable.stringValue();
                            if (object2 == null) {
                                throw new IllegalArgumentException("field must have either TokenStream, String or Reader value");
                            }
                            this.perThread.stringReader.init((String)object2);
                            reader = this.perThread.stringReader;
                        }
                        object = this.docState.analyzer.reusableTokenStream(this.fieldInfo.name, reader);
                    }
                    ((TokenStream)object).reset();
                    n3 = this.fieldState.length;
                    try {
                        boolean bl2 = ((TokenStream)object).incrementToken();
                        this.fieldState.attributeSource = object;
                        object2 = this.fieldState.attributeSource.addAttribute(OffsetAttribute.class);
                        PositionIncrementAttribute positionIncrementAttribute = this.fieldState.attributeSource.addAttribute(PositionIncrementAttribute.class);
                        this.consumer.start(fieldable);
                        while (bl2) {
                            int n5 = positionIncrementAttribute.getPositionIncrement();
                            this.fieldState.position += n5;
                            if (this.fieldState.position > 0) {
                                --this.fieldState.position;
                            }
                            if (n5 == 0) {
                                ++this.fieldState.numOverlap;
                            }
                            boolean bl3 = false;
                            try {
                                this.consumer.add();
                                bl3 = true;
                            }
                            finally {
                                if (!bl3) {
                                    this.docState.docWriter.setAborting();
                                }
                            }
                            ++this.fieldState.position;
                            if (++this.fieldState.length >= n2) {
                                if (this.docState.infoStream == null) break;
                                this.docState.infoStream.println("maxFieldLength " + n2 + " reached for field " + this.fieldInfo.name + ", ignoring following tokens");
                                break;
                            }
                            bl2 = ((TokenStream)object).incrementToken();
                        }
                        ((TokenStream)object).end();
                        this.fieldState.offset += object2.endOffset();
                    }
                    finally {
                        ((TokenStream)object).close();
                    }
                }
                this.fieldState.offset = this.fieldState.offset + (this.docState.analyzer == null ? 0 : this.docState.analyzer.getOffsetGap(fieldable));
                this.fieldState.boost *= fieldable.getBoost();
            }
            fieldableArray[i] = null;
        }
        this.consumer.finish();
        this.endConsumer.finish();
    }
}

