/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.MultiLevelSkipListReader;
import org.apache.lucene.store.IndexInput;

class DefaultSkipListReader
extends MultiLevelSkipListReader {
    private boolean currentFieldStoresPayloads;
    private long[] freqPointer;
    private long[] proxPointer;
    private int[] payloadLength;
    private long lastFreqPointer;
    private long lastProxPointer;
    private int lastPayloadLength;

    DefaultSkipListReader(IndexInput indexInput, int n, int n2) {
        super(indexInput, n, n2);
        this.freqPointer = new long[n];
        this.proxPointer = new long[n];
        this.payloadLength = new int[n];
    }

    void init(long l, long l2, long l3, int n, boolean bl) {
        super.init(l, n);
        this.currentFieldStoresPayloads = bl;
        this.lastFreqPointer = l2;
        this.lastProxPointer = l3;
        Arrays.fill(this.freqPointer, l2);
        Arrays.fill(this.proxPointer, l3);
        Arrays.fill(this.payloadLength, 0);
    }

    long getFreqPointer() {
        return this.lastFreqPointer;
    }

    long getProxPointer() {
        return this.lastProxPointer;
    }

    int getPayloadLength() {
        return this.lastPayloadLength;
    }

    @Override
    protected void seekChild(int n) throws IOException {
        super.seekChild(n);
        this.freqPointer[n] = this.lastFreqPointer;
        this.proxPointer[n] = this.lastProxPointer;
        this.payloadLength[n] = this.lastPayloadLength;
    }

    @Override
    protected void setLastSkipData(int n) {
        super.setLastSkipData(n);
        this.lastFreqPointer = this.freqPointer[n];
        this.lastProxPointer = this.proxPointer[n];
        this.lastPayloadLength = this.payloadLength[n];
    }

    @Override
    protected int readSkipData(int n, IndexInput indexInput) throws IOException {
        int n2;
        if (this.currentFieldStoresPayloads) {
            n2 = indexInput.readVInt();
            if ((n2 & 1) != 0) {
                this.payloadLength[n] = indexInput.readVInt();
            }
            n2 >>>= 1;
        } else {
            n2 = indexInput.readVInt();
        }
        int n3 = n;
        this.freqPointer[n3] = this.freqPointer[n3] + (long)indexInput.readVInt();
        int n4 = n;
        this.proxPointer[n4] = this.proxPointer[n4] + (long)indexInput.readVInt();
        return n2;
    }
}

