/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;

class CompoundFileReader
extends Directory {
    private int readBufferSize;
    private Directory directory;
    private String fileName;
    private IndexInput stream;
    private HashMap<String, FileEntry> entries = new HashMap();

    public CompoundFileReader(Directory directory, String string) throws IOException {
        this(directory, string, 1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompoundFileReader(Directory directory, String string, int n) throws IOException {
        assert (!(directory instanceof CompoundFileReader)) : "compound file inside of compound file: " + string;
        this.directory = directory;
        this.fileName = string;
        this.readBufferSize = n;
        boolean bl = false;
        try {
            boolean bl2;
            int n2;
            this.stream = directory.openInput(string, n);
            int n3 = this.stream.readVInt();
            if (n3 < 0) {
                if (n3 < -1) {
                    throw new CorruptIndexException("Incompatible format version: " + n3 + " expected " + -1 + " (resource: " + this.stream + ")");
                }
                n2 = this.stream.readVInt();
                bl2 = false;
            } else {
                n2 = n3;
                bl2 = true;
            }
            FileEntry fileEntry = null;
            for (int i = 0; i < n2; ++i) {
                long l = this.stream.readLong();
                String string2 = this.stream.readString();
                if (bl2) {
                    string2 = IndexFileNames.stripSegmentName(string2);
                }
                if (fileEntry != null) {
                    fileEntry.length = l - fileEntry.offset;
                }
                fileEntry = new FileEntry();
                fileEntry.offset = l;
                this.entries.put(string2, fileEntry);
            }
            if (fileEntry != null) {
                fileEntry.length = this.stream.length() - fileEntry.offset;
            }
            bl = true;
        }
        finally {
            if (!bl && this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public String getName() {
        return this.fileName;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.stream == null) {
            throw new IOException("Already closed");
        }
        this.entries.clear();
        this.stream.close();
        this.stream = null;
    }

    @Override
    public synchronized IndexInput openInput(String string) throws IOException {
        return this.openInput(string, this.readBufferSize);
    }

    @Override
    public synchronized IndexInput openInput(String string, int n) throws IOException {
        if (this.stream == null) {
            throw new IOException("Stream closed");
        }
        FileEntry fileEntry = this.entries.get(string = IndexFileNames.stripSegmentName(string));
        if (fileEntry == null) {
            throw new IOException("No sub-file with id " + string + " found (fileName=" + this.fileName + " files: " + this.entries.keySet() + ")");
        }
        return new CSIndexInput(this.stream, fileEntry.offset, fileEntry.length, n);
    }

    @Override
    public String[] listAll() {
        String[] stringArray = this.entries.keySet().toArray(new String[this.entries.size()]);
        String string = this.fileName.substring(0, this.fileName.indexOf(46));
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = string + stringArray[i];
        }
        return stringArray;
    }

    @Override
    public boolean fileExists(String string) {
        return this.entries.containsKey(IndexFileNames.stripSegmentName(string));
    }

    @Override
    public long fileModified(String string) throws IOException {
        return this.directory.fileModified(this.fileName);
    }

    @Override
    @Deprecated
    public void touchFile(String string) throws IOException {
        this.directory.touchFile(this.fileName);
    }

    @Override
    public void deleteFile(String string) {
        throw new UnsupportedOperationException();
    }

    public void renameFile(String string, String string2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long fileLength(String string) throws IOException {
        FileEntry fileEntry = this.entries.get(IndexFileNames.stripSegmentName(string));
        if (fileEntry == null) {
            throw new FileNotFoundException(string);
        }
        return fileEntry.length;
    }

    @Override
    public IndexOutput createOutput(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Lock makeLock(String string) {
        throw new UnsupportedOperationException();
    }

    static final class CSIndexInput
    extends BufferedIndexInput {
        IndexInput base;
        long fileOffset;
        long length;

        CSIndexInput(IndexInput indexInput, long l, long l2) {
            this(indexInput, l, l2, 1024);
        }

        CSIndexInput(IndexInput indexInput, long l, long l2, int n) {
            super(n);
            this.base = (IndexInput)indexInput.clone();
            this.fileOffset = l;
            this.length = l2;
        }

        @Override
        public Object clone() {
            CSIndexInput cSIndexInput = (CSIndexInput)super.clone();
            cSIndexInput.base = (IndexInput)this.base.clone();
            cSIndexInput.fileOffset = this.fileOffset;
            cSIndexInput.length = this.length;
            return cSIndexInput;
        }

        @Override
        protected void readInternal(byte[] byArray, int n, int n2) throws IOException {
            long l = this.getFilePointer();
            if (l + (long)n2 > this.length) {
                throw new EOFException("read past EOF (resource: " + this.base + ")");
            }
            this.base.seek(this.fileOffset + l);
            this.base.readBytes(byArray, n, n2, false);
        }

        @Override
        protected void seekInternal(long l) {
        }

        @Override
        public void close() throws IOException {
            this.base.close();
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public void copyBytes(IndexOutput indexOutput, long l) throws IOException {
            if ((l -= (long)this.flushBuffer(indexOutput, l)) > 0L) {
                long l2 = this.getFilePointer();
                if (l2 + l > this.length) {
                    throw new EOFException("read past EOF (resource: " + this.base + ")");
                }
                this.base.seek(this.fileOffset + l2);
                this.base.copyBytes(indexOutput, l);
            }
        }
    }

    private static final class FileEntry {
        long offset;
        long length;

        private FileEntry() {
        }
    }
}

