/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.Reader;
import org.apache.lucene.analysis.NumericTokenStream;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.AbstractField;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.FieldInfo;

public final class NumericField
extends AbstractField {
    private transient NumericTokenStream numericTS;
    private DataType type;
    private final int precisionStep;

    public NumericField(String string) {
        this(string, 4, Field.Store.NO, true);
    }

    public NumericField(String string, Field.Store store, boolean bl) {
        this(string, 4, store, bl);
    }

    public NumericField(String string, int n) {
        this(string, n, Field.Store.NO, true);
    }

    public NumericField(String string, int n, Field.Store store, boolean bl) {
        super(string, store, bl ? Field.Index.ANALYZED_NO_NORMS : Field.Index.NO, Field.TermVector.NO);
        this.precisionStep = n;
        this.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
    }

    @Override
    public TokenStream tokenStreamValue() {
        if (!this.isIndexed()) {
            return null;
        }
        if (this.numericTS == null) {
            this.numericTS = new NumericTokenStream(this.precisionStep);
            if (this.fieldsData != null) {
                assert (this.type != null);
                Number number = (Number)this.fieldsData;
                switch (this.type) {
                    case INT: {
                        this.numericTS.setIntValue(number.intValue());
                        break;
                    }
                    case LONG: {
                        this.numericTS.setLongValue(number.longValue());
                        break;
                    }
                    case FLOAT: {
                        this.numericTS.setFloatValue(number.floatValue());
                        break;
                    }
                    case DOUBLE: {
                        this.numericTS.setDoubleValue(number.doubleValue());
                        break;
                    }
                    default: {
                        assert (false) : "Should never get here";
                        break;
                    }
                }
            }
        }
        return this.numericTS;
    }

    @Override
    public byte[] getBinaryValue(byte[] byArray) {
        return null;
    }

    @Override
    public Reader readerValue() {
        return null;
    }

    @Override
    public String stringValue() {
        return this.fieldsData == null ? null : this.fieldsData.toString();
    }

    public Number getNumericValue() {
        return (Number)this.fieldsData;
    }

    public int getPrecisionStep() {
        return this.precisionStep;
    }

    public DataType getDataType() {
        return this.type;
    }

    public NumericField setLongValue(long l) {
        if (this.numericTS != null) {
            this.numericTS.setLongValue(l);
        }
        this.fieldsData = l;
        this.type = DataType.LONG;
        return this;
    }

    public NumericField setIntValue(int n) {
        if (this.numericTS != null) {
            this.numericTS.setIntValue(n);
        }
        this.fieldsData = n;
        this.type = DataType.INT;
        return this;
    }

    public NumericField setDoubleValue(double d) {
        if (this.numericTS != null) {
            this.numericTS.setDoubleValue(d);
        }
        this.fieldsData = d;
        this.type = DataType.DOUBLE;
        return this;
    }

    public NumericField setFloatValue(float f) {
        if (this.numericTS != null) {
            this.numericTS.setFloatValue(f);
        }
        this.fieldsData = Float.valueOf(f);
        this.type = DataType.FLOAT;
        return this;
    }

    public static enum DataType {
        INT,
        LONG,
        FLOAT,
        DOUBLE;

    }
}

