/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;

public class MapFieldSelector
implements FieldSelector {
    Map<String, FieldSelectorResult> fieldSelections;

    public MapFieldSelector(Map<String, FieldSelectorResult> map) {
        this.fieldSelections = map;
    }

    public MapFieldSelector(List<String> list) {
        this.fieldSelections = new HashMap<String, FieldSelectorResult>(list.size() * 5 / 3);
        for (String string : list) {
            this.fieldSelections.put(string, FieldSelectorResult.LOAD);
        }
    }

    public MapFieldSelector(String ... stringArray) {
        this(Arrays.asList(stringArray));
    }

    @Override
    public FieldSelectorResult accept(String string) {
        FieldSelectorResult fieldSelectorResult = this.fieldSelections.get(string);
        return fieldSelectorResult != null ? fieldSelectorResult : FieldSelectorResult.NO_LOAD;
    }
}

