/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.Reader;
import java.io.Serializable;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.AbstractField;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.util.StringHelper;

public final class Field
extends AbstractField
implements Fieldable,
Serializable {
    @Override
    public String stringValue() {
        return this.fieldsData instanceof String ? (String)this.fieldsData : null;
    }

    @Override
    public Reader readerValue() {
        return this.fieldsData instanceof Reader ? (Reader)this.fieldsData : null;
    }

    @Override
    public TokenStream tokenStreamValue() {
        return this.tokenStream;
    }

    public void setValue(String string) {
        if (this.isBinary) {
            throw new IllegalArgumentException("cannot set a String value on a binary field");
        }
        this.fieldsData = string;
    }

    public void setValue(Reader reader) {
        if (this.isBinary) {
            throw new IllegalArgumentException("cannot set a Reader value on a binary field");
        }
        if (this.isStored) {
            throw new IllegalArgumentException("cannot set a Reader value on a stored field");
        }
        this.fieldsData = reader;
    }

    public void setValue(byte[] byArray) {
        if (!this.isBinary) {
            throw new IllegalArgumentException("cannot set a byte[] value on a non-binary field");
        }
        this.fieldsData = byArray;
        this.binaryLength = byArray.length;
        this.binaryOffset = 0;
    }

    public void setValue(byte[] byArray, int n, int n2) {
        if (!this.isBinary) {
            throw new IllegalArgumentException("cannot set a byte[] value on a non-binary field");
        }
        this.fieldsData = byArray;
        this.binaryLength = n2;
        this.binaryOffset = n;
    }

    public void setTokenStream(TokenStream tokenStream) {
        this.isIndexed = true;
        this.isTokenized = true;
        this.tokenStream = tokenStream;
    }

    public Field(String string, String string2, Store store, Index index) {
        this(string, string2, store, index, TermVector.NO);
    }

    public Field(String string, String string2, Store store, Index index, TermVector termVector) {
        this(string, true, string2, store, index, termVector);
    }

    public Field(String string, boolean bl, String string2, Store store, Index index, TermVector termVector) {
        if (string == null) {
            throw new NullPointerException("name cannot be null");
        }
        if (string2 == null) {
            throw new NullPointerException("value cannot be null");
        }
        if (index == Index.NO && store == Store.NO) {
            throw new IllegalArgumentException("it doesn't make sense to have a field that is neither indexed nor stored");
        }
        if (index == Index.NO && termVector != TermVector.NO) {
            throw new IllegalArgumentException("cannot store term vector information for a field that is not indexed");
        }
        if (bl) {
            string = StringHelper.intern(string);
        }
        this.name = string;
        this.fieldsData = string2;
        this.isStored = store.isStored();
        this.isIndexed = index.isIndexed();
        this.isTokenized = index.isAnalyzed();
        this.omitNorms = index.omitNorms();
        if (index == Index.NO) {
            this.indexOptions = FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
        }
        this.isBinary = false;
        this.setStoreTermVector(termVector);
    }

    public Field(String string, Reader reader) {
        this(string, reader, TermVector.NO);
    }

    public Field(String string, Reader reader, TermVector termVector) {
        if (string == null) {
            throw new NullPointerException("name cannot be null");
        }
        if (reader == null) {
            throw new NullPointerException("reader cannot be null");
        }
        this.name = StringHelper.intern(string);
        this.fieldsData = reader;
        this.isStored = false;
        this.isIndexed = true;
        this.isTokenized = true;
        this.isBinary = false;
        this.setStoreTermVector(termVector);
    }

    public Field(String string, TokenStream tokenStream) {
        this(string, tokenStream, TermVector.NO);
    }

    public Field(String string, TokenStream tokenStream, TermVector termVector) {
        if (string == null) {
            throw new NullPointerException("name cannot be null");
        }
        if (tokenStream == null) {
            throw new NullPointerException("tokenStream cannot be null");
        }
        this.name = StringHelper.intern(string);
        this.fieldsData = null;
        this.tokenStream = tokenStream;
        this.isStored = false;
        this.isIndexed = true;
        this.isTokenized = true;
        this.isBinary = false;
        this.setStoreTermVector(termVector);
    }

    @Deprecated
    public Field(String string, byte[] byArray, Store store) {
        this(string, byArray, 0, byArray.length);
        if (store == Store.NO) {
            throw new IllegalArgumentException("binary values can't be unstored");
        }
    }

    public Field(String string, byte[] byArray) {
        this(string, byArray, 0, byArray.length);
    }

    @Deprecated
    public Field(String string, byte[] byArray, int n, int n2, Store store) {
        this(string, byArray, n, n2);
        if (store == Store.NO) {
            throw new IllegalArgumentException("binary values can't be unstored");
        }
    }

    public Field(String string, byte[] byArray, int n, int n2) {
        if (string == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.name = StringHelper.intern(string);
        this.fieldsData = byArray;
        this.isStored = true;
        this.isIndexed = false;
        this.isTokenized = false;
        this.indexOptions = FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
        this.omitNorms = true;
        this.isBinary = true;
        this.binaryLength = n2;
        this.binaryOffset = n;
        this.setStoreTermVector(TermVector.NO);
    }

    public static enum TermVector {
        NO{

            @Override
            public boolean isStored() {
                return false;
            }

            @Override
            public boolean withPositions() {
                return false;
            }

            @Override
            public boolean withOffsets() {
                return false;
            }
        }
        ,
        YES{

            @Override
            public boolean isStored() {
                return true;
            }

            @Override
            public boolean withPositions() {
                return false;
            }

            @Override
            public boolean withOffsets() {
                return false;
            }
        }
        ,
        WITH_POSITIONS{

            @Override
            public boolean isStored() {
                return true;
            }

            @Override
            public boolean withPositions() {
                return true;
            }

            @Override
            public boolean withOffsets() {
                return false;
            }
        }
        ,
        WITH_OFFSETS{

            @Override
            public boolean isStored() {
                return true;
            }

            @Override
            public boolean withPositions() {
                return false;
            }

            @Override
            public boolean withOffsets() {
                return true;
            }
        }
        ,
        WITH_POSITIONS_OFFSETS{

            @Override
            public boolean isStored() {
                return true;
            }

            @Override
            public boolean withPositions() {
                return true;
            }

            @Override
            public boolean withOffsets() {
                return true;
            }
        };


        public static TermVector toTermVector(boolean bl, boolean bl2, boolean bl3) {
            if (!bl) {
                return NO;
            }
            if (bl2) {
                if (bl3) {
                    return WITH_POSITIONS_OFFSETS;
                }
                return WITH_OFFSETS;
            }
            if (bl3) {
                return WITH_POSITIONS;
            }
            return YES;
        }

        public abstract boolean isStored();

        public abstract boolean withPositions();

        public abstract boolean withOffsets();
    }

    public static enum Index {
        NO{

            @Override
            public boolean isIndexed() {
                return false;
            }

            @Override
            public boolean isAnalyzed() {
                return false;
            }

            @Override
            public boolean omitNorms() {
                return true;
            }
        }
        ,
        ANALYZED{

            @Override
            public boolean isIndexed() {
                return true;
            }

            @Override
            public boolean isAnalyzed() {
                return true;
            }

            @Override
            public boolean omitNorms() {
                return false;
            }
        }
        ,
        NOT_ANALYZED{

            @Override
            public boolean isIndexed() {
                return true;
            }

            @Override
            public boolean isAnalyzed() {
                return false;
            }

            @Override
            public boolean omitNorms() {
                return false;
            }
        }
        ,
        NOT_ANALYZED_NO_NORMS{

            @Override
            public boolean isIndexed() {
                return true;
            }

            @Override
            public boolean isAnalyzed() {
                return false;
            }

            @Override
            public boolean omitNorms() {
                return true;
            }
        }
        ,
        ANALYZED_NO_NORMS{

            @Override
            public boolean isIndexed() {
                return true;
            }

            @Override
            public boolean isAnalyzed() {
                return true;
            }

            @Override
            public boolean omitNorms() {
                return true;
            }
        };


        public static Index toIndex(boolean bl, boolean bl2) {
            return Index.toIndex(bl, bl2, false);
        }

        public static Index toIndex(boolean bl, boolean bl2, boolean bl3) {
            if (!bl) {
                return NO;
            }
            if (!bl3) {
                if (bl2) {
                    return ANALYZED;
                }
                return NOT_ANALYZED;
            }
            if (bl2) {
                return ANALYZED_NO_NORMS;
            }
            return NOT_ANALYZED_NO_NORMS;
        }

        public abstract boolean isIndexed();

        public abstract boolean isAnalyzed();

        public abstract boolean omitNorms();
    }

    public static enum Store {
        YES{

            @Override
            public boolean isStored() {
                return true;
            }
        }
        ,
        NO{

            @Override
            public boolean isStored() {
                return false;
            }
        };


        public abstract boolean isStored();
    }
}

