/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.collation;

import java.io.IOException;
import java.text.Collator;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.util.IndexableBinaryStringTools;

public final class CollationKeyFilter
extends TokenFilter {
    private final Collator collator;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);

    public CollationKeyFilter(TokenStream tokenStream, Collator collator) {
        super(tokenStream);
        this.collator = (Collator)collator.clone();
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            byte[] byArray = this.collator.getCollationKey(this.termAtt.toString()).toByteArray();
            int n = IndexableBinaryStringTools.getEncodedLength(byArray, 0, byArray.length);
            this.termAtt.resizeBuffer(n);
            this.termAtt.setLength(n);
            IndexableBinaryStringTools.encode(byArray, 0, byArray.length, this.termAtt.buffer(), 0, n);
            return true;
        }
        return false;
    }
}

