/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.standard;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.standard.ClassicTokenizerImpl;
import org.apache.lucene.analysis.standard.StandardTokenizerImpl;
import org.apache.lucene.analysis.standard.StandardTokenizerInterface;
import org.apache.lucene.analysis.standard.std31.StandardTokenizerImpl31;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.Version;

public final class StandardTokenizer
extends Tokenizer {
    private StandardTokenizerInterface scanner;
    public static final int ALPHANUM = 0;
    @Deprecated
    public static final int APOSTROPHE = 1;
    @Deprecated
    public static final int ACRONYM = 2;
    @Deprecated
    public static final int COMPANY = 3;
    public static final int EMAIL = 4;
    @Deprecated
    public static final int HOST = 5;
    public static final int NUM = 6;
    @Deprecated
    public static final int CJ = 7;
    @Deprecated
    public static final int ACRONYM_DEP = 8;
    public static final int SOUTHEAST_ASIAN = 9;
    public static final int IDEOGRAPHIC = 10;
    public static final int HIRAGANA = 11;
    public static final int KATAKANA = 12;
    public static final int HANGUL = 13;
    public static final String[] TOKEN_TYPES = new String[]{"<ALPHANUM>", "<APOSTROPHE>", "<ACRONYM>", "<COMPANY>", "<EMAIL>", "<HOST>", "<NUM>", "<CJ>", "<ACRONYM_DEP>", "<SOUTHEAST_ASIAN>", "<IDEOGRAPHIC>", "<HIRAGANA>", "<KATAKANA>", "<HANGUL>"};
    private boolean replaceInvalidAcronym;
    private int maxTokenLength = 255;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = this.addAttribute(PositionIncrementAttribute.class);
    private final TypeAttribute typeAtt = this.addAttribute(TypeAttribute.class);

    public void setMaxTokenLength(int n) {
        this.maxTokenLength = n;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    public StandardTokenizer(Version version, Reader reader) {
        this.init(reader, version);
    }

    public StandardTokenizer(Version version, AttributeSource attributeSource, Reader reader) {
        super(attributeSource);
        this.init(reader, version);
    }

    public StandardTokenizer(Version version, AttributeSource.AttributeFactory attributeFactory, Reader reader) {
        super(attributeFactory);
        this.init(reader, version);
    }

    private final void init(Reader reader, Version version) {
        this.scanner = version.onOrAfter(Version.LUCENE_34) ? new StandardTokenizerImpl(reader) : (version.onOrAfter(Version.LUCENE_31) ? new StandardTokenizerImpl31(reader) : new ClassicTokenizerImpl(reader));
        this.replaceInvalidAcronym = version.onOrAfter(Version.LUCENE_24);
        this.input = reader;
    }

    @Override
    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        int n = 1;
        int n2;
        while ((n2 = this.scanner.getNextToken()) != -1) {
            if (this.scanner.yylength() <= this.maxTokenLength) {
                this.posIncrAtt.setPositionIncrement(n);
                this.scanner.getText(this.termAtt);
                int n3 = this.scanner.yychar();
                this.offsetAtt.setOffset(this.correctOffset(n3), this.correctOffset(n3 + this.termAtt.length()));
                if (n2 == 8) {
                    if (this.replaceInvalidAcronym) {
                        this.typeAtt.setType(TOKEN_TYPES[5]);
                        this.termAtt.setLength(this.termAtt.length() - 1);
                    } else {
                        this.typeAtt.setType(TOKEN_TYPES[2]);
                    }
                } else {
                    this.typeAtt.setType(TOKEN_TYPES[n2]);
                }
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public final void end() {
        int n = this.correctOffset(this.scanner.yychar() + this.scanner.yylength());
        this.offsetAtt.setOffset(n, n);
    }

    @Override
    public void reset(Reader reader) throws IOException {
        super.reset(reader);
        this.scanner.yyreset(reader);
    }

    @Deprecated
    public boolean isReplaceInvalidAcronym() {
        return this.replaceInvalidAcronym;
    }

    @Deprecated
    public void setReplaceInvalidAcronym(boolean bl) {
        this.replaceInvalidAcronym = bl;
    }
}

