/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.standard;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.standard.ClassicTokenizerImpl;
import org.apache.lucene.analysis.standard.StandardTokenizerInterface;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.Version;

public final class ClassicTokenizer
extends Tokenizer {
    private StandardTokenizerInterface scanner;
    public static final int ALPHANUM = 0;
    public static final int APOSTROPHE = 1;
    public static final int ACRONYM = 2;
    public static final int COMPANY = 3;
    public static final int EMAIL = 4;
    public static final int HOST = 5;
    public static final int NUM = 6;
    public static final int CJ = 7;
    @Deprecated
    public static final int ACRONYM_DEP = 8;
    public static final String[] TOKEN_TYPES = new String[]{"<ALPHANUM>", "<APOSTROPHE>", "<ACRONYM>", "<COMPANY>", "<EMAIL>", "<HOST>", "<NUM>", "<CJ>", "<ACRONYM_DEP>"};
    private boolean replaceInvalidAcronym;
    private int maxTokenLength = 255;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = this.addAttribute(PositionIncrementAttribute.class);
    private final TypeAttribute typeAtt = this.addAttribute(TypeAttribute.class);

    public void setMaxTokenLength(int n) {
        this.maxTokenLength = n;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    public ClassicTokenizer(Version version, Reader reader) {
        this.init(reader, version);
    }

    public ClassicTokenizer(Version version, AttributeSource attributeSource, Reader reader) {
        super(attributeSource);
        this.init(reader, version);
    }

    public ClassicTokenizer(Version version, AttributeSource.AttributeFactory attributeFactory, Reader reader) {
        super(attributeFactory);
        this.init(reader, version);
    }

    private final void init(Reader reader, Version version) {
        this.scanner = new ClassicTokenizerImpl(reader);
        this.replaceInvalidAcronym = version.onOrAfter(Version.LUCENE_24);
        this.input = reader;
    }

    @Override
    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        int n = 1;
        int n2;
        while ((n2 = this.scanner.getNextToken()) != -1) {
            if (this.scanner.yylength() <= this.maxTokenLength) {
                this.posIncrAtt.setPositionIncrement(n);
                this.scanner.getText(this.termAtt);
                int n3 = this.scanner.yychar();
                this.offsetAtt.setOffset(this.correctOffset(n3), this.correctOffset(n3 + this.termAtt.length()));
                if (n2 == 8) {
                    if (this.replaceInvalidAcronym) {
                        this.typeAtt.setType(TOKEN_TYPES[5]);
                        this.termAtt.setLength(this.termAtt.length() - 1);
                    } else {
                        this.typeAtt.setType(TOKEN_TYPES[2]);
                    }
                } else {
                    this.typeAtt.setType(TOKEN_TYPES[n2]);
                }
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public final void end() {
        int n = this.correctOffset(this.scanner.yychar() + this.scanner.yylength());
        this.offsetAtt.setOffset(n, n);
    }

    @Override
    public void reset(Reader reader) throws IOException {
        super.reset(reader);
        this.scanner.yyreset(reader);
    }

    @Deprecated
    public boolean isReplaceInvalidAcronym() {
        return this.replaceInvalidAcronym;
    }

    @Deprecated
    public void setReplaceInvalidAcronym(boolean bl) {
        this.replaceInvalidAcronym = bl;
    }
}

