/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.standard;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.standard.ClassicFilter;
import org.apache.lucene.analysis.standard.ClassicTokenizer;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;

public final class ClassicAnalyzer
extends StopwordAnalyzerBase {
    public static final int DEFAULT_MAX_TOKEN_LENGTH = 255;
    private int maxTokenLength = 255;
    private final boolean replaceInvalidAcronym;
    public static final Set<?> STOP_WORDS_SET = StopAnalyzer.ENGLISH_STOP_WORDS_SET;

    public ClassicAnalyzer(Version version, Set<?> set) {
        super(version, set);
        this.replaceInvalidAcronym = version.onOrAfter(Version.LUCENE_24);
    }

    public ClassicAnalyzer(Version version) {
        this(version, STOP_WORDS_SET);
    }

    public ClassicAnalyzer(Version version, File file) throws IOException {
        this(version, WordlistLoader.getWordSet(IOUtils.getDecodingReader(file, IOUtils.CHARSET_UTF_8), version));
    }

    public ClassicAnalyzer(Version version, Reader reader) throws IOException {
        this(version, WordlistLoader.getWordSet(reader, version));
    }

    public void setMaxTokenLength(int n) {
        this.maxTokenLength = n;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    @Override
    protected ReusableAnalyzerBase.TokenStreamComponents createComponents(String string, Reader reader) {
        final ClassicTokenizer classicTokenizer = new ClassicTokenizer(this.matchVersion, reader);
        classicTokenizer.setMaxTokenLength(this.maxTokenLength);
        classicTokenizer.setReplaceInvalidAcronym(this.replaceInvalidAcronym);
        TokenFilter tokenFilter = new ClassicFilter(classicTokenizer);
        tokenFilter = new LowerCaseFilter(this.matchVersion, tokenFilter);
        tokenFilter = new StopFilter(this.matchVersion, (TokenStream)tokenFilter, this.stopwords);
        return new ReusableAnalyzerBase.TokenStreamComponents(classicTokenizer, tokenFilter){

            @Override
            protected boolean reset(Reader reader) throws IOException {
                classicTokenizer.setMaxTokenLength(ClassicAnalyzer.this.maxTokenLength);
                return super.reset(reader);
            }
        };
    }
}

