/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public final class LimitTokenCountFilter
extends TokenFilter {
    private final int maxTokenCount;
    private int tokenCount = 0;

    public LimitTokenCountFilter(TokenStream tokenStream, int n) {
        super(tokenStream);
        this.maxTokenCount = n;
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.tokenCount < this.maxTokenCount && this.input.incrementToken()) {
            ++this.tokenCount;
            return true;
        }
        return false;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.tokenCount = 0;
    }
}

