/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.util.AttributeSource;

public final class KeywordTokenizer
extends Tokenizer {
    private static final int DEFAULT_BUFFER_SIZE = 256;
    private boolean done = false;
    private int finalOffset;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);

    public KeywordTokenizer(Reader reader) {
        this(reader, 256);
    }

    public KeywordTokenizer(Reader reader, int n) {
        super(reader);
        this.termAtt.resizeBuffer(n);
    }

    public KeywordTokenizer(AttributeSource attributeSource, Reader reader, int n) {
        super(attributeSource, reader);
        this.termAtt.resizeBuffer(n);
    }

    public KeywordTokenizer(AttributeSource.AttributeFactory attributeFactory, Reader reader, int n) {
        super(attributeFactory, reader);
        this.termAtt.resizeBuffer(n);
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (!this.done) {
            int n;
            this.clearAttributes();
            this.done = true;
            int n2 = 0;
            char[] cArray = this.termAtt.buffer();
            while ((n = this.input.read(cArray, n2, cArray.length - n2)) != -1) {
                if ((n2 += n) != cArray.length) continue;
                cArray = this.termAtt.resizeBuffer(1 + cArray.length);
            }
            this.termAtt.setLength(n2);
            this.finalOffset = this.correctOffset(n2);
            this.offsetAtt.setOffset(this.correctOffset(0), this.finalOffset);
            return true;
        }
        return false;
    }

    @Override
    public final void end() {
        this.offsetAtt.setOffset(this.finalOffset, this.finalOffset);
    }

    @Override
    public void reset(Reader reader) throws IOException {
        super.reset(reader);
        this.done = false;
    }
}

