/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import net.jcip.annotations.Immutable;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;
import org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import org.apache.http.impl.cookie.DateParseException;
import org.apache.http.impl.cookie.DateUtils;

@Immutable
public class BasicExpiresHandler
extends AbstractCookieAttributeHandler {
    private final String[] datepatterns;

    public BasicExpiresHandler(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("Array of date patterns may not be null");
        }
        this.datepatterns = stringArray;
    }

    @Override
    public void parse(SetCookie setCookie, String string) throws MalformedCookieException {
        if (setCookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (string == null) {
            throw new MalformedCookieException("Missing value for expires attribute");
        }
        try {
            setCookie.setExpiryDate(DateUtils.parseDate(string, this.datepatterns));
        }
        catch (DateParseException dateParseException) {
            throw new MalformedCookieException("Unable to parse expires attribute: " + string);
        }
    }
}

