/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import net.jcip.annotations.Immutable;
import org.apache.http.impl.conn.Wire;
import org.apache.http.io.HttpTransportMetrics;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.util.CharArrayBuffer;

@Immutable
public class LoggingSessionInputBuffer
implements SessionInputBuffer {
    private final SessionInputBuffer in;
    private final Wire wire;

    public LoggingSessionInputBuffer(SessionInputBuffer sessionInputBuffer, Wire wire) {
        this.in = sessionInputBuffer;
        this.wire = wire;
    }

    public boolean isDataAvailable(int n) throws IOException {
        return this.in.isDataAvailable(n);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (this.wire.enabled() && n3 > 0) {
            this.wire.input(byArray, n, n3);
        }
        return n3;
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (this.wire.enabled() && n != -1) {
            this.wire.input(n);
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.in.read(byArray);
        if (this.wire.enabled() && n > 0) {
            this.wire.input(byArray, 0, n);
        }
        return n;
    }

    public String readLine() throws IOException {
        String string = this.in.readLine();
        if (this.wire.enabled() && string != null) {
            this.wire.input(string + "[EOL]");
        }
        return string;
    }

    public int readLine(CharArrayBuffer charArrayBuffer) throws IOException {
        int n = this.in.readLine(charArrayBuffer);
        if (this.wire.enabled() && n >= 0) {
            int n2 = charArrayBuffer.length() - n;
            String string = new String(charArrayBuffer.buffer(), n2, n);
            this.wire.input(string + "[EOL]");
        }
        return n;
    }

    public HttpTransportMetrics getMetrics() {
        return this.in.getMetrics();
    }
}

