/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.util.Map;
import net.jcip.annotations.Immutable;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.impl.client.AbstractAuthenticationHandler;
import org.apache.http.protocol.HttpContext;

@Immutable
public class DefaultTargetAuthenticationHandler
extends AbstractAuthenticationHandler {
    @Override
    public boolean isAuthenticationRequested(HttpResponse httpResponse, HttpContext httpContext) {
        if (httpResponse == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        int n = httpResponse.getStatusLine().getStatusCode();
        return n == 401;
    }

    @Override
    public Map<String, Header> getChallenges(HttpResponse httpResponse, HttpContext httpContext) throws MalformedChallengeException {
        if (httpResponse == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        Header[] headerArray = httpResponse.getHeaders("WWW-Authenticate");
        return this.parseChallenges(headerArray);
    }
}

