/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.scheme;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import net.jcip.annotations.Immutable;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.scheme.HostNameResolver;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

@Immutable
public final class PlainSocketFactory
implements SocketFactory {
    private static final PlainSocketFactory DEFAULT_FACTORY = new PlainSocketFactory();
    private final HostNameResolver nameResolver;

    public static PlainSocketFactory getSocketFactory() {
        return DEFAULT_FACTORY;
    }

    public PlainSocketFactory(HostNameResolver hostNameResolver) {
        this.nameResolver = hostNameResolver;
    }

    public PlainSocketFactory() {
        this(null);
    }

    @Override
    public Socket createSocket() {
        return new Socket();
    }

    @Override
    public Socket connectSocket(Socket socket, String string, int n, InetAddress inetAddress, int n2, HttpParams httpParams) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("Target host may not be null.");
        }
        if (httpParams == null) {
            throw new IllegalArgumentException("Parameters may not be null.");
        }
        if (socket == null) {
            socket = this.createSocket();
        }
        if (inetAddress != null || n2 > 0) {
            if (n2 < 0) {
                n2 = 0;
            }
            InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n2);
            socket.bind(inetSocketAddress);
        }
        int n3 = HttpConnectionParams.getConnectionTimeout((HttpParams)httpParams);
        InetSocketAddress inetSocketAddress = this.nameResolver != null ? new InetSocketAddress(this.nameResolver.resolve(string), n) : new InetSocketAddress(string, n);
        try {
            socket.connect(inetSocketAddress, n3);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            throw new ConnectTimeoutException("Connect to " + inetSocketAddress + " timed out");
        }
        return socket;
    }

    @Override
    public final boolean isSecure(Socket socket) throws IllegalArgumentException {
        if (socket == null) {
            throw new IllegalArgumentException("Socket may not be null.");
        }
        if (socket.isClosed()) {
            throw new IllegalArgumentException("Socket is closed.");
        }
        return false;
    }
}

