/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.mp4.field;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.mp4.Mp4FieldKey;
import org.jaudiotagger.tag.mp4.atom.Mp4DataBox;
import org.jaudiotagger.tag.mp4.field.Mp4FieldType;
import org.jaudiotagger.tag.mp4.field.Mp4TagTextField;

public class Mp4TagByteField
extends Mp4TagTextField {
    public static String TRUE_VALUE = "1";
    private int realDataLength;
    private byte[] bytedata;

    public Mp4TagByteField(Mp4FieldKey mp4FieldKey, String string) throws FieldDataInvalidException {
        this(mp4FieldKey, string, 1);
    }

    public Mp4TagByteField(Mp4FieldKey mp4FieldKey, String string, int n) throws FieldDataInvalidException {
        super(mp4FieldKey.getFieldName(), string);
        this.realDataLength = n;
        try {
            Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new FieldDataInvalidException("Value of:" + string + " is invalid for field:" + (Object)((Object)mp4FieldKey));
        }
    }

    public Mp4TagByteField(String string, ByteBuffer byteBuffer) throws UnsupportedEncodingException {
        super(string, byteBuffer);
    }

    @Override
    public Mp4FieldType getFieldType() {
        return Mp4FieldType.INTEGER;
    }

    @Override
    protected byte[] getDataBytes() throws UnsupportedEncodingException {
        if (this.bytedata != null) {
            return this.bytedata;
        }
        switch (this.realDataLength) {
            case 2: {
                Short s = new Short(this.content);
                byte[] byArray = Utils.getSizeBEInt16(s);
                return byArray;
            }
            case 1: {
                Short s = new Short(this.content);
                byte[] byArray = new byte[]{s.byteValue()};
                return byArray;
            }
            case 4: {
                Integer n = new Integer(this.content);
                byte[] byArray = Utils.getSizeBEInt32(n);
                return byArray;
            }
        }
        throw new RuntimeException(this.id + ":" + this.realDataLength + ":" + "Dont know how to write byte fields of this length");
    }

    @Override
    protected void build(ByteBuffer byteBuffer) throws UnsupportedEncodingException {
        Mp4BoxHeader mp4BoxHeader = new Mp4BoxHeader(byteBuffer);
        Mp4DataBox mp4DataBox = new Mp4DataBox(mp4BoxHeader, byteBuffer);
        this.dataSize = mp4BoxHeader.getDataLength();
        this.realDataLength = this.dataSize - 8;
        this.bytedata = mp4DataBox.getByteData();
        this.content = mp4DataBox.getContent();
    }
}

