/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.lyrics3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import org.jaudiotagger.tag.id3.AbstractTagFrame;
import org.jaudiotagger.tag.id3.framebody.AbstractFrameBodyTextInfo;
import org.jaudiotagger.tag.id3.framebody.FrameBodyCOMM;
import org.jaudiotagger.tag.id3.framebody.FrameBodySYLT;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUSLT;
import org.jaudiotagger.tag.lyrics3.AbstractLyrics3v2FieldFrameBody;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyAUT;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyEAL;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyEAR;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyETT;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyIMG;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyIND;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyINF;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyLYR;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyUnsupported;
import org.jaudiotagger.tag.lyrics3.Lyrics3v2Fields;

public class Lyrics3v2Field
extends AbstractTagFrame {
    public Lyrics3v2Field() {
    }

    public Lyrics3v2Field(Lyrics3v2Field lyrics3v2Field) {
        super(lyrics3v2Field);
    }

    public Lyrics3v2Field(AbstractLyrics3v2FieldFrameBody abstractLyrics3v2FieldFrameBody) {
        this.frameBody = abstractLyrics3v2FieldFrameBody;
    }

    public Lyrics3v2Field(AbstractID3v2Frame abstractID3v2Frame) throws TagException {
        String string = abstractID3v2Frame.getIdentifier();
        if (string.startsWith("USLT")) {
            this.frameBody = new FieldFrameBodyLYR("");
            ((FieldFrameBodyLYR)this.frameBody).addLyric((FrameBodyUSLT)abstractID3v2Frame.getBody());
        } else if (string.startsWith("SYLT")) {
            this.frameBody = new FieldFrameBodyLYR("");
            ((FieldFrameBodyLYR)this.frameBody).addLyric((FrameBodySYLT)abstractID3v2Frame.getBody());
        } else if (string.startsWith("COMM")) {
            String string2 = ((FrameBodyCOMM)abstractID3v2Frame.getBody()).getText();
            this.frameBody = new FieldFrameBodyINF(string2);
        } else if (string.equals("TCOM")) {
            AbstractFrameBodyTextInfo abstractFrameBodyTextInfo = (AbstractFrameBodyTextInfo)abstractID3v2Frame.getBody();
            this.frameBody = new FieldFrameBodyAUT("");
            if (abstractFrameBodyTextInfo != null && abstractFrameBodyTextInfo.getText().length() > 0) {
                this.frameBody = new FieldFrameBodyAUT(abstractFrameBodyTextInfo.getText());
            }
        } else if (string.equals("TALB")) {
            AbstractFrameBodyTextInfo abstractFrameBodyTextInfo = (AbstractFrameBodyTextInfo)abstractID3v2Frame.getBody();
            if (abstractFrameBodyTextInfo != null && abstractFrameBodyTextInfo.getText().length() > 0) {
                this.frameBody = new FieldFrameBodyEAL(abstractFrameBodyTextInfo.getText());
            }
        } else if (string.equals("TPE1")) {
            AbstractFrameBodyTextInfo abstractFrameBodyTextInfo = (AbstractFrameBodyTextInfo)abstractID3v2Frame.getBody();
            if (abstractFrameBodyTextInfo != null && abstractFrameBodyTextInfo.getText().length() > 0) {
                this.frameBody = new FieldFrameBodyEAR(abstractFrameBodyTextInfo.getText());
            }
        } else if (string.equals("TIT2")) {
            AbstractFrameBodyTextInfo abstractFrameBodyTextInfo = (AbstractFrameBodyTextInfo)abstractID3v2Frame.getBody();
            if (abstractFrameBodyTextInfo != null && abstractFrameBodyTextInfo.getText().length() > 0) {
                this.frameBody = new FieldFrameBodyETT(abstractFrameBodyTextInfo.getText());
            }
        } else {
            throw new TagException("Cannot createField Lyrics3v2 field from given ID3v2 frame");
        }
    }

    public Lyrics3v2Field(ByteBuffer byteBuffer) throws InvalidTagException {
        this.read(byteBuffer);
    }

    @Override
    public String getIdentifier() {
        if (this.frameBody == null) {
            return "";
        }
        return this.frameBody.getIdentifier();
    }

    @Override
    public int getSize() {
        return this.frameBody.getSize() + 5 + this.getIdentifier().length();
    }

    @Override
    public void read(ByteBuffer byteBuffer) throws InvalidTagException {
        byte by;
        byte[] byArray = new byte[6];
        while ((by = byteBuffer.get()) == 0) {
        }
        byteBuffer.position(byteBuffer.position() - 1);
        byteBuffer.get(byArray, 0, 3);
        String string = new String(byArray, 0, 3);
        if (!Lyrics3v2Fields.isLyrics3v2FieldIdentifier(string)) {
            throw new InvalidTagException(string + " is not a valid ID3v2.4 frame");
        }
        this.frameBody = this.readBody(string, byteBuffer);
    }

    @Override
    public String toString() {
        if (this.frameBody == null) {
            return "";
        }
        return this.frameBody.toString();
    }

    public void write(RandomAccessFile randomAccessFile) throws IOException {
        if (this.frameBody.getSize() > 0 || TagOptionSingleton.getInstance().isLyrics3SaveEmptyField()) {
            byte[] byArray = new byte[3];
            String string = this.getIdentifier();
            for (int i = 0; i < string.length(); ++i) {
                byArray[i] = (byte)string.charAt(i);
            }
            randomAccessFile.write(byArray, 0, string.length());
        }
    }

    private AbstractLyrics3v2FieldFrameBody readBody(String string, ByteBuffer byteBuffer) throws InvalidTagException {
        AbstractLyrics3v2FieldFrameBody abstractLyrics3v2FieldFrameBody = string.equals("AUT") ? new FieldFrameBodyAUT(byteBuffer) : (string.equals("EAL") ? new FieldFrameBodyEAL(byteBuffer) : (string.equals("EAR") ? new FieldFrameBodyEAR(byteBuffer) : (string.equals("ETT") ? new FieldFrameBodyETT(byteBuffer) : (string.equals("IMG") ? new FieldFrameBodyIMG(byteBuffer) : (string.equals("IND") ? new FieldFrameBodyIND(byteBuffer) : (string.equals("INF") ? new FieldFrameBodyINF(byteBuffer) : (string.equals("LYR") ? new FieldFrameBodyLYR(byteBuffer) : new FieldFrameBodyUnsupported(byteBuffer))))))));
        return abstractLyrics3v2FieldFrameBody;
    }
}

