/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.lyrics3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.datatype.Lyrics3Image;
import org.jaudiotagger.tag.lyrics3.AbstractLyrics3v2FieldFrameBody;
import org.jaudiotagger.tag.lyrics3.Lyrics3v2Fields;

public class FieldFrameBodyIMG
extends AbstractLyrics3v2FieldFrameBody {
    private ArrayList<Lyrics3Image> images = new ArrayList();

    public FieldFrameBodyIMG() {
    }

    public FieldFrameBodyIMG(FieldFrameBodyIMG fieldFrameBodyIMG) {
        super(fieldFrameBodyIMG);
        for (int i = 0; i < fieldFrameBodyIMG.images.size(); ++i) {
            Lyrics3Image lyrics3Image = fieldFrameBodyIMG.images.get(i);
            this.images.add(new Lyrics3Image(lyrics3Image));
        }
    }

    public FieldFrameBodyIMG(String string) {
        this.readString(string);
    }

    public FieldFrameBodyIMG(Lyrics3Image lyrics3Image) {
        this.images.add(lyrics3Image);
    }

    public FieldFrameBodyIMG(ByteBuffer byteBuffer) throws InvalidTagException {
        this.read(byteBuffer);
    }

    @Override
    public String getIdentifier() {
        return "IMG";
    }

    @Override
    public int getSize() {
        int n = 0;
        Iterator<Lyrics3Image> iterator = this.images.iterator();
        while (iterator.hasNext()) {
            Lyrics3Image lyrics3Image;
            Lyrics3Image lyrics3Image2 = lyrics3Image = iterator.next();
            n += lyrics3Image2.getSize() + 2;
        }
        return n - 2;
    }

    @Override
    public boolean isSubsetOf(Object object) {
        if (!(object instanceof FieldFrameBodyIMG)) {
            return false;
        }
        ArrayList<Lyrics3Image> arrayList = ((FieldFrameBodyIMG)object).images;
        for (Lyrics3Image lyrics3Image : this.images) {
            if (arrayList.contains(lyrics3Image)) continue;
            return false;
        }
        return super.isSubsetOf(object);
    }

    public void setValue(String string) {
        this.readString(string);
    }

    public String getValue() {
        return this.writeString();
    }

    public void addImage(Lyrics3Image lyrics3Image) {
        this.images.add(lyrics3Image);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof FieldFrameBodyIMG)) {
            return false;
        }
        FieldFrameBodyIMG fieldFrameBodyIMG = (FieldFrameBodyIMG)object;
        return this.images.equals(fieldFrameBodyIMG.images) && super.equals(object);
    }

    @Override
    public Iterator<Lyrics3Image> iterator() {
        return this.images.iterator();
    }

    @Override
    public void read(ByteBuffer byteBuffer) throws InvalidTagException {
        byte[] byArray = new byte[5];
        byteBuffer.get(byArray, 0, 5);
        int n = Integer.parseInt(new String(byArray, 0, 5));
        if (n == 0 && !TagOptionSingleton.getInstance().isLyrics3KeepEmptyFieldIfRead()) {
            throw new InvalidTagException("Lyircs3v2 Field has size of zero.");
        }
        byArray = new byte[n];
        byteBuffer.get(byArray);
        String string = new String(byArray);
        this.readString(string);
    }

    @Override
    public String toString() {
        String string = this.getIdentifier() + " : ";
        for (Lyrics3Image lyrics3Image : this.images) {
            string = string + ((Object)lyrics3Image).toString() + " ; ";
        }
        return string;
    }

    @Override
    public void write(RandomAccessFile randomAccessFile) throws IOException {
        int n;
        int n2 = 0;
        byte[] byArray = new byte[5];
        int n3 = this.getSize();
        String string = Integer.toString(n3);
        for (n = 0; n < 5 - string.length(); ++n) {
            byArray[n] = 48;
        }
        n2 += 5 - string.length();
        for (n = 0; n < string.length(); ++n) {
            byArray[n + n2] = (byte)string.charAt(n);
        }
        n2 += string.length();
        randomAccessFile.write(byArray, 0, 5);
        if (n3 > 0) {
            string = this.writeString();
            byArray = new byte[string.length()];
            for (n = 0; n < string.length(); ++n) {
                byArray[n] = (byte)string.charAt(n);
            }
            randomAccessFile.write(byArray);
        }
    }

    private void readString(String string) {
        Lyrics3Image lyrics3Image;
        String string2;
        int n = 0;
        int n2 = string.indexOf(Lyrics3v2Fields.CRLF);
        this.images = new ArrayList();
        while (n2 >= 0) {
            string2 = string.substring(n, n2);
            lyrics3Image = new Lyrics3Image("Image", this);
            lyrics3Image.setFilename(string2);
            this.images.add(lyrics3Image);
            n = n2 + Lyrics3v2Fields.CRLF.length();
            n2 = string.indexOf(Lyrics3v2Fields.CRLF, n);
        }
        if (n < string.length()) {
            string2 = string.substring(n);
            lyrics3Image = new Lyrics3Image("Image", this);
            lyrics3Image.setFilename(string2);
            this.images.add(lyrics3Image);
        }
    }

    private String writeString() {
        String string = "";
        Iterator<Lyrics3Image> iterator = this.images.iterator();
        while (iterator.hasNext()) {
            Lyrics3Image lyrics3Image;
            Lyrics3Image lyrics3Image2 = lyrics3Image = iterator.next();
            string = string + lyrics3Image2.writeString() + Lyrics3v2Fields.CRLF;
        }
        if (string.length() > 2) {
            return string.substring(0, string.length() - 2);
        }
        return string;
    }

    @Override
    protected void setupObjectList() {
    }
}

