/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3.framebody;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.datatype.AbstractString;
import org.jaudiotagger.tag.datatype.Lyrics3Line;
import org.jaudiotagger.tag.datatype.NumberHashMap;
import org.jaudiotagger.tag.datatype.StringHashMap;
import org.jaudiotagger.tag.datatype.TextEncodedStringNullTerminated;
import org.jaudiotagger.tag.datatype.TextEncodedStringSizeTerminated;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.ID3TextEncodingConversion;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;
import org.jaudiotagger.tag.id3.framebody.ID3v23FrameBody;
import org.jaudiotagger.tag.id3.framebody.ID3v24FrameBody;

public class FrameBodyUSLT
extends AbstractID3v2FrameBody
implements ID3v23FrameBody,
ID3v24FrameBody {
    public FrameBodyUSLT() {
        this.setObjectValue("TextEncoding", (byte)0);
        this.setObjectValue("Language", "");
        this.setObjectValue("Description", "");
        this.setObjectValue("Lyrics", "");
    }

    public FrameBodyUSLT(FrameBodyUSLT frameBodyUSLT) {
        super(frameBodyUSLT);
    }

    public FrameBodyUSLT(byte by, String string, String string2, String string3) {
        this.setObjectValue("TextEncoding", by);
        this.setObjectValue("Language", string);
        this.setObjectValue("Description", string2);
        this.setObjectValue("Lyrics", string3);
    }

    public FrameBodyUSLT(ByteBuffer byteBuffer, int n) throws InvalidTagException {
        super(byteBuffer, n);
    }

    @Override
    public String getUserFriendlyValue() {
        return this.getFirstTextValue();
    }

    public void setDescription(String string) {
        this.setObjectValue("Description", string);
    }

    public String getDescription() {
        return (String)this.getObjectValue("Description");
    }

    @Override
    public String getIdentifier() {
        return "USLT";
    }

    public void setLanguage(String string) {
        this.setObjectValue("Language", string);
    }

    public String getLanguage() {
        return (String)this.getObjectValue("Language");
    }

    public void setLyric(String string) {
        this.setObjectValue("Lyrics", string);
    }

    public String getLyric() {
        return (String)this.getObjectValue("Lyrics");
    }

    public String getFirstTextValue() {
        TextEncodedStringSizeTerminated textEncodedStringSizeTerminated = (TextEncodedStringSizeTerminated)this.getObject("Lyrics");
        return textEncodedStringSizeTerminated.getValueAtIndex(0);
    }

    public void addLyric(String string) {
        this.setLyric(this.getLyric() + string);
    }

    public void addLyric(Lyrics3Line lyrics3Line) {
        this.setLyric(this.getLyric() + lyrics3Line.writeString());
    }

    @Override
    public void write(ByteArrayOutputStream byteArrayOutputStream) {
        this.setTextEncoding(ID3TextEncodingConversion.getTextEncoding(this.getHeader(), this.getTextEncoding()));
        if (!((AbstractString)this.getObject("Description")).canBeEncoded()) {
            this.setTextEncoding(ID3TextEncodingConversion.getUnicodeTextEncoding(this.getHeader()));
        }
        if (!((AbstractString)this.getObject("Lyrics")).canBeEncoded()) {
            this.setTextEncoding(ID3TextEncodingConversion.getUnicodeTextEncoding(this.getHeader()));
        }
        super.write(byteArrayOutputStream);
    }

    @Override
    protected void setupObjectList() {
        this.objectList.add(new NumberHashMap("TextEncoding", (AbstractTagFrameBody)this, 1));
        this.objectList.add(new StringHashMap("Language", (AbstractTagFrameBody)this, 3));
        this.objectList.add(new TextEncodedStringNullTerminated("Description", this));
        this.objectList.add(new TextEncodedStringSizeTerminated("Lyrics", this));
    }
}

