/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3.framebody;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.datatype.AbstractString;
import org.jaudiotagger.tag.datatype.ByteArraySizeTerminated;
import org.jaudiotagger.tag.datatype.NumberHashMap;
import org.jaudiotagger.tag.datatype.StringNullTerminated;
import org.jaudiotagger.tag.datatype.TextEncodedStringNullTerminated;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;
import org.jaudiotagger.tag.id3.framebody.FrameBodyPIC;
import org.jaudiotagger.tag.id3.framebody.ID3v23FrameBody;
import org.jaudiotagger.tag.id3.framebody.ID3v24FrameBody;
import org.jaudiotagger.tag.id3.valuepair.ImageFormats;

public class FrameBodyAPIC
extends AbstractID3v2FrameBody
implements ID3v24FrameBody,
ID3v23FrameBody {
    public static final String IMAGE_IS_URL = "-->";

    public FrameBodyAPIC() {
        this.setObjectValue("TextEncoding", (byte)0);
    }

    public FrameBodyAPIC(FrameBodyAPIC frameBodyAPIC) {
        super(frameBodyAPIC);
    }

    public FrameBodyAPIC(FrameBodyPIC frameBodyPIC) {
        this.setObjectValue("TextEncoding", frameBodyPIC.getTextEncoding());
        this.setObjectValue("MIMEType", ImageFormats.getMimeTypeForFormat((String)frameBodyPIC.getObjectValue("ImageType")));
        this.setObjectValue("PictureType", frameBodyPIC.getObjectValue("PictureType"));
        this.setObjectValue("Description", frameBodyPIC.getDescription());
        this.setObjectValue("PictureData", frameBodyPIC.getObjectValue("PictureData"));
    }

    public FrameBodyAPIC(byte by, String string, byte by2, String string2, byte[] byArray) {
        this.setObjectValue("TextEncoding", by);
        this.setMimeType(string);
        this.setPictureType(by2);
        this.setDescription(string2);
        this.setImageData(byArray);
    }

    public FrameBodyAPIC(ByteBuffer byteBuffer, int n) throws InvalidTagException {
        super(byteBuffer, n);
    }

    @Override
    public String getUserFriendlyValue() {
        return this.getMimeType() + ":" + this.getDescription() + ":" + this.getImageData().length;
    }

    public void setDescription(String string) {
        this.setObjectValue("Description", string);
    }

    public String getDescription() {
        return (String)this.getObjectValue("Description");
    }

    public void setMimeType(String string) {
        this.setObjectValue("MIMEType", string);
    }

    public String getMimeType() {
        return (String)this.getObjectValue("MIMEType");
    }

    public void setImageData(byte[] byArray) {
        this.setObjectValue("PictureData", byArray);
    }

    public byte[] getImageData() {
        return (byte[])this.getObjectValue("PictureData");
    }

    public void setPictureType(byte by) {
        this.setObjectValue("PictureType", by);
    }

    public int getPictureType() {
        return ((Long)this.getObjectValue("PictureType")).intValue();
    }

    @Override
    public String getIdentifier() {
        return "APIC";
    }

    @Override
    public void write(ByteArrayOutputStream byteArrayOutputStream) {
        if (!((AbstractString)this.getObject("Description")).canBeEncoded()) {
            this.setTextEncoding((byte)1);
        }
        super.write(byteArrayOutputStream);
    }

    @Override
    protected void setupObjectList() {
        this.objectList.add(new NumberHashMap("TextEncoding", (AbstractTagFrameBody)this, 1));
        this.objectList.add(new StringNullTerminated("MIMEType", this));
        this.objectList.add(new NumberHashMap("PictureType", (AbstractTagFrameBody)this, 1));
        this.objectList.add(new TextEncodedStringNullTerminated("Description", this));
        this.objectList.add(new ByteArraySizeTerminated("PictureData", this));
    }

    public boolean isImageUrl() {
        return this.getMimeType() != null && this.getMimeType().equals(IMAGE_IS_URL);
    }

    public String getImageUrl() {
        if (this.isImageUrl()) {
            return Utils.getString((byte[])this.getObjectValue("PictureData"), 0, ((byte[])this.getObjectValue("PictureData")).length, "ISO-8859-1");
        }
        return "";
    }
}

