/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.EmptyFrameException;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.InvalidFrameException;
import org.jaudiotagger.tag.InvalidFrameIdentifierException;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.PaddingException;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagNotFoundException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import org.jaudiotagger.tag.id3.AbstractTag;
import org.jaudiotagger.tag.id3.AggregatedFrame;
import org.jaudiotagger.tag.id3.ID3Frames;
import org.jaudiotagger.tag.id3.ID3SyncSafeInteger;
import org.jaudiotagger.tag.id3.ID3Unsynchronization;
import org.jaudiotagger.tag.id3.ID3v23FieldKey;
import org.jaudiotagger.tag.id3.ID3v23Frame;
import org.jaudiotagger.tag.id3.ID3v23Frames;
import org.jaudiotagger.tag.id3.ID3v23PreferredFrameOrderComparator;
import org.jaudiotagger.tag.id3.ID3v24Tag;
import org.jaudiotagger.tag.id3.TyerTdatAggregatedFrame;
import org.jaudiotagger.tag.id3.framebody.AbstractFrameBodyTextInfo;
import org.jaudiotagger.tag.id3.framebody.FrameBodyAPIC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTDAT;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTDRC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTIME;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTYER;
import org.jaudiotagger.tag.images.Artwork;
import org.jaudiotagger.tag.images.ArtworkFactory;
import org.jaudiotagger.tag.reference.PictureTypes;

public class ID3v23Tag
extends AbstractID3v2Tag {
    protected static final String TYPE_CRCDATA = "crcdata";
    protected static final String TYPE_EXPERIMENTAL = "experimental";
    protected static final String TYPE_EXTENDED = "extended";
    protected static final String TYPE_PADDINGSIZE = "paddingsize";
    protected static final String TYPE_UNSYNCHRONISATION = "unsyncronisation";
    protected static int TAG_EXT_HEADER_LENGTH = 10;
    protected static int TAG_EXT_HEADER_CRC_LENGTH = 4;
    protected static int FIELD_TAG_EXT_SIZE_LENGTH = 4;
    protected static int TAG_EXT_HEADER_DATA_LENGTH = TAG_EXT_HEADER_LENGTH - FIELD_TAG_EXT_SIZE_LENGTH;
    public static final int MASK_V23_UNSYNCHRONIZATION = 128;
    public static final int MASK_V23_EXTENDED_HEADER = 64;
    public static final int MASK_V23_EXPERIMENTAL = 32;
    public static final int MASK_V23_CRC_DATA_PRESENT = 128;
    public static final int MASK_V23_EMBEDDED_INFO_FLAG = 2;
    protected boolean crcDataFlag = false;
    protected boolean experimental = false;
    protected boolean extended = false;
    private int crc32;
    private int paddingSize = 0;
    protected boolean unsynchronization = false;
    protected boolean compression = false;
    public static final byte RELEASE = 2;
    public static final byte MAJOR_VERSION = 3;
    public static final byte REVISION = 0;

    @Override
    public byte getRelease() {
        return 2;
    }

    @Override
    public byte getMajorVersion() {
        return 3;
    }

    @Override
    public byte getRevision() {
        return 0;
    }

    public int getCrc32() {
        return this.crc32;
    }

    public ID3v23Tag() {
        this.frameMap = new LinkedHashMap();
        this.encryptedFrameMap = new LinkedHashMap();
    }

    @Override
    protected void copyPrimitives(AbstractID3v2Tag abstractID3v2Tag) {
        logger.config("Copying primitives");
        super.copyPrimitives(abstractID3v2Tag);
        if (abstractID3v2Tag instanceof ID3v23Tag) {
            ID3v23Tag iD3v23Tag = (ID3v23Tag)abstractID3v2Tag;
            this.crcDataFlag = iD3v23Tag.crcDataFlag;
            this.experimental = iD3v23Tag.experimental;
            this.extended = iD3v23Tag.extended;
            this.crc32 = iD3v23Tag.crc32;
            this.paddingSize = iD3v23Tag.paddingSize;
        }
    }

    @Override
    protected void addFrame(AbstractID3v2Frame abstractID3v2Frame) {
        try {
            if (abstractID3v2Frame.getIdentifier().equals("TDRC") && abstractID3v2Frame.getBody() instanceof FrameBodyTDRC) {
                this.translateFrame(abstractID3v2Frame);
            } else if (abstractID3v2Frame instanceof ID3v23Frame) {
                this.copyFrameIntoMap(abstractID3v2Frame.getIdentifier(), abstractID3v2Frame);
            } else {
                ID3v23Frame iD3v23Frame = new ID3v23Frame(abstractID3v2Frame);
                this.copyFrameIntoMap(iD3v23Frame.getIdentifier(), iD3v23Frame);
            }
        }
        catch (InvalidFrameException invalidFrameException) {
            logger.log(Level.SEVERE, "Unable to convert frame:" + abstractID3v2Frame.getIdentifier());
        }
    }

    protected void translateFrame(AbstractID3v2Frame abstractID3v2Frame) {
        ID3v23Frame iD3v23Frame;
        FrameBodyTDRC frameBodyTDRC = (FrameBodyTDRC)abstractID3v2Frame.getBody();
        if (!frameBodyTDRC.getYear().equals("")) {
            iD3v23Frame = new ID3v23Frame("TYER");
            ((FrameBodyTYER)iD3v23Frame.getBody()).setText(frameBodyTDRC.getYear());
            logger.config("Adding Frame:" + iD3v23Frame.getIdentifier());
            this.frameMap.put(iD3v23Frame.getIdentifier(), iD3v23Frame);
        }
        if (!frameBodyTDRC.getDate().equals("")) {
            iD3v23Frame = new ID3v23Frame("TDAT");
            ((FrameBodyTDAT)iD3v23Frame.getBody()).setText(frameBodyTDRC.getDate());
            ((FrameBodyTDAT)iD3v23Frame.getBody()).setMonthOnly(frameBodyTDRC.isMonthOnly());
            logger.config("Adding Frame:" + iD3v23Frame.getIdentifier());
            this.frameMap.put(iD3v23Frame.getIdentifier(), iD3v23Frame);
        }
        if (!frameBodyTDRC.getTime().equals("")) {
            iD3v23Frame = new ID3v23Frame("TIME");
            ((FrameBodyTIME)iD3v23Frame.getBody()).setText(frameBodyTDRC.getTime());
            ((FrameBodyTIME)iD3v23Frame.getBody()).setHoursOnly(frameBodyTDRC.isHoursOnly());
            logger.config("Adding Frame:" + iD3v23Frame.getIdentifier());
            this.frameMap.put(iD3v23Frame.getIdentifier(), iD3v23Frame);
        }
    }

    public ID3v23Tag(ID3v23Tag iD3v23Tag) {
        super(iD3v23Tag);
        logger.config("Creating tag from another tag of same type");
        this.copyPrimitives(iD3v23Tag);
        this.copyFrames(iD3v23Tag);
    }

    public ID3v23Tag(AbstractTag abstractTag) {
        logger.config("Creating tag from a tag of a different version");
        this.frameMap = new LinkedHashMap();
        this.encryptedFrameMap = new LinkedHashMap();
        if (abstractTag != null) {
            if (abstractTag instanceof ID3v23Tag) {
                throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
            }
            ID3v24Tag iD3v24Tag = abstractTag instanceof ID3v24Tag ? (ID3v24Tag)abstractTag : new ID3v24Tag(abstractTag);
            this.setLoggingFilename(iD3v24Tag.getLoggingFilename());
            this.copyPrimitives(iD3v24Tag);
            this.copyFrames(iD3v24Tag);
            logger.config("Created tag from a tag of a different version");
        }
    }

    public ID3v23Tag(ByteBuffer byteBuffer, String string) throws TagException {
        this.setLoggingFilename(string);
        this.read(byteBuffer);
    }

    public ID3v23Tag(ByteBuffer byteBuffer) throws TagException {
        this(byteBuffer, "");
    }

    @Override
    public String getIdentifier() {
        return "ID3v2.30";
    }

    @Override
    public int getSize() {
        int n = 10;
        if (this.extended) {
            n += TAG_EXT_HEADER_LENGTH;
            if (this.crcDataFlag) {
                n += TAG_EXT_HEADER_CRC_LENGTH;
            }
        }
        return n += super.getSize();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ID3v23Tag)) {
            return false;
        }
        ID3v23Tag iD3v23Tag = (ID3v23Tag)object;
        if (this.crc32 != iD3v23Tag.crc32) {
            return false;
        }
        if (this.crcDataFlag != iD3v23Tag.crcDataFlag) {
            return false;
        }
        if (this.experimental != iD3v23Tag.experimental) {
            return false;
        }
        if (this.extended != iD3v23Tag.extended) {
            return false;
        }
        return this.paddingSize == iD3v23Tag.paddingSize && super.equals(object);
    }

    private void readHeaderFlags(ByteBuffer byteBuffer) throws TagException {
        byte by = byteBuffer.get();
        this.unsynchronization = (by & 0x80) != 0;
        this.extended = (by & 0x40) != 0;
        boolean bl = this.experimental = (by & 0x20) != 0;
        if ((by & 0x10) != 0) {
            logger.warning(ErrorMessage.ID3_INVALID_OR_UNKNOWN_FLAG_SET.getMsg(this.getLoggingFilename(), 16));
        }
        if ((by & 8) != 0) {
            logger.warning(ErrorMessage.ID3_INVALID_OR_UNKNOWN_FLAG_SET.getMsg(this.getLoggingFilename(), 8));
        }
        if ((by & 4) != 0) {
            logger.warning(ErrorMessage.ID3_INVALID_OR_UNKNOWN_FLAG_SET.getMsg(this.getLoggingFilename(), 4));
        }
        if ((by & 2) != 0) {
            logger.warning(ErrorMessage.ID3_INVALID_OR_UNKNOWN_FLAG_SET.getMsg(this.getLoggingFilename(), 2));
        }
        if ((by & 1) != 0) {
            logger.warning(ErrorMessage.ID3_INVALID_OR_UNKNOWN_FLAG_SET.getMsg(this.getLoggingFilename(), 1));
        }
        if (this.isUnsynchronization()) {
            logger.config(ErrorMessage.ID3_TAG_UNSYNCHRONIZED.getMsg(this.getLoggingFilename()));
        }
        if (this.extended) {
            logger.config(ErrorMessage.ID3_TAG_EXTENDED.getMsg(this.getLoggingFilename()));
        }
        if (this.experimental) {
            logger.config(ErrorMessage.ID3_TAG_EXPERIMENTAL.getMsg(this.getLoggingFilename()));
        }
    }

    private void readExtendedHeader(ByteBuffer byteBuffer, int n) {
        int n2 = byteBuffer.getInt();
        if (n2 == TAG_EXT_HEADER_DATA_LENGTH) {
            byte by = byteBuffer.get();
            boolean bl = this.crcDataFlag = (by & 0x80) != 0;
            if (this.crcDataFlag) {
                logger.warning(ErrorMessage.ID3_TAG_CRC_FLAG_SET_INCORRECTLY.getMsg(this.getLoggingFilename()));
            }
            byteBuffer.get();
            this.paddingSize = byteBuffer.getInt();
            if (this.paddingSize > 0) {
                logger.config(ErrorMessage.ID3_TAG_PADDING_SIZE.getMsg(this.getLoggingFilename(), this.paddingSize));
            }
            n -= this.paddingSize + TAG_EXT_HEADER_LENGTH;
        } else if (n2 == TAG_EXT_HEADER_DATA_LENGTH + TAG_EXT_HEADER_CRC_LENGTH) {
            logger.config(ErrorMessage.ID3_TAG_CRC.getMsg(this.getLoggingFilename()));
            byte by = byteBuffer.get();
            boolean bl = this.crcDataFlag = (by & 0x80) != 0;
            if (!this.crcDataFlag) {
                logger.warning(ErrorMessage.ID3_TAG_CRC_FLAG_SET_INCORRECTLY.getMsg(this.getLoggingFilename()));
            }
            byteBuffer.get();
            this.paddingSize = byteBuffer.getInt();
            if (this.paddingSize > 0) {
                logger.config(ErrorMessage.ID3_TAG_PADDING_SIZE.getMsg(this.getLoggingFilename(), this.paddingSize));
            }
            n -= this.paddingSize + TAG_EXT_HEADER_LENGTH + TAG_EXT_HEADER_CRC_LENGTH;
            this.crc32 = byteBuffer.getInt();
            logger.config(ErrorMessage.ID3_TAG_CRC_SIZE.getMsg(this.getLoggingFilename(), this.crc32));
        } else {
            logger.warning(ErrorMessage.ID3_EXTENDED_HEADER_SIZE_INVALID.getMsg(this.getLoggingFilename(), n2));
            byteBuffer.position(byteBuffer.position() - FIELD_TAG_EXT_SIZE_LENGTH);
        }
    }

    @Override
    public void read(ByteBuffer byteBuffer) throws TagException {
        if (!this.seek(byteBuffer)) {
            throw new TagNotFoundException(this.getIdentifier() + " tag not found");
        }
        logger.config(this.getLoggingFilename() + ":" + "Reading ID3v23 tag");
        this.readHeaderFlags(byteBuffer);
        int n = ID3SyncSafeInteger.bufferToValue(byteBuffer);
        logger.config(ErrorMessage.ID_TAG_SIZE.getMsg(this.getLoggingFilename(), n));
        if (this.extended) {
            this.readExtendedHeader(byteBuffer, n);
        }
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        if (this.isUnsynchronization()) {
            byteBuffer2 = ID3Unsynchronization.synchronize(byteBuffer2);
        }
        this.readFrames(byteBuffer2, n);
        logger.config(this.getLoggingFilename() + ":Loaded Frames,there are:" + this.frameMap.keySet().size());
    }

    protected void readFrames(ByteBuffer byteBuffer, int n) {
        this.frameMap = new LinkedHashMap();
        this.encryptedFrameMap = new LinkedHashMap();
        this.fileReadSize = n;
        logger.finest(this.getLoggingFilename() + ":Start of frame body at:" + byteBuffer.position() + ",frames data size is:" + n);
        while (byteBuffer.position() < n) {
            try {
                logger.finest(this.getLoggingFilename() + ":Looking for next frame at:" + byteBuffer.position());
                ID3v23Frame iD3v23Frame = new ID3v23Frame(byteBuffer, this.getLoggingFilename());
                String string = iD3v23Frame.getIdentifier();
                this.loadFrameIntoMap(string, iD3v23Frame);
            }
            catch (PaddingException paddingException) {
                logger.config(this.getLoggingFilename() + ":Found padding starting at:" + byteBuffer.position());
                break;
            }
            catch (EmptyFrameException emptyFrameException) {
                logger.warning(this.getLoggingFilename() + ":Empty Frame:" + emptyFrameException.getMessage());
                this.emptyFrameBytes += 10;
            }
            catch (InvalidFrameIdentifierException invalidFrameIdentifierException) {
                logger.warning(this.getLoggingFilename() + ":Invalid Frame Identifier:" + invalidFrameIdentifierException.getMessage());
                ++this.invalidFrames;
                break;
            }
            catch (InvalidFrameException invalidFrameException) {
                logger.warning(this.getLoggingFilename() + ":Invalid Frame:" + invalidFrameException.getMessage());
                ++this.invalidFrames;
                break;
            }
            catch (InvalidDataTypeException invalidDataTypeException) {
                logger.warning(this.getLoggingFilename() + ":Corrupt Frame:" + invalidDataTypeException.getMessage());
                ++this.invalidFrames;
            }
        }
    }

    private ByteBuffer writeHeaderToBuffer(int n, int n2) throws IOException {
        this.extended = false;
        this.experimental = false;
        this.crcDataFlag = false;
        ByteBuffer byteBuffer = ByteBuffer.allocate(10 + TAG_EXT_HEADER_LENGTH + TAG_EXT_HEADER_CRC_LENGTH);
        byteBuffer.put(TAG_ID);
        byteBuffer.put(this.getMajorVersion());
        byteBuffer.put(this.getRevision());
        byte by = 0;
        if (this.isUnsynchronization()) {
            by = (byte)(by | 0x80);
        }
        if (this.extended) {
            by = (byte)(by | 0x40);
        }
        if (this.experimental) {
            by = (byte)(by | 0x20);
        }
        byteBuffer.put(by);
        int n3 = 0;
        if (this.extended) {
            n3 += TAG_EXT_HEADER_LENGTH;
            if (this.crcDataFlag) {
                n3 += TAG_EXT_HEADER_CRC_LENGTH;
            }
        }
        byteBuffer.put(ID3SyncSafeInteger.valueToBuffer(n + n2 + n3));
        if (this.extended) {
            byte by2 = 0;
            byte by3 = 0;
            if (this.crcDataFlag) {
                byteBuffer.putInt(TAG_EXT_HEADER_DATA_LENGTH + TAG_EXT_HEADER_CRC_LENGTH);
                by2 = (byte)(by2 | 0x80);
                byteBuffer.put(by2);
                byteBuffer.put(by3);
                byteBuffer.putInt(this.paddingSize);
                byteBuffer.putInt(this.crc32);
            } else {
                byteBuffer.putInt(TAG_EXT_HEADER_DATA_LENGTH);
                byteBuffer.put(by2);
                byteBuffer.put(by3);
                byteBuffer.putInt(n);
            }
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    @Override
    public void write(File file, long l) throws IOException {
        this.setLoggingFilename(file.getName());
        logger.config("Writing tag to file:" + this.getLoggingFilename());
        byte[] byArray = this.writeFramesToBuffer().toByteArray();
        logger.config(this.getLoggingFilename() + ":bodybytebuffer:sizebeforeunsynchronisation:" + byArray.length);
        boolean bl = this.unsynchronization = TagOptionSingleton.getInstance().isUnsyncTags() && ID3Unsynchronization.requiresUnsynchronization(byArray);
        if (this.isUnsynchronization()) {
            byArray = ID3Unsynchronization.unsynchronize(byArray);
            logger.config(this.getLoggingFilename() + ":bodybytebuffer:sizeafterunsynchronisation:" + byArray.length);
        }
        int n = this.calculateTagSize(byArray.length + 10, (int)l);
        int n2 = n - (byArray.length + 10);
        logger.config(this.getLoggingFilename() + ":Current audiostart:" + l);
        logger.config(this.getLoggingFilename() + ":Size including padding:" + n);
        logger.config(this.getLoggingFilename() + ":Padding:" + n2);
        ByteBuffer byteBuffer = this.writeHeaderToBuffer(n2, byArray.length);
        this.writeBufferToFile(file, byteBuffer, byArray, n2, n, l);
    }

    @Override
    public void write(WritableByteChannel writableByteChannel) throws IOException {
        logger.config(this.getLoggingFilename() + ":Writing tag to channel");
        byte[] byArray = this.writeFramesToBuffer().toByteArray();
        logger.config(this.getLoggingFilename() + ":bodybytebuffer:sizebeforeunsynchronisation:" + byArray.length);
        boolean bl = this.unsynchronization = TagOptionSingleton.getInstance().isUnsyncTags() && ID3Unsynchronization.requiresUnsynchronization(byArray);
        if (this.isUnsynchronization()) {
            byArray = ID3Unsynchronization.unsynchronize(byArray);
            logger.config(this.getLoggingFilename() + ":bodybytebuffer:sizeafterunsynchronisation:" + byArray.length);
        }
        ByteBuffer byteBuffer = this.writeHeaderToBuffer(0, byArray.length);
        writableByteChannel.write(byteBuffer);
        writableByteChannel.write(ByteBuffer.wrap(byArray));
    }

    @Override
    public void createStructure() {
        MP3File.getStructureFormatter().openHeadingElement("tag", this.getIdentifier());
        super.createStructureHeader();
        MP3File.getStructureFormatter().openHeadingElement("header", "");
        MP3File.getStructureFormatter().addElement(TYPE_UNSYNCHRONISATION, this.isUnsynchronization());
        MP3File.getStructureFormatter().addElement(TYPE_EXTENDED, this.extended);
        MP3File.getStructureFormatter().addElement(TYPE_EXPERIMENTAL, this.experimental);
        MP3File.getStructureFormatter().addElement(TYPE_CRCDATA, this.crc32);
        MP3File.getStructureFormatter().addElement(TYPE_PADDINGSIZE, this.paddingSize);
        MP3File.getStructureFormatter().closeHeadingElement("header");
        super.createStructureBody();
        MP3File.getStructureFormatter().closeHeadingElement("tag");
    }

    public boolean isUnsynchronization() {
        return this.unsynchronization;
    }

    @Override
    public ID3v23Frame createFrame(String string) {
        return new ID3v23Frame(string);
    }

    public TagField createField(ID3v23FieldKey iD3v23FieldKey, String string) throws KeyNotFoundException, FieldDataInvalidException {
        if (iD3v23FieldKey == null) {
            throw new KeyNotFoundException();
        }
        return super.doCreateTagField(new AbstractID3v2Tag.FrameAndSubId(iD3v23FieldKey.getFrameId(), iD3v23FieldKey.getSubId()), string);
    }

    public String getFirst(ID3v23FieldKey iD3v23FieldKey) throws KeyNotFoundException {
        if (iD3v23FieldKey == null) {
            throw new KeyNotFoundException();
        }
        FieldKey fieldKey = ID3v23Frames.getInstanceOf().getGenericKeyFromId3(iD3v23FieldKey);
        if (fieldKey != null) {
            return super.getFirst(fieldKey);
        }
        AbstractID3v2Tag.FrameAndSubId frameAndSubId = new AbstractID3v2Tag.FrameAndSubId(iD3v23FieldKey.getFrameId(), iD3v23FieldKey.getSubId());
        return super.doGetValueAtIndex(frameAndSubId, 0);
    }

    public void deleteField(ID3v23FieldKey iD3v23FieldKey) throws KeyNotFoundException {
        if (iD3v23FieldKey == null) {
            throw new KeyNotFoundException();
        }
        super.doDeleteTagField(new AbstractID3v2Tag.FrameAndSubId(iD3v23FieldKey.getFrameId(), iD3v23FieldKey.getSubId()));
    }

    @Override
    public void deleteField(String string) {
        super.doDeleteTagField(new AbstractID3v2Tag.FrameAndSubId(string, null));
    }

    @Override
    protected AbstractID3v2Tag.FrameAndSubId getFrameAndSubIdFromGenericKey(FieldKey fieldKey) {
        if (fieldKey == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        ID3v23FieldKey iD3v23FieldKey = ID3v23Frames.getInstanceOf().getId3KeyFromGenericKey(fieldKey);
        if (iD3v23FieldKey == null) {
            throw new KeyNotFoundException(fieldKey.name());
        }
        return new AbstractID3v2Tag.FrameAndSubId(iD3v23FieldKey.getFrameId(), iD3v23FieldKey.getSubId());
    }

    @Override
    protected ID3Frames getID3Frames() {
        return ID3v23Frames.getInstanceOf();
    }

    @Override
    public Comparator getPreferredFrameOrderComparator() {
        return ID3v23PreferredFrameOrderComparator.getInstanceof();
    }

    @Override
    public List<Artwork> getArtworkList() {
        List<TagField> list = this.getFields(FieldKey.COVER_ART);
        ArrayList<Artwork> arrayList = new ArrayList<Artwork>(list.size());
        for (TagField tagField : list) {
            FrameBodyAPIC frameBodyAPIC = (FrameBodyAPIC)((AbstractID3v2Frame)tagField).getBody();
            Artwork artwork = ArtworkFactory.getNew();
            artwork.setMimeType(frameBodyAPIC.getMimeType());
            artwork.setPictureType(frameBodyAPIC.getPictureType());
            if (frameBodyAPIC.isImageUrl()) {
                artwork.setLinked(true);
                artwork.setImageUrl(frameBodyAPIC.getImageUrl());
            } else {
                artwork.setBinaryData(frameBodyAPIC.getImageData());
            }
            arrayList.add(artwork);
        }
        return arrayList;
    }

    @Override
    public TagField createField(Artwork artwork) throws FieldDataInvalidException {
        ID3v23Frame iD3v23Frame = this.createFrame(this.getFrameAndSubIdFromGenericKey(FieldKey.COVER_ART).getFrameId());
        FrameBodyAPIC frameBodyAPIC = (FrameBodyAPIC)iD3v23Frame.getBody();
        if (!artwork.isLinked()) {
            frameBodyAPIC.setObjectValue("PictureData", artwork.getBinaryData());
            frameBodyAPIC.setObjectValue("PictureType", artwork.getPictureType());
            frameBodyAPIC.setObjectValue("MIMEType", artwork.getMimeType());
            frameBodyAPIC.setObjectValue("Description", "");
            return iD3v23Frame;
        }
        try {
            frameBodyAPIC.setObjectValue("PictureData", artwork.getImageUrl().getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.getMessage());
        }
        frameBodyAPIC.setObjectValue("PictureType", artwork.getPictureType());
        frameBodyAPIC.setObjectValue("MIMEType", "-->");
        frameBodyAPIC.setObjectValue("Description", "");
        return iD3v23Frame;
    }

    public TagField createArtworkField(byte[] byArray, String string) {
        ID3v23Frame iD3v23Frame = this.createFrame(this.getFrameAndSubIdFromGenericKey(FieldKey.COVER_ART).getFrameId());
        FrameBodyAPIC frameBodyAPIC = (FrameBodyAPIC)iD3v23Frame.getBody();
        frameBodyAPIC.setObjectValue("PictureData", byArray);
        frameBodyAPIC.setObjectValue("PictureType", PictureTypes.DEFAULT_ID);
        frameBodyAPIC.setObjectValue("MIMEType", string);
        frameBodyAPIC.setObjectValue("Description", "");
        return iD3v23Frame;
    }

    public int getPaddingSize() {
        return this.paddingSize;
    }

    @Override
    public TagField createField(FieldKey fieldKey, String string) throws KeyNotFoundException, FieldDataInvalidException {
        if (fieldKey == null) {
            throw new KeyNotFoundException();
        }
        if (fieldKey != FieldKey.YEAR) {
            return super.createField(fieldKey, string);
        }
        if (string.length() < 4) {
            throw new FieldDataInvalidException();
        }
        if (string.length() == 4) {
            ID3v23Frame iD3v23Frame = this.createFrame("TYER");
            ((AbstractFrameBodyTextInfo)iD3v23Frame.getBody()).setText(string.substring(0, 4));
            return iD3v23Frame;
        }
        if (string.length() > 4) {
            ID3v23Frame iD3v23Frame = this.createFrame("TYER");
            ((AbstractFrameBodyTextInfo)iD3v23Frame.getBody()).setText(string.substring(0, 4));
            if (string.length() >= 10) {
                String string2 = string.substring(5, 7);
                String string3 = string.substring(8, 10);
                ID3v23Frame iD3v23Frame2 = this.createFrame("TDAT");
                ((AbstractFrameBodyTextInfo)iD3v23Frame2.getBody()).setText(string3 + string2);
                TyerTdatAggregatedFrame tyerTdatAggregatedFrame = new TyerTdatAggregatedFrame();
                tyerTdatAggregatedFrame.addFrame(iD3v23Frame);
                tyerTdatAggregatedFrame.addFrame(iD3v23Frame2);
                return tyerTdatAggregatedFrame;
            }
            if (string.length() >= 7) {
                String string4 = string.substring(5, 7);
                String string5 = "01";
                ID3v23Frame iD3v23Frame3 = this.createFrame("TDAT");
                ((AbstractFrameBodyTextInfo)iD3v23Frame3.getBody()).setText(string5 + string4);
                TyerTdatAggregatedFrame tyerTdatAggregatedFrame = new TyerTdatAggregatedFrame();
                tyerTdatAggregatedFrame.addFrame(iD3v23Frame);
                tyerTdatAggregatedFrame.addFrame(iD3v23Frame3);
                return tyerTdatAggregatedFrame;
            }
            return iD3v23Frame;
        }
        return null;
    }

    @Override
    public String getValue(FieldKey fieldKey, int n) throws KeyNotFoundException {
        if (fieldKey == null) {
            throw new KeyNotFoundException();
        }
        if (fieldKey != FieldKey.YEAR) {
            return super.getValue(fieldKey, n);
        }
        AggregatedFrame aggregatedFrame = (AggregatedFrame)this.getFrame("TYERTDAT");
        if (aggregatedFrame != null) {
            return aggregatedFrame.getContent();
        }
        return super.getValue(fieldKey, n);
    }

    @Override
    protected void loadFrameIntoSpecifiedMap(HashMap hashMap, String string, AbstractID3v2Frame abstractID3v2Frame) {
        if (!string.equals("TYER") && !string.equals("TDAT")) {
            super.loadFrameIntoSpecifiedMap(hashMap, string, abstractID3v2Frame);
            return;
        }
        if (hashMap.containsKey(string) || hashMap.containsKey("TYERTDAT")) {
            if (this.duplicateFrameId.length() > 0) {
                this.duplicateFrameId = this.duplicateFrameId + ";";
            }
            this.duplicateFrameId = this.duplicateFrameId + string;
            this.duplicateBytes += abstractID3v2Frame.getSize();
        } else if (string.equals("TYER")) {
            if (hashMap.containsKey("TDAT")) {
                TyerTdatAggregatedFrame tyerTdatAggregatedFrame = new TyerTdatAggregatedFrame();
                tyerTdatAggregatedFrame.addFrame(abstractID3v2Frame);
                tyerTdatAggregatedFrame.addFrame((AbstractID3v2Frame)hashMap.get("TDAT"));
                hashMap.remove("TDAT");
                hashMap.put("TYERTDAT", tyerTdatAggregatedFrame);
            } else {
                hashMap.put("TYER", abstractID3v2Frame);
            }
        } else if (string.equals("TDAT")) {
            if (hashMap.containsKey("TYER")) {
                TyerTdatAggregatedFrame tyerTdatAggregatedFrame = new TyerTdatAggregatedFrame();
                tyerTdatAggregatedFrame.addFrame((AbstractID3v2Frame)hashMap.get("TYER"));
                tyerTdatAggregatedFrame.addFrame(abstractID3v2Frame);
                hashMap.remove("TYER");
                hashMap.put("TYERTDAT", tyerTdatAggregatedFrame);
            } else {
                hashMap.put("TDAT", abstractID3v2Frame);
            }
        }
    }
}

