/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.ByteArrayOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.InvalidFrameException;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.PaddingException;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.TagTextField;
import org.jaudiotagger.tag.id3.AbstractTagFrame;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.ID3v23Frame;
import org.jaudiotagger.tag.id3.ID3v24Frame;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;
import org.jaudiotagger.tag.id3.framebody.FrameBodyEncrypted;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUnsupported;
import org.jaudiotagger.tag.id3.valuepair.TextEncoding;
import org.jaudiotagger.utils.EqualsUtil;

public abstract class AbstractID3v2Frame
extends AbstractTagFrame
implements TagTextField {
    protected static final String TYPE_FRAME = "frame";
    protected static final String TYPE_FRAME_SIZE = "frameSize";
    protected static final String UNSUPPORTED_ID = "Unsupported";
    protected String identifier = "";
    protected int frameSize;
    private String loggingFilename = "";
    StatusFlags statusFlags = null;
    EncodingFlags encodingFlags = null;

    protected abstract int getFrameIdSize();

    protected abstract int getFrameSizeSize();

    protected abstract int getFrameHeaderSize();

    protected AbstractID3v2Frame() {
    }

    public AbstractID3v2Frame(AbstractID3v2Frame abstractID3v2Frame) {
        super(abstractID3v2Frame);
    }

    public AbstractID3v2Frame(AbstractID3v2FrameBody abstractID3v2FrameBody) {
        this.frameBody = abstractID3v2FrameBody;
        this.frameBody.setHeader(this);
    }

    public AbstractID3v2Frame(String string) {
        logger.config("Creating empty frame of type" + string);
        this.identifier = string;
        try {
            Class<?> clazz = Class.forName("org.jaudiotagger.tag.id3.framebody.FrameBody" + string);
            this.frameBody = (AbstractTagFrameBody)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.severe(classNotFoundException.getMessage());
            this.frameBody = new FrameBodyUnsupported(string);
        }
        catch (InstantiationException instantiationException) {
            logger.log(Level.SEVERE, "InstantiationException:" + string, instantiationException);
            throw new RuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.log(Level.SEVERE, "IllegalAccessException:" + string, illegalAccessException);
            throw new RuntimeException(illegalAccessException);
        }
        this.frameBody.setHeader(this);
        if (this instanceof ID3v24Frame) {
            this.frameBody.setTextEncoding(TagOptionSingleton.getInstance().getId3v24DefaultTextEncoding());
        } else if (this instanceof ID3v23Frame) {
            this.frameBody.setTextEncoding(TagOptionSingleton.getInstance().getId3v23DefaultTextEncoding());
        }
        logger.config("Created empty frame of type" + string);
    }

    protected String getLoggingFilename() {
        return this.loggingFilename;
    }

    protected void setLoggingFilename(String string) {
        this.loggingFilename = string;
    }

    @Override
    public String getId() {
        return this.getIdentifier();
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public void copyContent(TagField tagField) {
    }

    protected AbstractID3v2FrameBody readEncryptedBody(String string, ByteBuffer byteBuffer, int n) throws InvalidFrameException, InvalidDataTypeException {
        try {
            FrameBodyEncrypted frameBodyEncrypted = new FrameBodyEncrypted(string, byteBuffer, n);
            frameBodyEncrypted.setHeader(this);
            return frameBodyEncrypted;
        }
        catch (InvalidTagException invalidTagException) {
            throw new InvalidDataTypeException(invalidTagException);
        }
    }

    protected boolean isPadding(byte[] byArray) {
        return byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0;
    }

    protected AbstractID3v2FrameBody readBody(String string, ByteBuffer byteBuffer, int n) throws InvalidFrameException, InvalidDataTypeException {
        AbstractID3v2FrameBody abstractID3v2FrameBody;
        logger.finest("Creating framebody:start");
        try {
            Class<?> clazz = Class.forName("org.jaudiotagger.tag.id3.framebody.FrameBody" + string);
            Class[] classArray = new Class[]{Class.forName("java.nio.ByteBuffer"), Integer.TYPE};
            Object[] objectArray = new Object[]{byteBuffer, n};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            abstractID3v2FrameBody = (AbstractID3v2FrameBody)constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.config(this.getLoggingFilename() + ":" + "Identifier not recognised:" + string + " using FrameBodyUnsupported");
            try {
                abstractID3v2FrameBody = new FrameBodyUnsupported(byteBuffer, n);
            }
            catch (InvalidFrameException invalidFrameException) {
                throw invalidFrameException;
            }
            catch (InvalidTagException invalidTagException) {
                throw new InvalidFrameException(invalidTagException.getMessage());
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            logger.severe(this.getLoggingFilename() + ":" + "An error occurred within abstractID3v2FrameBody for identifier:" + string + ":" + invocationTargetException.getCause().getMessage());
            if (invocationTargetException.getCause() instanceof Error) {
                throw (Error)invocationTargetException.getCause();
            }
            if (invocationTargetException.getCause() instanceof RuntimeException) {
                throw (RuntimeException)invocationTargetException.getCause();
            }
            if (invocationTargetException.getCause() instanceof InvalidFrameException) {
                throw (InvalidFrameException)invocationTargetException.getCause();
            }
            if (invocationTargetException.getCause() instanceof InvalidDataTypeException) {
                throw (InvalidDataTypeException)invocationTargetException.getCause();
            }
            throw new InvalidFrameException(invocationTargetException.getCause().getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            logger.log(Level.SEVERE, this.getLoggingFilename() + ":" + "No such method:" + noSuchMethodException.getMessage(), noSuchMethodException);
            throw new RuntimeException(noSuchMethodException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            logger.log(Level.SEVERE, this.getLoggingFilename() + ":" + "Instantiation exception:" + instantiationException.getMessage(), instantiationException);
            throw new RuntimeException(instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.log(Level.SEVERE, this.getLoggingFilename() + ":" + "Illegal access exception :" + illegalAccessException.getMessage(), illegalAccessException);
            throw new RuntimeException(illegalAccessException.getMessage());
        }
        logger.finest(this.getLoggingFilename() + ":" + "Created framebody:end" + abstractID3v2FrameBody.getIdentifier());
        abstractID3v2FrameBody.setHeader(this);
        return abstractID3v2FrameBody;
    }

    protected String readIdentifier(ByteBuffer byteBuffer) throws PaddingException, InvalidFrameException {
        byte[] byArray = new byte[this.getFrameIdSize()];
        if (byteBuffer.position() + this.getFrameHeaderSize() >= byteBuffer.limit()) {
            logger.warning(this.getLoggingFilename() + ":" + "No space to find another frame:");
            throw new InvalidFrameException(this.getLoggingFilename() + ":" + "No space to find another frame");
        }
        byteBuffer.get(byArray, 0, this.getFrameIdSize());
        if (this.isPadding(byArray)) {
            throw new PaddingException(this.getLoggingFilename() + ":only padding found");
        }
        this.identifier = new String(byArray);
        logger.fine(this.getLoggingFilename() + ":" + "Identifier is" + this.identifier);
        return this.identifier;
    }

    protected AbstractID3v2FrameBody readBody(String string, AbstractID3v2FrameBody abstractID3v2FrameBody) throws InvalidFrameException {
        AbstractID3v2FrameBody abstractID3v2FrameBody2;
        try {
            Class<?> clazz = Class.forName("org.jaudiotagger.tag.id3.framebody.FrameBody" + string);
            Class[] classArray = new Class[]{abstractID3v2FrameBody.getClass()};
            Object[] objectArray = new Object[]{abstractID3v2FrameBody};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            abstractID3v2FrameBody2 = (AbstractID3v2FrameBody)constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.config("Identifier not recognised:" + string + " unable to create framebody");
            throw new InvalidFrameException("FrameBody" + string + " does not exist");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            logger.log(Level.SEVERE, "No such method:" + noSuchMethodException.getMessage(), noSuchMethodException);
            throw new InvalidFrameException("FrameBody" + string + " does not have a constructor that takes:" + abstractID3v2FrameBody.getClass().getName());
        }
        catch (InvocationTargetException invocationTargetException) {
            logger.severe("An error occurred within abstractID3v2FrameBody");
            logger.log(Level.SEVERE, "Invocation target exception:" + invocationTargetException.getCause().getMessage(), invocationTargetException.getCause());
            if (invocationTargetException.getCause() instanceof Error) {
                throw (Error)invocationTargetException.getCause();
            }
            if (invocationTargetException.getCause() instanceof RuntimeException) {
                throw (RuntimeException)invocationTargetException.getCause();
            }
            throw new InvalidFrameException(invocationTargetException.getCause().getMessage());
        }
        catch (InstantiationException instantiationException) {
            logger.log(Level.SEVERE, "Instantiation exception:" + instantiationException.getMessage(), instantiationException);
            throw new RuntimeException(instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.log(Level.SEVERE, "Illegal access exception :" + illegalAccessException.getMessage(), illegalAccessException);
            throw new RuntimeException(illegalAccessException.getMessage());
        }
        logger.finer("frame Body created" + abstractID3v2FrameBody2.getIdentifier());
        abstractID3v2FrameBody2.setHeader(this);
        return abstractID3v2FrameBody2;
    }

    @Override
    public byte[] getRawContent() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.write(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public abstract void write(ByteArrayOutputStream var1);

    @Override
    public void isBinary(boolean bl) {
    }

    @Override
    public boolean isEmpty() {
        AbstractTagFrameBody abstractTagFrameBody = this.getBody();
        return abstractTagFrameBody == null;
    }

    public StatusFlags getStatusFlags() {
        return this.statusFlags;
    }

    public EncodingFlags getEncodingFlags() {
        return this.encodingFlags;
    }

    public void createStructure() {
        MP3File.getStructureFormatter().openHeadingElement(TYPE_FRAME, this.getIdentifier());
        MP3File.getStructureFormatter().closeHeadingElement(TYPE_FRAME);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AbstractID3v2Frame)) {
            return false;
        }
        AbstractID3v2Frame abstractID3v2Frame = (AbstractID3v2Frame)object;
        return super.equals(abstractID3v2Frame);
    }

    @Override
    public String getContent() {
        return this.getBody().getUserFriendlyValue();
    }

    @Override
    public String getEncoding() {
        return TextEncoding.getInstanceOf().getValueForId(this.getBody().getTextEncoding());
    }

    @Override
    public void setContent(String string) {
        throw new UnsupportedOperationException("Not implemented please use the generic tag methods for setting content");
    }

    class EncodingFlags {
        protected static final String TYPE_FLAGS = "encodingFlags";
        protected byte flags;

        protected EncodingFlags() {
            this.resetFlags();
        }

        protected EncodingFlags(byte by) {
            this.setFlags(by);
        }

        public byte getFlags() {
            return this.flags;
        }

        public void setFlags(byte by) {
            this.flags = by;
        }

        public void resetFlags() {
            this.setFlags((byte)0);
        }

        public void createStructure() {
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof EncodingFlags)) {
                return false;
            }
            EncodingFlags encodingFlags = (EncodingFlags)object;
            return EqualsUtil.areEqual(this.getFlags(), encodingFlags.getFlags());
        }
    }

    public class StatusFlags {
        protected static final String TYPE_FLAGS = "statusFlags";
        protected byte originalFlags;
        protected byte writeFlags;

        protected StatusFlags() {
        }

        public byte getOriginalFlags() {
            return this.originalFlags;
        }

        public byte getWriteFlags() {
            return this.writeFlags;
        }

        public void createStructure() {
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof StatusFlags)) {
                return false;
            }
            StatusFlags statusFlags = (StatusFlags)object;
            return EqualsUtil.areEqual(this.getOriginalFlags(), statusFlags.getOriginalFlags()) && EqualsUtil.areEqual(this.getWriteFlags(), statusFlags.getWriteFlags());
        }
    }
}

