/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.datatype.AbstractString;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.valuepair.TextEncoding;

public class TextEncodedStringSizeTerminated
extends AbstractString {
    public TextEncodedStringSizeTerminated(String string, AbstractTagFrameBody abstractTagFrameBody) {
        super(string, abstractTagFrameBody);
    }

    public TextEncodedStringSizeTerminated(TextEncodedStringSizeTerminated textEncodedStringSizeTerminated) {
        super(textEncodedStringSizeTerminated);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof TextEncodedStringSizeTerminated && super.equals(object);
    }

    @Override
    public void readByteArray(byte[] byArray, int n) throws InvalidDataTypeException {
        ByteBuffer byteBuffer;
        Object object;
        logger.finest("Reading from array from offset:" + n);
        String string = this.getTextEncodingCharSet();
        CharsetDecoder charsetDecoder = Charset.forName(string).newDecoder();
        charsetDecoder.reset();
        if (TagOptionSingleton.getInstance().isAndroid()) {
            object = new byte[byArray.length - n];
            System.arraycopy(byArray, n, object, 0, ((byte[])object).length);
            byteBuffer = ByteBuffer.wrap((byte[])object);
        } else {
            byteBuffer = ByteBuffer.wrap(byArray, n, byArray.length - n).slice();
        }
        object = CharBuffer.allocate(byArray.length - n);
        CoderResult coderResult = charsetDecoder.decode(byteBuffer, (CharBuffer)object, true);
        if (coderResult.isError()) {
            logger.warning("Decoding error:" + coderResult.toString());
        }
        charsetDecoder.flush((CharBuffer)object);
        ((CharBuffer)object).flip();
        this.value = string.equals("UTF-16") ? ((CharBuffer)object).toString().replace("\ufeff", "").replace("\ufffe", "") : ((CharBuffer)object).toString();
        this.setSize(byArray.length - n);
        logger.config("Read SizeTerminatedString:" + this.value + " size:" + this.size);
    }

    private ByteBuffer writeString(CharsetEncoder charsetEncoder, String string, int n, int n2) throws CharacterCodingException {
        ByteBuffer byteBuffer = n + 1 == n2 ? charsetEncoder.encode(CharBuffer.wrap(string)) : charsetEncoder.encode(CharBuffer.wrap(string + '\u0000'));
        byteBuffer.rewind();
        return byteBuffer;
    }

    private ByteBuffer writeStringUTF16LEBOM(String string, int n, int n2) throws CharacterCodingException {
        CharsetEncoder charsetEncoder = Charset.forName("UTF-16LE").newEncoder();
        ByteBuffer byteBuffer = null;
        byteBuffer = n + 1 == n2 ? charsetEncoder.encode(CharBuffer.wrap('\ufeff' + string)) : charsetEncoder.encode(CharBuffer.wrap('\ufeff' + string + '\u0000'));
        byteBuffer.rewind();
        return byteBuffer;
    }

    private ByteBuffer writeStringUTF16BEBOM(String string, int n, int n2) throws CharacterCodingException {
        CharsetEncoder charsetEncoder = Charset.forName("UTF-16BE").newEncoder();
        ByteBuffer byteBuffer = null;
        byteBuffer = n + 1 == n2 ? charsetEncoder.encode(CharBuffer.wrap('\ufeff' + string)) : charsetEncoder.encode(CharBuffer.wrap('\ufeff' + string + '\u0000'));
        byteBuffer.rewind();
        return byteBuffer;
    }

    private void stripTrailingNull() {
        String string;
        if (TagOptionSingleton.getInstance().isRemoveTrailingTerminatorOnWrite() && (string = (String)this.value).length() > 0 && string.charAt(string.length() - 1) == '\u0000') {
            string = string.substring(0, string.length() - 1);
            this.value = string;
        }
    }

    private void checkTrailingNull(List<String> list, String string) {
        if (!TagOptionSingleton.getInstance().isRemoveTrailingTerminatorOnWrite() && string.length() > 0 && string.charAt(string.length() - 1) == '\u0000') {
            String string2 = list.get(list.size() - 1);
            String string3 = string2 + '\u0000';
            list.set(list.size() - 1, string3);
        }
    }

    @Override
    public byte[] writeByteArray() {
        byte[] byArray;
        try {
            this.stripTrailingNull();
            String string = (String)this.value;
            String string2 = this.getTextEncodingCharSet();
            String string3 = null;
            if (string2.equals("UTF-16")) {
                string3 = TagOptionSingleton.getInstance().isEncodeUTF16BomAsLittleEndian() ? "UTF-16LE" : "UTF-16BE";
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate((string.length() + 3) * 3);
            List<String> list = TextEncodedStringSizeTerminated.splitByNullSeperator(string);
            this.checkTrailingNull(list, string);
            for (int i = 0; i < list.size(); ++i) {
                String string4 = list.get(i);
                if (string3 != null) {
                    if (string3.equals("UTF-16LE")) {
                        byteBuffer.put(this.writeStringUTF16LEBOM(string4, i, list.size()));
                        continue;
                    }
                    if (!string3.equals("UTF-16BE")) continue;
                    byteBuffer.put(this.writeStringUTF16BEBOM(string4, i, list.size()));
                    continue;
                }
                byteBuffer.put(this.writeString(Charset.forName(string2).newEncoder(), string4, i, list.size()));
            }
            byteBuffer.flip();
            byArray = new byte[byteBuffer.limit()];
            byteBuffer.rewind();
            byteBuffer.get(byArray, 0, byteBuffer.limit());
            this.setSize(byArray.length);
        }
        catch (CharacterCodingException characterCodingException) {
            logger.severe(characterCodingException.getMessage());
            throw new RuntimeException(characterCodingException);
        }
        return byArray;
    }

    protected String getTextEncodingCharSet() {
        byte by = this.getBody().getTextEncoding();
        String string = TextEncoding.getInstanceOf().getValueForId(by);
        logger.finest("text encoding:" + by + " charset:" + string);
        return string;
    }

    public static List<String> splitByNullSeperator(String string) {
        String[] stringArray = string.split("\\u0000");
        List<String> list = Arrays.asList(stringArray);
        if (list.size() == 0) {
            list = new ArrayList<String>(1);
            list.add("");
        }
        return list;
    }

    public void addValue(String string) {
        this.setValue(this.value + "\u0000" + string);
    }

    public int getNumberOfValues() {
        return TextEncodedStringSizeTerminated.splitByNullSeperator((String)this.value).size();
    }

    public String getValueAtIndex(int n) {
        List<String> list = TextEncodedStringSizeTerminated.splitByNullSeperator((String)this.value);
        return list.get(n);
    }

    public List<String> getValues() {
        return TextEncodedStringSizeTerminated.splitByNullSeperator((String)this.value);
    }

    public String getValueWithoutTrailingNull() {
        List<String> list = TextEncodedStringSizeTerminated.splitByNullSeperator((String)this.value);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                stringBuffer.append("\u0000");
            }
            stringBuffer.append(list.get(i));
        }
        return stringBuffer.toString();
    }
}

