/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.datatype.AbstractString;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.valuepair.TextEncoding;
import org.jaudiotagger.tag.options.PadNumberOption;
import org.jaudiotagger.utils.EqualsUtil;

public class PartOfSet
extends AbstractString {
    public PartOfSet(String string, AbstractTagFrameBody abstractTagFrameBody) {
        super(string, abstractTagFrameBody);
    }

    public PartOfSet(PartOfSet partOfSet) {
        super(partOfSet);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PartOfSet)) {
            return false;
        }
        PartOfSet partOfSet = (PartOfSet)object;
        return EqualsUtil.areEqual(this.value, partOfSet.value);
    }

    @Override
    public void readByteArray(byte[] byArray, int n) throws InvalidDataTypeException {
        logger.finest("Reading from array from offset:" + n);
        String string = this.getTextEncodingCharSet();
        CharsetDecoder charsetDecoder = Charset.forName(string).newDecoder();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, byArray.length - n).slice();
        CharBuffer charBuffer = CharBuffer.allocate(byArray.length - n);
        charsetDecoder.reset();
        CoderResult coderResult = charsetDecoder.decode(byteBuffer, charBuffer, true);
        if (coderResult.isError()) {
            logger.warning("Decoding error:" + coderResult.toString());
        }
        charsetDecoder.flush(charBuffer);
        charBuffer.flip();
        String string2 = charBuffer.toString();
        this.value = new PartOfSetValue(string2);
        this.setSize(byArray.length - n);
        logger.config("Read SizeTerminatedString:" + this.value + " size:" + this.size);
    }

    @Override
    public byte[] writeByteArray() {
        byte[] byArray;
        String string = this.getValue().toString();
        try {
            String string2;
            if (TagOptionSingleton.getInstance().isRemoveTrailingTerminatorOnWrite() && string.length() > 0 && string.charAt(string.length() - 1) == '\u0000') {
                string = string.substring(0, string.length() - 1);
            }
            if ((string2 = this.getTextEncodingCharSet()).equals("UTF-16")) {
                string2 = "UTF-16LE";
                CharsetEncoder charsetEncoder = Charset.forName(string2).newEncoder();
                ByteBuffer byteBuffer = charsetEncoder.encode(CharBuffer.wrap('\ufeff' + string));
                byArray = new byte[byteBuffer.limit()];
                byteBuffer.get(byArray, 0, byteBuffer.limit());
            } else {
                CharsetEncoder charsetEncoder = Charset.forName(string2).newEncoder();
                ByteBuffer byteBuffer = charsetEncoder.encode(CharBuffer.wrap(string));
                byArray = new byte[byteBuffer.limit()];
                byteBuffer.get(byArray, 0, byteBuffer.limit());
            }
        }
        catch (CharacterCodingException characterCodingException) {
            logger.severe(characterCodingException.getMessage());
            throw new RuntimeException(characterCodingException);
        }
        this.setSize(byArray.length);
        return byArray;
    }

    protected String getTextEncodingCharSet() {
        byte by = this.getBody().getTextEncoding();
        String string = TextEncoding.getInstanceOf().getValueForId(by);
        logger.finest("text encoding:" + by + " charset:" + string);
        return string;
    }

    @Override
    public PartOfSetValue getValue() {
        return (PartOfSetValue)this.value;
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    public static class PartOfSetValue {
        private static final Pattern trackNoPatternWithTotalCount = Pattern.compile("([0-9]+)/([0-9]+)(.*)", 2);
        private static final Pattern trackNoPattern = Pattern.compile("([0-9]+)(.*)", 2);
        private static final String SEPARATOR = "/";
        private Integer count;
        private Integer total;
        private String extra;
        private String rawText;
        private String rawCount;
        private String rawTotal;

        public PartOfSetValue() {
            this.rawText = "";
        }

        public PartOfSetValue(String string) {
            this.rawText = string;
            this.initFromValue(string);
        }

        public PartOfSetValue(Integer n, Integer n2) {
            this.count = n;
            this.rawCount = n.toString();
            this.total = n2;
            this.rawTotal = n2.toString();
            this.resetValueFromCounts();
        }

        private void initFromValue(String string) {
            try {
                Matcher matcher = trackNoPatternWithTotalCount.matcher(string);
                if (matcher.matches()) {
                    this.extra = matcher.group(3);
                    this.count = Integer.parseInt(matcher.group(1));
                    this.rawCount = matcher.group(1);
                    this.total = Integer.parseInt(matcher.group(2));
                    this.rawTotal = matcher.group(2);
                    return;
                }
                matcher = trackNoPattern.matcher(string);
                if (matcher.matches()) {
                    this.extra = matcher.group(2);
                    this.count = Integer.parseInt(matcher.group(1));
                    this.rawCount = matcher.group(1);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.count = 0;
            }
        }

        private void resetValueFromCounts() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.rawCount != null) {
                stringBuffer.append(this.rawCount);
            } else {
                stringBuffer.append("0");
            }
            if (this.rawTotal != null) {
                stringBuffer.append(SEPARATOR + this.rawTotal);
            }
            if (this.extra != null) {
                stringBuffer.append(this.extra);
            }
            this.rawText = stringBuffer.toString();
        }

        public Integer getCount() {
            return this.count;
        }

        public Integer getTotal() {
            return this.total;
        }

        public void setCount(Integer n) {
            this.count = n;
            this.rawCount = n.toString();
            this.resetValueFromCounts();
        }

        public void setTotal(Integer n) {
            this.total = n;
            this.rawTotal = n.toString();
            this.resetValueFromCounts();
        }

        public void setCount(String string) {
            try {
                this.count = Integer.parseInt(string);
                this.rawCount = string;
                this.resetValueFromCounts();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public void setTotal(String string) {
            try {
                this.total = Integer.parseInt(string);
                this.rawTotal = string;
                this.resetValueFromCounts();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public String getRawValue() {
            return this.rawText;
        }

        public void setRawValue(String string) {
            this.rawText = string;
            this.initFromValue(string);
        }

        public String getCountAsText() {
            StringBuffer stringBuffer = new StringBuffer();
            if (!TagOptionSingleton.getInstance().isPadNumbers()) {
                return this.rawCount;
            }
            this.padNumber(stringBuffer, this.count, TagOptionSingleton.getInstance().getPadNumberTotalLength());
            return stringBuffer.toString();
        }

        private void padNumber(StringBuffer stringBuffer, Integer n, PadNumberOption padNumberOption) {
            if (n != null) {
                if (padNumberOption == PadNumberOption.PAD_ONE_ZERO) {
                    if (n > 0 && n < 10) {
                        stringBuffer.append("0").append(n);
                    } else {
                        stringBuffer.append(n);
                    }
                } else if (padNumberOption == PadNumberOption.PAD_TWO_ZERO) {
                    if (n > 0 && n < 10) {
                        stringBuffer.append("00").append(n);
                    } else if (n > 9 && n < 100) {
                        stringBuffer.append("0").append(n);
                    } else {
                        stringBuffer.append(n);
                    }
                } else if (padNumberOption == PadNumberOption.PAD_THREE_ZERO) {
                    if (n > 0 && n < 10) {
                        stringBuffer.append("000").append(n);
                    } else if (n > 9 && n < 100) {
                        stringBuffer.append("00").append(n);
                    } else if (n > 99 && n < 1000) {
                        stringBuffer.append("0").append(n);
                    } else {
                        stringBuffer.append(n);
                    }
                }
            }
        }

        public String getTotalAsText() {
            StringBuffer stringBuffer = new StringBuffer();
            if (!TagOptionSingleton.getInstance().isPadNumbers()) {
                return this.rawTotal;
            }
            this.padNumber(stringBuffer, this.total, TagOptionSingleton.getInstance().getPadNumberTotalLength());
            return stringBuffer.toString();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (!TagOptionSingleton.getInstance().isPadNumbers()) {
                return this.rawText;
            }
            if (this.count != null) {
                this.padNumber(stringBuffer, this.count, TagOptionSingleton.getInstance().getPadNumberTotalLength());
            } else if (this.total != null) {
                this.padNumber(stringBuffer, 0, TagOptionSingleton.getInstance().getPadNumberTotalLength());
            }
            if (this.total != null) {
                stringBuffer.append(SEPARATOR);
                this.padNumber(stringBuffer, this.total, TagOptionSingleton.getInstance().getPadNumberTotalLength());
            }
            if (this.extra != null) {
                stringBuffer.append(this.extra);
            }
            return stringBuffer.toString();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof PartOfSetValue)) {
                return false;
            }
            PartOfSetValue partOfSetValue = (PartOfSetValue)object;
            return EqualsUtil.areEqual(this.getCount(), partOfSetValue.getCount()) && EqualsUtil.areEqual(this.getTotal(), partOfSetValue.getTotal());
        }
    }
}

