/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.util.Arrays;
import java.util.logging.Logger;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.datatype.MultipleTextEncodedStringNullTerminated;
import org.jaudiotagger.tag.datatype.PairedTextEncodedStringNullTerminated;
import org.jaudiotagger.tag.datatype.PartOfSet;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;

public abstract class AbstractDataType {
    protected static final String TYPE_ELEMENT = "element";
    public static Logger logger = Logger.getLogger("org.jaudiotagger.tag.datatype");
    protected Object value = null;
    protected String identifier = "";
    protected AbstractTagFrameBody frameBody = null;
    protected int size;

    protected AbstractDataType(String string, AbstractTagFrameBody abstractTagFrameBody) {
        this.identifier = string;
        this.frameBody = abstractTagFrameBody;
    }

    protected AbstractDataType(String string, AbstractTagFrameBody abstractTagFrameBody, Object object) {
        this.identifier = string;
        this.frameBody = abstractTagFrameBody;
        this.setValue(object);
    }

    public AbstractDataType(AbstractDataType abstractDataType) {
        this.identifier = abstractDataType.identifier;
        if (abstractDataType.value == null) {
            this.value = null;
        } else if (abstractDataType.value instanceof String) {
            this.value = abstractDataType.value;
        } else if (abstractDataType.value instanceof Boolean) {
            this.value = abstractDataType.value;
        } else if (abstractDataType.value instanceof Byte) {
            this.value = abstractDataType.value;
        } else if (abstractDataType.value instanceof Character) {
            this.value = abstractDataType.value;
        } else if (abstractDataType.value instanceof Double) {
            this.value = abstractDataType.value;
        } else if (abstractDataType.value instanceof Float) {
            this.value = abstractDataType.value;
        } else if (abstractDataType.value instanceof Integer) {
            this.value = abstractDataType.value;
        } else if (abstractDataType.value instanceof Long) {
            this.value = abstractDataType.value;
        } else if (abstractDataType.value instanceof Short) {
            this.value = abstractDataType.value;
        } else if (abstractDataType.value instanceof MultipleTextEncodedStringNullTerminated.Values) {
            this.value = abstractDataType.value;
        } else if (abstractDataType.value instanceof PairedTextEncodedStringNullTerminated.ValuePairs) {
            this.value = abstractDataType.value;
        } else if (abstractDataType.value instanceof PartOfSet.PartOfSetValue) {
            this.value = abstractDataType.value;
        } else if (abstractDataType.value instanceof boolean[]) {
            this.value = ((boolean[])abstractDataType.value).clone();
        } else if (abstractDataType.value instanceof byte[]) {
            this.value = ((byte[])abstractDataType.value).clone();
        } else if (abstractDataType.value instanceof char[]) {
            this.value = ((char[])abstractDataType.value).clone();
        } else if (abstractDataType.value instanceof double[]) {
            this.value = ((double[])abstractDataType.value).clone();
        } else if (abstractDataType.value instanceof float[]) {
            this.value = ((float[])abstractDataType.value).clone();
        } else if (abstractDataType.value instanceof int[]) {
            this.value = ((int[])abstractDataType.value).clone();
        } else if (abstractDataType.value instanceof long[]) {
            this.value = ((long[])abstractDataType.value).clone();
        } else if (abstractDataType.value instanceof short[]) {
            this.value = ((short[])abstractDataType.value).clone();
        } else if (abstractDataType.value instanceof Object[]) {
            this.value = ((Object[])abstractDataType.value).clone();
        } else {
            throw new UnsupportedOperationException("Unable to create copy of class " + abstractDataType.getClass());
        }
    }

    public void setBody(AbstractTagFrameBody abstractTagFrameBody) {
        this.frameBody = abstractTagFrameBody;
    }

    public AbstractTagFrameBody getBody() {
        return this.frameBody;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public Object getValue() {
        return this.value;
    }

    public final void readByteArray(byte[] byArray) throws InvalidDataTypeException {
        this.readByteArray(byArray, 0);
    }

    public abstract int getSize();

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AbstractDataType)) {
            return false;
        }
        AbstractDataType abstractDataType = (AbstractDataType)object;
        if (!this.identifier.equals(abstractDataType.identifier)) {
            return false;
        }
        if (this.value == null && abstractDataType.value == null) {
            return true;
        }
        if (this.value == null || abstractDataType.value == null) {
            return false;
        }
        return !(this.value instanceof boolean[] && abstractDataType.value instanceof boolean[] ? !Arrays.equals((boolean[])this.value, (boolean[])abstractDataType.value) : (this.value instanceof byte[] && abstractDataType.value instanceof byte[] ? !Arrays.equals((byte[])this.value, (byte[])abstractDataType.value) : (this.value instanceof char[] && abstractDataType.value instanceof char[] ? !Arrays.equals((char[])this.value, (char[])abstractDataType.value) : (this.value instanceof double[] && abstractDataType.value instanceof double[] ? !Arrays.equals((double[])this.value, (double[])abstractDataType.value) : (this.value instanceof float[] && abstractDataType.value instanceof float[] ? !Arrays.equals((float[])this.value, (float[])abstractDataType.value) : (this.value instanceof int[] && abstractDataType.value instanceof int[] ? !Arrays.equals((int[])this.value, (int[])abstractDataType.value) : (this.value instanceof long[] && abstractDataType.value instanceof long[] ? !Arrays.equals((long[])this.value, (long[])abstractDataType.value) : (this.value instanceof Object[] && abstractDataType.value instanceof Object[] ? !Arrays.equals((Object[])this.value, (Object[])abstractDataType.value) : (this.value instanceof short[] && abstractDataType.value instanceof short[] ? !Arrays.equals((short[])this.value, (short[])abstractDataType.value) : !this.value.equals(abstractDataType.value))))))))));
    }

    public abstract void readByteArray(byte[] var1, int var2) throws InvalidDataTypeException;

    public abstract byte[] writeByteArray();

    public void createStructure() {
        MP3File.getStructureFormatter().addElement(this.identifier, this.getValue().toString());
    }
}

