/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.asf;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jaudiotagger.audio.asf.data.AsfHeader;
import org.jaudiotagger.audio.generic.AbstractTag;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagTextField;
import org.jaudiotagger.tag.asf.AsfFieldKey;
import org.jaudiotagger.tag.asf.AsfTagCoverField;
import org.jaudiotagger.tag.asf.AsfTagField;
import org.jaudiotagger.tag.asf.AsfTagTextField;
import org.jaudiotagger.tag.images.Artwork;
import org.jaudiotagger.tag.images.ArtworkFactory;
import org.jaudiotagger.tag.reference.PictureTypes;

public final class AsfTag
extends AbstractTag {
    public static final Set<AsfFieldKey> COMMON_FIELDS;
    private static final EnumMap<FieldKey, AsfFieldKey> tagFieldToAsfField;
    private final boolean copyFields;

    public AsfTag() {
        this(false);
    }

    public AsfTag(boolean bl) {
        this.copyFields = bl;
    }

    public AsfTag(Tag tag, boolean bl) throws UnsupportedEncodingException {
        this(bl);
        this.copyFrom(tag);
    }

    @Override
    public void addField(TagField tagField) {
        if (this.isValidField(tagField)) {
            if (AsfFieldKey.isMultiValued(tagField.getId())) {
                super.addField(this.copyFrom(tagField));
            } else {
                super.setField(this.copyFrom(tagField));
            }
        }
    }

    public void addCopyright(String string) {
        this.addField(this.createCopyrightField(string));
    }

    public void addRating(String string) {
        this.addField(this.createRatingField(string));
    }

    private void copyFrom(Tag tag) {
        Iterator<TagField> iterator = tag.getFields();
        while (iterator.hasNext()) {
            TagField tagField = this.copyFrom(iterator.next());
            if (tagField == null) continue;
            super.addField(tagField);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TagField copyFrom(TagField tagField) {
        if (!this.isCopyingFields()) return tagField;
        if (tagField instanceof AsfTagField) {
            try {
                return (TagField)((AsfTagField)tagField).clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return new AsfTagField(((AsfTagField)tagField).getDescriptor());
            }
        }
        if (!(tagField instanceof TagTextField)) throw new RuntimeException("Unknown Asf Tag Field class:" + tagField.getClass());
        String string = ((TagTextField)tagField).getContent();
        return new AsfTagTextField(tagField.getId(), string);
    }

    @Override
    public AsfTagCoverField createField(Artwork artwork) {
        return new AsfTagCoverField(artwork.getBinaryData(), artwork.getPictureType(), artwork.getDescription(), artwork.getMimeType());
    }

    public AsfTagCoverField createArtworkField(byte[] byArray) {
        return new AsfTagCoverField(byArray, PictureTypes.DEFAULT_ID, null, null);
    }

    public AsfTagTextField createCopyrightField(String string) {
        return new AsfTagTextField(AsfFieldKey.COPYRIGHT, string);
    }

    public AsfTagTextField createRatingField(String string) {
        return new AsfTagTextField(AsfFieldKey.RATING, string);
    }

    public AsfTagTextField createField(AsfFieldKey asfFieldKey, String string) {
        if (string == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        if (asfFieldKey == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        switch (asfFieldKey) {
            case COVER_ART: {
                throw new UnsupportedOperationException("Cover Art cannot be created using this method");
            }
            case BANNER_IMAGE: {
                throw new UnsupportedOperationException("Banner Image cannot be created using this method");
            }
        }
        return new AsfTagTextField(asfFieldKey.getFieldName(), string);
    }

    @Override
    public AsfTagTextField createField(FieldKey fieldKey, String string) throws KeyNotFoundException, FieldDataInvalidException {
        if (string == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        if (fieldKey == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        AsfFieldKey asfFieldKey = tagFieldToAsfField.get((Object)fieldKey);
        if (asfFieldKey == null) {
            throw new KeyNotFoundException(fieldKey.toString());
        }
        return this.createField(asfFieldKey, string);
    }

    public void deleteField(AsfFieldKey asfFieldKey) {
        super.deleteField(asfFieldKey.getFieldName());
    }

    @Override
    public void deleteField(FieldKey fieldKey) throws KeyNotFoundException {
        if (fieldKey == null) {
            throw new KeyNotFoundException();
        }
        super.deleteField(tagFieldToAsfField.get((Object)fieldKey).getFieldName());
    }

    @Override
    public List<TagField> getFields(FieldKey fieldKey) throws KeyNotFoundException {
        if (fieldKey == null) {
            throw new KeyNotFoundException();
        }
        return super.getFields(tagFieldToAsfField.get((Object)fieldKey).getFieldName());
    }

    @Override
    public List<String> getAll(FieldKey fieldKey) throws KeyNotFoundException {
        AsfFieldKey asfFieldKey = tagFieldToAsfField.get((Object)fieldKey);
        if (asfFieldKey == null) {
            throw new KeyNotFoundException();
        }
        return super.getAll(asfFieldKey.getFieldName());
    }

    @Override
    public List<Artwork> getArtworkList() {
        List<TagField> list = this.getFields(FieldKey.COVER_ART);
        ArrayList<Artwork> arrayList = new ArrayList<Artwork>(list.size());
        for (TagField tagField : list) {
            AsfTagCoverField asfTagCoverField = (AsfTagCoverField)tagField;
            Artwork artwork = ArtworkFactory.getNew();
            artwork.setBinaryData(asfTagCoverField.getRawImageData());
            artwork.setMimeType(asfTagCoverField.getMimeType());
            artwork.setDescription(asfTagCoverField.getDescription());
            artwork.setPictureType(asfTagCoverField.getPictureType());
            arrayList.add(artwork);
        }
        return arrayList;
    }

    public Iterator<AsfTagField> getAsfFields() {
        if (!this.isCopyingFields()) {
            throw new IllegalStateException("Since the field conversion is not enabled, this method cannot be executed");
        }
        return new AsfFieldIterator(this.getFields());
    }

    public List<TagField> getCopyright() {
        return this.getFields(AsfFieldKey.COPYRIGHT.getFieldName());
    }

    @Override
    public String getFirst(FieldKey fieldKey) throws KeyNotFoundException {
        return this.getValue(fieldKey, 0);
    }

    public String getFirst(AsfFieldKey asfFieldKey) throws KeyNotFoundException {
        if (asfFieldKey == null) {
            throw new KeyNotFoundException();
        }
        return super.getFirst(asfFieldKey.getFieldName());
    }

    @Override
    public String getValue(FieldKey fieldKey, int n) throws KeyNotFoundException {
        if (fieldKey == null) {
            throw new KeyNotFoundException();
        }
        return super.getItem(tagFieldToAsfField.get((Object)fieldKey).getFieldName(), n);
    }

    public String getFirstCopyright() {
        return this.getFirst(AsfFieldKey.COPYRIGHT.getFieldName());
    }

    @Override
    public AsfTagField getFirstField(FieldKey fieldKey) throws KeyNotFoundException {
        if (fieldKey == null) {
            throw new KeyNotFoundException();
        }
        return (AsfTagField)super.getFirstField(tagFieldToAsfField.get((Object)fieldKey).getFieldName());
    }

    public String getFirstRating() {
        return this.getFirst(AsfFieldKey.RATING.getFieldName());
    }

    public List<TagField> getRating() {
        return this.getFields(AsfFieldKey.RATING.getFieldName());
    }

    @Override
    protected boolean isAllowedEncoding(String string) {
        return AsfHeader.ASF_CHARSET.name().equals(string);
    }

    public boolean isCopyingFields() {
        return this.copyFields;
    }

    private boolean isValidField(TagField tagField) {
        if (tagField == null) {
            return false;
        }
        if (!(tagField instanceof AsfTagField)) {
            return false;
        }
        return !tagField.isEmpty();
    }

    @Override
    public void setField(TagField tagField) {
        if (this.isValidField(tagField)) {
            super.setField(this.copyFrom(tagField));
        }
    }

    public void setCopyright(String string) {
        this.setField(this.createCopyrightField(string));
    }

    public void setRating(String string) {
        this.setField(this.createRatingField(string));
    }

    @Override
    public boolean hasField(FieldKey fieldKey) {
        AsfFieldKey asfFieldKey = tagFieldToAsfField.get((Object)fieldKey);
        return this.getFields(asfFieldKey.getFieldName()).size() != 0;
    }

    public boolean hasField(AsfFieldKey asfFieldKey) {
        return this.getFields(asfFieldKey.getFieldName()).size() != 0;
    }

    static {
        tagFieldToAsfField = new EnumMap(FieldKey.class);
        tagFieldToAsfField.put(FieldKey.ALBUM, AsfFieldKey.ALBUM);
        tagFieldToAsfField.put(FieldKey.ALBUM_ARTIST, AsfFieldKey.ALBUM_ARTIST);
        tagFieldToAsfField.put(FieldKey.ALBUM_ARTIST_SORT, AsfFieldKey.ALBUM_ARTIST_SORT);
        tagFieldToAsfField.put(FieldKey.ALBUM_SORT, AsfFieldKey.ALBUM_SORT);
        tagFieldToAsfField.put(FieldKey.AMAZON_ID, AsfFieldKey.AMAZON_ID);
        tagFieldToAsfField.put(FieldKey.ARTIST, AsfFieldKey.AUTHOR);
        tagFieldToAsfField.put(FieldKey.ARTIST_SORT, AsfFieldKey.ARTIST_SORT);
        tagFieldToAsfField.put(FieldKey.ARTISTS, AsfFieldKey.ARTISTS);
        tagFieldToAsfField.put(FieldKey.BARCODE, AsfFieldKey.BARCODE);
        tagFieldToAsfField.put(FieldKey.BPM, AsfFieldKey.BPM);
        tagFieldToAsfField.put(FieldKey.CATALOG_NO, AsfFieldKey.CATALOG_NO);
        tagFieldToAsfField.put(FieldKey.COMMENT, AsfFieldKey.DESCRIPTION);
        tagFieldToAsfField.put(FieldKey.COMPOSER, AsfFieldKey.COMPOSER);
        tagFieldToAsfField.put(FieldKey.COMPOSER_SORT, AsfFieldKey.COMPOSER_SORT);
        tagFieldToAsfField.put(FieldKey.CONDUCTOR, AsfFieldKey.CONDUCTOR);
        tagFieldToAsfField.put(FieldKey.COVER_ART, AsfFieldKey.COVER_ART);
        tagFieldToAsfField.put(FieldKey.CUSTOM1, AsfFieldKey.CUSTOM1);
        tagFieldToAsfField.put(FieldKey.CUSTOM2, AsfFieldKey.CUSTOM2);
        tagFieldToAsfField.put(FieldKey.CUSTOM3, AsfFieldKey.CUSTOM3);
        tagFieldToAsfField.put(FieldKey.CUSTOM4, AsfFieldKey.CUSTOM4);
        tagFieldToAsfField.put(FieldKey.CUSTOM5, AsfFieldKey.CUSTOM5);
        tagFieldToAsfField.put(FieldKey.DISC_NO, AsfFieldKey.DISC_NO);
        tagFieldToAsfField.put(FieldKey.DISC_SUBTITLE, AsfFieldKey.DISC_SUBTITLE);
        tagFieldToAsfField.put(FieldKey.DISC_TOTAL, AsfFieldKey.DISC_TOTAL);
        tagFieldToAsfField.put(FieldKey.ENCODER, AsfFieldKey.ENCODER);
        tagFieldToAsfField.put(FieldKey.FBPM, AsfFieldKey.FBPM);
        tagFieldToAsfField.put(FieldKey.GENRE, AsfFieldKey.GENRE);
        tagFieldToAsfField.put(FieldKey.GROUPING, AsfFieldKey.GROUPING);
        tagFieldToAsfField.put(FieldKey.ISRC, AsfFieldKey.ISRC);
        tagFieldToAsfField.put(FieldKey.IS_COMPILATION, AsfFieldKey.IS_COMPILATION);
        tagFieldToAsfField.put(FieldKey.KEY, AsfFieldKey.INITIAL_KEY);
        tagFieldToAsfField.put(FieldKey.LANGUAGE, AsfFieldKey.LANGUAGE);
        tagFieldToAsfField.put(FieldKey.LYRICIST, AsfFieldKey.LYRICIST);
        tagFieldToAsfField.put(FieldKey.LYRICS, AsfFieldKey.LYRICS);
        tagFieldToAsfField.put(FieldKey.MEDIA, AsfFieldKey.MEDIA);
        tagFieldToAsfField.put(FieldKey.MOOD, AsfFieldKey.MOOD);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_ARTISTID, AsfFieldKey.MUSICBRAINZ_ARTISTID);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_DISC_ID, AsfFieldKey.MUSICBRAINZ_DISC_ID);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_ORIGINAL_RELEASE_ID, AsfFieldKey.MUSICBRAINZ_ORIGINAL_RELEASEID);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_RELEASEARTISTID, AsfFieldKey.MUSICBRAINZ_RELEASEARTISTID);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_RELEASEID, AsfFieldKey.MUSICBRAINZ_RELEASEID);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_RELEASE_COUNTRY, AsfFieldKey.MUSICBRAINZ_RELEASE_COUNTRY);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_RELEASE_GROUP_ID, AsfFieldKey.MUSICBRAINZ_RELEASEGROUPID);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_RELEASE_STATUS, AsfFieldKey.MUSICBRAINZ_RELEASE_STATUS);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_RELEASE_TYPE, AsfFieldKey.MUSICBRAINZ_RELEASE_TYPE);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_TRACK_ID, AsfFieldKey.MUSICBRAINZ_TRACK_ID);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_WORK_ID, AsfFieldKey.MUSICBRAINZ_WORKID);
        tagFieldToAsfField.put(FieldKey.MUSICIP_ID, AsfFieldKey.MUSICIP_ID);
        tagFieldToAsfField.put(FieldKey.OCCASION, AsfFieldKey.OCCASION);
        tagFieldToAsfField.put(FieldKey.ORIGINAL_ARTIST, AsfFieldKey.ORIGINAL_ARTIST);
        tagFieldToAsfField.put(FieldKey.ORIGINAL_ALBUM, AsfFieldKey.ORIGINAL_ALBUM);
        tagFieldToAsfField.put(FieldKey.ORIGINAL_LYRICIST, AsfFieldKey.ORIGINAL_LYRICIST);
        tagFieldToAsfField.put(FieldKey.ORIGINAL_YEAR, AsfFieldKey.ORIGINAL_YEAR);
        tagFieldToAsfField.put(FieldKey.RATING, AsfFieldKey.USER_RATING);
        tagFieldToAsfField.put(FieldKey.RECORD_LABEL, AsfFieldKey.RECORD_LABEL);
        tagFieldToAsfField.put(FieldKey.QUALITY, AsfFieldKey.QUALITY);
        tagFieldToAsfField.put(FieldKey.REMIXER, AsfFieldKey.REMIXER);
        tagFieldToAsfField.put(FieldKey.SCRIPT, AsfFieldKey.SCRIPT);
        tagFieldToAsfField.put(FieldKey.SUBTITLE, AsfFieldKey.SUBTITLE);
        tagFieldToAsfField.put(FieldKey.TAGS, AsfFieldKey.TAGS);
        tagFieldToAsfField.put(FieldKey.TEMPO, AsfFieldKey.TEMPO);
        tagFieldToAsfField.put(FieldKey.TITLE, AsfFieldKey.TITLE);
        tagFieldToAsfField.put(FieldKey.TITLE_SORT, AsfFieldKey.TITLE_SORT);
        tagFieldToAsfField.put(FieldKey.TRACK, AsfFieldKey.TRACK);
        tagFieldToAsfField.put(FieldKey.TRACK_TOTAL, AsfFieldKey.TRACK_TOTAL);
        tagFieldToAsfField.put(FieldKey.URL_DISCOGS_ARTIST_SITE, AsfFieldKey.URL_DISCOGS_ARTIST_SITE);
        tagFieldToAsfField.put(FieldKey.URL_DISCOGS_RELEASE_SITE, AsfFieldKey.URL_DISCOGS_RELEASE_SITE);
        tagFieldToAsfField.put(FieldKey.URL_LYRICS_SITE, AsfFieldKey.URL_LYRICS_SITE);
        tagFieldToAsfField.put(FieldKey.URL_OFFICIAL_ARTIST_SITE, AsfFieldKey.URL_OFFICIAL_ARTIST_SITE);
        tagFieldToAsfField.put(FieldKey.URL_OFFICIAL_RELEASE_SITE, AsfFieldKey.URL_OFFICIAL_RELEASE_SITE);
        tagFieldToAsfField.put(FieldKey.URL_WIKIPEDIA_ARTIST_SITE, AsfFieldKey.URL_WIKIPEDIA_ARTIST_SITE);
        tagFieldToAsfField.put(FieldKey.URL_WIKIPEDIA_RELEASE_SITE, AsfFieldKey.URL_WIKIPEDIA_RELEASE_SITE);
        tagFieldToAsfField.put(FieldKey.YEAR, AsfFieldKey.YEAR);
        tagFieldToAsfField.put(FieldKey.ENGINEER, AsfFieldKey.ENGINEER);
        tagFieldToAsfField.put(FieldKey.PRODUCER, AsfFieldKey.PRODUCER);
        tagFieldToAsfField.put(FieldKey.DJMIXER, AsfFieldKey.DJMIXER);
        tagFieldToAsfField.put(FieldKey.MIXER, AsfFieldKey.MIXER);
        tagFieldToAsfField.put(FieldKey.ARRANGER, AsfFieldKey.ARRANGER);
        tagFieldToAsfField.put(FieldKey.ACOUSTID_FINGERPRINT, AsfFieldKey.ACOUSTID_FINGERPRINT);
        tagFieldToAsfField.put(FieldKey.ACOUSTID_ID, AsfFieldKey.ACOUSTID_ID);
        tagFieldToAsfField.put(FieldKey.COUNTRY, AsfFieldKey.COUNTRY);
        COMMON_FIELDS = new HashSet<AsfFieldKey>();
        COMMON_FIELDS.add(AsfFieldKey.ALBUM);
        COMMON_FIELDS.add(AsfFieldKey.AUTHOR);
        COMMON_FIELDS.add(AsfFieldKey.DESCRIPTION);
        COMMON_FIELDS.add(AsfFieldKey.GENRE);
        COMMON_FIELDS.add(AsfFieldKey.TITLE);
        COMMON_FIELDS.add(AsfFieldKey.TRACK);
        COMMON_FIELDS.add(AsfFieldKey.YEAR);
    }

    private static class AsfFieldIterator
    implements Iterator<AsfTagField> {
        private final Iterator<TagField> fieldIterator;

        public AsfFieldIterator(Iterator<TagField> iterator) {
            assert (iterator != null);
            this.fieldIterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.fieldIterator.hasNext();
        }

        @Override
        public AsfTagField next() {
            return (AsfTagField)this.fieldIterator.next();
        }

        @Override
        public void remove() {
            this.fieldIterator.remove();
        }
    }
}

