/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;
import org.jaudiotagger.tag.id3.framebody.FrameBodyCOMM;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTIPL;
import org.jaudiotagger.tag.id3.framebody.ID3v24FrameBody;
import org.jaudiotagger.tag.lyrics3.Lyrics3v2Fields;
import org.jaudiotagger.tag.options.PadNumberOption;
import org.jaudiotagger.tag.reference.GenreTypes;
import org.jaudiotagger.tag.reference.ID3V2Version;
import org.jaudiotagger.tag.reference.Languages;

public class TagOptionSingleton {
    private static HashMap<String, TagOptionSingleton> tagOptionTable = new HashMap();
    private static String DEFAULT;
    private static String defaultOptions;
    private HashMap<Class<? extends ID3v24FrameBody>, LinkedList<String>> keywordMap = new HashMap();
    private HashMap<String, Boolean> lyrics3SaveFieldMap = new HashMap();
    private HashMap<String, String> parenthesisMap = new HashMap();
    private HashMap<String, String> replaceWordMap = new HashMap();
    private String language = "eng";
    private boolean filenameTagSave = false;
    private boolean id3v1Save = true;
    private boolean id3v1SaveAlbum = true;
    private boolean id3v1SaveArtist = true;
    private boolean id3v1SaveComment = true;
    private boolean id3v1SaveGenre = true;
    private boolean id3v1SaveTitle = true;
    private boolean id3v1SaveTrack = true;
    private boolean id3v1SaveYear = true;
    private boolean id3v2PaddingCopyTag = true;
    private boolean id3v2PaddingWillShorten = false;
    private boolean id3v2Save = true;
    private boolean lyrics3KeepEmptyFieldIfRead = false;
    private boolean lyrics3Save = true;
    private boolean lyrics3SaveEmptyField = false;
    private boolean originalSavedAfterAdjustingID3v2Padding = true;
    private byte timeStampFormat = (byte)2;
    private int numberMP3SyncFrame = 3;
    private boolean unsyncTags = false;
    private boolean removeTrailingTerminatorOnWrite = true;
    private byte id3v23DefaultTextEncoding = 0;
    private byte id3v24DefaultTextEncoding = 0;
    private byte id3v24UnicodeTextEncoding = 1;
    private boolean resetTextEncodingForExistingFrames = false;
    private boolean truncateTextWithoutErrors = false;
    private boolean padNumbers = false;
    private PadNumberOption padNumberTotalLength = PadNumberOption.PAD_ONE_ZERO;
    private boolean isAndroid = false;
    private boolean isEncodeUTF16BomAsLittleEndian = true;
    private int playerCompatability = -1;
    private long writeChunkSize = 5000000L;
    private boolean isWriteMp4GenresAsText = false;
    private ID3V2Version id3v2Version = ID3V2Version.ID3_V23;

    private TagOptionSingleton() {
        this.setToDefault();
    }

    public static TagOptionSingleton getInstance() {
        return TagOptionSingleton.getInstance(defaultOptions);
    }

    public static TagOptionSingleton getInstance(String string) {
        TagOptionSingleton tagOptionSingleton = tagOptionTable.get(string);
        if (tagOptionSingleton == null) {
            tagOptionSingleton = new TagOptionSingleton();
            tagOptionTable.put(string, tagOptionSingleton);
        }
        return tagOptionSingleton;
    }

    public void setFilenameTagSave(boolean bl) {
        this.filenameTagSave = bl;
    }

    public boolean isFilenameTagSave() {
        return this.filenameTagSave;
    }

    public void setID3V2Version(ID3V2Version iD3V2Version) {
        this.id3v2Version = iD3V2Version;
    }

    public ID3V2Version getID3V2Version() {
        return this.id3v2Version;
    }

    public void setInstanceKey(String string) {
        defaultOptions = string;
    }

    public static String getInstanceKey() {
        return defaultOptions;
    }

    public void setId3v1Save(boolean bl) {
        this.id3v1Save = bl;
    }

    public boolean isId3v1Save() {
        return this.id3v1Save;
    }

    public void setId3v1SaveAlbum(boolean bl) {
        this.id3v1SaveAlbum = bl;
    }

    public boolean isId3v1SaveAlbum() {
        return this.id3v1SaveAlbum;
    }

    public void setId3v1SaveArtist(boolean bl) {
        this.id3v1SaveArtist = bl;
    }

    public boolean isId3v1SaveArtist() {
        return this.id3v1SaveArtist;
    }

    public void setId3v1SaveComment(boolean bl) {
        this.id3v1SaveComment = bl;
    }

    public boolean isId3v1SaveComment() {
        return this.id3v1SaveComment;
    }

    public void setId3v1SaveGenre(boolean bl) {
        this.id3v1SaveGenre = bl;
    }

    public boolean isId3v1SaveGenre() {
        return this.id3v1SaveGenre;
    }

    public void setId3v1SaveTitle(boolean bl) {
        this.id3v1SaveTitle = bl;
    }

    public boolean isId3v1SaveTitle() {
        return this.id3v1SaveTitle;
    }

    public void setId3v1SaveTrack(boolean bl) {
        this.id3v1SaveTrack = bl;
    }

    public boolean isId3v1SaveTrack() {
        return this.id3v1SaveTrack;
    }

    public void setId3v1SaveYear(boolean bl) {
        this.id3v1SaveYear = bl;
    }

    public boolean isId3v1SaveYear() {
        return this.id3v1SaveYear;
    }

    public void setId3v2PaddingCopyTag(boolean bl) {
        this.id3v2PaddingCopyTag = bl;
    }

    public boolean isId3v2PaddingCopyTag() {
        return this.id3v2PaddingCopyTag;
    }

    public void setId3v2PaddingWillShorten(boolean bl) {
        this.id3v2PaddingWillShorten = bl;
    }

    public boolean isId3v2PaddingWillShorten() {
        return this.id3v2PaddingWillShorten;
    }

    public void setId3v2Save(boolean bl) {
        this.id3v2Save = bl;
    }

    public boolean isId3v2Save() {
        return this.id3v2Save;
    }

    public Iterator<Class<? extends ID3v24FrameBody>> getKeywordIterator() {
        return this.keywordMap.keySet().iterator();
    }

    public Iterator<String> getKeywordListIterator(Class<? extends ID3v24FrameBody> clazz) {
        return this.keywordMap.get(clazz).iterator();
    }

    public void setLanguage(String string) {
        if (Languages.getInstanceOf().getIdToValueMap().containsKey(string)) {
            this.language = string;
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLyrics3KeepEmptyFieldIfRead(boolean bl) {
        this.lyrics3KeepEmptyFieldIfRead = bl;
    }

    public boolean isLyrics3KeepEmptyFieldIfRead() {
        return this.lyrics3KeepEmptyFieldIfRead;
    }

    public void setLyrics3Save(boolean bl) {
        this.lyrics3Save = bl;
    }

    public boolean isLyrics3Save() {
        return this.lyrics3Save;
    }

    public void setLyrics3SaveEmptyField(boolean bl) {
        this.lyrics3SaveEmptyField = bl;
    }

    public boolean isLyrics3SaveEmptyField() {
        return this.lyrics3SaveEmptyField;
    }

    public void setLyrics3SaveField(String string, boolean bl) {
        this.lyrics3SaveFieldMap.put(string, bl);
    }

    public boolean getLyrics3SaveField(String string) {
        return this.lyrics3SaveFieldMap.get(string);
    }

    public HashMap<String, Boolean> getLyrics3SaveFieldMap() {
        return this.lyrics3SaveFieldMap;
    }

    public String getNewReplaceWord(String string) {
        return this.replaceWordMap.get(string);
    }

    public void setNumberMP3SyncFrame(int n) {
        this.numberMP3SyncFrame = n;
    }

    public int getNumberMP3SyncFrame() {
        return this.numberMP3SyncFrame;
    }

    public Iterator<String> getOldReplaceWordIterator() {
        return this.replaceWordMap.keySet().iterator();
    }

    public boolean isOpenParenthesis(String string) {
        return this.parenthesisMap.containsKey(string);
    }

    public Iterator<String> getOpenParenthesisIterator() {
        return this.parenthesisMap.keySet().iterator();
    }

    public void setOriginalSavedAfterAdjustingID3v2Padding(boolean bl) {
        this.originalSavedAfterAdjustingID3v2Padding = bl;
    }

    public boolean isOriginalSavedAfterAdjustingID3v2Padding() {
        return this.originalSavedAfterAdjustingID3v2Padding;
    }

    public void setTimeStampFormat(byte by) {
        if (by == 1 || by == 2) {
            this.timeStampFormat = by;
        }
    }

    public byte getTimeStampFormat() {
        return this.timeStampFormat;
    }

    public void setToDefault() {
        Iterator<Object> iterator;
        this.keywordMap = new HashMap();
        this.filenameTagSave = false;
        this.id3v1Save = true;
        this.id3v1SaveAlbum = true;
        this.id3v1SaveArtist = true;
        this.id3v1SaveComment = true;
        this.id3v1SaveGenre = true;
        this.id3v1SaveTitle = true;
        this.id3v1SaveTrack = true;
        this.id3v1SaveYear = true;
        this.id3v2PaddingCopyTag = true;
        this.id3v2PaddingWillShorten = false;
        this.id3v2Save = true;
        this.language = "eng";
        this.lyrics3KeepEmptyFieldIfRead = false;
        this.lyrics3Save = true;
        this.lyrics3SaveEmptyField = false;
        this.lyrics3SaveFieldMap = new HashMap();
        this.numberMP3SyncFrame = 3;
        this.parenthesisMap = new HashMap();
        this.replaceWordMap = new HashMap();
        this.timeStampFormat = (byte)2;
        this.unsyncTags = false;
        this.removeTrailingTerminatorOnWrite = true;
        this.id3v23DefaultTextEncoding = 0;
        this.id3v24DefaultTextEncoding = 0;
        this.id3v24UnicodeTextEncoding = 1;
        this.resetTextEncodingForExistingFrames = false;
        this.truncateTextWithoutErrors = false;
        this.padNumbers = false;
        this.isAndroid = false;
        this.isEncodeUTF16BomAsLittleEndian = true;
        this.writeChunkSize = 5000000L;
        this.isWriteMp4GenresAsText = false;
        this.padNumberTotalLength = PadNumberOption.PAD_ONE_ZERO;
        this.id3v2Version = ID3V2Version.ID3_V23;
        for (String string : Lyrics3v2Fields.getInstanceOf().getIdToValueMap().keySet()) {
            this.lyrics3SaveFieldMap.put(string, true);
        }
        try {
            this.addKeyword(FrameBodyCOMM.class, "ultimix");
            this.addKeyword(FrameBodyCOMM.class, "dance");
            this.addKeyword(FrameBodyCOMM.class, "mix");
            this.addKeyword(FrameBodyCOMM.class, "remix");
            this.addKeyword(FrameBodyCOMM.class, "rmx");
            this.addKeyword(FrameBodyCOMM.class, "live");
            this.addKeyword(FrameBodyCOMM.class, "cover");
            this.addKeyword(FrameBodyCOMM.class, "soundtrack");
            this.addKeyword(FrameBodyCOMM.class, "version");
            this.addKeyword(FrameBodyCOMM.class, "acoustic");
            this.addKeyword(FrameBodyCOMM.class, "original");
            this.addKeyword(FrameBodyCOMM.class, "cd");
            this.addKeyword(FrameBodyCOMM.class, "extended");
            this.addKeyword(FrameBodyCOMM.class, "vocal");
            this.addKeyword(FrameBodyCOMM.class, "unplugged");
            this.addKeyword(FrameBodyCOMM.class, "acapella");
            this.addKeyword(FrameBodyCOMM.class, "edit");
            this.addKeyword(FrameBodyCOMM.class, "radio");
            this.addKeyword(FrameBodyCOMM.class, "original");
            this.addKeyword(FrameBodyCOMM.class, "album");
            this.addKeyword(FrameBodyCOMM.class, "studio");
            this.addKeyword(FrameBodyCOMM.class, "instrumental");
            this.addKeyword(FrameBodyCOMM.class, "unedited");
            this.addKeyword(FrameBodyCOMM.class, "karoke");
            this.addKeyword(FrameBodyCOMM.class, "quality");
            this.addKeyword(FrameBodyCOMM.class, "uncensored");
            this.addKeyword(FrameBodyCOMM.class, "clean");
            this.addKeyword(FrameBodyCOMM.class, "dirty");
            this.addKeyword(FrameBodyTIPL.class, "f.");
            this.addKeyword(FrameBodyTIPL.class, "feat");
            this.addKeyword(FrameBodyTIPL.class, "feat.");
            this.addKeyword(FrameBodyTIPL.class, "featuring");
            this.addKeyword(FrameBodyTIPL.class, "ftng");
            this.addKeyword(FrameBodyTIPL.class, "ftng.");
            this.addKeyword(FrameBodyTIPL.class, "ft.");
            this.addKeyword(FrameBodyTIPL.class, "ft");
            iterator = GenreTypes.getInstanceOf().getValueToIdMap().keySet().iterator();
            while (iterator.hasNext()) {
                this.addKeyword(FrameBodyCOMM.class, (String)iterator.next());
            }
        }
        catch (TagException tagException) {
            throw new RuntimeException(tagException);
        }
        this.addReplaceWord("v.", "vs.");
        this.addReplaceWord("vs.", "vs.");
        this.addReplaceWord("versus", "vs.");
        this.addReplaceWord("f.", "feat.");
        this.addReplaceWord("feat", "feat.");
        this.addReplaceWord("featuring", "feat.");
        this.addReplaceWord("ftng.", "feat.");
        this.addReplaceWord("ftng", "feat.");
        this.addReplaceWord("ft.", "feat.");
        this.addReplaceWord("ft", "feat.");
        iterator = this.getKeywordListIterator(FrameBodyTIPL.class);
        this.addParenthesis("(", ")");
        this.addParenthesis("[", "]");
        this.addParenthesis("{", "}");
        this.addParenthesis("<", ">");
    }

    public void addKeyword(Class<? extends ID3v24FrameBody> clazz, String string) throws TagException {
        if (!AbstractID3v2FrameBody.class.isAssignableFrom(clazz)) {
            throw new TagException("Invalid class type. Must be AbstractId3v2FrameBody " + clazz);
        }
        if (string != null && string.length() > 0) {
            LinkedList<Object> linkedList;
            if (!this.keywordMap.containsKey(clazz)) {
                linkedList = new LinkedList();
                this.keywordMap.put(clazz, linkedList);
            } else {
                linkedList = this.keywordMap.get(clazz);
            }
            linkedList.add(string);
        }
    }

    public void addParenthesis(String string, String string2) {
        this.parenthesisMap.put(string, string2);
    }

    public void addReplaceWord(String string, String string2) {
        this.replaceWordMap.put(string, string2);
    }

    public boolean isUnsyncTags() {
        return this.unsyncTags;
    }

    public void setUnsyncTags(boolean bl) {
        this.unsyncTags = bl;
    }

    public boolean isRemoveTrailingTerminatorOnWrite() {
        return this.removeTrailingTerminatorOnWrite;
    }

    public void setRemoveTrailingTerminatorOnWrite(boolean bl) {
        this.removeTrailingTerminatorOnWrite = bl;
    }

    public byte getId3v23DefaultTextEncoding() {
        return this.id3v23DefaultTextEncoding;
    }

    public void setId3v23DefaultTextEncoding(byte by) {
        if (by == 0 || by == 1) {
            this.id3v23DefaultTextEncoding = by;
        }
    }

    public byte getId3v24DefaultTextEncoding() {
        return this.id3v24DefaultTextEncoding;
    }

    public void setId3v24DefaultTextEncoding(byte by) {
        if (by == 0 || by == 1 || by == 2 || by == 3) {
            this.id3v24DefaultTextEncoding = by;
        }
    }

    public byte getId3v24UnicodeTextEncoding() {
        return this.id3v24UnicodeTextEncoding;
    }

    public void setId3v24UnicodeTextEncoding(byte by) {
        if (by == 1 || by == 2 || by == 3) {
            this.id3v24UnicodeTextEncoding = by;
        }
    }

    public boolean isResetTextEncodingForExistingFrames() {
        return this.resetTextEncodingForExistingFrames;
    }

    public void setResetTextEncodingForExistingFrames(boolean bl) {
        this.resetTextEncodingForExistingFrames = bl;
    }

    public boolean isTruncateTextWithoutErrors() {
        return this.truncateTextWithoutErrors;
    }

    public void setTruncateTextWithoutErrors(boolean bl) {
        this.truncateTextWithoutErrors = bl;
    }

    public boolean isPadNumbers() {
        return this.padNumbers;
    }

    public void setPadNumbers(boolean bl) {
        this.padNumbers = bl;
    }

    public boolean isAndroid() {
        return this.isAndroid;
    }

    public void setAndroid(boolean bl) {
        this.isAndroid = bl;
    }

    public int getPlayerCompatability() {
        return this.playerCompatability;
    }

    public void setPlayerCompatability(int n) {
        this.playerCompatability = n;
    }

    public boolean isEncodeUTF16BomAsLittleEndian() {
        return this.isEncodeUTF16BomAsLittleEndian;
    }

    public void setEncodeUTF16BomAsLittleEndian(boolean bl) {
        this.isEncodeUTF16BomAsLittleEndian = bl;
    }

    public long getWriteChunkSize() {
        return this.writeChunkSize;
    }

    public void setWriteChunkSize(long l) {
        this.writeChunkSize = l;
    }

    public boolean isWriteMp4GenresAsText() {
        return this.isWriteMp4GenresAsText;
    }

    public void setWriteMp4GenresAsText(boolean bl) {
        this.isWriteMp4GenresAsText = bl;
    }

    public PadNumberOption getPadNumberTotalLength() {
        return this.padNumberTotalLength;
    }

    public void setPadNumberTotalLength(PadNumberOption padNumberOption) {
        this.padNumberTotalLength = padNumberOption;
    }

    static {
        defaultOptions = DEFAULT = "default";
    }
}

