/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.real;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.Utils;

public class RealChunk {
    protected static final String RMF = ".RMF";
    protected static final String PROP = "PROP";
    protected static final String MDPR = "MDPR";
    protected static final String CONT = "CONT";
    protected static final String DATA = "DATA";
    protected static final String INDX = "INDX";
    private final String id;
    private final int size;
    private final byte[] bytes;

    public static RealChunk readChunk(RandomAccessFile randomAccessFile) throws CannotReadException, IOException {
        String string = Utils.readString(randomAccessFile, 4);
        int n = Utils.readUint32AsInt(randomAccessFile);
        if (n < 8) {
            throw new CannotReadException("Corrupt file: RealAudio chunk length at position " + (randomAccessFile.getFilePointer() - 4L) + " cannot be less than 8");
        }
        if ((long)n > randomAccessFile.length() - randomAccessFile.getFilePointer() + 8L) {
            throw new CannotReadException("Corrupt file: RealAudio chunk length of " + n + " at position " + (randomAccessFile.getFilePointer() - 4L) + " extends beyond the end of the file");
        }
        byte[] byArray = new byte[n - 8];
        randomAccessFile.readFully(byArray);
        return new RealChunk(string, n, byArray);
    }

    public RealChunk(String string, int n, byte[] byArray) {
        this.id = string;
        this.size = n;
        this.bytes = byArray;
    }

    public DataInputStream getDataInputStream() {
        return new DataInputStream(new ByteArrayInputStream(this.getBytes()));
    }

    public boolean isCONT() {
        return CONT.equals(this.id);
    }

    public boolean isPROP() {
        return PROP.equals(this.id);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getId() {
        return this.id;
    }

    public int getSize() {
        return this.size;
    }

    public String toString() {
        return this.id + "\t" + this.size;
    }
}

