/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp4.atom;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.HashMap;
import java.util.Map;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.mp4.Mp4AtomIdentifier;
import org.jaudiotagger.audio.mp4.atom.AbstractMp4Box;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;

public class Mp4HdlrBox
extends AbstractMp4Box {
    public static final int VERSION_FLAG_LENGTH = 1;
    public static final int OTHER_FLAG_LENGTH = 3;
    public static final int RESERVED_FLAG_LENGTH = 4;
    public static final int HANDLER_LENGTH = 4;
    public static final int RESERVED1_LENGTH = 4;
    public static final int RESERVED2_LENGTH = 4;
    public static final int RESERVED3_LENGTH = 4;
    public static final int NAME_LENGTH = 2;
    public static final int HANDLER_POS = 8;
    public static final int RESERVED1_POS = 12;
    public static final int ITUNES_META_HDLR_DAT_LENGTH = 26;
    private int reserved;
    private String handlerType;
    private String name;
    private MediaDataType mediaDataType;
    private static Map<String, MediaDataType> mediaDataTypeMap = new HashMap<String, MediaDataType>();

    public Mp4HdlrBox(Mp4BoxHeader mp4BoxHeader, ByteBuffer byteBuffer) {
        this.header = mp4BoxHeader;
        this.dataBuffer = byteBuffer;
    }

    public void processData() throws CannotReadException {
        this.dataBuffer.position(this.dataBuffer.position() + 1 + 3 + 4);
        CharsetDecoder charsetDecoder = Charset.forName("ISO-8859-1").newDecoder();
        try {
            this.handlerType = charsetDecoder.decode((ByteBuffer)this.dataBuffer.slice().limit(4)).toString();
        }
        catch (CharacterCodingException characterCodingException) {
            // empty catch block
        }
        this.mediaDataType = mediaDataTypeMap.get(this.handlerType);
    }

    public String getHandlerType() {
        return this.handlerType;
    }

    public MediaDataType getMediaDataType() {
        return this.mediaDataType;
    }

    public String toString() {
        String string = "handlerType:" + this.handlerType + ":human readable:" + this.mediaDataType.getDescription();
        return string;
    }

    public static Mp4HdlrBox createiTunesStyleHdlrBox() {
        Mp4BoxHeader mp4BoxHeader = new Mp4BoxHeader(Mp4AtomIdentifier.HDLR.getFieldName());
        mp4BoxHeader.setLength(34);
        ByteBuffer byteBuffer = ByteBuffer.allocate(26);
        byteBuffer.put(8, (byte)109);
        byteBuffer.put(9, (byte)100);
        byteBuffer.put(10, (byte)105);
        byteBuffer.put(11, (byte)114);
        byteBuffer.put(12, (byte)97);
        byteBuffer.put(13, (byte)112);
        byteBuffer.put(14, (byte)112);
        byteBuffer.put(15, (byte)108);
        byteBuffer.rewind();
        Mp4HdlrBox mp4HdlrBox = new Mp4HdlrBox(mp4BoxHeader, byteBuffer);
        return mp4HdlrBox;
    }

    static {
        for (MediaDataType mediaDataType : MediaDataType.values()) {
            mediaDataTypeMap.put(mediaDataType.getId(), mediaDataType);
        }
    }

    public static enum MediaDataType {
        ODSM("odsm", "ObjectDescriptorStream - defined in ISO/IEC JTC1/SC29/WG11 - CODING OF MOVING PICTURES AND AUDIO"),
        CRSM("crsm", "ClockReferenceStream - defined in ISO/IEC JTC1/SC29/WG11 - CODING OF MOVING PICTURES AND AUDIO"),
        SDSM("sdsm", "SceneDescriptionStream - defined in ISO/IEC JTC1/SC29/WG11 - CODING OF MOVING PICTURES AND AUDIO"),
        M7SM("m7sm", "MPEG7Stream - defined in ISO/IEC JTC1/SC29/WG11 - CODING OF MOVING PICTURES AND AUDIO"),
        OCSM("ocsm", "ObjectContentInfoStream - defined in ISO/IEC JTC1/SC29/WG11 - CODING OF MOVING PICTURES AND AUDIO"),
        IPSM("ipsm", "IPMP Stream - defined in ISO/IEC JTC1/SC29/WG11 - CODING OF MOVING PICTURES AND AUDIO"),
        MJSM("mjsm", "MPEG-J Stream - defined in ISO/IEC JTC1/SC29/WG11 - CODING OF MOVING PICTURES AND AUDIO"),
        MDIR("mdir", "Apple Meta Data iTunes Reader"),
        MP7B("mp7b", "MPEG-7 binary XML"),
        MP7T("mp7t", "MPEG-7 XML"),
        VIDE("vide", "Video Track"),
        SOUN("soun", "Sound Track"),
        HINT("hint", "Hint Track"),
        APPL("appl", "Apple specific"),
        META("meta", "Timed Metadata track - defined in ISO/IEC JTC1/SC29/WG11 - CODING OF MOVING PICTURES AND AUDIO");

        private String id;
        private String description;

        private MediaDataType(String string2, String string3) {
            this.id = string2;
            this.description = string3;
        }

        public String getId() {
            return this.id;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

