/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.flac;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ListIterator;
import java.util.logging.Logger;
import org.jaudiotagger.audio.flac.metadatablock.BlockType;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataPadding;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataPicture;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockHeader;
import org.jaudiotagger.audio.generic.AbstractTagCreator;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.flac.FlacTag;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentCreator;

public class FlacTagCreator
extends AbstractTagCreator {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.flac");
    public static final int DEFAULT_PADDING = 4000;
    private static final VorbisCommentCreator creator = new VorbisCommentCreator();

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuffer convert(Tag tag, int n) throws UnsupportedEncodingException {
        MetadataBlockHeader metadataBlockHeader;
        logger.config("Convert flac tag:padding:" + n);
        FlacTag flacTag = (FlacTag)tag;
        int n2 = 0;
        ByteBuffer byteBuffer = null;
        if (flacTag.getVorbisCommentTag() != null) {
            byteBuffer = creator.convert(flacTag.getVorbisCommentTag());
            n2 = byteBuffer.capacity() + 4;
        }
        for (MetadataBlockDataPicture object : flacTag.getImages()) {
            n2 += object.getBytes().length + 4;
        }
        logger.config("Convert flac tag:taglength:" + n2);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(n2 + n);
        if (flacTag.getVorbisCommentTag() != null) {
            void var7_10;
            if (n > 0 || flacTag.getImages().size() > 0) {
                MetadataBlockHeader metadataBlockHeader2 = new MetadataBlockHeader(false, BlockType.VORBIS_COMMENT, byteBuffer.capacity());
            } else {
                MetadataBlockHeader metadataBlockHeader3 = new MetadataBlockHeader(true, BlockType.VORBIS_COMMENT, byteBuffer.capacity());
            }
            byteBuffer2.put(var7_10.getBytes());
            byteBuffer2.put(byteBuffer);
        }
        ListIterator<MetadataBlockDataPicture> listIterator = flacTag.getImages().listIterator();
        while (listIterator.hasNext()) {
            MetadataBlockDataPicture metadataBlockDataPicture = listIterator.next();
            metadataBlockHeader = n > 0 || listIterator.hasNext() ? new MetadataBlockHeader(false, BlockType.PICTURE, metadataBlockDataPicture.getLength()) : new MetadataBlockHeader(true, BlockType.PICTURE, metadataBlockDataPicture.getLength());
            byteBuffer2.put(metadataBlockHeader.getBytes());
            byteBuffer2.put(metadataBlockDataPicture.getBytes());
        }
        logger.config("Convert flac tag at" + byteBuffer2.position());
        if (n > 0) {
            int n3 = n - 4;
            metadataBlockHeader = new MetadataBlockHeader(true, BlockType.PADDING, n3);
            MetadataBlockDataPadding metadataBlockDataPadding = new MetadataBlockDataPadding(n3);
            byteBuffer2.put(metadataBlockHeader.getBytes());
            byteBuffer2.put(metadataBlockDataPadding.getBytes());
        }
        byteBuffer2.rewind();
        return byteBuffer2;
    }
}

