/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.AudioStreamChunk;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.data.StreamChunk;
import org.jaudiotagger.audio.asf.data.VideoStreamChunk;
import org.jaudiotagger.audio.asf.io.ChunkReader;
import org.jaudiotagger.audio.asf.util.Utils;

public class StreamChunkReader
implements ChunkReader {
    private static final GUID[] APPLYING = new GUID[]{GUID.GUID_STREAM};

    protected StreamChunkReader() {
    }

    @Override
    public boolean canFail() {
        return true;
    }

    @Override
    public GUID[] getApplyingIds() {
        return (GUID[])APPLYING.clone();
    }

    @Override
    public Chunk read(GUID gUID, InputStream inputStream, long l) throws IOException {
        StreamChunk streamChunk = null;
        BigInteger bigInteger = Utils.readBig64(inputStream);
        GUID gUID2 = Utils.readGUID(inputStream);
        if (GUID.GUID_AUDIOSTREAM.equals(gUID2) || GUID.GUID_VIDEOSTREAM.equals(gUID2)) {
            long l2;
            GUID gUID3 = Utils.readGUID(inputStream);
            long l3 = Utils.readUINT64(inputStream);
            long l4 = Utils.readUINT32(inputStream);
            long l5 = Utils.readUINT32(inputStream);
            int n = Utils.readUINT16(inputStream);
            int n2 = n & 0x7F;
            boolean bl = (n & 0x8000) != 0;
            inputStream.skip(4L);
            if (GUID.GUID_AUDIOSTREAM.equals(gUID2)) {
                AudioStreamChunk audioStreamChunk = new AudioStreamChunk(bigInteger);
                streamChunk = audioStreamChunk;
                long l6 = Utils.readUINT16(inputStream);
                long l7 = Utils.readUINT16(inputStream);
                long l8 = Utils.readUINT32(inputStream);
                long l9 = Utils.readUINT32(inputStream);
                long l10 = Utils.readUINT16(inputStream);
                int n3 = Utils.readUINT16(inputStream);
                int n4 = Utils.readUINT16(inputStream);
                byte[] byArray = new byte[n4];
                inputStream.read(byArray);
                audioStreamChunk.setCompressionFormat(l6);
                audioStreamChunk.setChannelCount(l7);
                audioStreamChunk.setSamplingRate(l8);
                audioStreamChunk.setAverageBytesPerSec(l9);
                audioStreamChunk.setErrorConcealment(gUID3);
                audioStreamChunk.setBlockAlignment(l10);
                audioStreamChunk.setBitsPerSample(n3);
                audioStreamChunk.setCodecData(byArray);
                l2 = 18 + byArray.length;
            } else {
                VideoStreamChunk videoStreamChunk = new VideoStreamChunk(bigInteger);
                streamChunk = videoStreamChunk;
                long l11 = Utils.readUINT32(inputStream);
                long l12 = Utils.readUINT32(inputStream);
                inputStream.skip(1L);
                inputStream.skip(2L);
                inputStream.skip(16L);
                byte[] byArray = new byte[4];
                inputStream.read(byArray);
                videoStreamChunk.setPictureWidth(l11);
                videoStreamChunk.setPictureHeight(l12);
                videoStreamChunk.setCodecId(byArray);
                l2 = 31L;
            }
            streamChunk.setStreamNumber(n2);
            streamChunk.setStreamSpecificDataSize(l5);
            streamChunk.setTypeSpecificDataSize(l4);
            streamChunk.setTimeOffset(l3);
            streamChunk.setContentEncrypted(bl);
            streamChunk.setPosition(l);
            inputStream.skip(bigInteger.longValue() - 24L - l2 - 54L);
        }
        return streamChunk;
    }
}

