/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.ContainerType;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.data.MetadataContainer;
import org.jaudiotagger.audio.asf.data.MetadataDescriptor;
import org.jaudiotagger.audio.asf.io.ChunkReader;
import org.jaudiotagger.audio.asf.util.Utils;

public class MetadataReader
implements ChunkReader {
    private static final GUID[] APPLYING = new GUID[]{ContainerType.EXTENDED_CONTENT.getContainerGUID(), ContainerType.METADATA_OBJECT.getContainerGUID(), ContainerType.METADATA_LIBRARY_OBJECT.getContainerGUID()};

    @Override
    public boolean canFail() {
        return false;
    }

    @Override
    public GUID[] getApplyingIds() {
        return (GUID[])APPLYING.clone();
    }

    @Override
    public Chunk read(GUID gUID, InputStream inputStream, long l) throws IOException {
        BigInteger bigInteger = Utils.readBig64(inputStream);
        MetadataContainer metadataContainer = new MetadataContainer(gUID, l, bigInteger);
        boolean bl = metadataContainer.getContainerType() == ContainerType.EXTENDED_CONTENT;
        int n = Utils.readUINT16(inputStream);
        for (int i = 0; i < n; ++i) {
            long l2;
            int n2 = 0;
            int n3 = 0;
            if (!bl) {
                n2 = Utils.readUINT16(inputStream);
                assert (n2 >= 0 && n2 < 127);
                assert (metadataContainer.getContainerType() == ContainerType.METADATA_LIBRARY_OBJECT || n2 == 0);
                n3 = Utils.readUINT16(inputStream);
                assert (n3 >= 0 && n3 <= 127);
            }
            int n4 = Utils.readUINT16(inputStream);
            String string = null;
            if (bl) {
                string = Utils.readFixedSizeUTF16Str(inputStream, n4);
            }
            int n5 = Utils.readUINT16(inputStream);
            assert (n5 >= 0 && n5 <= 6);
            long l3 = l2 = bl ? (long)Utils.readUINT16(inputStream) : Utils.readUINT32(inputStream);
            assert (l2 >= 0L);
            assert (metadataContainer.getContainerType() == ContainerType.METADATA_LIBRARY_OBJECT || l2 <= MetadataDescriptor.DWORD_MAXVALUE);
            if (!bl) {
                string = Utils.readFixedSizeUTF16Str(inputStream, n4);
            }
            MetadataDescriptor metadataDescriptor = new MetadataDescriptor(metadataContainer.getContainerType(), string, n5, n3, n2);
            switch (n5) {
                case 0: {
                    metadataDescriptor.setStringValue(Utils.readFixedSizeUTF16Str(inputStream, (int)l2));
                    break;
                }
                case 1: {
                    metadataDescriptor.setBinaryValue(Utils.readBinary(inputStream, l2));
                    break;
                }
                case 2: {
                    assert (bl && l2 == 4L || !bl && l2 == 2L);
                    metadataDescriptor.setBooleanValue(this.readBoolean(inputStream, (int)l2));
                    break;
                }
                case 3: {
                    assert (l2 == 4L);
                    metadataDescriptor.setDWordValue(Utils.readUINT32(inputStream));
                    break;
                }
                case 5: {
                    assert (l2 == 2L);
                    metadataDescriptor.setWordValue(Utils.readUINT16(inputStream));
                    break;
                }
                case 4: {
                    assert (l2 == 8L);
                    metadataDescriptor.setQWordValue(Utils.readUINT64(inputStream));
                    break;
                }
                case 6: {
                    assert (l2 == 16L);
                    metadataDescriptor.setGUIDValue(Utils.readGUID(inputStream));
                    break;
                }
                default: {
                    metadataDescriptor.setStringValue("Invalid datatype: " + new String(Utils.readBinary(inputStream, l2)));
                }
            }
            metadataContainer.addDescriptor(metadataDescriptor);
        }
        return metadataContainer;
    }

    private boolean readBoolean(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        inputStream.read(byArray);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (i == n - 1) {
                boolean bl2 = bl = byArray[i] == 1;
                assert (byArray[i] == 0 || byArray[i] == 1);
                continue;
            }
            assert (byArray[i] == 0);
        }
        return bl;
    }
}

