/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.io.ChunkModifier;
import org.jaudiotagger.audio.asf.io.CountingInputStream;
import org.jaudiotagger.audio.asf.io.ModificationResult;
import org.jaudiotagger.audio.asf.util.Utils;

public class AsfExtHeaderModifier
implements ChunkModifier {
    private final List<ChunkModifier> modifierList;

    public AsfExtHeaderModifier(List<ChunkModifier> list) {
        assert (list != null);
        this.modifierList = new ArrayList<ChunkModifier>(list);
    }

    private void copyChunk(GUID gUID, InputStream inputStream, OutputStream outputStream) throws IOException {
        long l = Utils.readUINT64(inputStream);
        outputStream.write(gUID.getBytes());
        Utils.writeUINT64(l, outputStream);
        Utils.copy(inputStream, outputStream, l - 24L);
    }

    @Override
    public boolean isApplicable(GUID gUID) {
        return GUID.GUID_HEADER_EXTENSION.equals(gUID);
    }

    @Override
    public ModificationResult modify(GUID gUID, InputStream inputStream, OutputStream outputStream) throws IOException {
        assert (GUID.GUID_HEADER_EXTENSION.equals(gUID));
        long l = 0L;
        ArrayList<ChunkModifier> arrayList = new ArrayList<ChunkModifier>(this.modifierList);
        HashSet<GUID> hashSet = new HashSet<GUID>();
        hashSet.add(gUID);
        BigInteger bigInteger = Utils.readBig64(inputStream);
        GUID gUID2 = Utils.readGUID(inputStream);
        int n = Utils.readUINT16(inputStream);
        long l2 = Utils.readUINT32(inputStream);
        assert (l2 == 0L || l2 >= 24L);
        assert (bigInteger.subtract(BigInteger.valueOf(46L)).longValue() == l2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CountingInputStream countingInputStream = new CountingInputStream(inputStream);
        while (countingInputStream.getReadCount() < l2) {
            GUID gUID3 = Utils.readGUID(countingInputStream);
            boolean bl = false;
            for (int i = 0; i < arrayList.size() && !bl; ++i) {
                if (!((ChunkModifier)arrayList.get(i)).isApplicable(gUID3)) continue;
                ModificationResult modificationResult = ((ChunkModifier)arrayList.get(i)).modify(gUID3, countingInputStream, byteArrayOutputStream);
                l += modificationResult.getByteDifference();
                hashSet.addAll(modificationResult.getOccuredGUIDs());
                arrayList.remove(i);
                bl = true;
            }
            if (bl) continue;
            hashSet.add(gUID3);
            this.copyChunk(gUID3, countingInputStream, byteArrayOutputStream);
        }
        for (ChunkModifier chunkModifier : arrayList) {
            ModificationResult modificationResult = chunkModifier.modify(null, null, byteArrayOutputStream);
            l += modificationResult.getByteDifference();
            hashSet.addAll(modificationResult.getOccuredGUIDs());
        }
        outputStream.write(GUID.GUID_HEADER_EXTENSION.getBytes());
        Utils.writeUINT64(bigInteger.add(BigInteger.valueOf(l)).longValue(), outputStream);
        outputStream.write(gUID2.getBytes());
        Utils.writeUINT16(n, outputStream);
        Utils.writeUINT32(l2 + l, outputStream);
        outputStream.write(byteArrayOutputStream.toByteArray());
        return new ModificationResult(0, l, hashSet);
    }
}

