/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.logging.Logger;
import org.jaudiotagger.audio.asf.data.AsfHeader;
import org.jaudiotagger.audio.asf.data.ContainerType;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.util.Utils;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.TagOptionSingleton;

public class MetadataDescriptor
implements Comparable<MetadataDescriptor>,
Cloneable {
    public static final long DWORD_MAXVALUE = new BigInteger("FFFFFFFF", 16).longValue();
    private static final Logger LOGGER = Logger.getLogger("org.jaudiotagger.audio.asf.data");
    public static final int MAX_LANG_INDEX = 127;
    public static final int MAX_STREAM_NUMBER = 127;
    public static final BigInteger QWORD_MAXVALUE = new BigInteger("FFFFFFFFFFFFFFFF", 16);
    public static final int TYPE_BINARY = 1;
    public static final int TYPE_BOOLEAN = 2;
    public static final int TYPE_DWORD = 3;
    public static final int TYPE_GUID = 6;
    public static final int TYPE_QWORD = 4;
    public static final int TYPE_STRING = 0;
    public static final int TYPE_WORD = 5;
    public static final int WORD_MAXVALUE = 65535;
    private final ContainerType containerType;
    private byte[] content = new byte[0];
    private int descriptorType;
    private int languageIndex = 0;
    private final String name;
    private int streamNumber = 0;

    public MetadataDescriptor(ContainerType containerType, String string, int n) {
        this(containerType, string, n, 0, 0);
    }

    public MetadataDescriptor(ContainerType containerType, String string, int n, int n2, int n3) {
        assert (containerType != null);
        containerType.assertConstraints(string, new byte[0], n, n2, n3);
        this.containerType = containerType;
        this.name = string;
        this.descriptorType = n;
        this.streamNumber = n2;
        this.languageIndex = n3;
    }

    public MetadataDescriptor(String string) {
        this(string, 0);
    }

    public MetadataDescriptor(String string, int n) {
        this(ContainerType.METADATA_LIBRARY_OBJECT, string, n, 0, 0);
    }

    public BigInteger asNumber() {
        BigInteger bigInteger = null;
        switch (this.descriptorType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (this.content.length <= 8) break;
                throw new NumberFormatException("Binary data would exceed QWORD");
            }
            case 6: {
                throw new NumberFormatException("GUID cannot be converted to a number.");
            }
            case 0: {
                bigInteger = new BigInteger(this.getString(), 10);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (bigInteger == null) {
            byte[] byArray = new byte[this.content.length];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = this.content[this.content.length - (i + 1)];
            }
            bigInteger = new BigInteger(1, byArray);
        }
        return bigInteger;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public int compareTo(MetadataDescriptor metadataDescriptor) {
        return this.getName().compareTo(metadataDescriptor.getName());
    }

    public MetadataDescriptor createCopy() {
        MetadataDescriptor metadataDescriptor = new MetadataDescriptor(this.containerType, this.name, this.descriptorType, this.streamNumber, this.languageIndex);
        metadataDescriptor.content = this.getRawData();
        return metadataDescriptor;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof MetadataDescriptor) {
            MetadataDescriptor metadataDescriptor;
            bl = object == this ? true : (metadataDescriptor = (MetadataDescriptor)object).getName().equals(this.getName()) && metadataDescriptor.descriptorType == this.descriptorType && metadataDescriptor.languageIndex == this.languageIndex && metadataDescriptor.streamNumber == this.streamNumber && Arrays.equals(this.content, metadataDescriptor.content);
        }
        return bl;
    }

    public boolean getBoolean() {
        return this.content.length > 0 && this.content[0] != 0;
    }

    @Deprecated
    public byte[] getBytes() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.writeInto(byteArrayOutputStream, this.containerType);
        }
        catch (IOException iOException) {
            LOGGER.warning(iOException.getMessage());
        }
        return byteArrayOutputStream.toByteArray();
    }

    public ContainerType getContainerType() {
        return this.containerType;
    }

    public int getCurrentAsfSize(ContainerType containerType) {
        int n = 8;
        if (containerType != ContainerType.EXTENDED_CONTENT) {
            n += 6;
        }
        n += this.getName().length() * 2;
        if (this.getType() == 2) {
            n += 2;
            if (containerType == ContainerType.EXTENDED_CONTENT) {
                n += 2;
            }
        } else {
            n += this.content.length;
            if (0 == this.getType()) {
                n += 2;
            }
        }
        return n;
    }

    public GUID getGuid() {
        GUID gUID = null;
        if (this.getType() == 6 && this.content.length == 16) {
            gUID = new GUID(this.content);
        }
        return gUID;
    }

    public int getLanguageIndex() {
        return this.languageIndex;
    }

    public String getName() {
        return this.name;
    }

    public long getNumber() {
        int n;
        switch (this.getType()) {
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 4;
                break;
            }
            case 4: {
                n = 8;
                break;
            }
            case 5: {
                n = 2;
                break;
            }
            default: {
                throw new UnsupportedOperationException("The current type doesn't allow an interpretation as a number. (" + this.getType() + ")");
            }
        }
        if (n > this.content.length) {
            throw new IllegalStateException("The stored data cannot represent the type of current object.");
        }
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            l |= ((long)this.content[i] & 0xFFL) << i * 8;
        }
        return l;
    }

    public byte[] getRawData() {
        byte[] byArray = new byte[this.content.length];
        System.arraycopy(this.content, 0, byArray, 0, this.content.length);
        return byArray;
    }

    public int getRawDataSize() {
        return this.content.length;
    }

    public int getStreamNumber() {
        return this.streamNumber;
    }

    public String getString() {
        String string = null;
        switch (this.getType()) {
            case 1: {
                string = "binary data";
                break;
            }
            case 2: {
                string = String.valueOf(this.getBoolean());
                break;
            }
            case 6: {
                string = this.getGuid() == null ? "Invalid GUID" : this.getGuid().toString();
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = String.valueOf(this.getNumber());
                break;
            }
            case 0: {
                try {
                    string = new String(this.content, "UTF-16LE");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    LOGGER.warning(unsupportedEncodingException.getMessage());
                }
                break;
            }
            default: {
                throw new IllegalStateException("Current type is not known.");
            }
        }
        return string;
    }

    public int getType() {
        return this.descriptorType;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean isEmpty() {
        return this.content.length == 0;
    }

    public void setBinaryValue(byte[] byArray) throws IllegalArgumentException {
        this.containerType.assertConstraints(this.name, byArray, this.descriptorType, this.streamNumber, this.languageIndex);
        this.content = (byte[])byArray.clone();
        this.descriptorType = 1;
    }

    public void setBooleanValue(boolean bl) {
        this.content = new byte[]{bl ? (byte)1 : 0};
        this.descriptorType = 2;
    }

    public void setDWordValue(long l) {
        if (l < 0L || l > DWORD_MAXVALUE) {
            throw new IllegalArgumentException("value out of range (0-" + DWORD_MAXVALUE + ")");
        }
        this.content = Utils.getBytes(l, 4);
        this.descriptorType = 3;
    }

    public void setGUIDValue(GUID gUID) {
        this.containerType.assertConstraints(this.name, gUID.getBytes(), 6, this.streamNumber, this.languageIndex);
        this.content = gUID.getBytes();
        this.descriptorType = 6;
    }

    public void setLanguageIndex(int n) {
        this.containerType.assertConstraints(this.name, this.content, this.descriptorType, this.streamNumber, n);
        this.languageIndex = n;
    }

    public void setQWordValue(BigInteger bigInteger) throws IllegalArgumentException {
        if (bigInteger == null) {
            throw new NumberFormatException("null");
        }
        if (BigInteger.ZERO.compareTo(bigInteger) > 0) {
            throw new IllegalArgumentException("Only unsigned values allowed (no negative)");
        }
        if (QWORD_MAXVALUE.compareTo(bigInteger) < 0) {
            throw new IllegalArgumentException("Value exceeds QWORD (64 bit unsigned)");
        }
        this.content = new byte[8];
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length <= 8) {
            for (int i = byArray.length - 1; i >= 0; --i) {
                this.content[byArray.length - (i + 1)] = byArray[i];
            }
        } else {
            Arrays.fill(this.content, (byte)-1);
        }
        this.descriptorType = 4;
    }

    public void setQWordValue(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("value out of range (0-" + QWORD_MAXVALUE.toString() + ")");
        }
        this.content = Utils.getBytes(l, 8);
        this.descriptorType = 4;
    }

    public void setStreamNumber(int n) {
        this.containerType.assertConstraints(this.name, this.content, this.descriptorType, n, this.languageIndex);
        this.streamNumber = n;
    }

    public void setString(String string) throws IllegalArgumentException {
        try {
            switch (this.getType()) {
                case 1: {
                    throw new IllegalArgumentException("Cannot interpret binary as string.");
                }
                case 2: {
                    this.setBooleanValue(Boolean.parseBoolean(string));
                    break;
                }
                case 3: {
                    this.setDWordValue(Long.parseLong(string));
                    break;
                }
                case 4: {
                    this.setQWordValue(new BigInteger(string, 10));
                    break;
                }
                case 5: {
                    this.setWordValue(Integer.parseInt(string));
                    break;
                }
                case 6: {
                    this.setGUIDValue(GUID.parseGUID(string));
                    break;
                }
                case 0: {
                    this.setStringValue(string);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Value cannot be parsed as Number or is out of range (\"" + string + "\")", numberFormatException);
        }
    }

    public void setStringValue(String string) throws IllegalArgumentException {
        if (string == null) {
            this.content = new byte[0];
        } else {
            byte[] byArray = Utils.getBytes(string, AsfHeader.ASF_CHARSET);
            if (this.getContainerType().isWithinValueRange(byArray.length)) {
                this.content = byArray;
            } else if (TagOptionSingleton.getInstance().isTruncateTextWithoutErrors()) {
                int n = (int)this.getContainerType().getMaximumDataLength().longValue();
                this.content = new byte[n % 2 == 0 ? n : n - 1];
                System.arraycopy(byArray, 0, this.content, 0, this.content.length);
            } else {
                throw new IllegalArgumentException(ErrorMessage.WMA_LENGTH_OF_DATA_IS_TOO_LARGE.getMsg(byArray.length, this.getContainerType().getMaximumDataLength(), this.getContainerType().getContainerGUID().getDescription()));
            }
        }
        this.descriptorType = 0;
    }

    public void setWordValue(int n) throws IllegalArgumentException {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("value out of range (0-65535)");
        }
        this.content = Utils.getBytes(n, 2);
        this.descriptorType = 5;
    }

    public String toString() {
        return this.getName() + " : " + (new String[]{"String: ", "Binary: ", "Boolean: ", "DWORD: ", "QWORD:", "WORD:", "GUID:"})[this.descriptorType] + this.getString() + " (language: " + this.languageIndex + " / stream: " + this.streamNumber + ")";
    }

    public int writeInto(OutputStream outputStream, ContainerType containerType) throws IOException {
        byte[] byArray;
        int n = this.getCurrentAsfSize(containerType);
        if (this.descriptorType == 2) {
            byArray = new byte[containerType == ContainerType.EXTENDED_CONTENT ? 4 : 2];
            byArray[0] = (byte)(this.getBoolean() ? 1 : 0);
        } else {
            byArray = this.content;
        }
        if (containerType != ContainerType.EXTENDED_CONTENT) {
            Utils.writeUINT16(this.getLanguageIndex(), outputStream);
            Utils.writeUINT16(this.getStreamNumber(), outputStream);
        }
        Utils.writeUINT16(this.getName().length() * 2 + 2, outputStream);
        if (containerType == ContainerType.EXTENDED_CONTENT) {
            outputStream.write(Utils.getBytes(this.getName(), AsfHeader.ASF_CHARSET));
            outputStream.write(AsfHeader.ZERO_TERM);
        }
        int n2 = this.getType();
        Utils.writeUINT16(n2, outputStream);
        int n3 = byArray.length;
        if (0 == n2) {
            n3 += 2;
        }
        if (containerType == ContainerType.EXTENDED_CONTENT) {
            Utils.writeUINT16(n3, outputStream);
        } else {
            Utils.writeUINT32(n3, outputStream);
        }
        if (containerType != ContainerType.EXTENDED_CONTENT) {
            outputStream.write(Utils.getBytes(this.getName(), AsfHeader.ASF_CHARSET));
            outputStream.write(AsfHeader.ZERO_TERM);
        }
        outputStream.write(byArray);
        if (0 == n2) {
            outputStream.write(AsfHeader.ZERO_TERM);
        }
        return n;
    }
}

