/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.ContainerType;
import org.jaudiotagger.audio.asf.data.ContentBranding;
import org.jaudiotagger.audio.asf.data.ContentDescription;
import org.jaudiotagger.audio.asf.data.MetadataContainer;

public final class MetadataContainerFactory {
    private static final MetadataContainerFactory INSTANCE = new MetadataContainerFactory();

    public static MetadataContainerFactory getInstance() {
        return INSTANCE;
    }

    private MetadataContainerFactory() {
    }

    public MetadataContainer createContainer(ContainerType containerType) {
        return this.createContainer(containerType, 0L, BigInteger.ZERO);
    }

    public MetadataContainer createContainer(ContainerType containerType, long l, BigInteger bigInteger) {
        MetadataContainer metadataContainer = containerType == ContainerType.CONTENT_DESCRIPTION ? new ContentDescription(l, bigInteger) : (containerType == ContainerType.CONTENT_BRANDING ? new ContentBranding(l, bigInteger) : new MetadataContainer(containerType, l, bigInteger));
        return metadataContainer;
    }

    public MetadataContainer[] createContainers(ContainerType[] containerTypeArray) {
        assert (containerTypeArray != null);
        MetadataContainer[] metadataContainerArray = new MetadataContainer[containerTypeArray.length];
        for (int i = 0; i < metadataContainerArray.length; ++i) {
            metadataContainerArray[i] = this.createContainer(containerTypeArray[i]);
        }
        return metadataContainerArray;
    }
}

