/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.i18n;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;
import org.xnap.commons.i18n.LocaleChangeEvent;
import org.xnap.commons.i18n.LocaleChangeListener;

public class I18nManager {
    private static I18nManager instance = new I18nManager();
    List i18ns = Collections.synchronizedList(new ArrayList());
    List localeChangeListeners = new ArrayList();

    private I18nManager() {
    }

    public static I18nManager getInstance() {
        return instance;
    }

    public void add(I18n i18n) {
        this.i18ns.add(i18n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultLocale(Locale locale) {
        List list = this.i18ns;
        synchronized (list) {
            for (I18n i18n : this.i18ns) {
                i18n.setLocale(locale);
            }
        }
        this.fireLocaleChangedEvent(locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocaleChangeListener(LocaleChangeListener localeChangeListener) {
        List list = this.localeChangeListeners;
        synchronized (list) {
            this.localeChangeListeners.add(localeChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWeakLocaleChangeListener(LocaleChangeListener localeChangeListener) {
        List list = this.localeChangeListeners;
        synchronized (list) {
            this.localeChangeListeners.add(new WeakLocaleChangeListener(localeChangeListener));
        }
    }

    public void remove(I18n i18n) {
        this.i18ns.remove(i18n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocaleChangeListener(LocaleChangeListener localeChangeListener) {
        List list = this.localeChangeListeners;
        synchronized (list) {
            this.localeChangeListeners.remove(localeChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireLocaleChangedEvent(Locale locale) {
        LocaleChangeListener[] localeChangeListenerArray;
        Object object = this.localeChangeListeners;
        synchronized (object) {
            localeChangeListenerArray = this.localeChangeListeners.toArray(new LocaleChangeListener[0]);
        }
        if (localeChangeListenerArray.length > 0) {
            object = new LocaleChangeEvent(I18nFactory.class, locale);
            for (int i = localeChangeListenerArray.length - 1; i >= 0; --i) {
                localeChangeListenerArray[i].localeChanged((LocaleChangeEvent)object);
            }
        }
    }

    private static class WeakLocaleChangeListener
    implements LocaleChangeListener {
        private WeakReference reference;

        public WeakLocaleChangeListener(LocaleChangeListener localeChangeListener) {
            this.reference = new WeakReference<LocaleChangeListener>(localeChangeListener);
        }

        @Override
        public void localeChanged(LocaleChangeEvent localeChangeEvent) {
            Object t = this.reference.get();
            if (t != null) {
                ((LocaleChangeListener)t).localeChanged(localeChangeEvent);
            } else {
                I18nManager.getInstance().removeLocaleChangeListener(this);
            }
        }
    }
}

