/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComponentMappingBox
extends Box {
    private short[] components;
    private byte[] type;
    private byte[] map;

    public ComponentMappingBox(byte[] byArray) {
        super(8 + byArray.length, 1668112752, byArray);
    }

    public ComponentMappingBox(short[] sArray, byte[] byArray, byte[] byArray2) {
        super(8 + (sArray.length << 2), 1668112752, null);
        this.components = sArray;
        this.type = byArray;
        this.map = byArray2;
    }

    public ComponentMappingBox(Node node) throws IIOInvalidTreeException {
        super(node);
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength() / 3;
        this.components = new short[n];
        this.type = new byte[n];
        this.map = new byte[n];
        n *= 3;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if ("Component".equals(string)) {
                this.components[n2] = Box.getShortElementValue(node2);
            }
            if ("ComponentType".equals(string)) {
                this.type[n2] = Box.getByteElementValue(node2);
            }
            if (!"ComponentAssociation".equals(string)) continue;
            this.map[n2++] = Box.getByteElementValue(node2);
        }
    }

    protected void parse(byte[] byArray) {
        int n = byArray.length / 4;
        this.components = new short[n];
        this.type = new byte[n];
        this.map = new byte[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            this.components[i] = (short)((byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF);
            this.type[i] = byArray[n2++];
            this.map[i] = byArray[n2++];
        }
    }

    public IIOMetadataNode getNativeNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(Box.getName(this.getType()));
        this.setDefaultAttributes(iIOMetadataNode);
        for (int i = 0; i < this.components.length; ++i) {
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("Component");
            Short s = new Short(this.components[i]);
            iIOMetadataNode2.setUserObject(new Short(this.components[i]));
            iIOMetadataNode2.setNodeValue("" + this.components[i]);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            iIOMetadataNode2 = new IIOMetadataNode("ComponentType");
            iIOMetadataNode2.setUserObject(new Byte(this.type[i]));
            iIOMetadataNode2.setNodeValue("" + this.type[i]);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            iIOMetadataNode2 = new IIOMetadataNode("ComponentAssociation");
            iIOMetadataNode2.setUserObject(new Byte(this.map[i]));
            iIOMetadataNode2.setNodeValue("" + this.map[i]);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    public short[] getComponent() {
        return this.components;
    }

    public byte[] getComponentType() {
        return this.type;
    }

    public byte[] getComponentAssociation() {
        return this.map;
    }

    protected void compose() {
        if (this.data != null) {
            return;
        }
        this.data = new byte[this.type.length << 2];
        int n = 0;
        for (int i = 0; i < this.type.length; ++i) {
            this.data[n++] = (byte)(this.components[i] >> 8);
            this.data[n++] = (byte)(this.components[i] & 0xFF);
            this.data[n++] = this.type[i];
            this.data[n++] = this.map[i];
        }
    }
}

