/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui.swing;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.RepaintManager;
import javax.swing.filechooser.FileFilter;
import org.jpedal.PdfDecoder;
import org.jpedal.SingleDisplay;
import org.jpedal.examples.simpleviewer.Commands;
import org.jpedal.examples.simpleviewer.SimpleViewer;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;
import org.jpedal.exception.PdfException;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.Messages;

public class SwingMouseSelector {
    private PdfDecoder decode_pdf;
    private SwingGUI currentGUI;
    private Values commonValues;
    private Commands currentCommands;
    public static boolean activateMultipageHighlight = true;
    private int clickCount = 0;
    private long lastTime = -1L;
    private int pageMouseIsOver = -1;
    private int pageOfHighlight = -1;
    private boolean startHighlighting = false;
    public int id = -1;
    public int lastId = -1;
    private int old_m_x2 = -1;
    private int old_m_y2 = -1;
    boolean altIsDown = false;
    private JPopupMenu rightClick = new JPopupMenu();
    private boolean menuCreated = false;
    JMenuItem copy;
    JMenuItem selectAll;
    JMenuItem deselectall;
    JMenu extract;
    JMenuItem extractText;
    JMenuItem extractImage;
    ImageIcon snapshotIcon;
    JMenuItem snapShot;
    JMenuItem find;
    JMenuItem speakHighlighted;
    private boolean isDragging = false;

    public SwingMouseSelector(PdfDecoder pdfDecoder, SwingGUI swingGUI, Values values, Commands commands) {
        this.decode_pdf = pdfDecoder;
        this.currentGUI = swingGUI;
        this.commonValues = values;
        this.currentCommands = commands;
    }

    public void updateRectangle() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.decode_pdf.getDisplayView() != 1 && !activateMultipageHighlight) return;
        long l = new Date().getTime();
        if (this.lastTime + 500L < l) {
            this.clickCount = 0;
        }
        this.lastTime = l;
        if (mouseEvent.getButton() == 1) {
            int n;
            Rectangle[] rectangleArray;
            if (this.clickCount != 4) {
                ++this.clickCount;
            }
            float f = this.currentGUI.getScaling();
            SwingMouseSelector swingMouseSelector = this;
            int n2 = swingMouseSelector.currentGUI.getPDFDisplayInset();
            int n3 = (int)((float)(this.currentGUI.AdjustForAlignment(mouseEvent.getX()) - n2) / f);
            int n4 = (int)((float)this.decode_pdf.getPdfPageData().getCropBoxHeight(this.commonValues.getCurrentPage()) - (float)(mouseEvent.getY() - n2) / f);
            Point point = this.getCoordsOnPage(mouseEvent.getX(), mouseEvent.getY(), this.commonValues.getCurrentPage());
            n3 = (int)point.getX();
            n4 = (int)point.getY();
            this.id = this.decode_pdf.getDisplayView() == 1 ? this.decode_pdf.getDynamicRenderer().isInsideImage(n3, n4) : -1;
            if (this.lastId != this.id && this.id != -1) {
                rectangleArray = this.decode_pdf.getDynamicRenderer().getArea(this.id);
                if (rectangleArray != null) {
                    int n5 = rectangleArray.height;
                    n = rectangleArray.width;
                    int n6 = rectangleArray.x;
                    int n7 = rectangleArray.y;
                    this.decode_pdf.getDynamicRenderer().setneedsHorizontalInvert(false);
                    this.decode_pdf.getDynamicRenderer().setneedsVerticalInvert(false);
                    if (n < 0) {
                        this.decode_pdf.getDynamicRenderer().setneedsHorizontalInvert(true);
                        n = -n;
                        n6 -= n;
                    }
                    if (n5 < 0) {
                        this.decode_pdf.getDynamicRenderer().setneedsVerticalInvert(true);
                        n5 = -n5;
                        n7 -= n5;
                    }
                    if (this.currentGUI.currentCommands.isImageExtractionAllowed()) {
                        this.currentCommands.pages.setHighlightedImage(new int[]{n6, n7, n, n5});
                    }
                }
                this.lastId = this.id;
            } else {
                if (this.currentGUI.currentCommands.isImageExtractionAllowed()) {
                    this.currentCommands.pages.setHighlightedImage(null);
                }
                this.lastId = -1;
            }
            if (this.id != -1 || this.clickCount <= 1) return;
            switch (this.clickCount) {
                case 1: {
                    return;
                }
                case 2: {
                    rectangleArray = this.decode_pdf.getTextLines().getLineAreas(this.pageMouseIsOver);
                    Rectangle rectangle = new Rectangle(n3, n4, 1, 1);
                    if (rectangleArray == null) return;
                    for (n = 0; n != rectangleArray.length; ++n) {
                        if (!rectangleArray[n].intersects(rectangle)) continue;
                        this.decode_pdf.updateCursorBoxOnScreen(rectangleArray[n], DecoderOptions.highlightColor);
                        this.decode_pdf.getTextLines().addHighlights(new Rectangle[]{rectangleArray[n]}, false, this.pageMouseIsOver);
                    }
                    return;
                }
                case 3: {
                    Rectangle rectangle = this.decode_pdf.getTextLines().setFoundParagraph(n3, n4, this.pageMouseIsOver);
                    if (rectangle == null) return;
                    this.decode_pdf.updateCursorBoxOnScreen(rectangle, DecoderOptions.highlightColor);
                    return;
                }
                case 4: {
                    this.currentGUI.currentCommands.executeCommand(26, null);
                }
            }
            return;
        }
        if (mouseEvent.getButton() != 2 && mouseEvent.getButton() != 3) return;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if ((this.decode_pdf.getDisplayView() == 1 || activateMultipageHighlight) && mouseEvent.getButton() == 1) {
            this.decode_pdf.updateCursorBoxOnScreen(null, null);
            this.currentCommands.pages.setHighlightedImage(null);
            this.decode_pdf.getTextLines().clearHighlights();
            this.decode_pdf.grabFocus();
            Point point = this.getCoordsOnPage(mouseEvent.getX(), mouseEvent.getY(), this.commonValues.getCurrentPage());
            this.commonValues.m_x1 = (int)point.getX();
            this.commonValues.m_y1 = (int)point.getY();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.decode_pdf.getDisplayView() == 1 || activateMultipageHighlight) {
            if (mouseEvent.getButton() == 1) {
                if (this.startHighlighting) {
                    this.startHighlighting = false;
                }
                this.repaintArea(new Rectangle(this.commonValues.m_x1 - this.currentGUI.cropX, this.commonValues.m_y2 + this.currentGUI.cropY, this.commonValues.m_x2 - this.commonValues.m_x1 + this.currentGUI.cropX, this.commonValues.m_y1 - this.commonValues.m_y2 + this.currentGUI.cropY), this.currentGUI.mediaH);
                this.decode_pdf.repaint();
                if (this.currentCommands.extractingAsImage) {
                    this.decode_pdf.updateCursorBoxOnScreen(null, null);
                    this.decode_pdf.getTextLines().clearHighlights();
                    this.currentCommands.pages.setHighlightedImage(null);
                    this.decode_pdf.setPDFCursor(Cursor.getPredefinedCursor(0));
                    this.currentGUI.currentCommands.extractSelectedScreenAsImage();
                    this.currentCommands.extractingAsImage = false;
                    PdfDecoder.showMouseBox = false;
                }
                this.pageOfHighlight = -1;
            } else if (mouseEvent.getButton() == 3 && this.currentGUI.getProperties().getValue("allowRightClick").toLowerCase().equals("true")) {
                if (!this.menuCreated) {
                    this.createRightClickMenu();
                }
                if (this.currentCommands.pages.getHighlightedImage() == null) {
                    this.extractImage.setEnabled(false);
                } else {
                    this.extractImage.setEnabled(true);
                }
                if (this.decode_pdf.getTextLines().getHighlightedAreas(this.commonValues.getCurrentPage()) == null) {
                    this.extractText.setEnabled(false);
                    this.find.setEnabled(false);
                    this.speakHighlighted.setEnabled(false);
                    this.copy.setEnabled(false);
                } else {
                    this.extractText.setEnabled(true);
                    this.find.setEnabled(true);
                    this.speakHighlighted.setEnabled(true);
                    this.copy.setEnabled(true);
                }
                if (this.decode_pdf != null && this.decode_pdf.isOpen()) {
                    this.rightClick.show(this.decode_pdf, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.altIsDown = mouseEvent.isAltDown();
        if (!this.startHighlighting) {
            this.startHighlighting = true;
        }
        Point point = this.getCoordsOnPage(mouseEvent.getX(), mouseEvent.getY(), this.commonValues.getCurrentPage());
        if (this.pageMouseIsOver == this.pageOfHighlight) {
            this.commonValues.m_x2 = (int)point.getX();
            this.commonValues.m_y2 = (int)point.getY();
        }
        if (this.commonValues.isPDF()) {
            this.generateNewCursorBox();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    protected int[] updateXY(int n, int n2) {
        float f = this.currentGUI.getScaling();
        SwingMouseSelector swingMouseSelector = this;
        int n3 = swingMouseSelector.currentGUI.getPDFDisplayInset();
        int n4 = this.currentGUI.getRotation();
        int n5 = (int)((float)(this.currentGUI.AdjustForAlignment(n) - n3) / f);
        int n6 = (int)((float)(n2 - n3) / f);
        if (this.commonValues.maxViewY != 0) {
            n5 = (int)((double)((float)n5 - (float)this.commonValues.dx * f) / this.commonValues.viewportScale);
            n6 = (int)(((double)this.currentGUI.mediaH - (double)((float)this.currentGUI.mediaH - (float)n6 / f - (float)this.commonValues.dy) / this.commonValues.viewportScale) * (double)f);
        }
        int[] nArray = new int[2];
        if (n4 == 90) {
            nArray[1] = n5 + this.currentGUI.cropY;
            nArray[0] = n6 + this.currentGUI.cropX;
        } else if (n4 == 180) {
            nArray[0] = this.currentGUI.mediaW - (n5 + this.currentGUI.mediaW - this.currentGUI.cropW - this.currentGUI.cropX);
            nArray[1] = n6 + this.currentGUI.cropY;
        } else if (n4 == 270) {
            nArray[1] = this.currentGUI.mediaH - (n5 + this.currentGUI.mediaH - this.currentGUI.cropH - this.currentGUI.cropY);
            nArray[0] = this.currentGUI.mediaW - (n6 + this.currentGUI.mediaW - this.currentGUI.cropW - this.currentGUI.cropX);
        } else {
            nArray[0] = n5 + this.currentGUI.cropX;
            nArray[1] = this.currentGUI.mediaH - (n6 + this.currentGUI.mediaH - this.currentGUI.cropH - this.currentGUI.cropY);
        }
        return nArray;
    }

    private void createRightClickMenu() {
        this.copy = new JMenuItem(Messages.getMessage("PdfRightClick.copy"));
        this.selectAll = new JMenuItem(Messages.getMessage("PdfRightClick.selectAll"));
        this.deselectall = new JMenuItem(Messages.getMessage("PdfRightClick.deselectAll"));
        this.extract = new JMenu(Messages.getMessage("PdfRightClick.extract"));
        this.extractText = new JMenuItem(Messages.getMessage("PdfRightClick.extractText"));
        this.extractImage = new JMenuItem(Messages.getMessage("PdfRightClick.extractImage"));
        this.snapshotIcon = new ImageIcon(this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/snapshot_menu.gif"));
        this.snapShot = new JMenuItem(Messages.getMessage("PdfRightClick.snapshot"), this.snapshotIcon);
        this.find = new JMenuItem(Messages.getMessage("PdfRightClick.find"));
        this.speakHighlighted = new JMenuItem("Speak Highlighted text");
        this.rightClick.add(this.copy);
        this.copy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SwingMouseSelector.this.decode_pdf.getDisplayView() == 1) {
                    ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.currentCommands.executeCommand(25, null);
                } else if (SimpleViewer.showMessages) {
                    JOptionPane.showMessageDialog(SwingMouseSelector.this.currentGUI.getFrame(), "Copy is only avalible in single page display mode");
                }
            }
        });
        this.rightClick.addSeparator();
        this.rightClick.add(this.selectAll);
        this.selectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.currentCommands.executeCommand(26, null);
            }
        });
        this.rightClick.add(this.deselectall);
        this.deselectall.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.currentCommands.executeCommand(27, null);
            }
        });
        this.rightClick.addSeparator();
        this.rightClick.add(this.extract);
        this.extract.add(this.extractText);
        this.extractText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SwingMouseSelector.this.decode_pdf.getDisplayView() == 1) {
                    ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.currentCommands.extractSelectedText();
                } else if (SimpleViewer.showMessages) {
                    JOptionPane.showMessageDialog(SwingMouseSelector.this.currentGUI.getFrame(), "Text Extraction is only avalible in single page display mode");
                }
            }
        });
        this.extract.add(this.extractImage);
        this.extractImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (((SwingMouseSelector)SwingMouseSelector.this).currentCommands.pages.getHighlightedImage() == null) {
                    if (SimpleViewer.showMessages) {
                        JOptionPane.showMessageDialog(SwingMouseSelector.this.decode_pdf, "No image has been selected for extraction.", "No image selected", 0);
                    }
                } else if (SwingMouseSelector.this.decode_pdf.getDisplayView() == 1) {
                    JFileChooser jFileChooser = new JFileChooser();
                    FileFilter fileFilter = new FileFilter(){

                        public boolean accept(File file) {
                            return file.isDirectory() || file.getName().toLowerCase().endsWith(".jpg") || file.getName().toLowerCase().endsWith(".jpeg");
                        }

                        public String getDescription() {
                            return "JPG (*.jpg)";
                        }
                    };
                    FileFilter fileFilter2 = new FileFilter(){

                        public boolean accept(File file) {
                            return file.isDirectory() || file.getName().toLowerCase().endsWith(".png");
                        }

                        public String getDescription() {
                            return "PNG (*.png)";
                        }
                    };
                    FileFilter fileFilter3 = new FileFilter(){

                        public boolean accept(File file) {
                            return file.isDirectory() || file.getName().toLowerCase().endsWith(".tif") || file.getName().toLowerCase().endsWith(".tiff");
                        }

                        public String getDescription() {
                            return "TIF (*.tiff)";
                        }
                    };
                    jFileChooser.addChoosableFileFilter(fileFilter3);
                    jFileChooser.addChoosableFileFilter(fileFilter2);
                    jFileChooser.addChoosableFileFilter(fileFilter);
                    jFileChooser.showSaveDialog(null);
                    File file = jFileChooser.getSelectedFile();
                    boolean bl = false;
                    if (file != null) {
                        String string = file.getAbsolutePath();
                        String string2 = jFileChooser.getFileFilter().getDescription().substring(0, 3).toLowerCase();
                        if (string.indexOf(46) != -1) {
                            String string3 = string.substring(string.indexOf(46) + 1).toLowerCase();
                            if (string3.equals("jpg") || string3.equals("jpeg")) {
                                string2 = "jpg";
                            } else if (string3.equals("png")) {
                                string2 = "png";
                            } else if (string3.equals("tif") || string3.equals("tiff")) {
                                string2 = "tiff";
                            } else {
                                if (SimpleViewer.showMessages) {
                                    JOptionPane.showMessageDialog(null, "Sorry, we can not currently save images to ." + string3 + " files.");
                                }
                                bl = true;
                            }
                        }
                        if (string2.equals("tif")) {
                            string2 = "tiff";
                        }
                        if (string2.equals("all")) {
                            string2 = "png";
                        }
                        if (!string.toLowerCase().endsWith('.' + string2)) {
                            string = string + '.' + string2;
                        }
                        if (!bl) {
                            SwingMouseSelector.this.decode_pdf.getDynamicRenderer().saveImage(SwingMouseSelector.this.id, string, string2);
                        }
                    }
                }
            }
        });
        this.extract.add(this.snapShot);
        this.snapShot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.currentCommands.executeCommand(13, null);
            }
        });
        this.rightClick.addSeparator();
        this.rightClick.add(this.find);
        this.find.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int n2;
                int n3;
                Rectangle rectangle = SwingMouseSelector.this.decode_pdf.getCursorBoxOnScreen();
                if (rectangle == null) {
                    if (SimpleViewer.showMessages) {
                        JOptionPane.showMessageDialog(SwingMouseSelector.this.decode_pdf, "There is no text selected.\nPlease highlight the text you wish to search.", "No Text selected", 0);
                    }
                    return;
                }
                String string = SwingMouseSelector.this.currentGUI.showInputDialog(Messages.getMessage("PdfViewerMessage.GetUserInput"));
                if (string == null || string.length() < 1) {
                    return;
                }
                int n4 = rectangle.x;
                int n5 = rectangle.x + rectangle.width;
                int n6 = rectangle.y;
                int n7 = rectangle.y + rectangle.height;
                if (n6 < n7) {
                    n3 = n7;
                    n7 = n6;
                    n6 = n3;
                }
                if (n4 > n5) {
                    n3 = n5;
                    n5 = n4;
                    n4 = n3;
                }
                if (n4 < ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.cropX) {
                    n4 = ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.cropX;
                }
                if (n4 > ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.mediaW - ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.cropX) {
                    n4 = ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.mediaW - ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.cropX;
                }
                if (n5 < ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.cropX) {
                    n5 = ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.cropX;
                }
                if (n5 > ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.mediaW - ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.cropX) {
                    n5 = ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.mediaW - ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.cropX;
                }
                if (n6 < ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.cropY) {
                    n6 = ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.cropY;
                }
                if (n6 > ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.mediaH - ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.cropY) {
                    n6 = ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.mediaH - ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.cropY;
                }
                if (n7 < ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.cropY) {
                    n7 = ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.cropY;
                }
                if (n7 > ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.mediaH - ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.cropY) {
                    n7 = ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.mediaH - ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.cropY;
                }
                n3 = 0;
                int n8 = SwingMouseSelector.this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewercase.message"), null, 0);
                if (n8 == 0) {
                    n3 |= 2;
                }
                if ((n2 = SwingMouseSelector.this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerfindAll.message"), null, 0)) == 1) {
                    n3 |= 4;
                }
                if ((n = SwingMouseSelector.this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerfindHyphen.message"), null, 0)) == 0) {
                    n3 |= 8;
                }
                if (string != null) {
                    try {
                        float[] fArray = SwingMouseSelector.this.decode_pdf.getGroupingObject().findText(new Rectangle(n4, n6, n5 - n4, n7 - n6), SwingMouseSelector.this.commonValues.getCurrentPage(), new String[]{string}, n3);
                        if (fArray != null) {
                            if (fArray.length < 3) {
                                SwingMouseSelector.this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.Found") + ' ' + fArray[0] + ',' + fArray[1]);
                            } else {
                                StringBuffer stringBuffer = new StringBuffer();
                                String string2 = Messages.getMessage("PdfViewerMessage.FoundAt");
                                for (int i = 0; i < fArray.length; i += 5) {
                                    stringBuffer.append(string2).append(' ');
                                    stringBuffer.append(fArray[i]);
                                    stringBuffer.append(',');
                                    stringBuffer.append(fArray[i + 1]);
                                    stringBuffer.append('\n');
                                    string2 = fArray[i + 4] == -101.0f ? Messages.getMessage("PdfViewerMessage.FoundAtHyphen") : Messages.getMessage("PdfViewerMessage.FoundAt");
                                }
                                SwingMouseSelector.this.currentGUI.showMessageDialog(stringBuffer.toString());
                            }
                        } else {
                            SwingMouseSelector.this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NotFound"));
                        }
                    }
                    catch (PdfException pdfException) {
                        pdfException.printStackTrace();
                    }
                }
            }
        });
        this.menuCreated = true;
        this.decode_pdf.add(this.rightClick);
    }

    protected void generateNewCursorBox() {
        if (this.old_m_x2 != -1 | this.old_m_y2 != -1 | Math.abs(this.commonValues.m_x2 - this.old_m_x2) > 5 | Math.abs(this.commonValues.m_y2 - this.old_m_y2) > 5) {
            int n = this.commonValues.m_x1;
            if (this.commonValues.m_x1 > this.commonValues.m_x2) {
                n = this.commonValues.m_x2;
            }
            int n2 = this.commonValues.m_y1;
            if (this.commonValues.m_y1 > this.commonValues.m_y2) {
                n2 = this.commonValues.m_y2;
            }
            int n3 = Math.abs(this.commonValues.m_x2 - this.commonValues.m_x1);
            int n4 = Math.abs(this.commonValues.m_y2 - this.commonValues.m_y1);
            Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            this.decode_pdf.updateCursorBoxOnScreen(rectangle, DecoderOptions.highlightColor);
            if (!this.currentCommands.extractingAsImage) {
                int n5 = this.decode_pdf.getDynamicRenderer().getObjectUnderneath(this.commonValues.m_x1, this.commonValues.m_y1);
                if (this.altIsDown && n5 != 1 && n5 != 4 && n5 != 5 && n5 != 6) {
                    this.decode_pdf.getTextLines().addHighlights(new Rectangle[]{rectangle}, true, this.pageOfHighlight);
                } else {
                    Rectangle rectangle2 = new Rectangle(this.commonValues.m_x1, this.commonValues.m_y1, this.commonValues.m_x2 - this.commonValues.m_x1, this.commonValues.m_y2 - this.commonValues.m_y1);
                    this.decode_pdf.getTextLines().addHighlights(new Rectangle[]{rectangle2}, false, this.pageOfHighlight);
                }
            }
            this.old_m_x2 = this.commonValues.m_x2;
            this.old_m_y2 = this.commonValues.m_y2;
        }
        ((SingleDisplay)this.decode_pdf.getExternalHandler(16)).refreshDisplay();
        this.decode_pdf.repaint();
    }

    private Point getPageCoordsInSingleDisplayMode(int n, int n2, int n3) {
        int n4;
        int n5;
        if (this.currentGUI.useNewLayout) {
            int[] nArray = new int[]{1, 0};
            if (this.currentGUI.getRotation() % 180 == 90) {
                n5 = this.decode_pdf.getPdfPageData().getScaledCropBoxHeight(n3);
                n4 = this.decode_pdf.getPdfPageData().getScaledCropBoxWidth(n3);
            } else {
                n5 = this.decode_pdf.getPdfPageData().getScaledCropBoxWidth(n3);
                n4 = this.decode_pdf.getPdfPageData().getScaledCropBoxHeight(n3);
            }
            Rectangle rectangle = new Rectangle(this.decode_pdf.getWidth() / 2 - n5 / 2, this.decode_pdf.getInsetH(), n5, n4);
            nArray[1] = rectangle.contains(n, n2) ? 1 : 0;
            if (this.pageOfHighlight == -1 && this.startHighlighting) {
                this.pageOfHighlight = n3;
            }
            this.pageMouseIsOver = n3;
            this.currentGUI.setMultibox(nArray);
        }
        float f = this.currentGUI.getScaling();
        SwingMouseSelector swingMouseSelector = this;
        n5 = swingMouseSelector.currentGUI.getPDFDisplayInset();
        n4 = this.currentGUI.getRotation();
        int n6 = this.currentGUI.AdjustForAlignment(n) - n5;
        int n7 = n2 - n5;
        if (this.commonValues.maxViewY != 0) {
            n6 = (int)((double)((float)n6 - (float)this.commonValues.dx * f) / this.commonValues.viewportScale);
            n7 = (int)(((double)this.currentGUI.mediaH - (double)((float)this.currentGUI.mediaH - (float)n7 / f - (float)this.commonValues.dy) / this.commonValues.viewportScale) * (double)f);
        }
        n = (int)((float)n6 / f);
        n2 = (int)((float)n7 / f);
        if (n4 == 90) {
            int n8 = n + this.currentGUI.cropY;
            n = n2 + this.currentGUI.cropX;
            n2 = n8;
        } else if (n4 == 180) {
            n = this.currentGUI.cropW + this.currentGUI.cropX - n;
            n2 += this.currentGUI.cropY;
        } else if (n4 == 270) {
            int n9 = this.currentGUI.cropH + this.currentGUI.cropY - n;
            n = this.currentGUI.cropW + this.currentGUI.cropX - n2;
            n2 = n9;
        } else {
            n += this.currentGUI.cropX;
            n2 = this.decode_pdf.getDisplayView() == 1 ? this.currentGUI.cropH + this.currentGUI.cropY - n2 : this.currentGUI.cropY + n2;
        }
        return new Point(n, n2);
    }

    private Point getPageCoordsInContinuousDisplayMode(int n, int n2, int n3) {
        int n4;
        SingleDisplay singleDisplay = (SingleDisplay)this.decode_pdf.getExternalHandler(16);
        if (this.currentGUI.useNewLayout) {
            int[] nArray = new int[]{1, 0};
            n4 = this.decode_pdf.getWidth() / 2 - this.decode_pdf.getPdfPageData().getScaledCropBoxWidth(n3) / 2;
            n4 = n4 < 0 ? 0 : (n4 -= singleDisplay.getXCordForPage(n3));
            Rectangle rectangle = new Rectangle(singleDisplay.getXCordForPage(n3) + n4, singleDisplay.getYCordForPage(n3), this.decode_pdf.getPdfPageData().getScaledCropBoxWidth(n3), this.decode_pdf.getPdfPageData().getScaledCropBoxHeight(n3));
            if (rectangle.contains(n, n2)) {
                nArray[1] = 1;
            }
            if (nArray[1] == 0) {
                if (n2 < rectangle.y && n3 > 1) {
                    while (nArray[1] == 0 && n3 > 1) {
                        if (!(rectangle = new Rectangle(singleDisplay.getXCordForPage(--n3) + n4, singleDisplay.getYCordForPage(n3), this.decode_pdf.getPdfPageData().getScaledCropBoxWidth(n3), this.decode_pdf.getPdfPageData().getScaledCropBoxHeight(n3))).contains(n, n2)) continue;
                        nArray[1] = 1;
                    }
                } else if ((double)n2 > rectangle.getMaxY() && n3 < this.commonValues.getPageCount()) {
                    while (nArray[1] == 0 && n3 < this.commonValues.getPageCount()) {
                        if (!(rectangle = new Rectangle(singleDisplay.getXCordForPage(++n3) + n4, singleDisplay.getYCordForPage(n3), this.decode_pdf.getPdfPageData().getScaledCropBoxWidth(n3), this.decode_pdf.getPdfPageData().getScaledCropBoxHeight(n3))).contains(n, n2)) continue;
                        nArray[1] = 1;
                    }
                }
            }
            if (this.pageOfHighlight == -1 && this.startHighlighting) {
                this.pageOfHighlight = n3;
            }
            this.pageMouseIsOver = n3;
            n2 = singleDisplay.getYCordForPage(n3) + this.decode_pdf.getPdfPageData().getScaledCropBoxHeight(n3) + this.decode_pdf.getInsetH() - n2;
            this.currentGUI.setMultibox(nArray);
        }
        float f = this.currentGUI.getScaling();
        SwingMouseSelector swingMouseSelector = this;
        n4 = swingMouseSelector.currentGUI.getPDFDisplayInset();
        int n5 = this.currentGUI.getRotation();
        int n6 = this.currentGUI.AdjustForAlignment(n) - n4;
        int n7 = n2 - n4;
        if (this.commonValues.maxViewY != 0) {
            n6 = (int)((double)((float)n6 - (float)this.commonValues.dx * f) / this.commonValues.viewportScale);
            n7 = (int)(((double)this.currentGUI.mediaH - (double)((float)this.currentGUI.mediaH - (float)n7 / f - (float)this.commonValues.dy) / this.commonValues.viewportScale) * (double)f);
        }
        n = (int)((float)n6 / f);
        n2 = (int)((float)n7 / f);
        if (n5 == 90) {
            int n8 = n + this.currentGUI.cropY;
            n = n2 + this.currentGUI.cropX;
            n2 = n8;
        } else if (n5 == 180) {
            n = this.currentGUI.cropW + this.currentGUI.cropX - n;
            n2 += this.currentGUI.cropY;
        } else if (n5 == 270) {
            int n9 = this.currentGUI.cropH + this.currentGUI.cropY - n;
            n = this.currentGUI.cropW + this.currentGUI.cropX - n2;
            n2 = n9;
        } else {
            n += this.currentGUI.cropX;
            n2 = this.decode_pdf.getDisplayView() == 1 ? this.currentGUI.cropH + this.currentGUI.cropY - n2 : this.currentGUI.cropY + n2;
        }
        return new Point(n, n2);
    }

    private Point getPageCoordsInContinuousFacingDisplayMode(int n, int n2, int n3) {
        int n4;
        SingleDisplay singleDisplay = (SingleDisplay)this.decode_pdf.getExternalHandler(16);
        if (this.currentGUI.useNewLayout) {
            Rectangle rectangle;
            int[] nArray = new int[]{1, 0};
            if (n3 != 1 && n > this.decode_pdf.getWidth() / 2 && n3 < this.commonValues.getPageCount()) {
                ++n3;
            }
            if ((n4 = this.decode_pdf.getWidth() / 2 - this.decode_pdf.getPdfPageData().getScaledCropBoxWidth(n3) - this.decode_pdf.getInsetW()) < 0) {
                System.err.println("x adjustment is less than 0");
                n4 = 0;
            }
            if ((rectangle = new Rectangle(singleDisplay.getXCordForPage(n3) + n4, singleDisplay.getYCordForPage(n3), this.decode_pdf.getPdfPageData().getScaledCropBoxWidth(n3), this.decode_pdf.getPdfPageData().getScaledCropBoxHeight(n3))).contains(n, n2)) {
                nArray[1] = 1;
            }
            if (nArray[1] == 0) {
                if (n2 < rectangle.y && n3 > 1) {
                    while (nArray[1] == 0 && n3 > 1) {
                        n4 = this.decode_pdf.getWidth() / 2 - this.decode_pdf.getPdfPageData().getScaledCropBoxWidth(--n3) - this.decode_pdf.getInsetW();
                        if (n4 < 0) {
                            n4 = 0;
                        }
                        if (!(rectangle = new Rectangle(singleDisplay.getXCordForPage(n3) + n4, singleDisplay.getYCordForPage(n3), this.decode_pdf.getPdfPageData().getScaledCropBoxWidth(n3), this.decode_pdf.getPdfPageData().getScaledCropBoxHeight(n3))).contains(n, n2)) continue;
                        nArray[1] = 1;
                    }
                } else if ((double)n2 > rectangle.getMaxY() && n3 < this.commonValues.getPageCount()) {
                    while (nArray[1] == 0 && n3 < this.commonValues.getPageCount()) {
                        n4 = this.decode_pdf.getWidth() / 2 - this.decode_pdf.getPdfPageData().getScaledCropBoxWidth(++n3) - this.decode_pdf.getInsetW();
                        if (n4 < 0) {
                            n4 = 0;
                        }
                        if (!(rectangle = new Rectangle(singleDisplay.getXCordForPage(n3) + n4, singleDisplay.getYCordForPage(n3), this.decode_pdf.getPdfPageData().getScaledCropBoxWidth(n3), this.decode_pdf.getPdfPageData().getScaledCropBoxHeight(n3))).contains(n, n2)) continue;
                        nArray[1] = 1;
                    }
                }
            }
            if (this.pageOfHighlight == -1 && this.startHighlighting) {
                this.pageOfHighlight = n3;
            }
            this.pageMouseIsOver = n3;
            n2 = singleDisplay.getYCordForPage(n3) + this.decode_pdf.getPdfPageData().getScaledCropBoxHeight(n3) + this.decode_pdf.getInsetH() - n2;
            n -= singleDisplay.getXCordForPage(n3) - this.decode_pdf.getInsetW();
            this.currentGUI.setMultibox(nArray);
        }
        float f = this.currentGUI.getScaling();
        SwingMouseSelector swingMouseSelector = this;
        n4 = swingMouseSelector.currentGUI.getPDFDisplayInset();
        int n5 = this.currentGUI.getRotation();
        int n6 = this.currentGUI.AdjustForAlignment(n) - n4;
        int n7 = n2 - n4;
        if (this.commonValues.maxViewY != 0) {
            n6 = (int)((double)((float)n6 - (float)this.commonValues.dx * f) / this.commonValues.viewportScale);
            n7 = (int)(((double)this.currentGUI.mediaH - (double)((float)this.currentGUI.mediaH - (float)n7 / f - (float)this.commonValues.dy) / this.commonValues.viewportScale) * (double)f);
        }
        n = (int)((float)n6 / f);
        n2 = (int)((float)n7 / f);
        if (n5 == 90) {
            int n8 = n + this.currentGUI.cropY;
            n = n2 + this.currentGUI.cropX;
            n2 = n8;
        } else if (n5 == 180) {
            n = this.currentGUI.cropW + this.currentGUI.cropX - n;
            n2 += this.currentGUI.cropY;
        } else if (n5 == 270) {
            int n9 = this.currentGUI.cropH + this.currentGUI.cropY - n;
            n = this.currentGUI.cropW + this.currentGUI.cropX - n2;
            n2 = n9;
        } else {
            n += this.currentGUI.cropX;
            n2 = this.decode_pdf.getDisplayView() == 1 ? this.currentGUI.cropH + this.currentGUI.cropY - n2 : this.currentGUI.cropY + n2;
        }
        return new Point(n, n2);
    }

    private Point getPageCoordsInFacingDisplayMode(int n, int n2, int n3) {
        if (this.currentGUI.useNewLayout) {
            int[] nArray = new int[]{1, 0};
            nArray[1] = 0;
            this.currentGUI.setMultibox(nArray);
        }
        float f = this.currentGUI.getScaling();
        SwingMouseSelector swingMouseSelector = this;
        int n4 = swingMouseSelector.currentGUI.getPDFDisplayInset();
        int n5 = this.currentGUI.getRotation();
        int n6 = this.currentGUI.AdjustForAlignment(n) - n4;
        int n7 = n2 - n4;
        if (this.commonValues.maxViewY != 0) {
            n6 = (int)((double)((float)n6 - (float)this.commonValues.dx * f) / this.commonValues.viewportScale);
            n7 = (int)(((double)this.currentGUI.mediaH - (double)((float)this.currentGUI.mediaH - (float)n7 / f - (float)this.commonValues.dy) / this.commonValues.viewportScale) * (double)f);
        }
        n = (int)((float)n6 / f);
        n2 = (int)((float)n7 / f);
        if (n5 == 90) {
            int n8 = n + this.currentGUI.cropY;
            n = n2 + this.currentGUI.cropX;
            n2 = n8;
        } else if (n5 == 180) {
            n = this.currentGUI.cropW + this.currentGUI.cropX - n;
            n2 += this.currentGUI.cropY;
        } else if (n5 == 270) {
            int n9 = this.currentGUI.cropH + this.currentGUI.cropY - n;
            n = this.currentGUI.cropW + this.currentGUI.cropX - n2;
            n2 = n9;
        } else {
            n += this.currentGUI.cropX;
            n2 = this.decode_pdf.getDisplayView() == 1 ? this.currentGUI.cropH + this.currentGUI.cropY - n2 : this.currentGUI.cropY + n2;
        }
        return new Point(n, n2);
    }

    public Point getCoordsOnPage(int n, int n2, int n3) {
        Point point = null;
        switch (this.decode_pdf.getDisplayView()) {
            case 1: {
                point = this.getPageCoordsInSingleDisplayMode(n, n2, n3);
                n = point.x;
                n2 = point.y;
                break;
            }
            case 2: {
                point = this.getPageCoordsInContinuousDisplayMode(n, n2, n3);
                n = point.x;
                n2 = point.y;
                break;
            }
            case 3: {
                point = this.getPageCoordsInFacingDisplayMode(n, n2, n3);
                n = point.x;
                n2 = point.y;
                break;
            }
            case 4: {
                point = this.getPageCoordsInContinuousFacingDisplayMode(n, n2, n3);
                n = point.x;
                n2 = point.y;
                break;
            }
        }
        return new Point(n, n2);
    }

    public void repaintArea(Rectangle rectangle, int n) {
        int n2 = 10;
        float f = this.decode_pdf.getScaling();
        int n3 = (int)((float)rectangle.x * f) - n2;
        int n4 = (int)((float)(n - rectangle.y - rectangle.height) * f) - n2;
        int n5 = (int)((float)(rectangle.x + rectangle.width) * f) + n2 + n2;
        int n6 = (int)((float)(rectangle.y + rectangle.height) * f) + n2 + n2;
        RepaintManager repaintManager = RepaintManager.currentManager(this.decode_pdf);
        repaintManager.addDirtyRegion(this.decode_pdf, n3, n4, n5, n6);
    }
}

