/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.util.Map;
import org.jpedal.color.CalGrayColorSpace;
import org.jpedal.color.CalRGBColorSpace;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.color.DeviceGrayColorSpace;
import org.jpedal.color.DeviceNColorSpace;
import org.jpedal.color.DeviceRGBColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.ICCColorSpace;
import org.jpedal.color.LabColorSpace;
import org.jpedal.color.PatternColorSpace;
import org.jpedal.color.SeparationColorSpace;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfObject;

public class ColorspaceFactory {
    private ColorspaceFactory() {
    }

    public static final GenericColorSpace getColorSpaceInstance(PdfObjectReader pdfObjectReader, PdfObject pdfObject, Map map) {
        String string = pdfObject.getStatus() == 0 ? pdfObject.getObjectRefAsString() : new String(pdfObject.getUnresolvedData());
        GenericColorSpace genericColorSpace = null;
        Object v = map.get(string);
        if (v != null) {
            genericColorSpace = (GenericColorSpace)v;
            genericColorSpace.reset();
        }
        if (genericColorSpace == null && (genericColorSpace = ColorspaceFactory.getColorSpaceInstance(pdfObjectReader, pdfObject)).getID() == 1247168582) {
            map.put(string, genericColorSpace);
        }
        return genericColorSpace;
    }

    public static final GenericColorSpace getColorSpaceInstance(PdfObjectReader pdfObjectReader, PdfObject pdfObject) {
        pdfObjectReader.checkResolved(pdfObject);
        int n = pdfObject.getParameterConstant(2087749783);
        if (n == 320678171) {
            n = 1498837125;
        }
        boolean bl = false;
        int n2 = 0;
        byte[] byArray = null;
        int n3 = -1;
        if (n == 895578984 || n == 25) {
            bl = true;
            n2 = pdfObject.getInt(960901492);
            byArray = pdfObject.getDictionary(1060856191).getDecodedStream();
            pdfObject = pdfObject.getDictionary(895578984);
            n3 = n = pdfObject.getParameterConstant(2087749783);
        }
        GenericColorSpace genericColorSpace = ColorspaceFactory.getColorspace(pdfObjectReader, pdfObject, n);
        if (bl) {
            if (n3 == 1247168582 && byArray.length < 3) {
                genericColorSpace = new DeviceGrayColorSpace();
            }
            genericColorSpace.setIndex(byArray, n2);
        }
        genericColorSpace.setAlternateColorSpace(pdfObject.getParameterConstant(2054519176));
        return genericColorSpace;
    }

    private static GenericColorSpace getColorspace(PdfObjectReader pdfObjectReader, PdfObject pdfObject, int n) {
        GenericColorSpace genericColorSpace = new DeviceRGBColorSpace();
        switch (n) {
            case -2073385820: {
                genericColorSpace = new SeparationColorSpace(pdfObjectReader, pdfObject);
                break;
            }
            case 960981604: {
                genericColorSpace = new DeviceNColorSpace(pdfObjectReader, pdfObject);
                break;
            }
            case 1568372915: {
                genericColorSpace = new DeviceGrayColorSpace();
                break;
            }
            case 1498837125: {
                genericColorSpace = new DeviceCMYKColorSpace();
                break;
            }
            case 391471749: {
                genericColorSpace = ColorspaceFactory.getCalGrayColorspace(pdfObject);
                break;
            }
            case 1008872003: {
                genericColorSpace = ColorspaceFactory.getCalRGBColorspace(pdfObject);
                break;
            }
            case 1847602: {
                genericColorSpace = ColorspaceFactory.getLabColorspace(pdfObject);
                break;
            }
            case 1247168582: {
                genericColorSpace = ColorspaceFactory.getICCColorspace(pdfObject);
                break;
            }
            case 1146450818: {
                genericColorSpace = new PatternColorSpace(pdfObjectReader);
            }
        }
        return genericColorSpace;
    }

    private static GenericColorSpace getICCColorspace(PdfObject pdfObject) {
        GenericColorSpace genericColorSpace = new DeviceRGBColorSpace();
        int n = pdfObject.getParameterConstant(2054519176);
        if (n != 1568372915) {
            genericColorSpace = new ICCColorSpace(pdfObject);
        }
        if (n == 1498837125 && genericColorSpace.isInvalid()) {
            genericColorSpace = new DeviceCMYKColorSpace();
        }
        return genericColorSpace;
    }

    private static GenericColorSpace getLabColorspace(PdfObject pdfObject) {
        float[] fArray = new float[]{-100.0f, 100.0f, -100.0f, 100.0f};
        float[] fArray2 = new float[]{0.0f, 1.0f, 0.0f};
        float[] fArray3 = new float[]{0.0f, 0.0f, 0.0f};
        float[] fArray4 = pdfObject.getFloatArray(1886161824);
        float[] fArray5 = pdfObject.getFloatArray(2021497500);
        float[] fArray6 = pdfObject.getFloatArray(826160983);
        if (fArray5 != null) {
            fArray2 = fArray5;
        }
        if (fArray4 != null) {
            fArray3 = fArray4;
        }
        if (fArray6 != null) {
            fArray = fArray6;
        }
        return new LabColorSpace(fArray2, fArray3, fArray);
    }

    private static GenericColorSpace getCalRGBColorspace(PdfObject pdfObject) {
        float[] fArray = new float[]{0.0f, 1.0f, 0.0f};
        float[] fArray2 = new float[]{0.0f, 0.0f, 0.0f};
        float[] fArray3 = new float[]{1.0f, 1.0f, 1.0f};
        float[] fArray4 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        float[] fArray5 = pdfObject.getFloatArray(826096968);
        float[] fArray6 = pdfObject.getFloatArray(1886161824);
        float[] fArray7 = pdfObject.getFloatArray(2021497500);
        float[] fArray8 = pdfObject.getFloatArray(1145198201);
        if (fArray7 != null) {
            fArray = fArray7;
        }
        if (fArray6 != null) {
            fArray2 = fArray6;
        }
        if (fArray5 != null) {
            fArray3 = fArray5;
        }
        if (fArray8 != null) {
            fArray4 = fArray8;
        }
        return new CalRGBColorSpace(fArray, fArray2, fArray4, fArray3);
    }

    private static GenericColorSpace getCalGrayColorspace(PdfObject pdfObject) {
        float[] fArray = new float[]{0.0f, 1.0f, 0.0f};
        float[] fArray2 = new float[]{0.0f, 0.0f, 0.0f};
        float[] fArray3 = new float[]{1.0f, 1.0f, 1.0f};
        float[] fArray4 = null;
        float[] fArray5 = pdfObject.getFloatArray(1886161824);
        float[] fArray6 = pdfObject.getFloatArray(2021497500);
        float f = pdfObject.getFloatNumber(826096968);
        if (f != -1.0f) {
            fArray4 = new float[]{f};
        }
        if (fArray6 != null) {
            fArray = fArray6;
        }
        if (fArray5 != null) {
            fArray2 = fArray5;
        }
        if (fArray4 != null) {
            fArray3 = fArray4;
        }
        return new CalGrayColorSpace(fArray, fArray2, fArray3);
    }
}

