/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss.gui;

import at.laborg.briss.BrissGUI;
import at.laborg.briss.gui.ClipBoard;
import at.laborg.briss.gui.DrawableCropRect;
import at.laborg.briss.model.CropFinder;
import at.laborg.briss.model.PageCluster;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergedPanel
extends JPanel {
    private static DrawableCropRect curCrop;
    private static Point lastDragPoint;
    private static Point cropStartPoint;
    private static Point popUpMenuPoint;
    private static Point relativeHotCornerGrabDistance;
    private static ActionState actionState;
    private static final int SELECT_BORDER_WIDTH = 1;
    private static final Font BASE_FONT;
    private static final Composite SMOOTH_NORMAL;
    private static final Composite SMOOTH_SELECT;
    private static final Composite XOR_COMPOSITE;
    private static final float[] DASH_PATTERN;
    private static final BasicStroke SELECTED_STROKE;
    private final PageCluster cluster;
    private final List<DrawableCropRect> crops = new ArrayList<DrawableCropRect>();
    private final BufferedImage img;
    private final BrissGUI briss;

    static {
        actionState = ActionState.NOTHING;
        BASE_FONT = new Font(null, 0, 10);
        SMOOTH_NORMAL = AlphaComposite.getInstance(3, 0.2f);
        SMOOTH_SELECT = AlphaComposite.getInstance(3, 0.5f);
        XOR_COMPOSITE = AlphaComposite.getInstance(3, 0.8f);
        DASH_PATTERN = new float[]{25.0f, 25.0f};
        SELECTED_STROKE = new BasicStroke(1.0f, 2, 2, 1.0f, DASH_PATTERN, 0.0f);
    }

    public MergedPanel(PageCluster cluster, BrissGUI briss) {
        this.briss = briss;
        this.cluster = cluster;
        this.img = cluster.getImageData().getPreviewImage();
        Float[] autoRatios = CropFinder.getAutoCropFloats(this.img);
        cluster.addRatios(autoRatios);
        this.setPreferredSize(new Dimension(this.img.getWidth(), this.img.getHeight()));
        this.setSize(new Dimension(this.img.getWidth(), this.img.getHeight()));
        if (cluster.getImageData().isRenderable()) {
            MergedPanelMouseAdapter mouseAdapter = new MergedPanelMouseAdapter();
            this.addMouseMotionListener(mouseAdapter);
            this.addMouseListener(mouseAdapter);
        }
        this.addRatiosAsCrops(cluster.getRatiosList());
        this.setToolTipText(this.createInfoString(cluster));
        this.addKeyListener(new MergedPanelKeyAdapter());
        this.setFocusable(true);
        this.repaint();
    }

    private void addRatiosAsCrops(List<Float[]> ratiosList) {
        for (Float[] ratios : this.cluster.getRatiosList()) {
            DrawableCropRect rect = new DrawableCropRect();
            rect.x = (int)((float)this.img.getWidth() * ratios[0].floatValue());
            rect.y = (int)((float)this.img.getHeight() * ratios[3].floatValue());
            rect.width = (int)((float)this.img.getWidth() * (1.0f - (ratios[0].floatValue() + ratios[2].floatValue())));
            rect.height = (int)((float)this.img.getHeight() * (1.0f - (ratios[1].floatValue() + ratios[3].floatValue())));
            this.crops.add(rect);
        }
    }

    private String createInfoString(PageCluster cluster) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append(cluster.isEvenPage() ? "Even " : "Odd ").append("page<br>");
        sb.append(String.valueOf(cluster.getAllPages().size()) + " pages: ");
        int pagecounter = 0;
        for (Integer pageNumber : cluster.getAllPages()) {
            sb.append(pageNumber + " ");
            if (pagecounter++ <= 10) continue;
            pagecounter = 0;
            sb.append("<br>");
        }
        sb.append("</html>");
        return sb.toString();
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public void update(Graphics g) {
        if (!this.isEnabled()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.drawImage(this.img, null, 0, 0);
        int cropCnt = 0;
        for (DrawableCropRect crop : this.crops) {
            this.drawNormalCropRectangle(g2, cropCnt, crop);
            if (crop.isSelected()) {
                this.drawSelectionOverlay(g2, crop);
            }
            ++cropCnt;
        }
        g2.dispose();
    }

    private void drawNormalCropRectangle(Graphics2D g2, int cropCnt, DrawableCropRect crop) {
        g2.setComposite(SMOOTH_NORMAL);
        g2.setColor(Color.BLUE);
        g2.fill(crop);
        g2.setColor(Color.BLACK);
        g2.setFont(this.scaleFont(String.valueOf(cropCnt + 1), crop));
        g2.drawString(String.valueOf(cropCnt + 1), crop.x, crop.y + crop.height);
        int cD = 20;
        g2.fillRect(crop.x, crop.y, cD, cD);
        g2.fillRect(crop.x + crop.width - cD - 1, crop.y + crop.height - cD - 1, cD, cD);
    }

    private void drawSelectionOverlay(Graphics2D g2, DrawableCropRect crop) {
        g2.setComposite(XOR_COMPOSITE);
        g2.setColor(Color.BLACK);
        g2.setStroke(SELECTED_STROKE);
        g2.drawRect(crop.x + 0, crop.y + 0, crop.width - 1, crop.height - 1);
        int w = Math.round(25.4f * (float)crop.width / 72.0f);
        int h = Math.round(25.4f * (float)crop.height / 72.0f);
        String size = String.valueOf(Integer.toString(w)) + "x" + Integer.toString(h);
        g2.setFont(this.scaleFont(size, crop));
        g2.setColor(Color.YELLOW);
        g2.setComposite(SMOOTH_SELECT);
        g2.drawString(size, crop.x + 1, crop.y + crop.height - 1);
    }

    private void changeSelectRectangle(Point p) {
        for (DrawableCropRect crop : this.crops) {
            if (!crop.contains(p)) continue;
            crop.setSelected(!crop.isSelected());
            break;
        }
        this.repaint();
    }

    public int getWidestSelectedRect() {
        int max = -1;
        for (DrawableCropRect crop : this.crops) {
            if (!crop.isSelected() || crop.width <= max) continue;
            max = crop.width;
        }
        return max;
    }

    public int getHeighestSelectedRect() {
        int max = -1;
        for (DrawableCropRect crop : this.crops) {
            if (!crop.isSelected() || crop.height <= max) continue;
            max = crop.height;
        }
        return max;
    }

    public int getLeftmostSelectedRect() {
        int min = Integer.MAX_VALUE;
        for (DrawableCropRect crop : this.crops) {
            if (!crop.isSelected() || crop.x >= min) continue;
            min = crop.x;
        }
        return min;
    }

    public int getUpmostSelectedRect() {
        int min = Integer.MAX_VALUE;
        for (DrawableCropRect crop : this.crops) {
            if (!crop.isSelected() || crop.y >= min) continue;
            min = crop.y;
        }
        return min;
    }

    public Dimension getLargestRect() {
        int maxW = -1;
        int maxH = -1;
        for (DrawableCropRect crop : this.crops) {
            if (crop.width > maxW) {
                maxW = crop.width;
            }
            if (crop.height <= maxH) continue;
            maxH = crop.height;
        }
        return new Dimension(maxW, maxH);
    }

    public void setSelCropWidth(int width) {
        for (DrawableCropRect crop : this.crops) {
            if (!crop.isSelected()) continue;
            int diffToMax = width - crop.width;
            crop.grow(diffToMax / 2, 0);
        }
        this.updateClusterRatios(this.crops);
        this.repaint();
    }

    public void setSelCropHeight(int height) {
        for (DrawableCropRect crop : this.crops) {
            if (!crop.isSelected()) continue;
            int diffToMax = height - crop.height;
            crop.grow(0, diffToMax / 2);
        }
        this.updateClusterRatios(this.crops);
        this.repaint();
    }

    public void setSelCropSize(int width, int height) {
        for (DrawableCropRect crop : this.crops) {
            if (!crop.isSelected()) continue;
            int diffToMaxW = width - crop.width;
            int diffToMaxH = height - crop.height;
            crop.grow(diffToMaxW / 2, diffToMaxH / 2);
        }
        this.updateClusterRatios(this.crops);
        this.repaint();
    }

    public void resizeSelCrop(int width, int height) {
        for (DrawableCropRect crop : this.crops) {
            if (!crop.isSelected()) continue;
            if (width < 0 && crop.width <= -width || height < 0 && crop.height <= -height) {
                return;
            }
            crop.setSize(crop.width + width, crop.height + height);
        }
        this.updateClusterRatios(this.crops);
        this.repaint();
    }

    public void setAllCropSize(int width, int height) {
        for (DrawableCropRect crop : this.crops) {
            crop.setSize(width, height);
        }
        this.updateClusterRatios(this.crops);
        this.repaint();
    }

    public void moveSelelectedCrops(int x, int y) {
        for (DrawableCropRect crop : this.crops) {
            if (!crop.isSelected()) continue;
            int newX = crop.x + x;
            int newY = crop.y + y;
            crop.setLocation(newX, newY);
        }
        this.repaint();
    }

    public void moveToSelelectedCrops(int x, int y) {
        for (DrawableCropRect crop : this.crops) {
            if (!crop.isSelected()) continue;
            crop.setLocation(x, y);
        }
        this.repaint();
    }

    public void selectCrops(boolean select) {
        for (DrawableCropRect crop : this.crops) {
            crop.setSelected(select);
        }
        this.repaint();
    }

    private void updateClusterRatios(List<DrawableCropRect> tmpCrops) {
        this.cluster.clearRatios();
        for (Rectangle rectangle : tmpCrops) {
            this.cluster.addRatios(MergedPanel.getCutRatiosForPdf(rectangle, this.img.getWidth(), this.img.getHeight()));
        }
    }

    private static Float[] getCutRatiosForPdf(Rectangle crop, int imgWidth, int imgHeight) {
        int x1 = crop.x;
        int x2 = x1 + crop.width;
        int y1 = crop.y;
        int y2 = y1 + crop.height;
        if (x1 < 0) {
            x1 = 0;
        }
        if (x2 > imgWidth) {
            x2 = imgWidth;
        }
        if (y1 < 0) {
            y1 = 0;
        }
        if (y2 > imgHeight) {
            y2 = imgHeight;
        }
        Float[] ratios = new Float[]{Float.valueOf((float)x1 / (float)imgWidth), Float.valueOf((float)(imgHeight - y2) / (float)imgHeight), Float.valueOf(1.0f - (float)x2 / (float)imgWidth), Float.valueOf(1.0f - (float)(imgHeight - y1) / (float)imgHeight)};
        return ratios;
    }

    private Font scaleFont(String text, Rectangle rect) {
        int size = BASE_FONT.getSize();
        int width = this.getFontMetrics(BASE_FONT).stringWidth(text);
        int height = this.getFontMetrics(BASE_FONT).getHeight();
        if (width == 0 || height == 0) {
            return BASE_FONT;
        }
        float scaleFactorWidth = rect.width / width;
        float scaleFactorHeight = rect.height / height;
        float scaledWidth = scaleFactorWidth * (float)size;
        float scaledHeight = scaleFactorHeight * (float)size;
        return BASE_FONT.deriveFont(scaleFactorHeight > scaleFactorWidth ? scaledWidth : scaledHeight);
    }

    private void copyToClipBoard() {
        ClipBoard.getInstance().clear();
        for (DrawableCropRect crop : this.crops) {
            if (!crop.isSelected()) continue;
            ClipBoard.getInstance().addCrop(crop);
        }
        this.updateClusterRatios(this.crops);
        this.repaint();
    }

    private void pasteFromClipBoard() {
        for (DrawableCropRect crop : ClipBoard.getInstance().getCrops()) {
            if (this.crops.contains(crop)) continue;
            DrawableCropRect newCrop = new DrawableCropRect(crop);
            this.crops.add(newCrop);
        }
        ClipBoard.getInstance().clear();
        this.updateClusterRatios(this.crops);
        this.repaint();
    }

    private void alignSelected(Point p) {
        for (DrawableCropRect crop : this.crops) {
            if (!crop.contains(p)) continue;
            this.briss.alignSelRects(crop.x, crop.y, crop.width, crop.height);
            break;
        }
    }

    private void deleteAllSelected() {
        ArrayList<DrawableCropRect> removeList = new ArrayList<DrawableCropRect>();
        for (DrawableCropRect crop : this.crops) {
            if (!crop.isSelected()) continue;
            removeList.add(crop);
        }
        this.crops.removeAll(removeList);
        this.updateClusterRatios(this.crops);
        this.repaint();
    }

    private void clipCropsToVisibleArea() {
        for (Rectangle rectangle : this.crops) {
            if (rectangle.x < 0) {
                rectangle.width -= -rectangle.x;
                rectangle.x = 0;
            }
            if (rectangle.y < 0) {
                rectangle.height -= -rectangle.y;
                rectangle.y = 0;
            }
            if (rectangle.x + rectangle.width > this.getWidth()) {
                rectangle.width = this.getWidth() - rectangle.x;
            }
            if (rectangle.y + rectangle.height <= this.getHeight()) continue;
            rectangle.height = this.getHeight() - rectangle.y;
        }
    }

    private void removeToSmallCrops() {
        ArrayList<Rectangle> cropsToTrash = new ArrayList<Rectangle>();
        for (Rectangle rectangle : this.crops) {
            if (!(rectangle.getWidth() < 40.0) && !(rectangle.getHeight() < 40.0)) continue;
            cropsToTrash.add(rectangle);
        }
        this.crops.removeAll(cropsToTrash);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ActionState {
        NOTHING,
        DRAWING_NEW_CROP,
        RESIZING_HOTCORNER_UL,
        RESIZING_HOTCORNER_LR,
        MOVE_CROP;

    }

    private class MergedPanelKeyAdapter
    extends KeyAdapter {
        private MergedPanelKeyAdapter() {
        }

        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 67: {
                    if (e.getModifiers() != 2) break;
                    MergedPanel.this.copyToClipBoard();
                    break;
                }
                case 86: {
                    if (e.getModifiers() != 2) break;
                    MergedPanel.this.pasteFromClipBoard();
                    break;
                }
                case 127: {
                    MergedPanel.this.deleteAllSelected();
                    break;
                }
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    int x = 0;
                    int y = 0;
                    switch (e.getKeyCode()) {
                        case 37: {
                            x = -1;
                            break;
                        }
                        case 39: {
                            x = 1;
                            break;
                        }
                        case 38: {
                            y = -1;
                            break;
                        }
                        case 40: {
                            y = 1;
                        }
                    }
                    if ((e.getModifiers() & 1) != 0) {
                        x *= 10;
                        y *= 10;
                    }
                    if ((e.getModifiers() & 2) != 0) {
                        MergedPanel.this.briss.resizeSelRects(x, y);
                        break;
                    }
                    MergedPanel.this.briss.moveSelectedRects(x, y);
                }
            }
        }
    }

    private class MergedPanelMouseAdapter
    extends MouseAdapter
    implements ActionListener {
        private MergedPanelMouseAdapter() {
        }

        public void mouseMoved(MouseEvent e) {
            if (MergedPanel.this.contains(e.getPoint())) {
                MergedPanel.this.requestFocusInWindow();
            }
        }

        public void actionPerformed(ActionEvent e) {
            if ("Delete rectangle".equals(e.getActionCommand())) {
                for (Rectangle crop : MergedPanel.this.crops) {
                    if (!crop.contains(popUpMenuPoint)) continue;
                    MergedPanel.this.crops.remove(crop);
                    break;
                }
                MergedPanel.this.cluster.clearRatios();
                MergedPanel.this.repaint();
            } else if ("Select/Deselect rectangle".equals(e.getActionCommand())) {
                MergedPanel.this.changeSelectRectangle(popUpMenuPoint);
            } else if ("Copy Selected rectangles".equals(e.getActionCommand())) {
                MergedPanel.this.copyToClipBoard();
            } else if ("Paste rectangles".equals(e.getActionCommand())) {
                MergedPanel.this.pasteFromClipBoard();
            } else if ("Align selected rectangles".equals(e.getActionCommand())) {
                MergedPanel.this.alignSelected(popUpMenuPoint);
            }
        }

        public void mouseDragged(MouseEvent mE) {
            Point curPoint = mE.getPoint();
            switch (actionState) {
                case DRAWING_NEW_CROP: {
                    if (cropStartPoint == null) {
                        cropStartPoint = curPoint;
                    }
                    curCrop.x = curPoint.x < cropStartPoint.x ? curPoint.x : cropStartPoint.x;
                    curCrop.width = Math.abs(curPoint.x - cropStartPoint.x);
                    curCrop.y = curPoint.y < cropStartPoint.y ? curPoint.y : cropStartPoint.y;
                    curCrop.height = Math.abs(curPoint.y - cropStartPoint.y);
                    break;
                }
                case MOVE_CROP: {
                    if (lastDragPoint == null) {
                        lastDragPoint = curPoint;
                    }
                    if (mE.isShiftDown()) {
                        MergedPanel.this.briss.moveSelectedRects(curPoint.x - lastDragPoint.x, curPoint.y - lastDragPoint.y);
                    } else {
                        curCrop.translate(curPoint.x - lastDragPoint.x, curPoint.y - lastDragPoint.y);
                    }
                    lastDragPoint = curPoint;
                    break;
                }
                case RESIZING_HOTCORNER_LR: {
                    if (lastDragPoint == null) {
                        lastDragPoint = curPoint;
                    }
                    if (mE.isShiftDown()) {
                        MergedPanel.this.briss.resizeSelRects(curPoint.x - lastDragPoint.x, curPoint.y - lastDragPoint.y);
                    } else {
                        curPoint.translate(relativeHotCornerGrabDistance.x, relativeHotCornerGrabDistance.y);
                        curCrop.setNewHotCornerLR(curPoint);
                    }
                    lastDragPoint = curPoint;
                    break;
                }
                case RESIZING_HOTCORNER_UL: {
                    if (lastDragPoint == null) {
                        lastDragPoint = curPoint;
                    }
                    if (mE.isShiftDown()) {
                        MergedPanel.this.briss.resizeSelRects(lastDragPoint.x - curPoint.x, lastDragPoint.y - curPoint.y);
                        MergedPanel.this.briss.moveSelectedRects(curPoint.x - lastDragPoint.x, curPoint.y - lastDragPoint.y);
                    } else {
                        curPoint.translate(relativeHotCornerGrabDistance.x, relativeHotCornerGrabDistance.y);
                        curCrop.setNewHotCornerUL(curPoint);
                    }
                    lastDragPoint = curPoint;
                }
            }
            MergedPanel.this.repaint();
        }

        public void mousePressed(MouseEvent mE) {
            Point p = mE.getPoint();
            if (mE.isPopupTrigger()) {
                this.showPopUpMenu(mE);
            }
            if (mE.isControlDown()) {
                MergedPanel.this.changeSelectRectangle(p);
                return;
            }
            if (SwingUtilities.isLeftMouseButton(mE)) {
                for (DrawableCropRect crop : MergedPanel.this.crops) {
                    if (!crop.containsInHotCornerUL(p)) continue;
                    MergedPanel.actionState = ActionState.RESIZING_HOTCORNER_UL;
                    relativeHotCornerGrabDistance = new Point(crop.x - p.x, crop.y - p.y);
                    curCrop = crop;
                    return;
                }
                for (DrawableCropRect crop : MergedPanel.this.crops) {
                    if (!crop.containsInHotCornerLR(p)) continue;
                    MergedPanel.actionState = ActionState.RESIZING_HOTCORNER_LR;
                    relativeHotCornerGrabDistance = new Point(crop.x + crop.width - p.x, crop.y + crop.height - p.y);
                    curCrop = crop;
                    return;
                }
                for (DrawableCropRect crop : MergedPanel.this.crops) {
                    if (!crop.contains(p)) continue;
                    MergedPanel.actionState = ActionState.MOVE_CROP;
                    curCrop = crop;
                    return;
                }
                MergedPanel.actionState = ActionState.DRAWING_NEW_CROP;
                if (curCrop == null) {
                    curCrop = new DrawableCropRect();
                    MergedPanel.this.crops.add(curCrop);
                    cropStartPoint = p;
                }
            }
        }

        public void mouseReleased(MouseEvent mE) {
            if (mE.isPopupTrigger()) {
                this.showPopUpMenu(mE);
            }
            MergedPanel.this.clipCropsToVisibleArea();
            MergedPanel.this.removeToSmallCrops();
            MergedPanel.this.updateClusterRatios(MergedPanel.this.crops);
            MergedPanel.actionState = ActionState.NOTHING;
            cropStartPoint = null;
            lastDragPoint = null;
            curCrop = null;
            MergedPanel.this.repaint();
        }

        private void showPopUpMenu(MouseEvent e) {
            popUpMenuPoint = e.getPoint();
            new PopUpMenuForCropRectangles().show(e.getComponent(), e.getX(), e.getY());
        }

        private class PopUpMenuForCropRectangles
        extends JPopupMenu {
            public static final String DELETE = "Delete rectangle";
            public static final String SELECT_DESELECT = "Select/Deselect rectangle";
            public static final String COPY = "Copy Selected rectangles";
            public static final String PASTE = "Paste rectangles";
            public static final String ALIGN_SELECTED = "Align selected rectangles";

            public PopUpMenuForCropRectangles() {
                boolean isContainedInRectangle = false;
                for (DrawableCropRect crop : MergedPanel.this.crops) {
                    if (!crop.contains(popUpMenuPoint)) continue;
                    isContainedInRectangle = true;
                }
                if (isContainedInRectangle) {
                    JMenuItem deleteItem = new JMenuItem(DELETE);
                    deleteItem.addActionListener(MergedPanelMouseAdapter.this);
                    this.add(deleteItem);
                    JMenuItem selectDeselectItem = new JMenuItem(SELECT_DESELECT);
                    selectDeselectItem.addActionListener(MergedPanelMouseAdapter.this);
                    this.add(selectDeselectItem);
                }
                boolean copyPossible = false;
                for (DrawableCropRect crop : MergedPanel.this.crops) {
                    if (!crop.isSelected()) continue;
                    copyPossible = true;
                }
                JMenuItem copyItem = new JMenuItem(COPY);
                copyItem.addActionListener(MergedPanelMouseAdapter.this);
                copyItem.setEnabled(copyPossible);
                this.add(copyItem);
                JMenuItem pasteItem = new JMenuItem(PASTE);
                pasteItem.addActionListener(MergedPanelMouseAdapter.this);
                pasteItem.setEnabled(ClipBoard.getInstance().getAmountOfCropsInClipBoard() > 0);
                this.add(pasteItem);
                JMenuItem alignItem = new JMenuItem(ALIGN_SELECTED);
                alignItem.addActionListener(MergedPanelMouseAdapter.this);
                alignItem.setEnabled(true);
                this.add(alignItem);
            }
        }
    }
}

