/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss;

import at.laborg.briss.BrissGUI;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.TransferHandler;
import org.jpedal.exception.PdfException;

final class BrissTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;
    private final BrissGUI brissGUI;

    BrissTransferHandler(BrissGUI brissGUI) {
        this.brissGUI = brissGUI;
    }

    public boolean canImport(TransferHandler.TransferSupport support) {
        return support.isDataFlavorSupported(DataFlavor.stringFlavor);
    }

    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        Transferable t = support.getTransferable();
        try {
            String[] filenames;
            String dropInput = (String)t.getTransferData(DataFlavor.stringFlavor);
            String[] stringArray = filenames = dropInput.split("\n");
            int n = filenames.length;
            int n2 = 0;
            while (n2 < n) {
                String filename = stringArray[n2];
                filename = filename.replaceAll("\\n", "");
                filename = filename.replaceAll("\\t", "");
                if ((filename = filename.replaceAll("\\r", "")).trim().endsWith(".pdf")) {
                    File loadFile = null;
                    try {
                        URI uri = new URI(filename);
                        loadFile = new File(uri);
                    }
                    catch (URISyntaxException e1) {
                        e1.printStackTrace();
                    }
                    try {
                        this.brissGUI.importNewPdfFile(loadFile);
                    }
                    catch (PdfException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                ++n2;
            }
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }
}

