﻿// --------------------------------------------------------------------------------------------------------------------
// <copyright file="HBFunctions.cs" company="HandBrake Project (http://handbrake.fr)">
//   This file is part of the HandBrake source code - It may be used under the terms of the GNU General Public License.
// </copyright>
// <summary>
//   Defines the HBFunctions type.
// </summary>
// <auto-generated> Disable Stylecop Warnings for this file  </auto-generated>
// --------------------------------------------------------------------------------------------------------------------

namespace HandBrake.Interop.HbLib
{
	using System;
	using System.Runtime.InteropServices;

	public static class HBFunctions
	{
		[DllImport("hb.dll", EntryPoint = "hb_register_logger", CallingConvention = CallingConvention.Cdecl)]
		public static extern void hb_register_logger(LoggingCallback callback);

		[DllImport("hb.dll", EntryPoint = "hb_register_error_handler", CallingConvention = CallingConvention.Cdecl)]
		public static extern void hb_register_error_handler(LoggingCallback callback);

		/// Return Type: hb_handle_t*
		///verbose: int
		///update_check: int
		[DllImport("hb.dll", EntryPoint = "hb_init", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr hb_init(int verbose, int update_check);


		/// Return Type: hb_handle_t*
		///verbose: int
		///update_check: int
		[DllImport("hb.dll", EntryPoint = "hb_init_dl", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr hb_init_dl(int verbose, int update_check);


		/// Return Type: char*
		///param0: hb_handle_t*
		[DllImport("hb.dll", EntryPoint = "hb_get_version", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr hb_get_version(ref hb_handle_s param0);


		/// Return Type: int
		///param0: hb_handle_t*
		[DllImport("hb.dll", EntryPoint = "hb_get_build", CallingConvention = CallingConvention.Cdecl)]
		public static extern int hb_get_build(ref hb_handle_s param0);


		/// Return Type: int
		///h: hb_handle_t*
		///version: char**
		[DllImport("hb.dll", EntryPoint = "hb_check_update", CallingConvention = CallingConvention.Cdecl)]
		public static extern int hb_check_update(ref hb_handle_s h, ref IntPtr version);


		/// Return Type: char*
		///path: char*
		[DllImport("hb.dll", EntryPoint = "hb_dvd_name", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr hb_dvd_name(IntPtr path);


		/// Return Type: void
		///enable: int
		[DllImport("hb.dll", EntryPoint = "hb_dvd_set_dvdnav", CallingConvention = CallingConvention.Cdecl)]
		public static extern void hb_dvd_set_dvdnav(int enable);


		/// Return Type: void
		///param0: hb_handle_t*
		///path: char*
		///title_index: int
		///preview_count: int
		///store_previews: int
		[DllImport("hb.dll", EntryPoint = "hb_scan", CallingConvention = CallingConvention.Cdecl)]
		public static extern void hb_scan(IntPtr hbHandle, [In] [MarshalAs(UnmanagedType.LPStr)] string path, int title_index, int preview_count, int store_previews, ulong min_duration);

		[DllImport("hb.dll", EntryPoint = "hb_scan_stop", CallingConvention = CallingConvention.Cdecl)]
		public static extern void hb_scan_stop(IntPtr hbHandle);

		/// Return Type: hb_list_t*
		///param0: hb_handle_t*
		[DllImport("hb.dll", EntryPoint = "hb_get_titles", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr hb_get_titles(IntPtr hbHandle);


		/// Return Type: int
		///buf: hb_buffer_t*
		///width: int
		///height: int
		///color_equal: int
		///color_diff: int
		///threshold: int
		///prog_equal: int
		///prog_diff: int
		///prog_threshold: int
		[DllImport("hb.dll", EntryPoint = "hb_detect_comb", CallingConvention = CallingConvention.Cdecl)]
		public static extern int hb_detect_comb(ref hb_buffer_s buf, int width, int height, int color_equal, int color_diff, int threshold, int prog_equal, int prog_diff, int prog_threshold);

		/// Return Type: void
		///param0: hb_handle_t*
		///param1: hb_title_t*
		///param2: int
		///param3: uint8_t*
		[DllImport("hb.dll", EntryPoint = "hb_get_preview", CallingConvention = CallingConvention.Cdecl)]
		public static extern void hb_get_preview(IntPtr hbHandle, ref hb_job_s title, int preview, IntPtr buffer);


		/// Return Type: void
		///param0: hb_job_t*
		///ratio: double
		///pixels: int
		[DllImport("hb.dll", EntryPoint = "hb_set_size", CallingConvention = CallingConvention.Cdecl)]
		public static extern void hb_set_size(ref hb_job_s param0, double ratio, int pixels);

		/// Return Type: void
		///param0: hb_job_t*
		///output_width: int*
		///output_height: int*
		///output_par_width: int*
		///output_par_height: int*
		[DllImport("hb.dll", EntryPoint = "hb_set_anamorphic_size", CallingConvention = CallingConvention.Cdecl)]
		public static extern void hb_set_anamorphic_size(ref hb_job_s job, ref int output_width, ref int output_height, ref int output_par_width, ref int output_par_height);


		/// Return Type: int
		///param0: hb_handle_t*
		[DllImport("hb.dll", EntryPoint = "hb_count", CallingConvention = CallingConvention.Cdecl)]
		public static extern int hb_count(IntPtr hbHandle);


		/// Return Type: hb_job_t*
		///param0: hb_handle_t*
		///param1: int
		[DllImport("hb.dll", EntryPoint = "hb_job", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr hb_job(IntPtr hbHandle, int jobIndex);

		[DllImport("hb.dll", EntryPoint = "hb_set_job", CallingConvention = CallingConvention.Cdecl)]
		public static extern void hb_set_job(IntPtr hbHandle, int title_index, ref hb_job_s job);

		/// Return Type: void
		///param0: hb_handle_t*
		///param1: hb_job_t*
		[DllImport("hb.dll", EntryPoint = "hb_add", CallingConvention = CallingConvention.Cdecl)]
		public static extern void hb_add(IntPtr hbHandle, ref hb_job_s job);


		/// Return Type: void
		///param0: hb_handle_t*
		///param1: hb_job_t*
		[DllImport("hb.dll", EntryPoint = "hb_rem", CallingConvention = CallingConvention.Cdecl)]
		public static extern void hb_rem(IntPtr hbHandle, IntPtr job);


		/// Return Type: void
		///param0: hb_handle_t*
		[DllImport("hb.dll", EntryPoint = "hb_start", CallingConvention = CallingConvention.Cdecl)]
		public static extern void hb_start(IntPtr hbHandle);


		/// Return Type: void
		///param0: hb_handle_t*
		[DllImport("hb.dll", EntryPoint = "hb_pause", CallingConvention = CallingConvention.Cdecl)]
		public static extern void hb_pause(IntPtr hbHandle);


		/// Return Type: void
		///param0: hb_handle_t*
		[DllImport("hb.dll", EntryPoint = "hb_resume", CallingConvention = CallingConvention.Cdecl)]
		public static extern void hb_resume(IntPtr hbHandle);


		/// Return Type: void
		///param0: hb_handle_t*
		[DllImport("hb.dll", EntryPoint = "hb_stop", CallingConvention = CallingConvention.Cdecl)]
		public static extern void hb_stop(IntPtr hbHandle);

		/// Return Type: void
		///param0: hb_handle_t*
		///param1: hb_state_t*
		[DllImport("hb.dll", EntryPoint = "hb_get_state", CallingConvention = CallingConvention.Cdecl)]
		public static extern void hb_get_state(IntPtr hbHandle, ref hb_state_s state);


		/// Return Type: void
		///param0: hb_handle_t*
		///param1: hb_state_t*
		[DllImport("hb.dll", EntryPoint = "hb_get_state2", CallingConvention = CallingConvention.Cdecl)]
		public static extern void hb_get_state2(ref hb_handle_s param0, ref hb_state_s param1);


		/// Return Type: int
		///param0: hb_handle_t*
		[DllImport("hb.dll", EntryPoint = "hb_get_scancount", CallingConvention = CallingConvention.Cdecl)]
		public static extern int hb_get_scancount(ref hb_handle_s param0);


		/// Return Type: void
		///param0: hb_handle_t**
		[DllImport("hb.dll", EntryPoint = "hb_close", CallingConvention = CallingConvention.Cdecl)]
		public static extern void hb_close(IntPtr hbHandle);

		[DllImport("hb.dll", EntryPoint = "hb_global_close", CallingConvention = CallingConvention.Cdecl)]
		public static extern void hb_global_close();

		[DllImport("hb.dll", EntryPoint = "hb_subtitle_add", CallingConvention = CallingConvention.Cdecl)]
		public static extern int hb_subtitle_add(ref hb_job_s job, ref hb_subtitle_config_s subtitleConfig, int track);

		[DllImport("hb.dll", EntryPoint = "hb_srt_add", CallingConvention = CallingConvention.Cdecl)]
		public static extern int hb_srt_add(ref hb_job_s job, ref hb_subtitle_config_s subtitleConfig, string lang);


		[DllImport("hb.dll", EntryPoint = "hb_mixdown_is_supported", CallingConvention = CallingConvention.Cdecl)]
		public static extern int hb_mixdown_is_supported(int mixdown, uint codec, ulong layout);

		[DllImport("hb.dll", EntryPoint = "hb_mixdown_has_remix_support", CallingConvention = CallingConvention.Cdecl)]
		public static extern int hb_mixdown_has_remix_support(int mixdown, ulong layout);

		[DllImport("hb.dll", EntryPoint = "hb_mixdown_has_codec_support", CallingConvention = CallingConvention.Cdecl)]
		public static extern int hb_mixdown_has_codec_support(int mixdown, uint codec);

		[DllImport("hb.dll", EntryPoint = "hb_get_default_mixdown", CallingConvention = CallingConvention.Cdecl)]
		public static extern int hb_get_default_mixdown(uint codec, ulong layout);

		[DllImport("hb.dll", EntryPoint = "hb_get_best_mixdown", CallingConvention = CallingConvention.Cdecl)]
		public static extern int hb_get_best_mixdown(uint codec, ulong layout, int mixdown);

		[DllImport("hb.dll", EntryPoint = "hb_get_best_audio_bitrate", CallingConvention = CallingConvention.Cdecl)]
		public static extern int hb_get_best_audio_bitrate(uint codec, int bitrate, int samplerate, int mixdown);

		[DllImport("hb.dll", EntryPoint = "hb_get_default_audio_bitrate", CallingConvention = CallingConvention.Cdecl)]
		public static extern int hb_get_default_audio_bitrate(uint codec, int samplerate, int mixdown);

		[DllImport("hb.dll", EntryPoint = "hb_get_audio_bitrate_limits", CallingConvention = CallingConvention.Cdecl)]
		public static extern int hb_get_audio_bitrate_limits(uint codec, int samplerate, int mixdown, ref int low, ref int high);

		[DllImport("hb.dll", EntryPoint = "hb_get_audio_quality_limits", CallingConvention = CallingConvention.Cdecl)]
		public static extern void hb_get_audio_quality_limits(uint codec, ref float low, ref float high, ref float granularity, ref int direction);

		[DllImport("hb.dll", EntryPoint = "hb_get_default_audio_quality", CallingConvention = CallingConvention.Cdecl)]
		public static extern float hb_get_default_audio_quality(uint codec);

		[DllImport("hb.dll", EntryPoint = "hb_get_audio_compression_limits", CallingConvention = CallingConvention.Cdecl)]
		public static extern void hb_get_audio_compression_limits(uint codec, ref float low, ref float high, ref float granularity, ref int direction);

		[DllImport("hb.dll", EntryPoint = "hb_get_default_audio_compression", CallingConvention = CallingConvention.Cdecl)]
		public static extern float hb_get_default_audio_compression(uint codec);


		[DllImport("hb.dll", EntryPoint = "hb_get_video_rates", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr hb_get_video_rates();

		[DllImport("hb.dll", EntryPoint = "hb_get_video_rates_count", CallingConvention = CallingConvention.Cdecl)]
		public static extern int hb_get_video_rates_count();

		[DllImport("hb.dll", EntryPoint = "hb_get_audio_rates", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr hb_get_audio_rates();

		[DllImport("hb.dll", EntryPoint = "hb_get_audio_rates_count", CallingConvention = CallingConvention.Cdecl)]
		public static extern int hb_get_audio_rates_count();

		[DllImport("hb.dll", EntryPoint = "hb_get_audio_rates_default", CallingConvention = CallingConvention.Cdecl)]
		public static extern int hb_get_audio_rates_default();

		[DllImport("hb.dll", EntryPoint = "hb_get_audio_bitrates", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr hb_get_audio_bitrates();

		[DllImport("hb.dll", EntryPoint = "hb_get_audio_bitrates_count", CallingConvention = CallingConvention.Cdecl)]
		public static extern int hb_get_audio_bitrates_count();

		[DllImport("hb.dll", EntryPoint = "hb_get_audio_mixdowns", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr hb_get_audio_mixdowns();

		[DllImport("hb.dll", EntryPoint = "hb_get_audio_mixdowns_count", CallingConvention = CallingConvention.Cdecl)]
		public static extern int hb_get_audio_mixdowns_count();

		[DllImport("hb.dll", EntryPoint = "hb_get_video_encoders", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr hb_get_video_encoders();

		[DllImport("hb.dll", EntryPoint = "hb_get_video_encoders_count", CallingConvention = CallingConvention.Cdecl)]
		public static extern int hb_get_video_encoders_count();

		[DllImport("hb.dll", EntryPoint = "hb_get_audio_encoders", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr hb_get_audio_encoders();

		[DllImport("hb.dll", EntryPoint = "hb_get_audio_encoders_count", CallingConvention = CallingConvention.Cdecl)]
		public static extern int hb_get_audio_encoders_count();


		/// void hb_autopassthru_apply_settings( hb_job_t * job )
		[DllImport("hb.dll", EntryPoint = "hb_autopassthru_apply_settings", CallingConvention = CallingConvention.Cdecl)]
		public static extern void hb_autopassthru_apply_settings(ref hb_job_s job);

		///hb_title_set_t  * hb_get_title_set( hb_handle_t * );
		[DllImport("hb.dll", EntryPoint = "hb_get_title_set", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr hb_get_title_set(IntPtr hbHandle);

		///hb_job_t * hb_job_init_by_index( hb_handle_t *h, int title_index );
		[DllImport("hb.dll", EntryPoint = "hb_job_init_by_index", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr hb_job_init_by_index(IntPtr hbHandle, int title_index);

		///hb_job_t * hb_job_init( hb_title_t * title );
		[DllImport("hb.dll", EntryPoint = "hb_job_init", CallingConvention = CallingConvention.Cdecl)]
		public static extern hb_job_s hb_job_init(ref hb_title_s title);

		///void hb_job_reset( hb_job_t * job );
		[DllImport("hb.dll", EntryPoint = "hb_job_reset", CallingConvention = CallingConvention.Cdecl)]
		public static extern void hb_job_reset(ref hb_job_s job);

		///void hb_job_close( hb_job_t ** job );
		[DllImport("hb.dll", EntryPoint = "hb_job_close", CallingConvention = CallingConvention.Cdecl)]
		public static extern void hb_job_close(IntPtr job);

		///void hb_job_set_advanced_opts( hb_job_t *job, const char *advanced_opts );
		[DllImport("hb.dll", EntryPoint = "hb_job_set_advanced_opts", CallingConvention = CallingConvention.Cdecl)]
		public static extern void hb_job_set_advanced_opts(ref hb_job_s job, IntPtr advanced_opts);

		///void hb_job_set_file( hb_job_t *job, const char *file );
		[DllImport("hb.dll", EntryPoint = "hb_job_set_file", CallingConvention = CallingConvention.Cdecl)]
		public static extern void hb_job_set_file(ref hb_job_s job, IntPtr file);

		///void hb_chapter_set_title(hb_chapter_t *chapter, const char *title);
		[DllImport("hb.dll", EntryPoint = "hb_chapter_set_title", CallingConvention = CallingConvention.Cdecl)]
		public static extern void hb_chapter_set_title(IntPtr chapter, [In] [MarshalAs(UnmanagedType.LPStr)] string title);

		/// void hb_add_filter( hb_job_t * job, hb_filter_object_t * filter, const char * settings ); 
		[DllImport("hb.dll", EntryPoint = "hb_add_filter", CallingConvention = CallingConvention.Cdecl)]
		public static extern void hb_add_filter(ref hb_job_s job, ref hb_filter_object_s filter, IntPtr settings);

		/// hb_filter_object_t * hb_filter_init( int filter_id );
		[DllImport("hb.dll", EntryPoint = "hb_filter_init", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr hb_filter_init(int filter_id);

		[DllImport("hb.dll", EntryPoint = "hb_x264_encopt_name", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr hb_x264_encopt_name(IntPtr name);

		[DllImport("hb.dll", EntryPoint = "hb_check_h264_level", CallingConvention = CallingConvention.Cdecl)]
		public static extern int hb_check_h264_level([In] [MarshalAs(UnmanagedType.LPStr)] string level, int width, int height, int fps_num, int fps_den, int interlaced, int fake_interlaced);

		[DllImport("hb.dll", EntryPoint = "hb_x264_param_unparse", CallingConvention = CallingConvention.Cdecl)]
        public static extern IntPtr hb_x264_param_unparse(
			[In] [MarshalAs(UnmanagedType.LPStr)] string x264_preset,
			[In] [MarshalAs(UnmanagedType.LPStr)] string x264_tune,
			[In] [MarshalAs(UnmanagedType.LPStr)] string x264_encopts,
			[In] [MarshalAs(UnmanagedType.LPStr)] string x264_profile,
			[In] [MarshalAs(UnmanagedType.LPStr)] string h264_level,
			int width,
			int height);
	}
}
