/* condition.c generated by valac 0.22.1, the Vala compiler
 * generated from condition.vala, do not modify */

/*      condition.vala*/
/*      */
/*      Copyright 2011 Hong Jen Yee (PCMan) <pcman.tw@pcman.tw@gmail.com>*/
/*      */
/*      This program is free software; you can redistribute it and/or modify*/
/*      it under the terms of the GNU General Public License as published by*/
/*      the Free Software Foundation; either version 2 of the License, or*/
/*      (at your option) any later version.*/
/*      */
/*      This program is distributed in the hope that it will be useful,*/
/*      but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*      GNU General Public License for more details.*/
/*      */
/*      You should have received a copy of the GNU General Public License*/
/*      along with this program; if not, write to the Free Software*/
/*      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,*/
/*      MA 02110-1301, USA.*/
/*      */
/*      */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <fm-file-info.h>
#include <glib/gstdio.h>
#include <gio/gio.h>
#include <fm-mime-type.h>
#include <fm-path.h>


#define FM_TYPE_FILE_ACTION_CAPABILITY (fm_file_action_capability_get_type ())
typedef struct _FmFileActionCondition FmFileActionCondition;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_pattern_spec_free0(var) ((var == NULL) ? NULL : (var = (g_pattern_spec_free (var), NULL)))

typedef enum  {
	FM_FILE_ACTION_CAPABILITY_OWNER = 0,
	FM_FILE_ACTION_CAPABILITY_READABLE = 1 << 1,
	FM_FILE_ACTION_CAPABILITY_WRITABLE = 1 << 2,
	FM_FILE_ACTION_CAPABILITY_EXECUTABLE = 1 << 3,
	FM_FILE_ACTION_CAPABILITY_LOCAL = 1 << 4
} FmFileActionCapability;

struct _FmFileActionCondition {
	gchar** only_show_in;
	gint only_show_in_length1;
	gchar** not_show_in;
	gint not_show_in_length1;
	gchar* try_exec;
	gchar* show_if_registered;
	gchar* show_if_true;
	gchar* show_if_running;
	gchar** mime_types;
	gint mime_types_length1;
	gchar** base_names;
	gint base_names_length1;
	gboolean match_case;
	gchar selection_count_cmp;
	gint selection_count;
	gchar** schemes;
	gint schemes_length1;
	gchar** folders;
	gint folders_length1;
	FmFileActionCapability capabilities;
};



GType fm_file_action_capability_get_type (void) G_GNUC_CONST;
void fm_file_action_condition_free (FmFileActionCondition* self);
static void fm_file_action_condition_instance_init (FmFileActionCondition * self);
FmFileActionCondition* fm_file_action_condition_new (GKeyFile* kf, const gchar* group);
FmFileActionCondition* fm_file_action_condition_new (GKeyFile* kf, const gchar* group);
gchar** utils_key_file_get_string_list (GKeyFile* kf, const gchar* group, const gchar* key, gchar** def_val, int def_val_length1, int* result_length1);
gchar* utils_key_file_get_string (GKeyFile* kf, const gchar* group, const gchar* key, const gchar* def_val);
gboolean utils_key_file_get_bool (GKeyFile* kf, const gchar* group, const gchar* key, gboolean def_val);
static inline gboolean fm_file_action_condition_match_try_exec (FmFileActionCondition* self, GList* files);
gchar* fm_file_action_parameters_expand (const gchar* templ, GList* files, gboolean for_display, FmFileInfo* first_file);
static inline gboolean fm_file_action_condition_match_show_if_registered (FmFileActionCondition* self, GList* files);
static inline gboolean fm_file_action_condition_match_show_if_true (FmFileActionCondition* self, GList* files);
static inline gboolean fm_file_action_condition_match_show_if_running (FmFileActionCondition* self, GList* files);
static inline gboolean fm_file_action_condition_match_mime_type (FmFileActionCondition* self, GList* files, const gchar* type, gboolean negated);
static inline gboolean fm_file_action_condition_match_mime_types (FmFileActionCondition* self, GList* files);
static inline gboolean fm_file_action_condition_match_base_name (FmFileActionCondition* self, GList* files, const gchar* base_name, gboolean negated);
static inline gboolean fm_file_action_condition_match_base_names (FmFileActionCondition* self, GList* files);
static gboolean fm_file_action_condition_match_scheme (GList* files, const gchar* scheme, gboolean negated);
static inline gboolean fm_file_action_condition_match_schemes (FmFileActionCondition* self, GList* files);
static gboolean fm_file_action_condition_match_folder (GList* files, const gchar* folder, gboolean negated);
static inline gboolean fm_file_action_condition_match_folders (FmFileActionCondition* self, GList* files);
static inline gboolean fm_file_action_condition_match_selection_count (FmFileActionCondition* self, GList* files);
static inline gboolean fm_file_action_condition_match_capabilities (FmFileActionCondition* self, GList* files);
gboolean fm_file_action_condition_match (FmFileActionCondition* self, GList* files);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType fm_file_action_capability_get_type (void) {
	static volatile gsize fm_file_action_capability_type_id__volatile = 0;
	if (g_once_init_enter (&fm_file_action_capability_type_id__volatile)) {
		static const GEnumValue values[] = {{FM_FILE_ACTION_CAPABILITY_OWNER, "FM_FILE_ACTION_CAPABILITY_OWNER", "owner"}, {FM_FILE_ACTION_CAPABILITY_READABLE, "FM_FILE_ACTION_CAPABILITY_READABLE", "readable"}, {FM_FILE_ACTION_CAPABILITY_WRITABLE, "FM_FILE_ACTION_CAPABILITY_WRITABLE", "writable"}, {FM_FILE_ACTION_CAPABILITY_EXECUTABLE, "FM_FILE_ACTION_CAPABILITY_EXECUTABLE", "executable"}, {FM_FILE_ACTION_CAPABILITY_LOCAL, "FM_FILE_ACTION_CAPABILITY_LOCAL", "local"}, {0, NULL, NULL}};
		GType fm_file_action_capability_type_id;
		fm_file_action_capability_type_id = g_enum_register_static ("FmFileActionCapability", values);
		g_once_init_leave (&fm_file_action_capability_type_id__volatile, fm_file_action_capability_type_id);
	}
	return fm_file_action_capability_type_id__volatile;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


FmFileActionCondition* fm_file_action_condition_new (GKeyFile* kf, const gchar* group) {
	FmFileActionCondition* self;
	GKeyFile* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar** _tmp3_ = NULL;
	GKeyFile* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gchar** _tmp7_ = NULL;
	GKeyFile* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GKeyFile* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	GKeyFile* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	GKeyFile* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	GKeyFile* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gchar** _tmp23_ = NULL;
	GKeyFile* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	gchar** _tmp27_ = NULL;
	GKeyFile* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	gboolean _tmp30_ = FALSE;
	gchar* selection_count_str = NULL;
	GKeyFile* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	GKeyFile* _tmp40_ = NULL;
	const gchar* _tmp41_ = NULL;
	gint _tmp42_ = 0;
	gchar** _tmp43_ = NULL;
	GKeyFile* _tmp44_ = NULL;
	const gchar* _tmp45_ = NULL;
	gint _tmp46_ = 0;
	gchar** _tmp47_ = NULL;
	gchar** caps = NULL;
	GKeyFile* _tmp48_ = NULL;
	const gchar* _tmp49_ = NULL;
	gint _tmp50_ = 0;
	gchar** _tmp51_ = NULL;
	gint caps_length1 = 0;
	gint _caps_size_ = 0;
	gchar** _tmp52_ = NULL;
	gint _tmp52__length1 = 0;
	g_return_val_if_fail (kf != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	self = g_slice_new0 (FmFileActionCondition);
	fm_file_action_condition_instance_init (self);
	_tmp0_ = kf;
	_tmp1_ = group;
	_tmp3_ = utils_key_file_get_string_list (_tmp0_, _tmp1_, "OnlyShowIn", NULL, 0, &_tmp2_);
	self->only_show_in = (_vala_array_free (self->only_show_in, self->only_show_in_length1, (GDestroyNotify) g_free), NULL);
	self->only_show_in = _tmp3_;
	self->only_show_in_length1 = _tmp2_;
	_tmp4_ = kf;
	_tmp5_ = group;
	_tmp7_ = utils_key_file_get_string_list (_tmp4_, _tmp5_, "NotShowIn", NULL, 0, &_tmp6_);
	self->not_show_in = (_vala_array_free (self->not_show_in, self->not_show_in_length1, (GDestroyNotify) g_free), NULL);
	self->not_show_in = _tmp7_;
	self->not_show_in_length1 = _tmp6_;
	_tmp8_ = kf;
	_tmp9_ = group;
	_tmp10_ = utils_key_file_get_string (_tmp8_, _tmp9_, "TryExec", NULL);
	_g_free0 (self->try_exec);
	self->try_exec = _tmp10_;
	_tmp11_ = kf;
	_tmp12_ = group;
	_tmp13_ = utils_key_file_get_string (_tmp11_, _tmp12_, "ShowIfRegistered", NULL);
	_g_free0 (self->show_if_registered);
	self->show_if_registered = _tmp13_;
	_tmp14_ = kf;
	_tmp15_ = group;
	_tmp16_ = utils_key_file_get_string (_tmp14_, _tmp15_, "ShowIfTrue", NULL);
	_g_free0 (self->show_if_true);
	self->show_if_true = _tmp16_;
	_tmp17_ = kf;
	_tmp18_ = group;
	_tmp19_ = utils_key_file_get_string (_tmp17_, _tmp18_, "ShowIfRunning", NULL);
	_g_free0 (self->show_if_running);
	self->show_if_running = _tmp19_;
	_tmp20_ = kf;
	_tmp21_ = group;
	_tmp23_ = utils_key_file_get_string_list (_tmp20_, _tmp21_, "MimeTypes", NULL, 0, &_tmp22_);
	self->mime_types = (_vala_array_free (self->mime_types, self->mime_types_length1, (GDestroyNotify) g_free), NULL);
	self->mime_types = _tmp23_;
	self->mime_types_length1 = _tmp22_;
	_tmp24_ = kf;
	_tmp25_ = group;
	_tmp27_ = utils_key_file_get_string_list (_tmp24_, _tmp25_, "Basenames", NULL, 0, &_tmp26_);
	self->base_names = (_vala_array_free (self->base_names, self->base_names_length1, (GDestroyNotify) g_free), NULL);
	self->base_names = _tmp27_;
	self->base_names_length1 = _tmp26_;
	_tmp28_ = kf;
	_tmp29_ = group;
	_tmp30_ = utils_key_file_get_bool (_tmp28_, _tmp29_, "Matchcase", FALSE);
	self->match_case = _tmp30_;
	_tmp31_ = kf;
	_tmp32_ = group;
	_tmp33_ = utils_key_file_get_string (_tmp31_, _tmp32_, "SelectionCount", NULL);
	selection_count_str = _tmp33_;
	_tmp34_ = selection_count_str;
	if (_tmp34_ != NULL) {
		const gchar* _tmp35_ = NULL;
		gchar _tmp36_ = '\0';
		_tmp35_ = selection_count_str;
		_tmp36_ = string_get (_tmp35_, (glong) 0);
		switch (_tmp36_) {
			case '<':
			case '>':
			case '=':
			{
				const gchar* _tmp37_ = NULL;
				gchar _tmp38_ = '\0';
				gchar tmp = '\0';
				static const char s[] = "%c%d";
				const gchar* _tmp39_ = NULL;
				_tmp37_ = selection_count_str;
				_tmp38_ = string_get (_tmp37_, (glong) 0);
				self->selection_count_cmp = _tmp38_;
				tmp = (gchar) 0;
				_tmp39_ = selection_count_str;
				sscanf (_tmp39_, s, &tmp, &self->selection_count);
				break;
			}
			default:
			{
				self->selection_count_cmp = '>';
				self->selection_count = 0;
				break;
			}
		}
	} else {
		self->selection_count_cmp = '>';
		self->selection_count = 0;
	}
	_tmp40_ = kf;
	_tmp41_ = group;
	_tmp43_ = utils_key_file_get_string_list (_tmp40_, _tmp41_, "Schemes", NULL, 0, &_tmp42_);
	self->schemes = (_vala_array_free (self->schemes, self->schemes_length1, (GDestroyNotify) g_free), NULL);
	self->schemes = _tmp43_;
	self->schemes_length1 = _tmp42_;
	_tmp44_ = kf;
	_tmp45_ = group;
	_tmp47_ = utils_key_file_get_string_list (_tmp44_, _tmp45_, "Folders", NULL, 0, &_tmp46_);
	self->folders = (_vala_array_free (self->folders, self->folders_length1, (GDestroyNotify) g_free), NULL);
	self->folders = _tmp47_;
	self->folders_length1 = _tmp46_;
	_tmp48_ = kf;
	_tmp49_ = group;
	_tmp51_ = utils_key_file_get_string_list (_tmp48_, _tmp49_, "Capabilities", NULL, 0, &_tmp50_);
	caps = _tmp51_;
	caps_length1 = _tmp50_;
	_caps_size_ = caps_length1;
	_tmp52_ = caps;
	_tmp52__length1 = caps_length1;
	{
		gchar** cap_collection = NULL;
		gint cap_collection_length1 = 0;
		gint _cap_collection_size_ = 0;
		gint cap_it = 0;
		cap_collection = _tmp52_;
		cap_collection_length1 = _tmp52__length1;
		for (cap_it = 0; cap_it < _tmp52__length1; cap_it = cap_it + 1) {
			const gchar* cap = NULL;
			cap = cap_collection[cap_it];
			{
				FILE* _tmp53_ = NULL;
				const gchar* _tmp54_ = NULL;
				_tmp53_ = stdin;
				_tmp54_ = cap;
				fprintf (_tmp53_, "%s\n", _tmp54_);
			}
		}
	}
	caps = (_vala_array_free (caps, caps_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (selection_count_str);
	return self;
}


static inline gboolean fm_file_action_condition_match_try_exec (FmFileActionCondition* self, GList* files) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->try_exec;
	if (_tmp0_ != NULL) {
		gchar* exec_path = NULL;
		const gchar* _tmp1_ = NULL;
		GList* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp1_ = self->try_exec;
		_tmp2_ = files;
		_tmp3_ = fm_file_action_parameters_expand (_tmp1_, _tmp2_, FALSE, NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_find_program_in_path (_tmp4_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		exec_path = _tmp6_;
		_tmp7_ = exec_path;
		_tmp8_ = g_file_test (_tmp7_, G_FILE_TEST_IS_EXECUTABLE);
		if (!_tmp8_) {
			result = FALSE;
			_g_free0 (exec_path);
			return result;
		}
		_g_free0 (exec_path);
	}
	result = TRUE;
	return result;
}


static inline gboolean fm_file_action_condition_match_show_if_registered (FmFileActionCondition* self, GList* files) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->show_if_registered;
	if (_tmp0_ != NULL) {
		gchar* service = NULL;
		const gchar* _tmp1_ = NULL;
		GList* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp1_ = self->show_if_registered;
		_tmp2_ = files;
		_tmp3_ = fm_file_action_parameters_expand (_tmp1_, _tmp2_, FALSE, NULL);
		service = _tmp3_;
		{
			GDBusConnection* con = NULL;
			GDBusConnection* _tmp4_ = NULL;
			GVariant* _result_ = NULL;
			GDBusConnection* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			GVariant* _tmp7_ = NULL;
			GVariant* _tmp8_ = NULL;
			GVariantType* _tmp9_ = NULL;
			GVariantType* _tmp10_ = NULL;
			GVariant* _tmp11_ = NULL;
			GVariant* _tmp12_ = NULL;
			gboolean name_has_owner = FALSE;
			GVariant* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			_tmp4_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
			con = _tmp4_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_IO_ERROR) {
					goto __catch3_g_io_error;
				}
				_g_free0 (service);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			_tmp5_ = con;
			_tmp6_ = service;
			_tmp7_ = g_variant_new ("(s)", _tmp6_, NULL);
			g_variant_ref_sink (_tmp7_);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_variant_type_new ("(b)");
			_tmp10_ = _tmp9_;
			_tmp11_ = g_dbus_connection_call_sync (_tmp5_, "org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "NameHasOwner", _tmp8_, _tmp10_, G_DBUS_CALL_FLAGS_NONE, -1, NULL, &_inner_error_);
			_tmp12_ = _tmp11_;
			_g_variant_type_free0 (_tmp10_);
			_g_variant_unref0 (_tmp8_);
			_result_ = _tmp12_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (con);
				if (_inner_error_->domain == G_IO_ERROR) {
					goto __catch3_g_io_error;
				}
				goto __finally3;
			}
			_tmp13_ = _result_;
			g_variant_get (_tmp13_, "(b)", &name_has_owner, NULL);
			_tmp14_ = name_has_owner;
			if (!_tmp14_) {
				result = FALSE;
				_g_variant_unref0 (_result_);
				_g_object_unref0 (con);
				_g_free0 (service);
				return result;
			}
			_g_variant_unref0 (_result_);
			_g_object_unref0 (con);
		}
		goto __finally3;
		__catch3_g_io_error:
		{
			GError* err = NULL;
			err = _inner_error_;
			_inner_error_ = NULL;
			result = FALSE;
			_g_error_free0 (err);
			_g_free0 (service);
			return result;
		}
		__finally3:
		if (_inner_error_ != NULL) {
			_g_free0 (service);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_g_free0 (service);
	}
	result = TRUE;
	return result;
}


static inline gboolean fm_file_action_condition_match_show_if_true (FmFileActionCondition* self, GList* files) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->show_if_true;
	if (_tmp0_ != NULL) {
		gchar* cmd = NULL;
		const gchar* _tmp1_ = NULL;
		GList* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gint exit_status = 0;
		const gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		_tmp1_ = self->show_if_true;
		_tmp2_ = files;
		_tmp3_ = fm_file_action_parameters_expand (_tmp1_, _tmp2_, FALSE, NULL);
		cmd = _tmp3_;
		_tmp4_ = cmd;
		_tmp5_ = system (_tmp4_);
		exit_status = _tmp5_;
		_tmp6_ = exit_status;
		if (_tmp6_ != 0) {
			result = FALSE;
			_g_free0 (cmd);
			return result;
		}
		_g_free0 (cmd);
	}
	result = TRUE;
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static inline gboolean fm_file_action_condition_match_show_if_running (FmFileActionCondition* self, GList* files) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->show_if_running;
	if (_tmp0_ != NULL) {
		gchar* process_name = NULL;
		const gchar* _tmp1_ = NULL;
		GList* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* pgrep = NULL;
		gchar* _tmp4_ = NULL;
		gboolean running = FALSE;
		const gchar* _tmp5_ = NULL;
		gboolean _tmp17_ = FALSE;
		_tmp1_ = self->show_if_running;
		_tmp2_ = files;
		_tmp3_ = fm_file_action_parameters_expand (_tmp1_, _tmp2_, FALSE, NULL);
		process_name = _tmp3_;
		_tmp4_ = g_find_program_in_path ("pgrep");
		pgrep = _tmp4_;
		running = FALSE;
		_tmp5_ = pgrep;
		if (_tmp5_ != NULL) {
			gint exit_status = 0;
			gboolean _tmp6_ = FALSE;
			const gchar* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp15_ = FALSE;
			_tmp7_ = pgrep;
			_tmp8_ = string_to_string (_tmp7_);
			_tmp9_ = process_name;
			_tmp10_ = string_to_string (_tmp9_);
			_tmp11_ = g_strconcat (_tmp8_, " -x '", _tmp10_, "'", NULL);
			_tmp12_ = _tmp11_;
			_tmp14_ = g_spawn_command_line_sync (_tmp12_, NULL, NULL, &_tmp13_, &_inner_error_);
			exit_status = _tmp13_;
			_tmp15_ = _tmp14_;
			_g_free0 (_tmp12_);
			_tmp6_ = _tmp15_;
			if (_inner_error_ != NULL) {
				_g_free0 (pgrep);
				_g_free0 (process_name);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			if (_tmp6_) {
				gint _tmp16_ = 0;
				_tmp16_ = exit_status;
				if (_tmp16_ == 0) {
					running = TRUE;
				}
			}
		}
		_tmp17_ = running;
		if (!_tmp17_) {
			result = FALSE;
			_g_free0 (pgrep);
			_g_free0 (process_name);
			return result;
		}
		_g_free0 (pgrep);
		_g_free0 (process_name);
	}
	result = TRUE;
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_ = 0L;
	gboolean _tmp17_ = FALSE;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static inline gboolean fm_file_action_condition_match_mime_type (FmFileActionCondition* self, GList* files, const gchar* type, gboolean negated) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp1_ = type;
	if (g_strcmp0 (_tmp1_, "all/all") == 0) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = type;
		_tmp0_ = g_strcmp0 (_tmp2_, "*") == 0;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		_tmp5_ = negated;
		if (_tmp5_) {
			_tmp4_ = FALSE;
		} else {
			_tmp4_ = TRUE;
		}
		_tmp6_ = _tmp4_;
		result = _tmp6_;
		return result;
	} else {
		const gchar* _tmp7_ = NULL;
		_tmp7_ = type;
		if (g_strcmp0 (_tmp7_, "all/allfiles") == 0) {
			gboolean _tmp8_ = FALSE;
			_tmp8_ = negated;
			if (_tmp8_) {
				GList* _tmp9_ = NULL;
				_tmp9_ = files;
				{
					GList* fi_collection = NULL;
					GList* fi_it = NULL;
					fi_collection = _tmp9_;
					for (fi_it = fi_collection; fi_it != NULL; fi_it = fi_it->next) {
						FmFileInfo* fi = NULL;
						fi = (FmFileInfo*) fi_it->data;
						{
							FmFileInfo* _tmp10_ = NULL;
							gboolean _tmp11_ = FALSE;
							_tmp10_ = fi;
							_tmp11_ = fm_file_info_is_dir (_tmp10_);
							if (!_tmp11_) {
								result = FALSE;
								return result;
							}
						}
					}
				}
			} else {
				GList* _tmp12_ = NULL;
				_tmp12_ = files;
				{
					GList* fi_collection = NULL;
					GList* fi_it = NULL;
					fi_collection = _tmp12_;
					for (fi_it = fi_collection; fi_it != NULL; fi_it = fi_it->next) {
						FmFileInfo* fi = NULL;
						fi = (FmFileInfo*) fi_it->data;
						{
							FmFileInfo* _tmp13_ = NULL;
							gboolean _tmp14_ = FALSE;
							_tmp13_ = fi;
							_tmp14_ = fm_file_info_is_dir (_tmp13_);
							if (_tmp14_) {
								result = FALSE;
								return result;
							}
						}
					}
				}
			}
		} else {
			const gchar* _tmp15_ = NULL;
			gboolean _tmp16_ = FALSE;
			_tmp15_ = type;
			_tmp16_ = g_str_has_suffix (_tmp15_, "/*");
			if (_tmp16_) {
				gchar* prefix = NULL;
				const gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				gboolean _tmp19_ = FALSE;
				_tmp17_ = type;
				_tmp18_ = string_slice (_tmp17_, (glong) 0, (glong) (-1));
				prefix = _tmp18_;
				_tmp19_ = negated;
				if (_tmp19_) {
					GList* _tmp20_ = NULL;
					_tmp20_ = files;
					{
						GList* fi_collection = NULL;
						GList* fi_it = NULL;
						fi_collection = _tmp20_;
						for (fi_it = fi_collection; fi_it != NULL; fi_it = fi_it->next) {
							FmFileInfo* fi = NULL;
							fi = (FmFileInfo*) fi_it->data;
							{
								FmFileInfo* _tmp21_ = NULL;
								FmMimeType* _tmp22_ = NULL;
								const gchar* _tmp23_ = NULL;
								const gchar* _tmp24_ = NULL;
								gboolean _tmp25_ = FALSE;
								_tmp21_ = fi;
								_tmp22_ = fm_file_info_get_mime_type (_tmp21_);
								_tmp23_ = fm_mime_type_get_type (_tmp22_);
								_tmp24_ = prefix;
								_tmp25_ = g_str_has_prefix (_tmp23_, _tmp24_);
								if (_tmp25_) {
									result = FALSE;
									_g_free0 (prefix);
									return result;
								}
							}
						}
					}
				} else {
					GList* _tmp26_ = NULL;
					_tmp26_ = files;
					{
						GList* fi_collection = NULL;
						GList* fi_it = NULL;
						fi_collection = _tmp26_;
						for (fi_it = fi_collection; fi_it != NULL; fi_it = fi_it->next) {
							FmFileInfo* fi = NULL;
							fi = (FmFileInfo*) fi_it->data;
							{
								FmFileInfo* _tmp27_ = NULL;
								FmMimeType* _tmp28_ = NULL;
								const gchar* _tmp29_ = NULL;
								const gchar* _tmp30_ = NULL;
								gboolean _tmp31_ = FALSE;
								_tmp27_ = fi;
								_tmp28_ = fm_file_info_get_mime_type (_tmp27_);
								_tmp29_ = fm_mime_type_get_type (_tmp28_);
								_tmp30_ = prefix;
								_tmp31_ = g_str_has_prefix (_tmp29_, _tmp30_);
								if (!_tmp31_) {
									result = FALSE;
									_g_free0 (prefix);
									return result;
								}
							}
						}
					}
				}
				_g_free0 (prefix);
			} else {
				gboolean _tmp32_ = FALSE;
				_tmp32_ = negated;
				if (_tmp32_) {
					GList* _tmp33_ = NULL;
					_tmp33_ = files;
					{
						GList* fi_collection = NULL;
						GList* fi_it = NULL;
						fi_collection = _tmp33_;
						for (fi_it = fi_collection; fi_it != NULL; fi_it = fi_it->next) {
							FmFileInfo* fi = NULL;
							fi = (FmFileInfo*) fi_it->data;
							{
								FmFileInfo* _tmp34_ = NULL;
								FmMimeType* _tmp35_ = NULL;
								const gchar* _tmp36_ = NULL;
								const gchar* _tmp37_ = NULL;
								_tmp34_ = fi;
								_tmp35_ = fm_file_info_get_mime_type (_tmp34_);
								_tmp36_ = fm_mime_type_get_type (_tmp35_);
								_tmp37_ = type;
								if (g_strcmp0 (_tmp36_, _tmp37_) == 0) {
									result = FALSE;
									return result;
								}
							}
						}
					}
				} else {
					GList* _tmp38_ = NULL;
					_tmp38_ = files;
					{
						GList* fi_collection = NULL;
						GList* fi_it = NULL;
						fi_collection = _tmp38_;
						for (fi_it = fi_collection; fi_it != NULL; fi_it = fi_it->next) {
							FmFileInfo* fi = NULL;
							fi = (FmFileInfo*) fi_it->data;
							{
								FmFileInfo* _tmp39_ = NULL;
								FmMimeType* _tmp40_ = NULL;
								const gchar* _tmp41_ = NULL;
								const gchar* _tmp42_ = NULL;
								_tmp39_ = fi;
								_tmp40_ = fm_file_info_get_mime_type (_tmp39_);
								_tmp41_ = fm_mime_type_get_type (_tmp40_);
								_tmp42_ = type;
								if (g_strcmp0 (_tmp41_, _tmp42_) != 0) {
									result = FALSE;
									return result;
								}
							}
						}
					}
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static inline gboolean fm_file_action_condition_match_mime_types (FmFileActionCondition* self, GList* files) {
	gboolean result = FALSE;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->mime_types;
	_tmp0__length1 = self->mime_types_length1;
	if (_tmp0_ != NULL) {
		gboolean allowed = FALSE;
		gchar** _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		allowed = FALSE;
		_tmp1_ = self->mime_types;
		_tmp1__length1 = self->mime_types_length1;
		{
			gchar** allowed_type_collection = NULL;
			gint allowed_type_collection_length1 = 0;
			gint _allowed_type_collection_size_ = 0;
			gint allowed_type_it = 0;
			allowed_type_collection = _tmp1_;
			allowed_type_collection_length1 = _tmp1__length1;
			for (allowed_type_it = 0; allowed_type_it < _tmp1__length1; allowed_type_it = allowed_type_it + 1) {
				const gchar* allowed_type = NULL;
				allowed_type = allowed_type_collection[allowed_type_it];
				{
					const gchar* type = NULL;
					gboolean negated = FALSE;
					const gchar* _tmp2_ = NULL;
					gchar _tmp3_ = '\0';
					gboolean _tmp6_ = FALSE;
					_tmp2_ = allowed_type;
					_tmp3_ = string_get (_tmp2_, (glong) 0);
					if (_tmp3_ == '!') {
						const gchar* _tmp4_ = NULL;
						_tmp4_ = allowed_type;
						type = (const gchar*) (((guint8*) _tmp4_) + 1);
						negated = TRUE;
					} else {
						const gchar* _tmp5_ = NULL;
						_tmp5_ = allowed_type;
						type = _tmp5_;
						negated = FALSE;
					}
					_tmp6_ = negated;
					if (_tmp6_) {
						gboolean type_is_allowed = FALSE;
						GList* _tmp7_ = NULL;
						const gchar* _tmp8_ = NULL;
						gboolean _tmp9_ = FALSE;
						gboolean _tmp10_ = FALSE;
						gboolean _tmp11_ = FALSE;
						_tmp7_ = files;
						_tmp8_ = type;
						_tmp9_ = negated;
						_tmp10_ = fm_file_action_condition_match_mime_type (self, _tmp7_, _tmp8_, _tmp9_);
						type_is_allowed = _tmp10_;
						_tmp11_ = type_is_allowed;
						if (!_tmp11_) {
							result = FALSE;
							return result;
						}
					} else {
						gboolean _tmp12_ = FALSE;
						_tmp12_ = allowed;
						if (!_tmp12_) {
							GList* _tmp13_ = NULL;
							const gchar* _tmp14_ = NULL;
							gboolean _tmp15_ = FALSE;
							_tmp13_ = files;
							_tmp14_ = type;
							_tmp15_ = fm_file_action_condition_match_mime_type (self, _tmp13_, _tmp14_, FALSE);
							allowed = _tmp15_;
						}
					}
				}
			}
		}
		result = allowed;
		return result;
	}
	result = TRUE;
	return result;
}


static inline gboolean fm_file_action_condition_match_base_name (FmFileActionCondition* self, GList* files, const gchar* base_name, gboolean negated) {
	gboolean result = FALSE;
	GPatternSpec* pattern = NULL;
	gboolean _tmp0_ = FALSE;
	GList* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_name != NULL, FALSE);
	_tmp0_ = self->match_case;
	if (_tmp0_) {
		const gchar* _tmp1_ = NULL;
		GPatternSpec* _tmp2_ = NULL;
		_tmp1_ = base_name;
		_tmp2_ = g_pattern_spec_new (_tmp1_);
		_g_pattern_spec_free0 (pattern);
		pattern = _tmp2_;
	} else {
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GPatternSpec* _tmp6_ = NULL;
		_tmp3_ = base_name;
		_tmp4_ = g_utf8_casefold (_tmp3_, (gssize) (-1));
		_tmp5_ = _tmp4_;
		_tmp6_ = g_pattern_spec_new (_tmp5_);
		_g_pattern_spec_free0 (pattern);
		pattern = _tmp6_;
		_g_free0 (_tmp5_);
	}
	_tmp7_ = files;
	{
		GList* fi_collection = NULL;
		GList* fi_it = NULL;
		fi_collection = _tmp7_;
		for (fi_it = fi_collection; fi_it != NULL; fi_it = fi_it->next) {
			FmFileInfo* fi = NULL;
			fi = (FmFileInfo*) fi_it->data;
			{
				gchar* name = NULL;
				FmFileInfo* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				gchar* _tmp10_ = NULL;
				gboolean _tmp11_ = FALSE;
				_tmp8_ = fi;
				_tmp9_ = fm_file_info_get_name (_tmp8_);
				_tmp10_ = g_strdup (_tmp9_);
				name = _tmp10_;
				_tmp11_ = self->match_case;
				if (_tmp11_) {
					GPatternSpec* _tmp12_ = NULL;
					const gchar* _tmp13_ = NULL;
					gboolean _tmp14_ = FALSE;
					_tmp12_ = pattern;
					_tmp13_ = name;
					_tmp14_ = g_pattern_match_string (_tmp12_, _tmp13_);
					if (_tmp14_) {
						gboolean _tmp15_ = FALSE;
						_tmp15_ = negated;
						if (_tmp15_) {
							result = FALSE;
							_g_free0 (name);
							_g_pattern_spec_free0 (pattern);
							return result;
						}
					} else {
						gboolean _tmp16_ = FALSE;
						_tmp16_ = negated;
						if (!_tmp16_) {
							result = FALSE;
							_g_free0 (name);
							_g_pattern_spec_free0 (pattern);
							return result;
						}
					}
				} else {
					GPatternSpec* _tmp17_ = NULL;
					const gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
					gboolean _tmp21_ = FALSE;
					gboolean _tmp22_ = FALSE;
					_tmp17_ = pattern;
					_tmp18_ = name;
					_tmp19_ = g_utf8_casefold (_tmp18_, (gssize) (-1));
					_tmp20_ = _tmp19_;
					_tmp21_ = g_pattern_match_string (_tmp17_, _tmp20_);
					_tmp22_ = _tmp21_;
					_g_free0 (_tmp20_);
					if (_tmp22_) {
						gboolean _tmp23_ = FALSE;
						_tmp23_ = negated;
						if (_tmp23_) {
							result = FALSE;
							_g_free0 (name);
							_g_pattern_spec_free0 (pattern);
							return result;
						}
					} else {
						gboolean _tmp24_ = FALSE;
						_tmp24_ = negated;
						if (!_tmp24_) {
							result = FALSE;
							_g_free0 (name);
							_g_pattern_spec_free0 (pattern);
							return result;
						}
					}
				}
				_g_free0 (name);
			}
		}
	}
	result = TRUE;
	_g_pattern_spec_free0 (pattern);
	return result;
}


static inline gboolean fm_file_action_condition_match_base_names (FmFileActionCondition* self, GList* files) {
	gboolean result = FALSE;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->base_names;
	_tmp0__length1 = self->base_names_length1;
	if (_tmp0_ != NULL) {
		gboolean allowed = FALSE;
		gchar** _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		allowed = FALSE;
		_tmp1_ = self->base_names;
		_tmp1__length1 = self->base_names_length1;
		{
			gchar** allowed_name_collection = NULL;
			gint allowed_name_collection_length1 = 0;
			gint _allowed_name_collection_size_ = 0;
			gint allowed_name_it = 0;
			allowed_name_collection = _tmp1_;
			allowed_name_collection_length1 = _tmp1__length1;
			for (allowed_name_it = 0; allowed_name_it < _tmp1__length1; allowed_name_it = allowed_name_it + 1) {
				const gchar* allowed_name = NULL;
				allowed_name = allowed_name_collection[allowed_name_it];
				{
					const gchar* name = NULL;
					gboolean negated = FALSE;
					const gchar* _tmp2_ = NULL;
					gchar _tmp3_ = '\0';
					gboolean _tmp6_ = FALSE;
					_tmp2_ = allowed_name;
					_tmp3_ = string_get (_tmp2_, (glong) 0);
					if (_tmp3_ == '!') {
						const gchar* _tmp4_ = NULL;
						_tmp4_ = allowed_name;
						name = (const gchar*) (((guint8*) _tmp4_) + 1);
						negated = TRUE;
					} else {
						const gchar* _tmp5_ = NULL;
						_tmp5_ = allowed_name;
						name = _tmp5_;
						negated = FALSE;
					}
					_tmp6_ = negated;
					if (_tmp6_) {
						gboolean name_is_allowed = FALSE;
						GList* _tmp7_ = NULL;
						const gchar* _tmp8_ = NULL;
						gboolean _tmp9_ = FALSE;
						gboolean _tmp10_ = FALSE;
						gboolean _tmp11_ = FALSE;
						_tmp7_ = files;
						_tmp8_ = name;
						_tmp9_ = negated;
						_tmp10_ = fm_file_action_condition_match_base_name (self, _tmp7_, _tmp8_, _tmp9_);
						name_is_allowed = _tmp10_;
						_tmp11_ = name_is_allowed;
						if (!_tmp11_) {
							result = FALSE;
							return result;
						}
					} else {
						gboolean _tmp12_ = FALSE;
						_tmp12_ = allowed;
						if (!_tmp12_) {
							GList* _tmp13_ = NULL;
							const gchar* _tmp14_ = NULL;
							gboolean _tmp15_ = FALSE;
							_tmp13_ = files;
							_tmp14_ = name;
							_tmp15_ = fm_file_action_condition_match_base_name (self, _tmp13_, _tmp14_, FALSE);
							allowed = _tmp15_;
						}
					}
				}
			}
		}
		result = allowed;
		return result;
	}
	result = TRUE;
	return result;
}


static gboolean fm_file_action_condition_match_scheme (GList* files, const gchar* scheme, gboolean negated) {
	gboolean result = FALSE;
	GList* _tmp0_ = NULL;
	g_return_val_if_fail (scheme != NULL, FALSE);
	_tmp0_ = files;
	{
		GList* fi_collection = NULL;
		GList* fi_it = NULL;
		fi_collection = _tmp0_;
		for (fi_it = fi_collection; fi_it != NULL; fi_it = fi_it->next) {
			FmFileInfo* fi = NULL;
			fi = (FmFileInfo*) fi_it->data;
			{
				gchar* uri = NULL;
				FmFileInfo* _tmp1_ = NULL;
				FmPath* _tmp2_ = NULL;
				gchar* _tmp3_ = NULL;
				const gchar* _tmp4_ = NULL;
				gchar* _tmp5_ = NULL;
				gchar* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				_tmp1_ = fi;
				_tmp2_ = fm_file_info_get_path (_tmp1_);
				_tmp3_ = fm_path_to_uri (_tmp2_);
				uri = _tmp3_;
				_tmp4_ = uri;
				_tmp5_ = g_uri_parse_scheme (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = scheme;
				_tmp8_ = g_strcmp0 (_tmp6_, _tmp7_) == 0;
				_g_free0 (_tmp6_);
				if (_tmp8_) {
					gboolean _tmp9_ = FALSE;
					_tmp9_ = negated;
					if (_tmp9_) {
						result = FALSE;
						_g_free0 (uri);
						return result;
					}
				} else {
					gboolean _tmp10_ = FALSE;
					_tmp10_ = negated;
					if (!_tmp10_) {
						result = FALSE;
						_g_free0 (uri);
						return result;
					}
				}
				_g_free0 (uri);
			}
		}
	}
	result = TRUE;
	return result;
}


static inline gboolean fm_file_action_condition_match_schemes (FmFileActionCondition* self, GList* files) {
	gboolean result = FALSE;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->schemes;
	_tmp0__length1 = self->schemes_length1;
	if (_tmp0_ != NULL) {
		gboolean allowed = FALSE;
		gchar** _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		allowed = FALSE;
		_tmp1_ = self->schemes;
		_tmp1__length1 = self->schemes_length1;
		{
			gchar** allowed_scheme_collection = NULL;
			gint allowed_scheme_collection_length1 = 0;
			gint _allowed_scheme_collection_size_ = 0;
			gint allowed_scheme_it = 0;
			allowed_scheme_collection = _tmp1_;
			allowed_scheme_collection_length1 = _tmp1__length1;
			for (allowed_scheme_it = 0; allowed_scheme_it < _tmp1__length1; allowed_scheme_it = allowed_scheme_it + 1) {
				const gchar* allowed_scheme = NULL;
				allowed_scheme = allowed_scheme_collection[allowed_scheme_it];
				{
					const gchar* scheme = NULL;
					gboolean negated = FALSE;
					const gchar* _tmp2_ = NULL;
					gchar _tmp3_ = '\0';
					gboolean _tmp6_ = FALSE;
					_tmp2_ = allowed_scheme;
					_tmp3_ = string_get (_tmp2_, (glong) 0);
					if (_tmp3_ == '!') {
						const gchar* _tmp4_ = NULL;
						_tmp4_ = allowed_scheme;
						scheme = (const gchar*) (((guint8*) _tmp4_) + 1);
						negated = TRUE;
					} else {
						const gchar* _tmp5_ = NULL;
						_tmp5_ = allowed_scheme;
						scheme = _tmp5_;
						negated = FALSE;
					}
					_tmp6_ = negated;
					if (_tmp6_) {
						gboolean scheme_is_allowed = FALSE;
						GList* _tmp7_ = NULL;
						const gchar* _tmp8_ = NULL;
						gboolean _tmp9_ = FALSE;
						gboolean _tmp10_ = FALSE;
						gboolean _tmp11_ = FALSE;
						_tmp7_ = files;
						_tmp8_ = scheme;
						_tmp9_ = negated;
						_tmp10_ = fm_file_action_condition_match_scheme (_tmp7_, _tmp8_, _tmp9_);
						scheme_is_allowed = _tmp10_;
						_tmp11_ = scheme_is_allowed;
						if (!_tmp11_) {
							result = FALSE;
							return result;
						}
					} else {
						gboolean _tmp12_ = FALSE;
						_tmp12_ = allowed;
						if (!_tmp12_) {
							GList* _tmp13_ = NULL;
							const gchar* _tmp14_ = NULL;
							gboolean _tmp15_ = FALSE;
							_tmp13_ = files;
							_tmp14_ = scheme;
							_tmp15_ = fm_file_action_condition_match_scheme (_tmp13_, _tmp14_, FALSE);
							allowed = _tmp15_;
						}
					}
				}
			}
		}
		result = allowed;
		return result;
	}
	result = TRUE;
	return result;
}


static gboolean fm_file_action_condition_match_folder (GList* files, const gchar* folder, gboolean negated) {
	gboolean result = FALSE;
	GPatternSpec* pattern = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GList* _tmp9_ = NULL;
	g_return_val_if_fail (folder != NULL, FALSE);
	_tmp0_ = folder;
	_tmp1_ = g_str_has_suffix (_tmp0_, "/*");
	if (_tmp1_) {
		const gchar* _tmp2_ = NULL;
		GPatternSpec* _tmp3_ = NULL;
		_tmp2_ = folder;
		_tmp3_ = g_pattern_spec_new (_tmp2_);
		_g_pattern_spec_free0 (pattern);
		pattern = _tmp3_;
	} else {
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		GPatternSpec* _tmp8_ = NULL;
		_tmp4_ = folder;
		_tmp5_ = string_to_string (_tmp4_);
		_tmp6_ = g_strconcat (_tmp5_, "/*", NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_pattern_spec_new (_tmp7_);
		_g_pattern_spec_free0 (pattern);
		pattern = _tmp8_;
		_g_free0 (_tmp7_);
	}
	_tmp9_ = files;
	{
		GList* fi_collection = NULL;
		GList* fi_it = NULL;
		fi_collection = _tmp9_;
		for (fi_it = fi_collection; fi_it != NULL; fi_it = fi_it->next) {
			FmFileInfo* fi = NULL;
			fi = (FmFileInfo*) fi_it->data;
			{
				gchar* dirname = NULL;
				FmFileInfo* _tmp10_ = NULL;
				FmPath* _tmp11_ = NULL;
				FmPath* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
				GPatternSpec* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				gboolean _tmp16_ = FALSE;
				_tmp10_ = fi;
				_tmp11_ = fm_file_info_get_path (_tmp10_);
				_tmp12_ = fm_path_get_parent (_tmp11_);
				_tmp13_ = fm_path_to_str (_tmp12_);
				dirname = _tmp13_;
				_tmp14_ = pattern;
				_tmp15_ = dirname;
				_tmp16_ = g_pattern_match_string (_tmp14_, _tmp15_);
				if (_tmp16_) {
					gboolean _tmp17_ = FALSE;
					_tmp17_ = negated;
					if (_tmp17_) {
						result = FALSE;
						_g_free0 (dirname);
						_g_pattern_spec_free0 (pattern);
						return result;
					}
				} else {
					gboolean _tmp18_ = FALSE;
					_tmp18_ = negated;
					if (!_tmp18_) {
						result = FALSE;
						_g_free0 (dirname);
						_g_pattern_spec_free0 (pattern);
						return result;
					}
				}
				_g_free0 (dirname);
			}
		}
	}
	result = TRUE;
	_g_pattern_spec_free0 (pattern);
	return result;
}


static inline gboolean fm_file_action_condition_match_folders (FmFileActionCondition* self, GList* files) {
	gboolean result = FALSE;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->folders;
	_tmp0__length1 = self->folders_length1;
	if (_tmp0_ != NULL) {
		gboolean allowed = FALSE;
		gchar** _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		allowed = FALSE;
		_tmp1_ = self->folders;
		_tmp1__length1 = self->folders_length1;
		{
			gchar** allowed_folder_collection = NULL;
			gint allowed_folder_collection_length1 = 0;
			gint _allowed_folder_collection_size_ = 0;
			gint allowed_folder_it = 0;
			allowed_folder_collection = _tmp1_;
			allowed_folder_collection_length1 = _tmp1__length1;
			for (allowed_folder_it = 0; allowed_folder_it < _tmp1__length1; allowed_folder_it = allowed_folder_it + 1) {
				const gchar* allowed_folder = NULL;
				allowed_folder = allowed_folder_collection[allowed_folder_it];
				{
					const gchar* folder = NULL;
					gboolean negated = FALSE;
					const gchar* _tmp2_ = NULL;
					gchar _tmp3_ = '\0';
					gboolean _tmp6_ = FALSE;
					_tmp2_ = allowed_folder;
					_tmp3_ = string_get (_tmp2_, (glong) 0);
					if (_tmp3_ == '!') {
						const gchar* _tmp4_ = NULL;
						_tmp4_ = allowed_folder;
						folder = (const gchar*) (((guint8*) _tmp4_) + 1);
						negated = TRUE;
					} else {
						const gchar* _tmp5_ = NULL;
						_tmp5_ = allowed_folder;
						folder = _tmp5_;
						negated = FALSE;
					}
					_tmp6_ = negated;
					if (_tmp6_) {
						gboolean folder_is_allowed = FALSE;
						GList* _tmp7_ = NULL;
						const gchar* _tmp8_ = NULL;
						gboolean _tmp9_ = FALSE;
						gboolean _tmp10_ = FALSE;
						gboolean _tmp11_ = FALSE;
						_tmp7_ = files;
						_tmp8_ = folder;
						_tmp9_ = negated;
						_tmp10_ = fm_file_action_condition_match_folder (_tmp7_, _tmp8_, _tmp9_);
						folder_is_allowed = _tmp10_;
						_tmp11_ = folder_is_allowed;
						if (!_tmp11_) {
							result = FALSE;
							return result;
						}
					} else {
						gboolean _tmp12_ = FALSE;
						_tmp12_ = allowed;
						if (!_tmp12_) {
							GList* _tmp13_ = NULL;
							const gchar* _tmp14_ = NULL;
							gboolean _tmp15_ = FALSE;
							_tmp13_ = files;
							_tmp14_ = folder;
							_tmp15_ = fm_file_action_condition_match_folder (_tmp13_, _tmp14_, FALSE);
							allowed = _tmp15_;
						}
					}
				}
			}
		}
		result = allowed;
		return result;
	}
	result = TRUE;
	return result;
}


static inline gboolean fm_file_action_condition_match_selection_count (FmFileActionCondition* self, GList* files) {
	gboolean result = FALSE;
	guint n_files = 0U;
	GList* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gchar _tmp2_ = '\0';
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = files;
	_tmp1_ = g_list_length (_tmp0_);
	n_files = _tmp1_;
	_tmp2_ = self->selection_count_cmp;
	switch (_tmp2_) {
		case '<':
		{
			guint _tmp3_ = 0U;
			gint _tmp4_ = 0;
			_tmp3_ = n_files;
			_tmp4_ = self->selection_count;
			if (_tmp3_ >= ((guint) _tmp4_)) {
				result = FALSE;
				return result;
			}
			break;
		}
		case '=':
		{
			guint _tmp5_ = 0U;
			gint _tmp6_ = 0;
			_tmp5_ = n_files;
			_tmp6_ = self->selection_count;
			if (_tmp5_ != ((guint) _tmp6_)) {
				result = FALSE;
				return result;
			}
			break;
		}
		case '>':
		{
			guint _tmp7_ = 0U;
			gint _tmp8_ = 0;
			_tmp7_ = n_files;
			_tmp8_ = self->selection_count;
			if (_tmp7_ <= ((guint) _tmp8_)) {
				result = FALSE;
				return result;
			}
			break;
		}
		default:
		break;
	}
	result = TRUE;
	return result;
}


static inline gboolean fm_file_action_condition_match_capabilities (FmFileActionCondition* self, GList* files) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = TRUE;
	return result;
}


gboolean fm_file_action_condition_match (FmFileActionCondition* self, GList* files) {
	gboolean result = FALSE;
	GList* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GList* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GList* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GList* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GList* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	GList* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	GList* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	GList* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	GList* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	GList* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = files;
	_tmp1_ = fm_file_action_condition_match_try_exec (self, _tmp0_);
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = files;
	_tmp3_ = fm_file_action_condition_match_mime_types (self, _tmp2_);
	if (!_tmp3_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = files;
	_tmp5_ = fm_file_action_condition_match_base_names (self, _tmp4_);
	if (!_tmp5_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = files;
	_tmp7_ = fm_file_action_condition_match_selection_count (self, _tmp6_);
	if (!_tmp7_) {
		result = FALSE;
		return result;
	}
	_tmp8_ = files;
	_tmp9_ = fm_file_action_condition_match_schemes (self, _tmp8_);
	if (!_tmp9_) {
		result = FALSE;
		return result;
	}
	_tmp10_ = files;
	_tmp11_ = fm_file_action_condition_match_folders (self, _tmp10_);
	if (!_tmp11_) {
		result = FALSE;
		return result;
	}
	_tmp12_ = files;
	_tmp13_ = fm_file_action_condition_match_capabilities (self, _tmp12_);
	if (!_tmp13_) {
		result = FALSE;
		return result;
	}
	_tmp14_ = files;
	_tmp15_ = fm_file_action_condition_match_show_if_registered (self, _tmp14_);
	if (!_tmp15_) {
		result = FALSE;
		return result;
	}
	_tmp16_ = files;
	_tmp17_ = fm_file_action_condition_match_show_if_true (self, _tmp16_);
	if (!_tmp17_) {
		result = FALSE;
		return result;
	}
	_tmp18_ = files;
	_tmp19_ = fm_file_action_condition_match_show_if_running (self, _tmp18_);
	if (!_tmp19_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static void fm_file_action_condition_instance_init (FmFileActionCondition * self) {
}


void fm_file_action_condition_free (FmFileActionCondition* self) {
	self->only_show_in = (_vala_array_free (self->only_show_in, self->only_show_in_length1, (GDestroyNotify) g_free), NULL);
	self->not_show_in = (_vala_array_free (self->not_show_in, self->not_show_in_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->try_exec);
	_g_free0 (self->show_if_registered);
	_g_free0 (self->show_if_true);
	_g_free0 (self->show_if_running);
	self->mime_types = (_vala_array_free (self->mime_types, self->mime_types_length1, (GDestroyNotify) g_free), NULL);
	self->base_names = (_vala_array_free (self->base_names, self->base_names_length1, (GDestroyNotify) g_free), NULL);
	self->schemes = (_vala_array_free (self->schemes, self->schemes_length1, (GDestroyNotify) g_free), NULL);
	self->folders = (_vala_array_free (self->folders, self->folders_length1, (GDestroyNotify) g_free), NULL);
	g_slice_free (FmFileActionCondition, self);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



