#!/bin/sh
#
# openbox startup-script:

# Applications you want to run with openbox.
# MAKE SURE THAT APPS THAT KEEP RUNNING HAVE AN ''&'' AT THE END.
#
# D-bus
if which dbus-launch >/dev/null && test -z "$DBUS_SESSION_BUS_ADDRESS"; then
       eval `dbus-launch --sh-syntax --exit-with-session`
fi
([ -x /usr/bin/batti ] && dbus-launch batti) &
([ -x /usr/bin/xdg-user-dirs-update ] && xdg-user-dirs-update) &
(sleep 1 && [ -x /usr/bin/spacefm ] && spacefm --desktop) &
([ -x /usr/bin/volumeicon ] && volumeicon) &
(setxkbmap -query | grep "^layout:" | sed "s/^layout: *//" | grep -q "," && [ -x /usr/bin/fbxkb ] && fbxkb) &
(sleep 1 && [ -x /usr/bin/fbpanel ] && fbpanel) &

(sleep 1 && [ -x /usr/libexec/menu-cached ] && /usr/libexec/menu-cached) &
(sleep 1 && [ -x /usr/bin/parcellite ] && parcellite) &
(sleep 9 && [ -x /usr/bin/xscreensaver ] && xscreensaver -nosplash) &
