# SDL::OpenGL.pm
#
#	A simplified OpenGL wrapper
#

package SDL::OpenGL;
use SDL;

require Exporter;

@ISA = qw/ Exporter /;

my @glu = qw/ LookAt Perspective Ortho2D ScaleImage Build1DMipmaps Build2DMipmaps  
	Build3DMipmaps Build1DMipmapLevels Build2DMipmapLevels Build3DMipmapLevels 
	ErrorString NewNurbsRenderer DeleteNurbsRenderer NurbsProperty	
	LoadSamplingMatrices GetNurbsProperty NurbsCallback BeginSurface EndSurface
	NurbsSurface BeginCurve EndCurve NurbsCurve NurbsCallbackData
	BeginTrim EndTrim PwlCurve
/;	

my @routines = keys %SDL::OpenGL::;
for ( @routines ) {
	if (/^GL/) {
		push @EXPORT, "&$_";
	} elsif ( in ( $_, @glu )) {
		eval "sub SDL::OpenGL::glu$_ { $_(\@_); }";
		push @EXPORT, "glu$_";
	} else {
		eval "sub SDL::OpenGL::gl$_ { $_(\@_); }";
		push @EXPORT, "gl$_";
	}
}

1;

__END__;

=pod

=head1 NAME

SDL::OpenGL - a perl extension

=head1 DESCRIPTION

L<SDL::OpenGL> is a perl module which when used by your application
exports the gl* and glu* functions into your application's primary namespace.
Most of the functions described in the OpenGL 1.3 specification are currently
supported in this fashion.  As the implementation of the OpenGL bindings that
comes with SDL_perl is largely type agnositic, there is no need to decline
the function names in the fashion that is done in the C API. For example,
glVertex3d is simply glVertex, and perl just does the right thing with regards
to types.

=head1 AUTHOR

David J. Goehrig

=head1 SEE ALSO

L<perl> L<SDL::App>

=cut
