#include "global.h"
#include "MemoryCardDisplay.h"
#include "ThemeManager.h"
#include "MemoryCardManager.h"
#include "RageUtil.h"
#include "XmlFile.h"
#include "ActorUtil.h"

REGISTER_ACTOR_CLASS( MemoryCardDisplay );

MemoryCardDisplay::MemoryCardDisplay()
{
	m_PlayerNumber = PLAYER_INVALID;
	m_LastSeenState = MemoryCardState_Invalid;
}

void MemoryCardDisplay::Load( PlayerNumber pn )
{
	m_PlayerNumber = pn;

	for( int i=0; i<NUM_MemoryCardState; i++ )
	{
		MemoryCardState mcs = (MemoryCardState)i;
		RString sState = MemoryCardStateToString(mcs);
		m_spr[i].Load( THEME->GetPathG("MemoryCardDisplay",ssprintf("%s p%d",sState.c_str(),pn+1)) );
		m_spr[i].SetVisible( false );
		this->AddChild( &m_spr[i] );
	}
}

void MemoryCardDisplay::LoadFromNode( const XNode* pNode )
{
	Lua *L = LUA->Get();
	pNode->PushAttrValue( L, "PlayerNumber" );
	PlayerNumber pn;
	LuaHelpers::Pop( L, pn );
	LUA->Release(L);

	Load( pn );

	ActorFrame::LoadFromNode( pNode );
}

void MemoryCardDisplay::Update( float fDelta )
{
	MemoryCardState newMcs = MEMCARDMAN->GetCardState(m_PlayerNumber);
	if( m_LastSeenState != newMcs )
	{
		if( m_LastSeenState != MemoryCardState_Invalid )
			m_spr[m_LastSeenState].SetVisible( false );
		m_LastSeenState = newMcs;
		m_spr[m_LastSeenState].SetVisible( true );
	}

	ActorFrame::Update( fDelta );
}

/*
 * (c) 2003 Chris Danford
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons to
 * whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT
 * OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */
