/* libsoup-2.4.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Soup", gir_namespace = "Soup", gir_version = "2.4", lower_case_cprefix = "soup_")]
namespace Soup {
	namespace Form {
		[CCode (cheader_filename = "libsoup/soup.h")]
		public static GLib.HashTable<string,string> decode (string encoded_form);
		[CCode (cheader_filename = "libsoup/soup.h")]
		public static GLib.HashTable<string,string> decode_multipart (Soup.Message msg, string? file_control_name, out string filename, out string content_type, out Soup.Buffer file);
		[CCode (cheader_filename = "libsoup/soup.h")]
		public static string encode (...);
		[CCode (cheader_filename = "libsoup/soup.h")]
		public static string encode_datalist (GLib.Datalist<string> form_data_set);
		[CCode (cheader_filename = "libsoup/soup.h")]
		public static string encode_hash (GLib.HashTable<string,string> form_data_set);
		[CCode (cheader_filename = "libsoup/soup.h")]
		public static string encode_valist (string first_field, va_list args);
		[CCode (cheader_filename = "libsoup/soup.h")]
		public static Soup.Message request_new (string method, string uri, ...);
		[CCode (cheader_filename = "libsoup/soup.h")]
		public static Soup.Message request_new_from_datalist (string method, string uri, GLib.Datalist<string> form_data_set);
		[CCode (cheader_filename = "libsoup/soup.h")]
		public static Soup.Message request_new_from_hash (string method, string uri, GLib.HashTable<string,string> form_data_set);
		[CCode (cheader_filename = "libsoup/soup.h")]
		public static Soup.Message request_new_from_multipart (string uri, Soup.Multipart multipart);
	}
	namespace XMLRPC {
		[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_XMLRPC_ERROR_")]
		[GIR (name = "XMLRPCError")]
		public errordomain Error {
			ARGUMENTS,
			RETVAL
		}
		[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_XMLRPC_FAULT_")]
		[GIR (name = "XMLRPCFault")]
		public errordomain Fault {
			PARSE_ERROR_NOT_WELL_FORMED,
			PARSE_ERROR_UNSUPPORTED_ENCODING,
			PARSE_ERROR_INVALID_CHARACTER_FOR_ENCODING,
			SERVER_ERROR_INVALID_XML_RPC,
			SERVER_ERROR_REQUESTED_METHOD_NOT_FOUND,
			SERVER_ERROR_INVALID_METHOD_PARAMETERS,
			SERVER_ERROR_INTERNAL_XML_RPC_ERROR,
			APPLICATION_ERROR,
			SYSTEM_ERROR,
			TRANSPORT_ERROR
		}
		[CCode (cheader_filename = "libsoup/soup.h")]
		[PrintfFormat]
		public static string build_fault (int fault_code, string fault_format, ...);
		[CCode (cheader_filename = "libsoup/soup.h")]
		public static string build_method_call (string method_name, [CCode (array_length_cname = "n_params", array_length_pos = 2.1)] GLib.Value[] @params);
		[CCode (cheader_filename = "libsoup/soup.h")]
		public static string build_method_response (GLib.Value value);
		[CCode (cheader_filename = "libsoup/soup.h")]
		public static GLib.Quark error_quark ();
		[CCode (cheader_filename = "libsoup/soup.h", sentinel = "G_TYPE_INVALID")]
		public static bool extract_method_call (string method_call, int length, out string method_name, ...);
		[CCode (cheader_filename = "libsoup/soup.h", sentinel = "G_TYPE_INVALID")]
		public static bool extract_method_response (string method_response, int length, ...) throws Soup.XMLRPC.Fault;
		[CCode (cheader_filename = "libsoup/soup.h")]
		public static GLib.Quark fault_quark ();
		[CCode (cheader_filename = "libsoup/soup.h")]
		public static bool parse_method_call (string method_call, int length, out string method_name, out GLib.ValueArray @params);
		[CCode (cheader_filename = "libsoup/soup.h")]
		public static bool parse_method_response (string method_response, int length, out GLib.Value value) throws Soup.XMLRPC.Fault;
		[CCode (cheader_filename = "libsoup/soup.h", sentinel = "G_TYPE_INVALID")]
		public static Soup.Message request_new (string uri, string method_name, ...);
		[CCode (cheader_filename = "libsoup/soup.h")]
		[PrintfFormat]
		public static void set_fault (Soup.Message msg, int fault_code, string fault_format, ...);
		[CCode (cheader_filename = "libsoup/soup.h", sentinel = "G_TYPE_INVALID")]
		public static void set_response (Soup.Message msg, ...);
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_address_get_type ()")]
	public class Address : GLib.Object, GLib.SocketConnectable {
		[CCode (has_construct_function = false)]
		public Address (string name, uint port);
		[CCode (has_construct_function = false)]
		public Address.any (Soup.AddressFamily family, uint port);
		public bool equal_by_ip (Soup.Address addr2);
		public bool equal_by_name (Soup.Address addr2);
		[CCode (has_construct_function = false)]
		public Address.from_sockaddr (void* sa, int len);
		public GLib.SocketAddress get_gsockaddr ();
		public unowned string get_name ();
		public unowned string get_physical ();
		public uint get_port ();
		public void* get_sockaddr (int len);
		public uint hash_by_ip ();
		public uint hash_by_name ();
		public bool is_resolved ();
		public void resolve_async (GLib.MainContext? async_context, GLib.Cancellable? cancellable, [CCode (scope = "async")] owned Soup.AddressCallback callback);
		public uint resolve_sync (GLib.Cancellable? cancellable = null);
		[NoAccessorMethod]
		public Soup.AddressFamily family { get; construct; }
		public string name { get; construct; }
		public string physical { get; }
		public int port { get; construct; }
		[NoAccessorMethod]
		public string protocol { owned get; construct; }
		[NoAccessorMethod]
		public void* sockaddr { get; construct; }
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_auth_get_type ()")]
	public abstract class Auth : GLib.Object {
		[CCode (has_construct_function = false)]
		public Auth (GLib.Type type, Soup.Message msg, string auth_header);
		public virtual void authenticate (string username, string password);
		public virtual string get_authorization (Soup.Message msg);
		public unowned string get_host ();
		public string get_info ();
		public virtual GLib.SList<string> get_protection_space (Soup.URI source_uri);
		public unowned string get_realm ();
		public unowned string get_saved_password (string user);
		public GLib.SList<string> get_saved_users ();
		public unowned string get_scheme_name ();
		public void has_saved_password (string username, string password);
		public virtual bool is_ready (Soup.Message msg);
		public void save_password (string username, string password);
		public virtual bool update (Soup.Message msg, GLib.HashTable<void*,void*> auth_header);
		[NoAccessorMethod]
		public string host { owned get; set; }
		[NoAccessorMethod]
		public virtual bool is_authenticated { get; }
		[NoAccessorMethod]
		public bool is_for_proxy { get; set; }
		[NoAccessorMethod]
		public string realm { owned get; set; }
		public string scheme_name { get; }
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_auth_basic_get_type ()")]
	public class AuthBasic : Soup.Auth {
		[CCode (has_construct_function = false)]
		protected AuthBasic ();
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_auth_digest_get_type ()")]
	public class AuthDigest : Soup.Auth {
		[CCode (has_construct_function = false)]
		protected AuthDigest ();
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_auth_domain_get_type ()")]
	public abstract class AuthDomain : GLib.Object {
		[CCode (has_construct_function = false)]
		protected AuthDomain ();
		[NoWrapper]
		public virtual string accepts (Soup.Message msg, string header);
		public void add_path (string path);
		[CCode (vfunc_name = "challenge")]
		public virtual string challenge (Soup.Message msg);
		public virtual bool check_password (Soup.Message msg, string username, string password);
		public bool covers (Soup.Message msg);
		public unowned string get_realm ();
		public void remove_path (string path);
		public void set_filter (owned Soup.AuthDomainFilter filter);
		public void set_generic_auth_callback (owned Soup.AuthDomainGenericAuthCallback auth_callback);
		public bool try_generic_auth_callback (Soup.Message msg, string username);
		[NoAccessorMethod]
		public void* filter { get; set; }
		[NoAccessorMethod]
		public void* filter_data { get; set; }
		[NoAccessorMethod]
		public void* generic_auth_callback { get; set; }
		[NoAccessorMethod]
		public void* generic_auth_data { get; set; }
		[NoAccessorMethod]
		public bool proxy { get; construct; }
		public string realm { get; construct; }
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_auth_domain_basic_get_type ()")]
	public class AuthDomainBasic : Soup.AuthDomain {
		[CCode (has_construct_function = false, type = "SoupAuthDomain*")]
		public AuthDomainBasic (string optname1, ...);
		public static void set_auth_callback (Soup.AuthDomain domain, owned Soup.AuthDomainBasicAuthCallback callback);
		[NoAccessorMethod]
		public void* auth_callback { get; set; }
		[NoAccessorMethod]
		public void* auth_data { get; set; }
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_auth_domain_digest_get_type ()")]
	public class AuthDomainDigest : Soup.AuthDomain {
		[CCode (has_construct_function = false, type = "SoupAuthDomain*")]
		public AuthDomainDigest (string optname1, ...);
		public static string encode_password (string username, string realm, string password);
		public static void set_auth_callback (Soup.AuthDomain domain, owned Soup.AuthDomainDigestAuthCallback callback);
		[NoAccessorMethod]
		public void* auth_callback { get; set; }
		[NoAccessorMethod]
		public void* auth_data { get; set; }
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_auth_manager_get_type ()")]
	public class AuthManager : GLib.Object, Soup.SessionFeature {
		[CCode (has_construct_function = false)]
		protected AuthManager ();
		public void use_auth (Soup.URI uri, Soup.Auth auth);
		public virtual signal void authenticate (Soup.Message msg, Soup.Auth auth, bool retrying);
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_auth_ntlm_get_type ()")]
	public class AuthNTLM : Soup.Auth {
		[CCode (has_construct_function = false)]
		protected AuthNTLM ();
	}
	[CCode (cheader_filename = "libsoup/soup.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "soup_buffer_get_type ()")]
	[Compact]
	public class Buffer {
		[CCode (array_length_cname = "length", array_length_type = "gsize")]
		public uint8[] data;
		public size_t length;
		[CCode (has_construct_function = false)]
		public Buffer (Soup.MemoryUse use, [CCode (array_length_cname = "length", array_length_pos = 2.1, array_length_type = "gsize", type = "gconstpointer")] uint8[] data);
		public Soup.Buffer copy ();
		public void free ();
		public GLib.Bytes get_as_bytes ();
		public void get_data ([CCode (array_length_cname = "length", array_length_pos = 1.1, array_length_type = "gsize")] out unowned uint8[] data);
		public void* get_owner ();
		[CCode (has_construct_function = false)]
		public Buffer.subbuffer (Soup.Buffer parent, size_t offset, size_t length);
		[CCode (has_construct_function = false)]
		public Buffer.take ([CCode (array_length_cname = "length", array_length_pos = 1.1, array_length_type = "gsize")] owned uint8[] data);
		[CCode (has_construct_function = false)]
		public Buffer.with_owner ([CCode (array_length_cname = "length", array_length_pos = 1.5, array_length_type = "gsize", type = "gconstpointer")] uint8[] data, void* owner, GLib.DestroyNotify? owner_dnotify);
	}
	[CCode (cheader_filename = "libsoup/soup.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "soup_byte_array_get_type ()")]
	[Compact]
	public class ByteArray {
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_cache_get_type ()")]
	public class Cache : GLib.Object, Soup.SessionFeature {
		[CCode (has_construct_function = false)]
		public Cache (string cache_dir, Soup.CacheType cache_type);
		public void clear ();
		public void dump ();
		public void flush ();
		[NoWrapper]
		public virtual Soup.Cacheability get_cacheability (Soup.Message msg);
		public uint get_max_size ();
		public void load ();
		public void set_max_size (uint max_size);
		[NoAccessorMethod]
		public string cache_dir { owned get; construct; }
		[NoAccessorMethod]
		public Soup.CacheType cache_type { get; construct; }
	}
	[CCode (cheader_filename = "libsoup/soup.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "soup_client_context_get_type ()")]
	[Compact]
	public class ClientContext {
		public unowned Soup.Address get_address ();
		public unowned Soup.AuthDomain get_auth_domain ();
		public unowned string get_auth_user ();
		public unowned string get_host ();
		public unowned Soup.Socket get_socket ();
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	[Compact]
	public class Connection {
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_content_decoder_get_type ()")]
	public class ContentDecoder : GLib.Object, Soup.SessionFeature {
		[CCode (has_construct_function = false)]
		protected ContentDecoder ();
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_content_sniffer_get_type ()")]
	public class ContentSniffer : GLib.Object, Soup.SessionFeature {
		[CCode (has_construct_function = false)]
		public ContentSniffer ();
		public virtual size_t get_buffer_size ();
		public virtual string sniff (Soup.Message msg, Soup.Buffer buffer, out GLib.HashTable<string,string>? @params);
	}
	[CCode (cheader_filename = "libsoup/soup.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "soup_cookie_get_type ()")]
	[Compact]
	public class Cookie {
		public weak string domain;
		public weak Soup.Date expires;
		public bool http_only;
		public weak string name;
		public weak string path;
		public bool secure;
		public weak string value;
		[CCode (has_construct_function = false)]
		public Cookie (string name, string value, string domain, string path, int max_age);
		public bool applies_to_uri (Soup.URI uri);
		public Soup.Cookie copy ();
		public bool domain_matches (string host);
		public bool equal (Soup.Cookie cookie2);
		public void free ();
		public unowned string get_domain ();
		public unowned Soup.Date get_expires ();
		public bool get_http_only ();
		public unowned string get_name ();
		public unowned string get_path ();
		public bool get_secure ();
		public unowned string get_value ();
		public static Soup.Cookie parse (string header, Soup.URI origin);
		public void set_domain (string domain);
		public void set_expires (Soup.Date expires);
		public void set_http_only (bool http_only);
		public void set_max_age (int max_age);
		public void set_name (string name);
		public void set_path (string path);
		public void set_secure (bool secure);
		public void set_value (string value);
		public string to_cookie_header ();
		public string to_set_cookie_header ();
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_cookie_jar_get_type ()")]
	public class CookieJar : GLib.Object, Soup.SessionFeature {
		[CCode (has_construct_function = false)]
		public CookieJar ();
		public void add_cookie (owned Soup.Cookie cookie);
		public void add_cookie_with_first_party (Soup.URI first_party, owned Soup.Cookie cookie);
		public GLib.SList<Soup.Cookie> all_cookies ();
		public void delete_cookie (Soup.Cookie cookie);
		public Soup.CookieJarAcceptPolicy get_accept_policy ();
		public GLib.SList<Soup.Cookie> get_cookie_list (Soup.URI uri, bool for_http);
		public string get_cookies (Soup.URI uri, bool for_http);
		public virtual bool is_persistent ();
		public virtual void save ();
		public void set_accept_policy (Soup.CookieJarAcceptPolicy policy);
		public void set_cookie (Soup.URI uri, string cookie);
		public void set_cookie_with_first_party (Soup.URI uri, Soup.URI first_party, string cookie);
		public Soup.CookieJarAcceptPolicy accept_policy { get; set; }
		[NoAccessorMethod]
		public bool read_only { get; construct; }
		public virtual signal void changed (Soup.Cookie old_cookie, Soup.Cookie new_cookie);
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_cookie_jar_db_get_type ()")]
	public class CookieJarDB : Soup.CookieJar, Soup.SessionFeature {
		[CCode (has_construct_function = false, type = "SoupCookieJar*")]
		public CookieJarDB (string filename, bool read_only);
		[NoAccessorMethod]
		public string filename { owned get; construct; }
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_cookie_jar_text_get_type ()")]
	public class CookieJarText : Soup.CookieJar, Soup.SessionFeature {
		[CCode (has_construct_function = false, type = "SoupCookieJar*")]
		public CookieJarText (string filename, bool read_only);
		[NoAccessorMethod]
		public string filename { owned get; construct; }
	}
	[CCode (cheader_filename = "libsoup/soup.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "soup_date_get_type ()")]
	[Compact]
	public class Date {
		public int day;
		public int hour;
		public int minute;
		public int month;
		public int offset;
		public int second;
		public bool utc;
		public int year;
		[CCode (has_construct_function = false)]
		public Date (int year, int month, int day, int hour, int minute, int second);
		public Soup.Date copy ();
		public void free ();
		[CCode (has_construct_function = false)]
		public Date.from_now (int offset_seconds);
		[CCode (has_construct_function = false)]
		public Date.from_string (string date_string);
		[CCode (has_construct_function = false)]
		public Date.from_time_t ([CCode (type = "time_t")] time_t when);
		public int get_day ();
		public int get_hour ();
		public int get_minute ();
		public int get_month ();
		public int get_offset ();
		public int get_second ();
		public int get_utc ();
		public int get_year ();
		public bool is_past ();
		public string to_string (Soup.DateFormat format);
		public time_t to_time_t ();
		public GLib.TimeVal to_timeval ();
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_logger_get_type ()")]
	public class Logger : GLib.Object, Soup.SessionFeature {
		[CCode (has_construct_function = false)]
		public Logger (Soup.LoggerLogLevel level, int max_body_size);
		public void set_printer (owned Soup.LoggerPrinter printer);
		public void set_request_filter (owned Soup.LoggerFilter request_filter);
		public void set_response_filter (owned Soup.LoggerFilter response_filter);
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_message_get_type ()")]
	public class Message : GLib.Object {
		public weak Soup.MessageBody request_body;
		public weak Soup.MessageHeaders request_headers;
		public weak Soup.MessageBody response_body;
		public weak Soup.MessageHeaders response_headers;
		[CCode (has_construct_function = false)]
		public Message (string method, string uri_string);
		public uint add_header_handler (string @signal, string header, GLib.Callback callback);
		public uint add_status_code_handler (string @signal, uint status_code, GLib.Callback callback);
		public void disable_feature (GLib.Type feature_type);
		[CCode (has_construct_function = false)]
		public Message.from_uri (string method, Soup.URI uri);
		public unowned Soup.Address get_address ();
		public unowned Soup.URI get_first_party ();
		public Soup.MessageFlags get_flags ();
		public Soup.HTTPVersion get_http_version ();
		public bool get_https_status (out unowned GLib.TlsCertificate certificate, out GLib.TlsCertificateFlags errors);
		public Soup.MessagePriority get_priority ();
		public unowned Soup.Request get_soup_request ();
		public unowned Soup.URI get_uri ();
		public bool is_keepalive ();
		public void set_chunk_allocator (owned Soup.ChunkAllocator allocator);
		public void set_first_party (Soup.URI first_party);
		public void set_flags (Soup.MessageFlags flags);
		public void set_http_version (Soup.HTTPVersion version);
		public void set_priority (Soup.MessagePriority priority);
		public void set_redirect (uint status_code, string redirect_uri);
		public void set_request (string content_type, Soup.MemoryUse req_use, [CCode (array_length_cname = "req_length", array_length_pos = 3.1, array_length_type = "gsize", type = "const char*")] uint8[] req_body);
		public void set_response (string? content_type, Soup.MemoryUse resp_use, [CCode (array_length_cname = "resp_length", array_length_pos = 3.1, array_length_type = "gsize")] uint8[] resp_body);
		public void set_status (uint status_code);
		public void set_status_full (uint status_code, string reason_phrase);
		public void set_uri (Soup.URI uri);
		public Soup.URI first_party { get; set; }
		public Soup.MessageFlags flags { get; set; }
		public Soup.HTTPVersion http_version { get; set; }
		[NoAccessorMethod]
		public string method { owned get; set; }
		public Soup.MessagePriority priority { get; set; }
		[NoAccessorMethod]
		public string reason_phrase { owned get; set; }
		[NoAccessorMethod]
		public bool server_side { get; construct; }
		[NoAccessorMethod]
		public uint status_code { get; set; }
		[NoAccessorMethod]
		public GLib.TlsCertificate tls_certificate { owned get; set; }
		[NoAccessorMethod]
		public GLib.TlsCertificateFlags tls_errors { get; set; }
		public Soup.URI uri { get; set; }
		[HasEmitter]
		public signal void content_sniffed (string content_type, GLib.HashTable<string,string> @params);
		[HasEmitter]
		public virtual signal void finished ();
		[HasEmitter]
		public virtual signal void got_body ();
		[HasEmitter]
		public virtual signal void got_chunk (Soup.Buffer chunk);
		[HasEmitter]
		public virtual signal void got_headers ();
		[HasEmitter]
		public virtual signal void got_informational ();
		public signal void network_event (GLib.SocketClientEvent event, GLib.IOStream connection);
		[HasEmitter]
		public virtual signal void restarted ();
		[HasEmitter]
		public virtual signal void wrote_body ();
		[HasEmitter]
		public signal void wrote_body_data (Soup.Buffer chunk);
		[HasEmitter]
		public virtual signal void wrote_chunk ();
		[HasEmitter]
		public virtual signal void wrote_headers ();
		[HasEmitter]
		public virtual signal void wrote_informational ();
	}
	[CCode (cheader_filename = "libsoup/soup.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "soup_message_body_get_type ()")]
	[Compact]
	public class MessageBody {
		[CCode (array_length_cname = "length", array_length_type = "gint64")]
		public uint8[] data;
		public int64 length;
		[CCode (has_construct_function = false)]
		public MessageBody ();
		public void append (Soup.MemoryUse use, [CCode (array_length_cname = "length", array_length_pos = 2.1, array_length_type = "gsize")] uint8[] data);
		public void append_buffer (Soup.Buffer buffer);
		public void append_take ([CCode (array_length_cname = "length", array_length_pos = 1.1, array_length_type = "gsize")] owned uint8[] data);
		public void complete ();
		public Soup.Buffer flatten ();
		public void free ();
		public bool get_accumulate ();
		public Soup.Buffer get_chunk (int64 offset);
		public void got_chunk (Soup.Buffer chunk);
		public void set_accumulate (bool accumulate);
		public void truncate ();
		public void wrote_chunk (Soup.Buffer chunk);
	}
	[CCode (cheader_filename = "libsoup/soup.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "soup_message_headers_get_type ()")]
	[Compact]
	public class MessageHeaders {
		[CCode (has_construct_function = false)]
		public MessageHeaders (Soup.MessageHeadersType type);
		public void append (string name, string value);
		public void clean_connection_headers ();
		public void clear ();
		public void @foreach (Soup.MessageHeadersForeachFunc func);
		public void free ();
		public void free_ranges (Soup.Range ranges);
		public unowned string @get (string name);
		public bool get_content_disposition (out string disposition, out GLib.HashTable<string,string> @params);
		public int64 get_content_length ();
		public bool get_content_range (int64 start, int64 end, int64 total_length);
		public unowned string get_content_type (out GLib.HashTable<string,string> @params);
		public Soup.Encoding get_encoding ();
		public Soup.Expectation get_expectations ();
		public unowned string get_list (string name);
		public unowned string get_one (string name);
		public bool get_ranges (int64 total_length, [CCode (array_length_cname = "length", array_length_pos = 2.1, type = "SoupRange**")] out Soup.Range[] ranges);
		public void remove (string name);
		public void replace (string name, string value);
		public void set_content_disposition (string disposition, GLib.HashTable<string,string>? @params);
		public void set_content_length (int64 content_length);
		public void set_content_range (int64 start, int64 end, int64 total_length);
		public void set_content_type (string content_type, GLib.HashTable<string,string>? @params);
		public void set_encoding (Soup.Encoding encoding);
		public void set_expectations (Soup.Expectation expectations);
		public void set_range (int64 start, int64 end);
		public void set_ranges (Soup.Range ranges, int length);
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	[Compact]
	public class MessageQueue {
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	[Compact]
	public class MessageQueueItem {
	}
	[CCode (cheader_filename = "libsoup/soup.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "soup_multipart_get_type ()")]
	[Compact]
	public class Multipart {
		[CCode (has_construct_function = false)]
		public Multipart (string mime_type);
		public void append_form_file (string control_name, string filename, string content_type, Soup.Buffer body);
		public void append_form_string (string control_name, string data);
		public void append_part (Soup.MessageHeaders headers, Soup.Buffer body);
		public void free ();
		[CCode (has_construct_function = false)]
		public Multipart.from_message (Soup.MessageHeaders headers, Soup.MessageBody body);
		public int get_length ();
		public bool get_part (int part, out unowned Soup.MessageHeaders headers, out unowned Soup.Buffer body);
		public void to_message (Soup.MessageHeaders dest_headers, Soup.MessageBody dest_body);
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_multipart_input_stream_get_type ()")]
	public class MultipartInputStream : GLib.FilterInputStream, GLib.PollableInputStream {
		[CCode (has_construct_function = false)]
		public MultipartInputStream (Soup.Message msg, GLib.InputStream base_stream);
		public unowned Soup.MessageHeaders get_headers ();
		public GLib.InputStream next_part (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async GLib.InputStream next_part_async (int io_priority, GLib.Cancellable? cancellable) throws GLib.Error;
		[NoAccessorMethod]
		public Soup.Message message { owned get; construct; }
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_proxy_resolver_default_get_type ()")]
	public class ProxyResolverDefault : GLib.Object, Soup.ProxyURIResolver, Soup.SessionFeature {
		[CCode (has_construct_function = false)]
		protected ProxyResolverDefault ();
		[NoAccessorMethod]
		public GLib.ProxyResolver gproxy_resolver { set; }
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_request_get_type ()")]
	public class Request : GLib.Object, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected Request ();
		[NoWrapper]
		public virtual bool check_uri (Soup.URI uri) throws GLib.Error;
		public virtual int64 get_content_length ();
		public virtual unowned string get_content_type ();
		public unowned Soup.Session get_session ();
		public unowned Soup.URI get_uri ();
		public virtual GLib.InputStream send (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual async GLib.InputStream send_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public Soup.Session session { get; construct; }
		public Soup.URI uri { get; construct; }
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_request_data_get_type ()")]
	public class RequestData : Soup.Request, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected RequestData ();
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_request_file_get_type ()")]
	public class RequestFile : Soup.Request, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected RequestFile ();
		public GLib.File get_file ();
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_request_http_get_type ()")]
	public class RequestHTTP : Soup.Request, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected RequestHTTP ();
		public Soup.Message get_message ();
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_requester_get_type ()")]
	[Deprecated (replacement = "Session", since = "2.42")]
	public class Requester : GLib.Object, Soup.SessionFeature {
		[CCode (has_construct_function = false)]
		public Requester ();
		public Soup.Request request (string uri_string) throws GLib.Error;
		public Soup.Request request_uri (Soup.URI uri) throws GLib.Error;
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_server_get_type ()")]
	public class Server : GLib.Object {
		[CCode (has_construct_function = false)]
		public Server (string optname1, ...);
		public void add_auth_domain (Soup.AuthDomain auth_domain);
		public void add_handler (string? path, owned Soup.ServerCallback callback);
		public void disconnect ();
		public unowned GLib.MainContext get_async_context ();
		public unowned Soup.Socket get_listener ();
		public uint get_port ();
		public bool is_https ();
		public void pause_message (Soup.Message msg);
		public void quit ();
		public void remove_auth_domain (Soup.AuthDomain auth_domain);
		public void remove_handler (string path);
		public void run ();
		public void run_async ();
		public void unpause_message (Soup.Message msg);
		public GLib.MainContext async_context { get; owned construct; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] http_aliases { owned get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] https_aliases { owned get; set; }
		[NoAccessorMethod]
		public Soup.Address @interface { owned get; construct; }
		public uint port { get; construct; }
		[NoAccessorMethod]
		public bool raw_paths { get; construct; }
		[NoAccessorMethod]
		public string server_header { owned get; set construct; }
		[NoAccessorMethod]
		public string ssl_cert_file { owned get; construct; }
		[NoAccessorMethod]
		public string ssl_key_file { owned get; construct; }
		[NoAccessorMethod]
		public GLib.TlsCertificate tls_certificate { owned get; construct; }
		public virtual signal void request_aborted (Soup.Message msg, Soup.ClientContext client);
		public virtual signal void request_finished (Soup.Message msg, Soup.ClientContext client);
		public virtual signal void request_read (Soup.Message msg, Soup.ClientContext client);
		public virtual signal void request_started (Soup.Message msg, Soup.ClientContext client);
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_session_get_type ()")]
	public class Session : GLib.Object {
		[CCode (has_construct_function = false)]
		public Session ();
		public void abort ();
		public void add_feature (Soup.SessionFeature feature);
		public void add_feature_by_type (GLib.Type feature_type);
		[NoWrapper]
		public virtual void auth_required (Soup.Message msg, Soup.Auth auth, bool retrying);
		public virtual void cancel_message (Soup.Message msg, uint status_code);
		[NoWrapper]
		public virtual void flush_queue ();
		public unowned GLib.MainContext get_async_context ();
		public unowned Soup.SessionFeature get_feature (GLib.Type feature_type);
		public unowned Soup.SessionFeature get_feature_for_message (GLib.Type feature_type, Soup.Message msg);
		public GLib.SList<Soup.SessionFeature> get_features (GLib.Type feature_type);
		public bool has_feature (GLib.Type feature_type);
		[NoWrapper]
		public virtual void kick ();
		public void pause_message (Soup.Message msg);
		public void prefetch_dns (string hostname, GLib.Cancellable? cancellable, [CCode (scope = "async")] owned Soup.AddressCallback? callback);
		[Deprecated (since = "2.38")]
		public void prepare_for_uri (Soup.URI uri);
		public virtual void queue_message (owned Soup.Message msg, [CCode (scope = "async")] owned Soup.SessionCallback? callback);
		public bool redirect_message (Soup.Message msg);
		public void remove_feature (Soup.SessionFeature feature);
		public void remove_feature_by_type (GLib.Type feature_type);
		public Soup.Request request (string uri_string) throws GLib.Error;
		public Soup.RequestHTTP request_http (string method, string uri_string) throws GLib.Error;
		public Soup.RequestHTTP request_http_uri (string method, Soup.URI uri) throws GLib.Error;
		public Soup.Request request_uri (Soup.URI uri) throws GLib.Error;
		public virtual void requeue_message (Soup.Message msg);
		public GLib.InputStream send (Soup.Message msg, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async GLib.InputStream send_async (Soup.Message msg, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual uint send_message (Soup.Message msg);
		public void unpause_message (Soup.Message msg);
		[CCode (has_construct_function = false)]
		public Session.with_options (string optname1, ...);
		public bool would_redirect (Soup.Message msg);
		[NoAccessorMethod]
		public string accept_language { owned get; set; }
		[NoAccessorMethod]
		public bool accept_language_auto { get; set; }
		public GLib.MainContext async_context { get; owned construct; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] http_aliases { owned get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] https_aliases { owned get; set; }
		[NoAccessorMethod]
		public uint idle_timeout { get; set; }
		[NoAccessorMethod]
		public Soup.Address local_address { owned get; construct; }
		[NoAccessorMethod]
		public int max_conns { get; set; }
		[NoAccessorMethod]
		public int max_conns_per_host { get; set; }
		[NoAccessorMethod]
		public GLib.ProxyResolver proxy_resolver { owned get; set; }
		[NoAccessorMethod]
		public Soup.URI proxy_uri { owned get; set; }
		[NoAccessorMethod]
		public string ssl_ca_file { owned get; set; }
		[NoAccessorMethod]
		public bool ssl_strict { get; set; }
		[NoAccessorMethod]
		public bool ssl_use_system_ca_file { get; set; }
		[NoAccessorMethod]
		public uint timeout { get; set; }
		[NoAccessorMethod]
		public GLib.TlsDatabase tls_database { owned get; set; }
		[NoAccessorMethod]
		public bool use_ntlm { get; set; }
		[NoAccessorMethod]
		public bool use_thread_context { get; set; }
		[NoAccessorMethod]
		public string user_agent { owned get; set; }
		public virtual signal void authenticate (Soup.Message msg, Soup.Auth auth, bool retrying);
		public signal void connection_created (GLib.Object connection);
		public signal void request_queued (Soup.Message msg);
		public virtual signal void request_started (Soup.Message msg, Soup.Socket socket);
		public signal void request_unqueued (Soup.Message msg);
		public signal void tunneling (GLib.Object connection);
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_session_async_get_type ()")]
	public class SessionAsync : Soup.Session {
		[CCode (has_construct_function = false, type = "SoupSession*")]
		public SessionAsync ();
		[CCode (has_construct_function = false, type = "SoupSession*")]
		public SessionAsync.with_options (string optname1, ...);
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_session_sync_get_type ()")]
	public class SessionSync : Soup.Session {
		[CCode (has_construct_function = false, type = "SoupSession*")]
		public SessionSync ();
		[CCode (has_construct_function = false, type = "SoupSession*")]
		public SessionSync.with_options (string optname1, ...);
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_socket_get_type ()")]
	public class Socket : GLib.Object {
		[CCode (has_construct_function = false)]
		public Socket (string optname1, ...);
		public void connect_async (GLib.Cancellable? cancellable, [CCode (scope = "async")] owned Soup.SocketCallback callback);
		public uint connect_sync (GLib.Cancellable? cancellable = null);
		public void disconnect ();
		public int get_fd ();
		public unowned Soup.Address get_local_address ();
		public unowned Soup.Address get_remote_address ();
		public bool is_connected ();
		public bool is_ssl ();
		public bool listen ();
		public Soup.SocketIOStatus read ([CCode (array_length_cname = "len", array_length_pos = 1.5, array_length_type = "gsize", type = "gpointer")] uint8[] buffer, out size_t nread, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public Soup.SocketIOStatus read_until ([CCode (array_length_cname = "len", array_length_pos = 1.5, array_length_type = "gsize", type = "gpointer")] uint8[] buffer, void* boundary, size_t boundary_len, out size_t nread, bool got_boundary, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool start_proxy_ssl (string ssl_host, GLib.Cancellable? cancellable = null);
		public bool start_ssl (GLib.Cancellable? cancellable = null);
		public Soup.SocketIOStatus write ([CCode (array_length_cname = "len", array_length_pos = 1.5, array_length_type = "gsize", type = "gconstpointer")] uint8[] buffer, out size_t nwrote, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[NoAccessorMethod]
		public GLib.MainContext async_context { owned get; construct; }
		public bool clean_dispose { construct; }
		[NoAccessorMethod]
		public bool is_server { get; }
		public Soup.Address local_address { get; construct; }
		[NoAccessorMethod]
		public bool non_blocking { get; set; }
		[NoAccessorMethod]
		public GLib.ProxyResolver proxy_resolver { owned get; construct; }
		public Soup.Address remote_address { get; construct; }
		[NoAccessorMethod]
		public void* ssl_creds { get; set; }
		[NoAccessorMethod]
		public bool ssl_fallback { get; construct; }
		[NoAccessorMethod]
		public bool ssl_strict { get; construct; }
		[NoAccessorMethod]
		public uint timeout { get; set; }
		[NoAccessorMethod]
		public GLib.TlsCertificate tls_certificate { owned get; }
		[NoAccessorMethod]
		public GLib.TlsCertificateFlags tls_errors { get; }
		[NoAccessorMethod]
		public bool trusted_certificate { get; }
		[NoAccessorMethod]
		public bool use_thread_context { get; construct; }
		public virtual signal void disconnected ();
		public signal void event (GLib.SocketClientEvent event, GLib.IOStream connection);
		public virtual signal void new_connection (Soup.Socket new_sock);
		public virtual signal void readable ();
		public virtual signal void writable ();
	}
	[CCode (cheader_filename = "libsoup/soup.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "soup_uri_get_type ()")]
	[Compact]
	public class URI {
		public weak string fragment;
		public weak string host;
		public weak string password;
		public weak string path;
		public uint port;
		public weak string query;
		public weak string scheme;
		public weak string user;
		[CCode (has_construct_function = false)]
		public URI (string? uri_string);
		public Soup.URI copy ();
		public Soup.URI copy_host ();
		public static string decode (string part);
		public static string encode (string part, string? escape_extra);
		public bool equal (Soup.URI uri2);
		public void free ();
		public unowned string get_fragment ();
		public unowned string get_host ();
		public unowned string get_password ();
		public unowned string get_path ();
		public uint get_port ();
		public unowned string get_query ();
		public unowned string get_scheme ();
		public unowned string get_user ();
		public bool host_equal (Soup.URI v2);
		public uint host_hash ();
		public static string normalize (string part, string unescape_extra);
		public void set_fragment (string? fragment);
		public void set_host (string? host);
		public void set_password (string? password);
		public void set_path (string path);
		public void set_port (uint port);
		public void set_query (string? query);
		public void set_query_from_fields (...);
		public void set_query_from_form (GLib.HashTable<string,string> form);
		public void set_scheme (string scheme);
		public void set_user (string? user);
		public string to_string (bool just_path_and_query);
		public bool uses_default_port ();
		[CCode (has_construct_function = false)]
		public URI.with_base (Soup.URI @base, string uri_string);
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_cname = "SoupPasswordManagerInterface", type_id = "soup_password_manager_get_type ()")]
	public interface PasswordManager : Soup.SessionFeature, GLib.Object {
		public abstract void get_passwords_async (Soup.Message msg, Soup.Auth auth, bool retrying, GLib.MainContext async_context, GLib.Cancellable? cancellable, [CCode (scope = "async")] owned Soup.PasswordManagerCallback callback);
		public abstract void get_passwords_sync (Soup.Message msg, Soup.Auth auth, GLib.Cancellable? cancellable = null);
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_cname = "SoupProxyResolverInterface", type_id = "soup_proxy_resolver_get_type ()")]
	[Deprecated (replacement = "Soup.ProxyURIResolver")]
	public interface ProxyResolver : Soup.SessionFeature, GLib.Object {
		public abstract void get_proxy_async (Soup.Message msg, GLib.MainContext async_context, GLib.Cancellable? cancellable, Soup.ProxyResolverCallback callback);
		public abstract uint get_proxy_sync (Soup.Message msg, GLib.Cancellable? cancellable, out unowned Soup.Address addr);
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_cname = "SoupProxyURIResolverInterface", type_id = "soup_proxy_uri_resolver_get_type ()")]
	public interface ProxyURIResolver : Soup.SessionFeature, GLib.Object {
		public abstract void get_proxy_uri_async (Soup.URI uri, GLib.MainContext? async_context, GLib.Cancellable? cancellable, [CCode (scope = "async")] owned Soup.ProxyURIResolverCallback callback);
		public abstract uint get_proxy_uri_sync (Soup.URI uri, GLib.Cancellable? cancellable, out Soup.URI proxy_uri);
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_cname = "SoupSessionFeatureInterface", type_id = "soup_session_feature_get_type ()")]
	public interface SessionFeature : GLib.Object {
		public abstract bool add_feature (GLib.Type type);
		public abstract void attach (Soup.Session session);
		public abstract void detach (Soup.Session session);
		public abstract bool has_feature (GLib.Type type);
		public abstract bool remove_feature (GLib.Type type);
		[NoWrapper]
		public abstract void request_queued (Soup.Session session, Soup.Message msg);
		[NoWrapper]
		public abstract void request_started (Soup.Session session, Soup.Message msg, Soup.Socket socket);
		[NoWrapper]
		public abstract void request_unqueued (Soup.Session session, Soup.Message msg);
	}
	[CCode (cheader_filename = "libsoup/soup.h", has_type_id = false)]
	public struct MessageHeadersIter {
		public static void init (out Soup.MessageHeadersIter iter, Soup.MessageHeaders hdrs);
		public bool next (out unowned string name, out unowned string value);
	}
	[CCode (cheader_filename = "libsoup/soup.h", has_type_id = false)]
	public struct Range {
		public int64 start;
		public int64 end;
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_ADDRESS_FAMILY_", type_id = "soup_address_family_get_type ()")]
	public enum AddressFamily {
		INVALID,
		IPV4,
		IPV6
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_CACHE_RESPONSE_", type_id = "soup_cache_response_get_type ()")]
	public enum CacheResponse {
		FRESH,
		NEEDS_VALIDATION,
		STALE
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_CACHE_", type_id = "soup_cache_type_get_type ()")]
	public enum CacheType {
		SINGLE_USER,
		SHARED
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_CACHE_", type_id = "soup_cacheability_get_type ()")]
	[Flags]
	public enum Cacheability {
		CACHEABLE,
		UNCACHEABLE,
		INVALIDATES,
		VALIDATES
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_CONNECTION_", type_id = "soup_connection_state_get_type ()")]
	public enum ConnectionState {
		NEW,
		CONNECTING,
		IDLE,
		IN_USE,
		REMOTE_DISCONNECTED,
		DISCONNECTED
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_COOKIE_JAR_ACCEPT_", type_id = "soup_cookie_jar_accept_policy_get_type ()")]
	public enum CookieJarAcceptPolicy {
		ALWAYS,
		NEVER,
		NO_THIRD_PARTY
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_DATE_", type_id = "soup_date_format_get_type ()")]
	public enum DateFormat {
		HTTP,
		COOKIE,
		RFC2822,
		ISO8601_COMPACT,
		ISO8601_FULL,
		ISO8601,
		ISO8601_XMLRPC
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_ENCODING_", type_id = "soup_encoding_get_type ()")]
	public enum Encoding {
		UNRECOGNIZED,
		NONE,
		CONTENT_LENGTH,
		EOF,
		CHUNKED,
		BYTERANGES
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_EXPECTATION_", type_id = "soup_expectation_get_type ()")]
	[Flags]
	public enum Expectation {
		UNRECOGNIZED,
		CONTINUE
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_HTTP_", type_id = "soup_http_version_get_type ()")]
	public enum HTTPVersion {
		@1_0,
		@1_1
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_STATUS_", type_id = "soup_known_status_code_get_type ()")]
	[Deprecated (replacement = "Status", since = "vala-0.22")]
	public enum KnownStatusCode {
		NONE,
		CANCELLED,
		CANT_RESOLVE,
		CANT_RESOLVE_PROXY,
		CANT_CONNECT,
		CANT_CONNECT_PROXY,
		SSL_FAILED,
		IO_ERROR,
		MALFORMED,
		TRY_AGAIN,
		TOO_MANY_REDIRECTS,
		TLS_FAILED,
		CONTINUE,
		SWITCHING_PROTOCOLS,
		PROCESSING,
		OK,
		CREATED,
		ACCEPTED,
		NON_AUTHORITATIVE,
		NO_CONTENT,
		RESET_CONTENT,
		PARTIAL_CONTENT,
		MULTI_STATUS,
		MULTIPLE_CHOICES,
		MOVED_PERMANENTLY,
		FOUND,
		MOVED_TEMPORARILY,
		SEE_OTHER,
		NOT_MODIFIED,
		USE_PROXY,
		NOT_APPEARING_IN_THIS_PROTOCOL,
		TEMPORARY_REDIRECT,
		BAD_REQUEST,
		UNAUTHORIZED,
		PAYMENT_REQUIRED,
		FORBIDDEN,
		NOT_FOUND,
		METHOD_NOT_ALLOWED,
		NOT_ACCEPTABLE,
		PROXY_AUTHENTICATION_REQUIRED,
		PROXY_UNAUTHORIZED,
		REQUEST_TIMEOUT,
		CONFLICT,
		GONE,
		LENGTH_REQUIRED,
		PRECONDITION_FAILED,
		REQUEST_ENTITY_TOO_LARGE,
		REQUEST_URI_TOO_LONG,
		UNSUPPORTED_MEDIA_TYPE,
		REQUESTED_RANGE_NOT_SATISFIABLE,
		INVALID_RANGE,
		EXPECTATION_FAILED,
		UNPROCESSABLE_ENTITY,
		LOCKED,
		FAILED_DEPENDENCY,
		INTERNAL_SERVER_ERROR,
		NOT_IMPLEMENTED,
		BAD_GATEWAY,
		SERVICE_UNAVAILABLE,
		GATEWAY_TIMEOUT,
		HTTP_VERSION_NOT_SUPPORTED,
		INSUFFICIENT_STORAGE,
		NOT_EXTENDED
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_LOGGER_LOG_", type_id = "soup_logger_log_level_get_type ()")]
	public enum LoggerLogLevel {
		NONE,
		MINIMAL,
		HEADERS,
		BODY
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_MEMORY_", type_id = "soup_memory_use_get_type ()")]
	public enum MemoryUse {
		STATIC,
		TAKE,
		COPY,
		TEMPORARY
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_MESSAGE_", type_id = "soup_message_flags_get_type ()")]
	[Flags]
	public enum MessageFlags {
		NO_REDIRECT,
		CAN_REBUILD,
		OVERWRITE_CHUNKS,
		CONTENT_DECODED,
		CERTIFICATE_TRUSTED,
		NEW_CONNECTION,
		IDEMPOTENT
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_MESSAGE_HEADERS_", type_id = "soup_message_headers_type_get_type ()")]
	public enum MessageHeadersType {
		REQUEST,
		RESPONSE,
		MULTIPART
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_MESSAGE_PRIORITY_", type_id = "soup_message_priority_get_type ()")]
	public enum MessagePriority {
		VERY_LOW,
		LOW,
		NORMAL,
		HIGH,
		VERY_HIGH
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_SOCKET_", type_id = "soup_socket_io_status_get_type ()")]
	public enum SocketIOStatus {
		OK,
		WOULD_BLOCK,
		EOF,
		ERROR
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_STATUS_", type_id = "soup_status_get_type ()")]
	public enum Status {
		NONE,
		CANCELLED,
		CANT_RESOLVE,
		CANT_RESOLVE_PROXY,
		CANT_CONNECT,
		CANT_CONNECT_PROXY,
		SSL_FAILED,
		IO_ERROR,
		MALFORMED,
		TRY_AGAIN,
		TOO_MANY_REDIRECTS,
		TLS_FAILED,
		CONTINUE,
		SWITCHING_PROTOCOLS,
		PROCESSING,
		OK,
		CREATED,
		ACCEPTED,
		NON_AUTHORITATIVE,
		NO_CONTENT,
		RESET_CONTENT,
		PARTIAL_CONTENT,
		MULTI_STATUS,
		MULTIPLE_CHOICES,
		MOVED_PERMANENTLY,
		FOUND,
		MOVED_TEMPORARILY,
		SEE_OTHER,
		NOT_MODIFIED,
		USE_PROXY,
		NOT_APPEARING_IN_THIS_PROTOCOL,
		TEMPORARY_REDIRECT,
		BAD_REQUEST,
		UNAUTHORIZED,
		PAYMENT_REQUIRED,
		FORBIDDEN,
		NOT_FOUND,
		METHOD_NOT_ALLOWED,
		NOT_ACCEPTABLE,
		PROXY_AUTHENTICATION_REQUIRED,
		PROXY_UNAUTHORIZED,
		REQUEST_TIMEOUT,
		CONFLICT,
		GONE,
		LENGTH_REQUIRED,
		PRECONDITION_FAILED,
		REQUEST_ENTITY_TOO_LARGE,
		REQUEST_URI_TOO_LONG,
		UNSUPPORTED_MEDIA_TYPE,
		REQUESTED_RANGE_NOT_SATISFIABLE,
		INVALID_RANGE,
		EXPECTATION_FAILED,
		UNPROCESSABLE_ENTITY,
		LOCKED,
		FAILED_DEPENDENCY,
		INTERNAL_SERVER_ERROR,
		NOT_IMPLEMENTED,
		BAD_GATEWAY,
		SERVICE_UNAVAILABLE,
		GATEWAY_TIMEOUT,
		HTTP_VERSION_NOT_SUPPORTED,
		INSUFFICIENT_STORAGE,
		NOT_EXTENDED;
		public static unowned string get_phrase (uint status_code);
		public static uint proxify (uint status_code);
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_REQUEST_ERROR_")]
	public errordomain RequestError {
		BAD_URI,
		UNSUPPORTED_URI_SCHEME,
		PARSING,
		ENCODING;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_REQUESTER_ERROR_")]
	public errordomain RequesterError {
		BAD_URI,
		UNSUPPORTED_URI_SCHEME;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public errordomain SSLError {
		HANDSHAKE_NEEDS_READ,
		HANDSHAKE_NEEDS_WRITE,
		CERTIFICATE,
		HANDSHAKE_FAILED;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_TLD_ERROR_")]
	public errordomain TLDError {
		INVALID_HOSTNAME,
		IS_IP_ADDRESS,
		NOT_ENOUGH_DOMAINS,
		NO_BASE_DOMAIN;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "libsoup/soup.h", instance_pos = 2.9)]
	public delegate void AddressCallback (Soup.Address addr, uint status);
	[CCode (cheader_filename = "libsoup/soup.h", instance_pos = 4.9)]
	public delegate bool AuthDomainBasicAuthCallback (Soup.AuthDomain domain, Soup.Message msg, string username, string password);
	[CCode (cheader_filename = "libsoup/soup.h", instance_pos = 3.9)]
	public delegate string AuthDomainDigestAuthCallback (Soup.AuthDomain domain, Soup.Message msg, string username);
	[CCode (cheader_filename = "libsoup/soup.h", instance_pos = 2.9)]
	public delegate bool AuthDomainFilter (Soup.AuthDomain domain, Soup.Message msg);
	[CCode (cheader_filename = "libsoup/soup.h", instance_pos = 3.9)]
	public delegate bool AuthDomainGenericAuthCallback (Soup.AuthDomain domain, Soup.Message msg, string username);
	[CCode (cheader_filename = "libsoup/soup.h", instance_pos = 2.9)]
	public delegate Soup.Buffer ChunkAllocator (Soup.Message msg, size_t max_len);
	[CCode (cheader_filename = "libsoup/soup.h", instance_pos = 2.9)]
	public delegate Soup.LoggerLogLevel LoggerFilter (Soup.Logger logger, Soup.Message msg);
	[CCode (cheader_filename = "libsoup/soup.h", instance_pos = 4.9)]
	public delegate void LoggerPrinter (Soup.Logger logger, Soup.LoggerLogLevel level, char direction, string data);
	[CCode (cheader_filename = "libsoup/soup.h", instance_pos = 2.9)]
	public delegate void MessageHeadersForeachFunc (string name, string value);
	[CCode (cheader_filename = "libsoup/soup.h", instance_pos = 4.9)]
	public delegate void PasswordManagerCallback (Soup.PasswordManager password_manager, Soup.Message msg, Soup.Auth auth, bool retrying);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public delegate void ProxyResolverCallback (Soup.ProxyResolver p1, Soup.Message p2, uint p3, Soup.Address p4);
	[CCode (cheader_filename = "libsoup/soup.h", has_target = false)]
	public delegate void ProxyURIResolverCallback (Soup.ProxyURIResolver resolver, uint status, Soup.URI proxy_uri);
	[CCode (cheader_filename = "libsoup/soup.h", instance_pos = 5.9)]
	public delegate void ServerCallback (Soup.Server server, Soup.Message msg, string path, GLib.HashTable<string,string>? query, Soup.ClientContext client);
	[CCode (cheader_filename = "libsoup/soup.h", instance_pos = 2.9)]
	public delegate void SessionCallback (Soup.Session session, Soup.Message msg);
	[CCode (cheader_filename = "libsoup/soup.h", instance_pos = 2.9)]
	public delegate void SocketCallback (Soup.Socket sock, uint status);
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_ADDRESS_ANY_PORT")]
	public const int ADDRESS_ANY_PORT;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_ADDRESS_FAMILY")]
	public const string ADDRESS_FAMILY;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_ADDRESS_NAME")]
	public const string ADDRESS_NAME;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_ADDRESS_PHYSICAL")]
	public const string ADDRESS_PHYSICAL;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_ADDRESS_PORT")]
	public const string ADDRESS_PORT;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_ADDRESS_PROTOCOL")]
	public const string ADDRESS_PROTOCOL;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_ADDRESS_SOCKADDR")]
	public const string ADDRESS_SOCKADDR;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_AUTH_DOMAIN_ADD_PATH")]
	public const string AUTH_DOMAIN_ADD_PATH;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_AUTH_DOMAIN_BASIC_AUTH_CALLBACK")]
	public const string AUTH_DOMAIN_BASIC_AUTH_CALLBACK;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_AUTH_DOMAIN_BASIC_AUTH_DATA")]
	public const string AUTH_DOMAIN_BASIC_AUTH_DATA;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_AUTH_DOMAIN_BASIC_H")]
	public const int AUTH_DOMAIN_BASIC_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_AUTH_DOMAIN_DIGEST_AUTH_CALLBACK")]
	public const string AUTH_DOMAIN_DIGEST_AUTH_CALLBACK;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_AUTH_DOMAIN_DIGEST_AUTH_DATA")]
	public const string AUTH_DOMAIN_DIGEST_AUTH_DATA;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_AUTH_DOMAIN_DIGEST_H")]
	public const int AUTH_DOMAIN_DIGEST_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_AUTH_DOMAIN_FILTER")]
	public const string AUTH_DOMAIN_FILTER;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_AUTH_DOMAIN_FILTER_DATA")]
	public const string AUTH_DOMAIN_FILTER_DATA;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_AUTH_DOMAIN_GENERIC_AUTH_CALLBACK")]
	public const string AUTH_DOMAIN_GENERIC_AUTH_CALLBACK;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_AUTH_DOMAIN_GENERIC_AUTH_DATA")]
	public const string AUTH_DOMAIN_GENERIC_AUTH_DATA;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_AUTH_DOMAIN_H")]
	public const int AUTH_DOMAIN_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_AUTH_DOMAIN_PROXY")]
	public const string AUTH_DOMAIN_PROXY;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_AUTH_DOMAIN_REALM")]
	public const string AUTH_DOMAIN_REALM;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_AUTH_DOMAIN_REMOVE_PATH")]
	public const string AUTH_DOMAIN_REMOVE_PATH;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_AUTH_H")]
	public const int AUTH_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_AUTH_HOST")]
	public const string AUTH_HOST;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_AUTH_IS_AUTHENTICATED")]
	public const string AUTH_IS_AUTHENTICATED;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_AUTH_IS_FOR_PROXY")]
	public const string AUTH_IS_FOR_PROXY;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_AUTH_MANAGER_H")]
	public const int AUTH_MANAGER_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_AUTH_REALM")]
	public const string AUTH_REALM;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_AUTH_SCHEME_NAME")]
	public const string AUTH_SCHEME_NAME;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_CACHE_H")]
	public const int CACHE_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_CHAR_HTTP_CTL")]
	public const int CHAR_HTTP_CTL;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_CHAR_HTTP_SEPARATOR")]
	public const int CHAR_HTTP_SEPARATOR;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_CHAR_URI_GEN_DELIMS")]
	public const int CHAR_URI_GEN_DELIMS;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_CHAR_URI_PERCENT_ENCODED")]
	public const int CHAR_URI_PERCENT_ENCODED;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_CHAR_URI_SUB_DELIMS")]
	public const int CHAR_URI_SUB_DELIMS;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_CONTENT_DECODER_H")]
	public const int CONTENT_DECODER_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_CONTENT_SNIFFER_H")]
	public const int CONTENT_SNIFFER_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_COOKIE_H")]
	public const int COOKIE_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_COOKIE_JAR_ACCEPT_POLICY")]
	public const string COOKIE_JAR_ACCEPT_POLICY;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_COOKIE_JAR_DB_FILENAME")]
	public const string COOKIE_JAR_DB_FILENAME;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_COOKIE_JAR_DB_H")]
	public const int COOKIE_JAR_DB_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_COOKIE_JAR_H")]
	public const int COOKIE_JAR_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_COOKIE_JAR_READ_ONLY")]
	public const string COOKIE_JAR_READ_ONLY;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_COOKIE_JAR_TEXT_FILENAME")]
	public const string COOKIE_JAR_TEXT_FILENAME;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_COOKIE_JAR_TEXT_H")]
	public const int COOKIE_JAR_TEXT_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_COOKIE_MAX_AGE_ONE_DAY")]
	public const int COOKIE_MAX_AGE_ONE_DAY;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_COOKIE_MAX_AGE_ONE_HOUR")]
	public const int COOKIE_MAX_AGE_ONE_HOUR;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_COOKIE_MAX_AGE_ONE_WEEK")]
	public const int COOKIE_MAX_AGE_ONE_WEEK;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_COOKIE_MAX_AGE_ONE_YEAR")]
	public const int COOKIE_MAX_AGE_ONE_YEAR;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_DATE_H")]
	public const int DATE_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_FORM_H")]
	public const int FORM_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_FORM_MIME_TYPE_MULTIPART")]
	public const string FORM_MIME_TYPE_MULTIPART;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_FORM_MIME_TYPE_URLENCODED")]
	public const string FORM_MIME_TYPE_URLENCODED;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_HEADERS_H")]
	public const int HEADERS_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_LOGGER_H")]
	public const int LOGGER_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_MESSAGE_BODY_H")]
	public const int MESSAGE_BODY_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_MESSAGE_FIRST_PARTY")]
	public const string MESSAGE_FIRST_PARTY;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_MESSAGE_FLAGS")]
	public const string MESSAGE_FLAGS;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_MESSAGE_H")]
	public const int MESSAGE_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_MESSAGE_HEADERS_H")]
	public const int MESSAGE_HEADERS_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_MESSAGE_HTTP_VERSION")]
	public const string MESSAGE_HTTP_VERSION;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_MESSAGE_METHOD")]
	public const string MESSAGE_METHOD;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_MESSAGE_PRIORITY")]
	public const string MESSAGE_PRIORITY;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_MESSAGE_REASON_PHRASE")]
	public const string MESSAGE_REASON_PHRASE;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_MESSAGE_REQUEST_BODY")]
	public const string MESSAGE_REQUEST_BODY;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_MESSAGE_REQUEST_HEADERS")]
	public const string MESSAGE_REQUEST_HEADERS;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_MESSAGE_RESPONSE_BODY")]
	public const string MESSAGE_RESPONSE_BODY;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_MESSAGE_RESPONSE_HEADERS")]
	public const string MESSAGE_RESPONSE_HEADERS;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_MESSAGE_SERVER_SIDE")]
	public const string MESSAGE_SERVER_SIDE;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_MESSAGE_STATUS_CODE")]
	public const string MESSAGE_STATUS_CODE;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_MESSAGE_TLS_CERTIFICATE")]
	public const string MESSAGE_TLS_CERTIFICATE;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_MESSAGE_TLS_ERRORS")]
	public const string MESSAGE_TLS_ERRORS;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_MESSAGE_URI")]
	public const string MESSAGE_URI;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_METHOD_H")]
	public const int METHOD_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_MISC_H")]
	public const int MISC_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_MULTIPART_H")]
	public const int MULTIPART_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_MULTIPART_INPUT_STREAM_H")]
	public const int MULTIPART_INPUT_STREAM_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_PASSWORD_MANAGER_H")]
	public const int PASSWORD_MANAGER_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_PROXY_RESOLVER_DEFAULT_H")]
	public const int PROXY_RESOLVER_DEFAULT_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_PROXY_URI_RESOLVER_H")]
	public const int PROXY_URI_RESOLVER_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_REQUESTER_H")]
	public const int REQUESTER_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_REQUEST_DATA_H")]
	public const int REQUEST_DATA_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_REQUEST_FILE_H")]
	public const int REQUEST_FILE_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_REQUEST_H")]
	public const int REQUEST_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_REQUEST_HTTP_H")]
	public const int REQUEST_HTTP_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_REQUEST_SESSION")]
	public const string REQUEST_SESSION;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_REQUEST_URI")]
	public const string REQUEST_URI;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SERVER_ASYNC_CONTEXT")]
	public const string SERVER_ASYNC_CONTEXT;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SERVER_H")]
	public const int SERVER_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SERVER_HTTPS_ALIASES")]
	public const string SERVER_HTTPS_ALIASES;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SERVER_HTTP_ALIASES")]
	public const string SERVER_HTTP_ALIASES;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SERVER_INTERFACE")]
	public const string SERVER_INTERFACE;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SERVER_PORT")]
	public const string SERVER_PORT;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SERVER_RAW_PATHS")]
	public const string SERVER_RAW_PATHS;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SERVER_SERVER_HEADER")]
	public const string SERVER_SERVER_HEADER;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SERVER_SSL_CERT_FILE")]
	public const string SERVER_SSL_CERT_FILE;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SERVER_SSL_KEY_FILE")]
	public const string SERVER_SSL_KEY_FILE;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SERVER_TLS_CERTIFICATE")]
	public const string SERVER_TLS_CERTIFICATE;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SESSION_ACCEPT_LANGUAGE")]
	public const string SESSION_ACCEPT_LANGUAGE;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SESSION_ACCEPT_LANGUAGE_AUTO")]
	public const string SESSION_ACCEPT_LANGUAGE_AUTO;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SESSION_ASYNC_CONTEXT")]
	public const string SESSION_ASYNC_CONTEXT;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SESSION_ASYNC_H")]
	public const int SESSION_ASYNC_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SESSION_FEATURE_H")]
	public const int SESSION_FEATURE_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SESSION_H")]
	public const int SESSION_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SESSION_HTTPS_ALIASES")]
	public const string SESSION_HTTPS_ALIASES;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SESSION_HTTP_ALIASES")]
	public const string SESSION_HTTP_ALIASES;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SESSION_IDLE_TIMEOUT")]
	public const string SESSION_IDLE_TIMEOUT;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SESSION_LOCAL_ADDRESS")]
	public const string SESSION_LOCAL_ADDRESS;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SESSION_MAX_CONNS")]
	public const string SESSION_MAX_CONNS;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SESSION_MAX_CONNS_PER_HOST")]
	public const string SESSION_MAX_CONNS_PER_HOST;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SESSION_PROXY_RESOLVER")]
	public const string SESSION_PROXY_RESOLVER;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SESSION_PROXY_URI")]
	public const string SESSION_PROXY_URI;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SESSION_SSL_CA_FILE")]
	public const string SESSION_SSL_CA_FILE;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SESSION_SSL_STRICT")]
	public const string SESSION_SSL_STRICT;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SESSION_SSL_USE_SYSTEM_CA_FILE")]
	public const string SESSION_SSL_USE_SYSTEM_CA_FILE;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SESSION_SYNC_H")]
	public const int SESSION_SYNC_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SESSION_TIMEOUT")]
	public const string SESSION_TIMEOUT;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SESSION_TLS_DATABASE")]
	public const string SESSION_TLS_DATABASE;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SESSION_USER_AGENT")]
	public const string SESSION_USER_AGENT;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SESSION_USE_NTLM")]
	public const string SESSION_USE_NTLM;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SESSION_USE_THREAD_CONTEXT")]
	public const string SESSION_USE_THREAD_CONTEXT;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SOCKET_ASYNC_CONTEXT")]
	public const string SOCKET_ASYNC_CONTEXT;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SOCKET_FLAG_NONBLOCKING")]
	public const string SOCKET_FLAG_NONBLOCKING;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SOCKET_H")]
	public const int SOCKET_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SOCKET_IS_SERVER")]
	public const string SOCKET_IS_SERVER;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SOCKET_LOCAL_ADDRESS")]
	public const string SOCKET_LOCAL_ADDRESS;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SOCKET_REMOTE_ADDRESS")]
	public const string SOCKET_REMOTE_ADDRESS;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SOCKET_SSL_CREDENTIALS")]
	public const string SOCKET_SSL_CREDENTIALS;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SOCKET_SSL_FALLBACK")]
	public const string SOCKET_SSL_FALLBACK;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SOCKET_SSL_STRICT")]
	public const string SOCKET_SSL_STRICT;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SOCKET_TIMEOUT")]
	public const string SOCKET_TIMEOUT;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SOCKET_TLS_CERTIFICATE")]
	public const string SOCKET_TLS_CERTIFICATE;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SOCKET_TLS_ERRORS")]
	public const string SOCKET_TLS_ERRORS;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SOCKET_TRUSTED_CERTIFICATE")]
	public const string SOCKET_TRUSTED_CERTIFICATE;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_SOCKET_USE_THREAD_CONTEXT")]
	public const string SOCKET_USE_THREAD_CONTEXT;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_STATUS_H")]
	public const int STATUS_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_TYPES_H")]
	public const int TYPES_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_URI_H")]
	public const int URI_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_VALUE_UTILS_H")]
	public const int VALUE_UTILS_H;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_XMLRPC_H")]
	public const int XMLRPC_H;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned GLib.TimeoutSource add_completion (GLib.MainContext? async_context, GLib.SourceFunc function);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned GLib.TimeoutSource add_idle (GLib.MainContext? async_context, GLib.SourceFunc function);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned GLib.TimeoutSource add_io_watch (GLib.MainContext? async_context, GLib.IOChannel chan, GLib.IOCondition condition, GLib.IOFunc function);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned GLib.TimeoutSource add_timeout (GLib.MainContext? async_context, uint interval, GLib.SourceFunc function);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static GLib.SList<Soup.Cookie> cookies_from_request (Soup.Message msg);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static GLib.SList<Soup.Cookie> cookies_from_response (Soup.Message msg);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static string cookies_to_cookie_header (GLib.SList<Soup.Cookie> cookies);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void cookies_to_request (GLib.SList<Soup.Cookie> cookies, Soup.Message msg);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void cookies_to_response (GLib.SList<Soup.Cookie> cookies, Soup.Message msg);
	[CCode (cheader_filename = "libsoup/soup.h")]
	[Deprecated (replacement = "Form.decode", since = "vala-0.12")]
	public static GLib.HashTable<string,string> form_decode (string encoded_form);
	[CCode (cheader_filename = "libsoup/soup.h")]
	[Deprecated (replacement = "Form.decode_multipart", since = "vala-0.12")]
	public static GLib.HashTable<string,string> form_decode_multipart (Soup.Message msg, string file_control_name, out string filename, out string content_type, out Soup.Buffer file);
	[CCode (cheader_filename = "libsoup/soup.h")]
	[Deprecated (replacement = "Form.encode", since = "vala-0.12")]
	public static string form_encode (...);
	[CCode (cheader_filename = "libsoup/soup.h")]
	[Deprecated (replacement = "Form.encode_datalist", since = "vala-0.12")]
	public static string form_encode_datalist (void* form_data_set);
	[CCode (cheader_filename = "libsoup/soup.h")]
	[Deprecated (replacement = "Form.encode_hash", since = "vala-0.12")]
	public static string form_encode_hash (GLib.HashTable<string,string> form_data_set);
	[CCode (cheader_filename = "libsoup/soup.h")]
	[Deprecated (since = "vala-0.12")]
	public static string form_encode_valist (string first_field, void* args);
	[CCode (cheader_filename = "libsoup/soup.h")]
	[Deprecated (replacement = "Form.request_new", since = "vala-0.12")]
	public static Soup.Message form_request_new (string method, string uri, ...);
	[CCode (cheader_filename = "libsoup/soup.h")]
	[Deprecated (replacement = "Form.request_new_from_datalist", since = "vala-0.12")]
	public static Soup.Message form_request_new_from_datalist (string method, string uri, void* form_data_set);
	[CCode (cheader_filename = "libsoup/soup.h")]
	[Deprecated (replacement = "Form.request_new_from_hash", since = "vala-0.12")]
	public static Soup.Message form_request_new_from_hash (string method, string uri, GLib.HashTable<string,string> form_data_set);
	[CCode (cheader_filename = "libsoup/soup.h")]
	[Deprecated (replacement = "Form.request_new_from_multipart", since = "vala-0.12")]
	public static Soup.Message form_request_new_from_multipart (string uri, Soup.Multipart multipart);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool header_contains (string header, string token);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void header_free_param_list (GLib.HashTable<string,string> param_list);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void header_g_string_append_param (GLib.StringBuilder string, string name, string value);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void header_g_string_append_param_quoted (GLib.StringBuilder string, string name, string value);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static GLib.SList<string> header_parse_list (string header);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static GLib.HashTable<string,string> header_parse_param_list (string header);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static GLib.SList<string> header_parse_quality_list (string header, out GLib.SList<string> unacceptable);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static GLib.HashTable<string,string> header_parse_semi_param_list (string header);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool headers_parse (string str, int len, Soup.MessageHeaders dest);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static uint headers_parse_request (string str, int len, Soup.MessageHeaders req_headers, out string req_method, out string req_path, out Soup.HTTPVersion ver);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool headers_parse_response (string str, int len, Soup.MessageHeaders headers, out Soup.HTTPVersion ver, out uint status_code, out string reason_phrase);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool headers_parse_status_line (string status_line, out Soup.HTTPVersion ver, out uint status_code, out string reason_phrase);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static GLib.Quark http_error_quark ();
	[CCode (cheader_filename = "libsoup/soup.h")]
	[Deprecated (replacement = "SSLError.quark", since = "vala-0.14")]
	public static GLib.Quark ssl_error_quark ();
	[CCode (cheader_filename = "libsoup/soup.h")]
	[Deprecated (replacement = "Status.get_phrase", since = "vala-0.22")]
	public static unowned string status_get_phrase (uint status_code);
	[CCode (cheader_filename = "libsoup/soup.h")]
	[Deprecated (replacement = "Status.proxify", since = "vala-0.22")]
	public static uint status_proxify (uint status_code);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool str_case_equal (void* v1, void* v2);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static uint str_case_hash (void* key);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool tld_domain_is_public_suffix (string domain);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned string tld_get_base_domain (string hostname) throws GLib.Error;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void value_array_append (GLib.ValueArray array, GLib.Type type, ...);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void value_array_append_vals (GLib.ValueArray array, ...);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static GLib.ValueArray value_array_from_args (va_list args);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool value_array_get_nth (GLib.ValueArray array, uint index_, GLib.Type type, ...);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void value_array_insert (GLib.ValueArray array, uint index_, GLib.Type type, ...);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static GLib.ValueArray value_array_new ();
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static GLib.ValueArray value_array_new_with_vals (...);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool value_array_to_args (GLib.ValueArray array, va_list args);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void value_hash_insert (GLib.HashTable<string,GLib.Value?> hash, string key, GLib.Type type, ...);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void value_hash_insert_vals (GLib.HashTable<string,GLib.Value?> hash, ...);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void value_hash_insert_value (GLib.HashTable<string,GLib.Value?> hash, string key, GLib.Value value);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool value_hash_lookup (GLib.HashTable<string,GLib.Value?> hash, string key, GLib.Type type, ...);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool value_hash_lookup_vals (GLib.HashTable<string,GLib.Value?> hash, ...);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static GLib.HashTable<string,GLib.Value?> value_hash_new ();
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static GLib.HashTable<string,GLib.Value?> value_hash_new_with_vals (...);
	[CCode (cheader_filename = "libsoup/soup.h")]
	[Deprecated (replacement = "XMLRPC.build_fault", since = "vala-0.12")]
	[PrintfFormat]
	public static unowned string xmlrpc_build_fault (int fault_code, string fault_format, ...);
	[CCode (cheader_filename = "libsoup/soup.h")]
	[Deprecated (replacement = "XMLRPC.build_method_call", since = "vala-0.12")]
	public static unowned string xmlrpc_build_method_call (string method_name, GLib.Value[] @params);
	[CCode (cheader_filename = "libsoup/soup.h")]
	[Deprecated (replacement = "XMLRPC.build_method_response", since = "vala-0.12")]
	public static unowned string xmlrpc_build_method_response (GLib.Value value);
	[CCode (cheader_filename = "libsoup/soup.h")]
	[Deprecated (replacement = "XMLRPC.error_quark", since = "vala-0.12")]
	public static GLib.Quark xmlrpc_error_quark ();
	[CCode (cheader_filename = "libsoup/soup.h", sentinel = "G_TYPE_INVALID")]
	[Deprecated (replacement = "XMLRPC.extract_method_call", since = "vala-0.12")]
	public static bool xmlrpc_extract_method_call (string method_call, int length, out unowned string method_name, ...);
	[CCode (cheader_filename = "libsoup/soup.h", sentinel = "G_TYPE_INVALID")]
	[Deprecated (replacement = "XMLRPC.extract_method_response", since = "vala-0.12")]
	public static bool xmlrpc_extract_method_response (string method_response, int length, ...) throws GLib.Error;
	[CCode (cheader_filename = "libsoup/soup.h")]
	[Deprecated (replacement = "XMLRPC.fault_quark", since = "vala-0.12")]
	public static GLib.Quark xmlrpc_fault_quark ();
	[CCode (cheader_filename = "libsoup/soup.h")]
	[Deprecated (replacement = "XMLRPC.parse_method_call", since = "vala-0.12")]
	public static bool xmlrpc_parse_method_call (string method_call, int length, out unowned string method_name, out unowned GLib.ValueArray @params);
	[CCode (cheader_filename = "libsoup/soup.h")]
	[Deprecated (replacement = "XMLRPC.parse_method_response", since = "vala-0.12")]
	public static bool xmlrpc_parse_method_response (string method_response, int length, GLib.Value value) throws GLib.Error;
	[CCode (cheader_filename = "libsoup/soup.h", sentinel = "G_TYPE_INVALID")]
	[Deprecated (replacement = "XMLRPC.request_new", since = "vala-0.12")]
	public static unowned Soup.Message xmlrpc_request_new (string uri, string method_name, ...);
	[CCode (cheader_filename = "libsoup/soup.h")]
	[Deprecated (replacement = "XMLRPC.set_fault", since = "vala-0.12")]
	[PrintfFormat]
	public static void xmlrpc_set_fault (Soup.Message msg, int fault_code, string fault_format, ...);
	[CCode (cheader_filename = "libsoup/soup.h", sentinel = "G_TYPE_INVALID")]
	[Deprecated (replacement = "XMLRPC.set_response", since = "vala-0.12")]
	public static void xmlrpc_set_response (Soup.Message msg, ...);
}
